/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.wsi.test.validator.Artifact;
import org.wsi.test.validator.Assertion;
import org.wsi.test.validator.ValidatorException;
import org.wsi.test.validator.XMLFileAccessor;
import org.wsi.test.validator.service.ProfileService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestAssertionsDocument {
    private List<Artifact> artifacts;

    public TestAssertionsDocument(String url, ProfileService profile) throws ValidatorException {
        XMLFileAccessor tadDoc;
        try {
            tadDoc = new XMLFileAccessor(url);
        }
        catch (ValidatorException e) {
            e.setUserReason("TAD file (" + url + ") not found");
            throw e;
        }
        this.artifacts = new ArrayList<Artifact>();
        List<Element> artifactList = tadDoc.getAttributesForElement("http://www.ws-i.org/testing/2004/07/assertions/", "artifact", "type");
        for (Element artifactEl : artifactList) {
            Artifact newArtifact = profile.getArtifact(artifactEl);
            if (newArtifact == null) continue;
            this.artifacts.add(newArtifact);
        }
    }

    public List<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public Map<String, List<String>> getAllEntryTypeTags() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (Artifact artifact : this.getArtifacts()) {
            HashSet<String> tags = new HashSet<String>();
            for (Assertion assertion : artifact.getAssertions()) {
                tags.add(assertion.getEntryType());
            }
            result.put(artifact.getType(), new ArrayList(tags));
        }
        return result;
    }

    public Assertion getAssertion(String id) {
        for (Artifact artifact : this.getArtifacts()) {
            for (Assertion assertion : artifact.getAssertions()) {
                if (!assertion.getId().equals(id)) continue;
                return assertion;
            }
        }
        return null;
    }
}

