/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.wsi.test.validator.ValidatorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceExtension<T> {
    private List<T> instances = new ArrayList<T>();

    public ServiceExtension(String fileName) throws ValidatorException {
        try {
            Enumeration<URL> urls = ClassLoader.getSystemClassLoader().getResources(fileName);
            while (urls.hasMoreElements()) {
                int available;
                URL thisURL = urls.nextElement();
                InputStream st = thisURL.openStream();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                while ((available = st.available()) > 0) {
                    byte[] b = new byte[available];
                    st.read(b);
                    if (b[available - 1] == 0) {
                        --available;
                    }
                    baos.write(b, 0, available);
                }
                String contents = baos.toString();
                String[] lines = contents.split("\\n");
                int i = 0;
                while (i < lines.length) {
                    String thisLine = lines[i].trim();
                    Class<?> klass = Class.forName(thisLine);
                    this.instances.add(klass.newInstance());
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new ValidatorException(e);
        }
    }

    public List<T> getServiceInstances() {
        return this.instances;
    }
}

