/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator;

import java.util.List;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wsi.test.validator.AssertionResult;
import org.wsi.test.validator.LogFile;
import org.wsi.test.validator.TestAssertionsDocument;
import org.wsi.test.validator.ValidatorException;
import org.wsi.test.validator.XMLFileAccessor;
import org.wsi.test.validator.service.ProfileService;

public class Configuration {
    private final String NS_CONFIG = "http://www.ws-i.org/testing/2003/03/analyzerConfig/";
    private final String TAG_TAD = "testAssertionsFile";
    private final String TAG_LOG_FILE = "logFile";
    private final String TAG_VERBOSE = "verbose";
    private final String TAG_ASSERTION_RESULTS = "assertionResults";
    private final String TAG_TYPE = "type";
    private final String TAG_MESSAGE_ENTRY = "messageEntry";
    private final String TAG_FAILURE_MESSAGE = "failureMessage";
    private final String TAG_FAILURE_DETAILS = "failureDetails";
    private final String TAG_ASSERTION_DESCRIPTION = "assertionDescription";
    private final String TAG_REPORT_FILE = "reportFile";
    private final String TAG_REPLACE = "replace";
    private final String TAG_LOCATION = "location";
    private final String TAG_ADD_STYLE_SHEET = "addStyleSheet";
    private final String TAG_HREF = "href";
    private final String TAG_STYLE_SHEET_TYPE = "type";
    private final String TAG_CORRELATION_TYPE = "correlationType";
    private final String TAG_DESCRIPTION = "description";
    private TestAssertionsDocument tad;
    private String tadLocation;
    private LogFile log;
    private String logLocation;
    private boolean verbose;
    private AssertionResultsType assertionResultsType;
    private boolean assertionResultsMessageEntry;
    private boolean assertionResultsFailureMessage;
    private boolean assertionResultsFailureDetails;
    private boolean assertionDescription;
    private boolean reportFileReplace;
    private String reportFileLocation;
    private String styleSheetHref;
    private String styleSheetType;
    private String logFileCorrelationType;
    private String wsdlURI;
    private String description;

    public Configuration(String configURL, ProfileService profile) throws ValidatorException {
        NodeList addStyleSheetNodes;
        List<Element> wsdlRef;
        XMLFileAccessor accessor;
        try {
            accessor = new XMLFileAccessor(configURL);
        }
        catch (ValidatorException e) {
            e.setUserReason("Configuration file (" + configURL + ") not found\n" + "You can specify a configuration ile on the command line " + "with the -config option");
            throw e;
        }
        this.tadLocation = accessor.getTextChildOfSingleNode("http://www.ws-i.org/testing/2003/03/analyzerConfig/", "testAssertionsFile");
        this.tad = new TestAssertionsDocument(this.tadLocation, profile);
        List<Element> logFileElements = accessor.getElementsByName("http://www.ws-i.org/testing/2003/03/analyzerConfig/", "logFile");
        if (logFileElements.size() > 1) {
            throw new ValidatorException("Error, more than one logFile element in config");
        }
        if (logFileElements.size() == 1) {
            Element logFile = logFileElements.get(0);
            this.logFileCorrelationType = logFile.getAttribute("correlationType");
            this.logLocation = ((CharacterData)logFile.getChildNodes().item(0)).getData().trim();
            this.log = new LogFile(this.logLocation);
        }
        if ((wsdlRef = accessor.getElementsByName("http://www.ws-i.org/testing/2003/03/analyzerConfig/", "wsdlReference")).size() > 1) {
            throw new ValidatorException("Error, more than one wsdlReference element in config");
        }
        if (wsdlRef.size() == 1) {
            Element wsdlUriEl = (Element)wsdlRef.get(0).getElementsByTagNameNS("http://www.ws-i.org/testing/2003/03/analyzerConfig/", "wsdlURI").item(0);
            this.wsdlURI = ((CharacterData)wsdlUriEl.getChildNodes().item(0)).getData().trim();
        }
        String booleanString = accessor.getTextChildOfSingleNode("http://www.ws-i.org/testing/2003/03/analyzerConfig/", "verbose");
        this.verbose = this.stringToBoolean(booleanString, null);
        Element assertionResults = accessor.getElementsByName("http://www.ws-i.org/testing/2003/03/analyzerConfig/", "assertionResults").get(0);
        String assertionResultsTypeSt = assertionResults.getAttribute("type");
        if (assertionResultsTypeSt.equals("")) {
            this.assertionResultsType = AssertionResultsType.ALL;
        } else if (assertionResultsTypeSt.equals("all")) {
            this.assertionResultsType = AssertionResultsType.ALL;
        } else if (assertionResultsTypeSt.equals("notPassed")) {
            this.assertionResultsType = AssertionResultsType.NOT_PASSED;
        } else if (assertionResultsTypeSt.equals("onlyFailed")) {
            this.assertionResultsType = AssertionResultsType.ONLY_FAILED;
        } else if (assertionResultsTypeSt.equals("notInfo")) {
            this.assertionResultsType = AssertionResultsType.NOT_INFO;
        } else {
            throw new ValidatorException("Illegal assertion results type:  " + assertionResultsTypeSt);
        }
        booleanString = assertionResults.getAttribute("messageEntry");
        this.assertionResultsMessageEntry = this.stringToBoolean(booleanString, "true");
        booleanString = assertionResults.getAttribute("failureMessage");
        this.assertionResultsFailureMessage = this.stringToBoolean(booleanString, "false");
        booleanString = assertionResults.getAttribute("failureDetails");
        this.assertionResultsFailureDetails = this.stringToBoolean(booleanString, "true");
        booleanString = assertionResults.getAttribute("assertionDescription");
        this.assertionDescription = this.stringToBoolean(booleanString, "false");
        Element reportFile = accessor.getElementsByName("http://www.ws-i.org/testing/2003/03/analyzerConfig/", "reportFile").get(0);
        booleanString = reportFile.getAttribute("replace");
        this.reportFileReplace = this.stringToBoolean(booleanString, "false");
        this.reportFileLocation = reportFile.getAttribute("location");
        if (this.reportFileLocation.equals("")) {
            this.reportFileLocation = "report.xml";
        }
        if ((addStyleSheetNodes = reportFile.getElementsByTagNameNS("http://www.ws-i.org/testing/2003/03/analyzerConfig/", "addStyleSheet")).getLength() > 1) {
            throw new ValidatorException("Config file error, too many addStyleSheet elements");
        }
        if (addStyleSheetNodes.getLength() == 1) {
            Element addStyleSheet = (Element)addStyleSheetNodes.item(0);
            this.styleSheetHref = addStyleSheet.getAttribute("href");
            this.styleSheetType = addStyleSheet.getAttribute("type");
            if (this.styleSheetType.equals("")) {
                this.styleSheetType = "text/xsl";
            }
        }
        this.description = accessor.getTextChildOfSingleNode("http://www.ws-i.org/testing/2003/03/analyzerConfig/", "description");
    }

    private boolean stringToBoolean(String s, String dflt) throws ValidatorException {
        if (s.equals("true")) {
            return true;
        }
        if (s.equals("false")) {
            return false;
        }
        if (s.equals("") && dflt != null) {
            return this.stringToBoolean(dflt, null);
        }
        throw new ValidatorException("Illegal boolean value:  " + s);
    }

    public LogFile getLogFile() {
        return this.log;
    }

    public String getTadLocation() {
        return this.tadLocation;
    }

    public String getLogFileLocation() {
        return this.logLocation;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public boolean getAssertionDescription() {
        return this.assertionDescription;
    }

    public boolean getReportFileReplace() {
        return this.reportFileReplace;
    }

    public String getReportFileLocation() {
        return this.reportFileLocation;
    }

    public String getStyleSheetHref() {
        return this.styleSheetHref;
    }

    public String getStyleSheetType() {
        return this.styleSheetType;
    }

    public String getLogFileCorrelationType() {
        return this.logFileCorrelationType;
    }

    public String getWsdlURI() {
        return this.wsdlURI;
    }

    public String getDescription() {
        return this.description;
    }

    public AssertionResultsType getAssertionResultsType() {
        return this.assertionResultsType;
    }

    public boolean getAssertionResultsMessageEntry() {
        return this.assertionResultsMessageEntry;
    }

    public boolean getAssertionResultsFailureMessage() {
        return this.assertionResultsFailureMessage;
    }

    public boolean getAssertionResultsFailureDetails() {
        return this.assertionResultsFailureDetails;
    }

    public TestAssertionsDocument getTad() throws ValidatorException {
        return this.tad;
    }

    public void setTadLocation(String loc) {
        this.tadLocation = loc;
        this.tad = null;
    }

    public boolean shouldReport(AssertionResult result) {
        if (this.getAssertionResultsType().equals("all")) {
            return true;
        }
        if (this.getAssertionResultsType().equals("notPassed")) {
            return !result.getResult().equals((Object)AssertionResult.Result.PASSED);
        }
        if (this.getAssertionResultsType().equals("onlyFailed")) {
            return result.getResult().equals((Object)AssertionResult.Result.FAILED);
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AssertionResultsType {
        ALL("all"),
        NOT_PASSED("notPassed"),
        ONLY_FAILED("onlyFailed"),
        NOT_INFO("notInfo");

        private final String name;

        private AssertionResultsType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

