/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.wsi.test.validator.Assertion;
import org.wsi.test.validator.Configuration;
import org.wsi.test.validator.TestAssertionsDocument;
import org.wsi.test.validator.ValidatorException;

public class AssertionResult {
    private String assertionId;
    private Result result;

    public AssertionResult(String id, Result r) {
        this.assertionId = id;
        this.result = r;
    }

    public String getAssertionId() {
        return this.assertionId;
    }

    public Result getResult() {
        return this.result;
    }

    public boolean failed() {
        return this.result == Result.FAILED || this.result == Result.PREREQ_FAILED;
    }

    private void populateErrorElement(Document doc, Element errorElement, TestAssertionsDocument tad) {
        errorElement.setAttributeNS("http://www.w3.org/XML/1998/namespace", "lang", "en");
        Assertion assertion = tad.getAssertion(this.getAssertionId());
        Text textNode = doc.createTextNode(assertion.getFailureMessage());
        errorElement.appendChild(textNode);
    }

    public Element getReportElement(Document doc, String reportNamespace, Configuration config) {
        Element failureElement;
        Element reportElement = doc.createElementNS(reportNamespace, "assertionResult");
        reportElement.setAttribute("id", this.assertionId);
        reportElement.setAttribute("result", this.result.getName());
        if (config.getAssertionResultsFailureMessage() && (this.result == Result.WARNING || this.result == Result.FAILED)) {
            failureElement = doc.createElementNS(reportNamespace, "failureMessage");
            try {
                this.populateErrorElement(doc, failureElement, config.getTad());
            }
            catch (ValidatorException validatorException) {
                // empty catch block
            }
            reportElement.appendChild(failureElement);
        }
        if (config.getAssertionResultsFailureDetails() && (this.result == Result.WARNING || this.result == Result.FAILED)) {
            failureElement = doc.createElementNS(reportNamespace, "failureDetail");
            try {
                this.populateErrorElement(doc, failureElement, config.getTad());
            }
            catch (ValidatorException validatorException) {
                // empty catch block
            }
            reportElement.appendChild(failureElement);
        }
        return reportElement;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Result {
        PASSED("passed"),
        WARNING("warning"),
        FAILED("failed"),
        NOT_APPLICABLE("notApplicable"),
        PREREQ_FAILED("prereqFailed");

        private final String name;

        private Result(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

