/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.util.collections;

import com.jidesoft.thirdparty.prefuse.data.DataTypeException;
import com.jidesoft.thirdparty.prefuse.util.collections.BooleanIntBitSetMap;
import com.jidesoft.thirdparty.prefuse.util.collections.DoubleIntTreeMap;
import com.jidesoft.thirdparty.prefuse.util.collections.FloatIntTreeMap;
import com.jidesoft.thirdparty.prefuse.util.collections.IncompatibleComparatorException;
import com.jidesoft.thirdparty.prefuse.util.collections.IntIntTreeMap;
import com.jidesoft.thirdparty.prefuse.util.collections.IntSortedMap;
import com.jidesoft.thirdparty.prefuse.util.collections.LiteralComparator;
import com.jidesoft.thirdparty.prefuse.util.collections.LiteralIterator;
import com.jidesoft.thirdparty.prefuse.util.collections.LongIntTreeMap;
import com.jidesoft.thirdparty.prefuse.util.collections.ObjectIntTreeMap;
import java.util.Comparator;

public class SortedMapFactory {
    public static IntSortedMap getMap(Class clazz, Comparator comparator, boolean bl) throws IncompatibleComparatorException {
        if (!SortedMapFactory.comparatorCheck(clazz, comparator)) {
            throw new IncompatibleComparatorException();
        }
        if (clazz.equals(Integer.TYPE)) {
            return new IntIntTreeMap((LiteralComparator)comparator, !bl);
        }
        if (clazz.equals(Long.TYPE)) {
            return new LongIntTreeMap((LiteralComparator)comparator, !bl);
        }
        if (clazz.equals(Float.TYPE)) {
            return new FloatIntTreeMap((LiteralComparator)comparator, !bl);
        }
        if (clazz.equals(Double.TYPE)) {
            return new DoubleIntTreeMap((LiteralComparator)comparator, !bl);
        }
        if (clazz.equals(Boolean.TYPE)) {
            return new BooleanIntBitSetMap();
        }
        if (Object.class.isAssignableFrom(clazz)) {
            return new ObjectIntTreeMap(comparator, !bl);
        }
        throw new DataTypeException("No map available for the provided type");
    }

    public static boolean comparatorCheck(Class clazz, Comparator comparator) {
        if (comparator == null) {
            return true;
        }
        if (clazz.equals(Integer.TYPE)) {
            if (!(comparator instanceof LiteralIterator)) {
                return false;
            }
            try {
                ((LiteralComparator)comparator).compare(0, 0);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (clazz.equals(Long.TYPE)) {
            if (!(comparator instanceof LiteralIterator)) {
                return false;
            }
            try {
                ((LiteralComparator)comparator).compare(0L, 0L);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (clazz.equals(Float.TYPE)) {
            if (!(comparator instanceof LiteralIterator)) {
                return false;
            }
            try {
                ((LiteralComparator)comparator).compare(0.0f, 0.0f);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (clazz.equals(Double.TYPE)) {
            if (!(comparator instanceof LiteralIterator)) {
                return false;
            }
            try {
                ((LiteralComparator)comparator).compare(0.0, 0.0);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (clazz.equals(Boolean.TYPE)) {
            if (!(comparator instanceof LiteralIterator)) {
                return false;
            }
            try {
                ((LiteralComparator)comparator).compare(false, false);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (Object.class.isAssignableFrom(clazz)) {
            return true;
        }
        throw new DataTypeException("No comparator available for the provided type");
    }
}

