/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pivot;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.pivot.IPivotDataModel;
import com.jidesoft.pivot.PivotField;
import com.jidesoft.pivot.PivotTablePane;
import com.jidesoft.pivot.SummaryCalculator;
import com.jidesoft.utils.BigDecimalMathUtils;
import com.jidesoft.utils.TypeUtils;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecimalSummaryCalculator
implements SummaryCalculator {
    private List<BigDecimal> a = new Vector<BigDecimal>();
    private MathContext b;
    private boolean c = true;

    public BigDecimalSummaryCalculator() {
        this(new MathContext(8));
    }

    public BigDecimalSummaryCalculator(MathContext mathContext) {
        this.b = mathContext;
    }

    public MathContext getMathContext() {
        return this.b;
    }

    public void setMathContext(MathContext mathContext) {
        this.b = mathContext;
    }

    @Override
    public void addValue(Object object) {
        boolean bl = object instanceof BigDecimal;
        if (PivotField.x == 0 && bl) {
            bl = this.a.add((BigDecimal)object);
        }
    }

    @Override
    public void addValue(IPivotDataModel iPivotDataModel, PivotField pivotField, int n2, int n3, Object object) {
        this.addValue(object);
    }

    @Override
    public void clear() {
        this.a = new Vector<BigDecimal>();
    }

    @Override
    public long getCount() {
        return this.a.size();
    }

    @Override
    public int getNumberOfSummaries() {
        return PivotTablePane.getSummaryCount();
    }

    @Override
    public String getSummaryName(Locale locale, int n2) {
        return PivotTablePane.getSummaryName(locale, n2);
    }

    @Override
    public Object getSummaryResult(int n2) {
        switch (n2) {
            case 3: {
                return BigDecimalMathUtils.mean(this.a, this.getMathContext());
            }
            case 2: {
                return BigDecimalMathUtils.min(this.a);
            }
            case 1: {
                return BigDecimalMathUtils.max(this.a);
            }
            case 0: {
                return BigDecimalMathUtils.sum(this.a);
            }
            case 6: {
                return this.getCount();
            }
            case 5: {
                return BigDecimalMathUtils.stddev(this.a, this.isBiasCorrected(), this.getMathContext());
            }
            case 4: {
                return BigDecimalMathUtils.var(this.a, this.isBiasCorrected(), this.getMathContext());
            }
            case -2: {
                return null;
            }
        }
        return BigDecimalMathUtils.sum(this.a);
    }

    public boolean isBiasCorrected() {
        return this.c;
    }

    public void setBiasCorrected(boolean bl) {
        this.c = bl;
    }

    @Override
    public int[] getAllowedSummaries(Class<?> clazz) {
        return this.getAllowedSummaries(clazz, null);
    }

    @Override
    public int[] getAllowedSummaries(Class<?> clazz, ConverterContext converterContext) {
        int n2 = PivotField.x;
        boolean bl = TypeUtils.isNumericType(clazz);
        if (n2 == 0) {
            if (bl) {
                return ALLOWED_SUMMARIES_ALL;
            }
            bl = clazz.isAssignableFrom(Date.class);
        }
        if (n2 == 0) {
            if (bl) {
                return ALLOWED_SUMMARIES_MAX_MIN_COUNT;
            }
            bl = clazz.isAssignableFrom(Calendar.class);
        }
        if (bl) {
            return ALLOWED_SUMMARIES_MAX_MIN_COUNT;
        }
        return ALLOWED_SUMMARIES_COUNT;
    }
}

