/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator.bsp11.tests;

import org.w3c.dom.Element;
import org.wsi.test.validator.Entry;
import org.wsi.test.validator.ValidatorException;
import org.wsi.test.validator.bsp11.SecureConstants;
import org.wsi.test.validator.bsp11.XPathAssertion;
import org.wsi.test.validator.bsp11.entrytypes.EncryptedDataEntryType;
import org.wsi.test.validator.bsp11.entrytypes.EncryptedHeaderEntryType;

public class BSP5627
extends XPathAssertion {
    public BSP5627(Element e) throws ValidatorException {
        super(e);
    }

    public boolean isApplicable(Entry e) {
        if (e instanceof EncryptedDataEntryType) {
            Element eHeader = (Element)e.getElement().getParentNode();
            if (EncryptedHeaderEntryType.getFactory().isValidElement(eHeader)) {
                String id = e.getElement().getAttribute("Id");
                if (id != null && !id.equals("")) {
                    EncryptedDataEntryType encData = (EncryptedDataEntryType)e;
                    return encData.getReferringList() == null;
                }
                return true;
            }
        }
        return false;
    }

    public boolean applyRule(Entry entry) {
        Element eHeader = (Element)entry.getElement().getParentNode();
        String wsuId = eHeader.getAttributeNS(SecureConstants.WSU_NAMESPACE, "Id");
        if (wsuId != null) {
            EncryptedHeaderEntryType encHeader = (EncryptedHeaderEntryType)EncryptedHeaderEntryType.getFactory().newInstance(eHeader);
            return encHeader.getReferringList() != null;
        }
        return false;
    }
}

