/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator.bsp11.entrytypes;

import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wsi.test.validator.bsp11.SecureConstants;
import org.wsi.test.validator.bsp11.entrytypes.BinarySecurityTokenEntryType;
import org.wsi.test.validator.bsp11.entrytypes.SecureEntryType;
import org.wsi.test.validator.bsp11.entrytypes.SecurityTokenReferenceEntryType;

public class StrKeyIdentifierEntryType
extends SecureEntryType {
    private static Factory fInstance = new Factory();

    public static Factory getFactory() {
        return fInstance;
    }

    private StrKeyIdentifierEntryType(Element e) {
        super(e);
    }

    public String getEntryTypeTag() {
        return "strKeyIdentifier";
    }

    public Element getReferencedSamlToken() {
        Node textNode = this.getElement().getFirstChild();
        if (textNode.getNodeType() != 3) {
            return null;
        }
        String ref = ((CharacterData)textNode).getData().trim();
        NodeList samlTokens = this.getElement().getOwnerDocument().getDocumentElement().getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");
        int i = 0;
        while (i < samlTokens.getLength()) {
            Element el = (Element)samlTokens.item(i);
            String elId = el.getAttribute("AssertionID");
            if (elId.equals(ref)) {
                return el;
            }
            ++i;
        }
        return null;
    }

    public BinarySecurityTokenEntryType getReferencedBinarySecurityToken() {
        Node textNode = this.getElement().getFirstChild();
        if (textNode.getNodeType() != 3) {
            return null;
        }
        String ref = ((CharacterData)textNode).getData().trim();
        NodeList bsTokens = this.getElement().getOwnerDocument().getDocumentElement().getElementsByTagNameNS(SecureConstants.WSSE_NAMESPACE, "BinarySecurityToken");
        int i = 0;
        while (i < bsTokens.getLength()) {
            Element el = (Element)bsTokens.item(i);
            String elId = el.getAttributeNS(SecureConstants.WSU_NAMESPACE, "Id");
            if (elId.equals(ref)) {
                return (BinarySecurityTokenEntryType)BinarySecurityTokenEntryType.getFactory().newInstance(el);
            }
            ++i;
        }
        return null;
    }

    /* synthetic */ StrKeyIdentifierEntryType(Element element, StrKeyIdentifierEntryType strKeyIdentifierEntryType) {
        this(element);
    }

    public static class Factory
    extends SecureEntryType.Factory {
        private Factory() {
        }

        public SecureEntryType newInstance(Element e) {
            return new StrKeyIdentifierEntryType(e, null);
        }

        public boolean isValidElement(Element el) {
            if (!this.checkURIandName(el, SecureConstants.WSSE_NAMESPACE, "KeyIdentifier")) {
                return false;
            }
            Element parent = (Element)el.getParentNode();
            return SecurityTokenReferenceEntryType.getFactory().isValidElement(parent);
        }
    }
}

