/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.desktop;

import com.install4j.api.Util;
import com.install4j.api.beans.ExternalFile;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.beans.actions.SystemInstallAction;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.MenuHelper;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchBooleanAction;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.platform.unix.UnixSpecialDirs;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import java.io.File;
import java.io.IOException;

public class CreateDesktopLinkAction
extends SystemInstallAction {
    private File file;
    private String name = "";
    private boolean allUsers = true;
    private ExternalFile winIconFile;
    private String arguments = "";
    private String description = "";
    private File startIn;
    private boolean runAsAdministrator = false;
    private boolean macSingleBundleTarget = true;

    public File getStartIn() {
        return CreateDesktopLinkAction.replaceVariables(this.startIn);
    }

    public void setStartIn(File file) {
        this.startIn = file;
    }

    public boolean isRunAsAdministrator() {
        return this.runAsAdministrator;
    }

    public void setRunAsAdministrator(boolean bl) {
        this.runAsAdministrator = bl;
    }

    public File getFile() {
        return CreateDesktopLinkAction.replaceVariables(this.file);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getName() {
        return CreateDesktopLinkAction.replaceVariables(this.name, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE);
    }

    public void setName(String string) {
        this.name = string;
    }

    public ExternalFile getWinIconFile() {
        return this.winIconFile;
    }

    public void setWinIconFile(ExternalFile externalFile) {
        this.winIconFile = externalFile;
    }

    public String getArguments() {
        return CreateDesktopLinkAction.replaceVariables(this.arguments);
    }

    public void setArguments(String string) {
        this.arguments = string;
    }

    public String getDescription() {
        return CreateDesktopLinkAction.replaceVariables(this.description, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE);
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public boolean isMacSingleBundleTarget() {
        return this.macSingleBundleTarget;
    }

    public void setMacSingleBundleTarget(boolean bl) {
        this.macSingleBundleTarget = bl;
    }

    public boolean isAllUsers() {
        return this.allUsers;
    }

    public void setAllUsers(boolean bl) {
        this.allUsers = bl;
    }

    public boolean install(InstallerContext installerContext) throws UserCanceledException {
        if (InstallerUtil.isWindows()) {
            return this.installWindows(installerContext);
        }
        if (InstallerUtil.isMacOS()) {
            return this.installMacos(installerContext);
        }
        return this.installUnix(installerContext);
    }

    private boolean installUnix(InstallerContext installerContext) throws UserCanceledException {
        File file = UnixSpecialDirs.getDirectory("XDG_DESKTOP_DIR");
        if (file == null || !file.isDirectory()) {
            file = new File(Util.getUserHome(), "Desktop");
        }
        if (file.isDirectory()) {
            try {
                if (MenuHelper.installUnixDesktopFile(installerContext.getInstallationDirectory(), file, installerContext.getDestinationFile(this.getFile()), this.getName(), null, this.getArguments()) == null) {
                    Logger.getInstance().log(this, "Destination file does not exist", false);
                    return false;
                }
                return true;
            }
            catch (IOException iOException) {
                Logger.getInstance().log(iOException);
                return false;
            }
        }
        Logger.getInstance().log(this, "Desktop directory " + file + " does not exist", false);
        return false;
    }

    private boolean installMacos(InstallerContext installerContext) {
        File file;
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        if (installerConfig.getMacSpecificConfig().isSingleBundle() && this.isMacSingleBundleTarget()) {
            file = installerContext.getDestinationFile(installerConfig.getMacSpecificConfig().getSingleBundleName());
        } else if (this.getFile() != null && this.getFile().getPath().trim().length() > 0) {
            file = installerContext.getDestinationFile(this.getFile());
        } else {
            return false;
        }
        if (file != null && file.exists()) {
            return CreateDesktopLinkAction.createLink(file, this.getName());
        }
        Logger.getInstance().log(this, "Destination file does not exist", false);
        return false;
    }

    private static boolean createLink(final File file, final String string) {
        return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.UNELEVATED, new FetchBooleanAction(){

            protected boolean fetchValue(Context context) throws Exception {
                File file2 = new File(new File(Util.getUserHome(), "Desktop"), string);
                if (!UnixFileSystem.createLink(file.getAbsolutePath(), file2)) {
                    return false;
                }
                FileInstaller.getInstance().registerUninstallFile(file2);
                return true;
            }
        });
    }

    private boolean installWindows(InstallerContext installerContext) throws UserCanceledException {
        File file = installerContext.getDestinationFile(this.getFile());
        if (file != null) {
            if (!file.exists()) {
                file = installerContext.getDestinationFile(this.getFile() + ".exe");
            }
            if (file.exists()) {
                boolean bl = this.allUsers;
                Object object = InstallerVariables.getVariable("sys.programGroupAllUsers");
                if (object != null && object instanceof Boolean) {
                    bl = (Boolean)object;
                }
                File file2 = installerContext.getExternalFile(this.winIconFile, true);
                if (bl && !InstallerUtil.checkWriteable(FolderInfo.getSpecialFolder(1, true))) {
                    bl = false;
                }
                File file3 = FolderInfo.getSpecialFolder(1, bl);
                File file4 = installerContext.getDestinationFile(this.getStartIn());
                if (file4 != null && !file4.isDirectory()) {
                    file4 = null;
                }
                try {
                    MenuHelper.installWindowsMenu(bl ? ExecutionContext.MAXIMUM : ExecutionContext.UNELEVATED, new File(file3, this.getName()), file, file2, this.getArguments(), this.isRunAsAdministrator(), this.getDescription(), file4);
                    return true;
                }
                catch (IOException iOException) {
                    Logger.getInstance().log(iOException);
                    return false;
                }
            }
            Logger.getInstance().log(this, "Destination file does not exist", false);
            return false;
        }
        Logger.getInstance().log(this, "Destination file does not exist", false);
        return false;
    }
}

