/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Shape;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.ViewFactory;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.SyntaxStyles;
import jsyntaxpane.Token;
import jsyntaxpane.TokenType;

public class SyntaxView
extends PlainView {
    private static final Logger log = Logger.getLogger(SyntaxView.class.getName());

    public SyntaxView(Element element) {
        super(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int drawUnselectedText(Graphics graphics, int x, int y, int p0, int p1) {
        Font saveFont = graphics.getFont();
        Color saveColor = graphics.getColor();
        SyntaxDocument doc = (SyntaxDocument)this.getDocument();
        Segment segment = this.getLineBuffer();
        try {
            Iterator<Token> i = doc.getTokens(p0, p1);
            int start = p0;
            while (i.hasNext()) {
                Token t = i.next();
                if (start < t.start) {
                    SyntaxStyles.getInstance().setGraphicsStyle(graphics, TokenType.DEFAULT);
                    doc.getText(start, t.start - start, segment);
                    x = Utilities.drawTabbedText(segment, x, y, graphics, (TabExpander)this, start);
                }
                int l = t.length;
                int s = t.start;
                if (s < p0) {
                    l -= p0 - s;
                    s = p0;
                }
                if (s + l > p1) {
                    l = p1 - s;
                }
                doc.getText(s, l, segment);
                x = SyntaxStyles.getInstance().drawText(segment, x, y, graphics, this, t);
                start = t.start + t.length;
            }
            if (start < p1) {
                SyntaxStyles.getInstance().setGraphicsStyle(graphics, TokenType.DEFAULT);
                doc.getText(start, p1 - start, segment);
                x = Utilities.drawTabbedText(segment, x, y, graphics, (TabExpander)this, start);
            }
        }
        catch (BadLocationException ex) {
            System.err.println("Requested: " + ex.offsetRequested());
            log.log(Level.SEVERE, null, ex);
        }
        finally {
            graphics.setFont(saveFont);
            graphics.setColor(saveColor);
        }
        return x;
    }

    protected int drawSelectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        return this.drawUnselectedText(g, x, y, p0, p1);
    }

    protected void updateDamage(DocumentEvent changes, Shape a, ViewFactory f) {
        super.updateDamage(changes, a, f);
        Container host = this.getContainer();
        host.repaint();
    }
}

