/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.gui.tk;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class GUILogger
extends JPanel
implements ActionListener,
ComponentListener {
    public static final String STYLE_NORMAL = "regular";
    public static final String STYLE_ERROR = "error";
    public static final String STYLE_LARGE = "large";
    public static final String STYLE_SMALL = "small";
    public static final String STYLE_BOLD = "bold";
    private StyledDocument document = new DefaultStyledDocument();
    private JTextPane log = new JTextPane(this.document);
    private JButton clear;
    private JScrollPane scroll;
    private JCheckBox autoScroll;

    public GUILogger() {
        super(new BorderLayout());
        this.log.setEditable(false);
        this.scroll = new JScrollPane(this.log);
        this.clear = new JButton("Clear");
        this.clear.setActionCommand("CLEAR");
        this.clear.addActionListener(this);
        this.autoScroll = new JCheckBox("Auto scroll", true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add(this.autoScroll);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.clear);
        this.add((Component)this.scroll, "Center");
        this.add((Component)jPanel, "South");
        this.log.addComponentListener(this);
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        Style style2 = this.document.addStyle(STYLE_NORMAL, style);
        StyleConstants.setFontFamily(style, "SansSerif");
        Style style3 = this.document.addStyle(STYLE_BOLD, style2);
        StyleConstants.setBold(style3, true);
        style3 = this.document.addStyle(STYLE_SMALL, style2);
        StyleConstants.setFontSize(style3, 10);
        style3 = this.document.addStyle(STYLE_LARGE, style2);
        StyleConstants.setFontSize(style3, 16);
        style3 = this.document.addStyle(STYLE_ERROR, style2);
        StyleConstants.setForeground(style3, Color.RED);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("CLEAR")) {
            try {
                this.document.remove(0, this.document.getLength());
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    public StyledDocument getStyledDocument() {
        return this.document;
    }

    public PrintStream getStreamedLogged(String string) {
        return new PrintStream(new LoggerOutputStream(string));
    }

    public void updateScrollPosition() {
        this.scroll.getViewport().setViewPosition(new Point(0, this.log.getHeight()));
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (this.autoScroll.isSelected()) {
            this.updateScrollPosition();
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public class LoggerOutputStream
    extends OutputStream {
        private String styleName;

        public LoggerOutputStream(String string) {
            this.styleName = string;
        }

        public void write(int n) throws IOException {
            try {
                GUILogger.this.document.insertString(GUILogger.this.document.getLength(), String.valueOf((char)n), GUILogger.this.document.getStyle(this.styleName));
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }
}

