/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.util;

import com.jidesoft.thirdparty.prefuse.data.Table;
import com.jidesoft.thirdparty.prefuse.util.collections.IntIterator;
import java.util.ConcurrentModificationException;
import java.util.Date;

public class TableIterator
extends IntIterator {
    private Table m_table;
    private IntIterator m_rows;
    private int m_modCount;
    protected int m_cur = -1;

    public TableIterator(Table table, IntIterator intIterator) {
        this.m_table = table;
        this.m_rows = intIterator;
        this.m_modCount = table.getModificationCount();
    }

    public int nextInt() {
        if (this.m_modCount != this.m_table.getModificationCount()) {
            throw new ConcurrentModificationException();
        }
        this.m_cur = this.m_rows.nextInt();
        return this.m_cur;
    }

    public boolean hasNext() {
        return this.m_rows.hasNext();
    }

    public void remove() {
        if (this.m_table.removeRow(this.m_cur)) {
            this.modify();
        }
    }

    protected void modify() {
        ++this.m_modCount;
        this.m_cur = -1;
    }

    public final boolean canGet(String string, Class clazz) {
        return this.m_table.canGet(string, clazz);
    }

    public final boolean canSet(String string, Class clazz) {
        return this.m_table.canSet(string, clazz);
    }

    public final Object get(String string) {
        return this.m_table.get(this.m_cur, string);
    }

    public final void set(String string, Object object) {
        ++this.m_modCount;
        this.m_table.set(this.m_cur, string, object);
    }

    public final boolean canGetInt(String string) {
        return this.m_table.canGetInt(string);
    }

    public final boolean canSetInt(String string) {
        return this.m_table.canSetInt(string);
    }

    public final int getInt(String string) {
        return this.m_table.getInt(this.m_cur, string);
    }

    public final void setInt(String string, int n2) {
        ++this.m_modCount;
        this.m_table.setInt(this.m_cur, string, n2);
    }

    public final boolean canGetLong(String string) {
        return this.m_table.canGetLong(string);
    }

    public final boolean canSetLong(String string) {
        return this.m_table.canSetLong(string);
    }

    public final long getLong(String string) {
        return this.m_table.getLong(this.m_cur, string);
    }

    public final void setLong(String string, long l2) {
        ++this.m_modCount;
        this.m_table.setLong(this.m_cur, string, l2);
    }

    public final boolean canGetFloat(String string) {
        return this.m_table.canGetFloat(string);
    }

    public final boolean canSetFloat(String string) {
        return this.m_table.canSetFloat(string);
    }

    public final float getFloat(String string) {
        return this.m_table.getFloat(this.m_cur, string);
    }

    public final void setFloat(String string, float f2) {
        ++this.m_modCount;
        this.m_table.setFloat(this.m_cur, string, f2);
    }

    public final boolean canGetDouble(String string) {
        return this.m_table.canGetDouble(string);
    }

    public final boolean canSetDouble(String string) {
        return this.m_table.canSetDouble(string);
    }

    public final double getDouble(String string) {
        return this.m_table.getDouble(this.m_cur, string);
    }

    public final void setDouble(String string, double d2) {
        ++this.m_modCount;
        this.m_table.setDouble(this.m_cur, string, d2);
    }

    public final boolean canGetBoolean(String string) {
        return this.m_table.canGetBoolean(string);
    }

    public final boolean canSetBoolean(String string) {
        return this.m_table.canSetBoolean(string);
    }

    public final boolean getBoolean(String string) {
        return this.m_table.getBoolean(this.m_cur, string);
    }

    public final void setBoolean(String string, boolean bl) {
        ++this.m_modCount;
        this.m_table.setBoolean(this.m_cur, string, bl);
    }

    public final boolean canGetString(String string) {
        return this.m_table.canGetString(string);
    }

    public final boolean canSetString(String string) {
        return this.m_table.canSetString(string);
    }

    public final String getString(String string) {
        return this.m_table.getString(this.m_cur, string);
    }

    public final void setString(String string, String string2) {
        ++this.m_modCount;
        this.m_table.setString(this.m_cur, string, string2);
    }

    public final boolean canGetDate(String string) {
        return this.m_table.canGetDate(string);
    }

    public final boolean canSetDate(String string) {
        return this.m_table.canSetDate(string);
    }

    public final Date getDate(String string) {
        return this.m_table.getDate(this.m_cur, string);
    }

    public final void setDate(String string, Date date) {
        ++this.m_modCount;
        this.m_table.setDate(this.m_cur, string, date);
    }
}

