/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.expression;

import com.jidesoft.thirdparty.prefuse.data.Schema;
import com.jidesoft.thirdparty.prefuse.data.Tuple;
import com.jidesoft.thirdparty.prefuse.data.expression.BinaryExpression;
import com.jidesoft.thirdparty.prefuse.data.expression.Expression;
import com.jidesoft.thirdparty.prefuse.util.TypeLib;

public class ArithmeticExpression
extends BinaryExpression {
    public static final int ADD = 0;
    public static final int SUB = 1;
    public static final int MUL = 2;
    public static final int DIV = 3;
    public static final int POW = 4;
    public static final int MOD = 5;
    private Class m_type = null;

    public ArithmeticExpression(int n2, Expression expression, Expression expression2) {
        super(n2, 0, 5, expression, expression2);
    }

    public Class getType(Schema schema) {
        if (this.m_type == null) {
            Class clazz = this.m_left.getType(schema);
            Class clazz2 = this.m_right.getType(schema);
            this.m_type = TypeLib.getNumericType(clazz, clazz2);
        }
        return this.m_type;
    }

    public Object get(Tuple tuple) {
        Class clazz = this.getType(tuple.getSchema());
        if (Integer.TYPE == clazz) {
            return new Integer(this.getInt(tuple));
        }
        if (Long.TYPE == clazz) {
            return new Long(this.getInt(tuple));
        }
        if (Float.TYPE == clazz) {
            return new Float(this.getFloat(tuple));
        }
        if (Double.TYPE == clazz) {
            return new Double(this.getDouble(tuple));
        }
        throw new IllegalStateException();
    }

    public int getInt(Tuple tuple) {
        int n2 = this.m_left.getInt(tuple);
        int n3 = this.m_right.getInt(tuple);
        switch (this.m_op) {
            case 0: {
                return n2 + n3;
            }
            case 1: {
                return n2 - n3;
            }
            case 2: {
                return n2 * n3;
            }
            case 3: {
                return n2 / n3;
            }
            case 4: {
                return (int)Math.pow(n2, n3);
            }
            case 5: {
                return n2 % n3;
            }
        }
        throw new IllegalStateException("Unknown operation type.");
    }

    public long getLong(Tuple tuple) {
        long l2 = this.m_left.getLong(tuple);
        long l3 = this.m_right.getLong(tuple);
        switch (this.m_op) {
            case 0: {
                return l2 + l3;
            }
            case 1: {
                return l2 - l3;
            }
            case 2: {
                return l2 * l3;
            }
            case 3: {
                return l2 / l3;
            }
            case 4: {
                return (long)Math.pow(l2, l3);
            }
            case 5: {
                return l2 % l3;
            }
        }
        throw new IllegalStateException("Unknown operation type.");
    }

    public float getFloat(Tuple tuple) {
        float f2 = this.m_left.getFloat(tuple);
        float f3 = this.m_right.getFloat(tuple);
        switch (this.m_op) {
            case 0: {
                return f2 + f3;
            }
            case 1: {
                return f2 - f3;
            }
            case 2: {
                return f2 * f3;
            }
            case 3: {
                return f2 / f3;
            }
            case 4: {
                return (float)Math.pow(f2, f3);
            }
            case 5: {
                return (float)Math.IEEEremainder(f2, f3);
            }
        }
        throw new IllegalStateException("Unknown operation type.");
    }

    public double getDouble(Tuple tuple) {
        double d2 = this.m_left.getDouble(tuple);
        double d3 = this.m_right.getDouble(tuple);
        switch (this.m_op) {
            case 0: {
                return d2 + d3;
            }
            case 1: {
                return d2 - d3;
            }
            case 2: {
                return d2 * d3;
            }
            case 3: {
                return d2 / d3;
            }
            case 4: {
                return Math.pow(d2, d3);
            }
            case 5: {
                return Math.IEEEremainder(d2, d3);
            }
        }
        throw new IllegalStateException("Unknown operation type.");
    }

    public String toString() {
        char c2 = '?';
        switch (this.m_op) {
            case 0: {
                c2 = '+';
                break;
            }
            case 1: {
                c2 = '-';
                break;
            }
            case 2: {
                c2 = '*';
                break;
            }
            case 3: {
                c2 = '/';
                break;
            }
            case 4: {
                c2 = '^';
                break;
            }
            case 5: {
                c2 = '%';
            }
        }
        return '(' + this.m_left.toString() + ' ' + c2 + ' ' + this.m_right.toString() + ')';
    }
}

