/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.util.Arrays;
import java.util.HashMap;
import org.apache.naming.resources.CacheEntry;

public class ResourceCache {
    protected CacheEntry[] cache = new CacheEntry[0];
    protected HashMap notFoundCache = new HashMap();
    protected int cacheMaxSize = 10240;
    protected int maxAllocateIterations = 10;
    protected long desiredEntryAccessRatio = 3L;
    protected int spareNotFoundEntries = 500;
    protected int cacheSize = 0;
    protected long accessCount = 0L;
    protected long hitsCount = 0L;

    public long getAccessCount() {
        return this.accessCount;
    }

    public int getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    public void setCacheMaxSize(int cacheMaxSize) {
        this.cacheMaxSize = cacheMaxSize;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public long getDesiredEntryAccessRatio() {
        return this.desiredEntryAccessRatio;
    }

    public void setDesiredEntryAccessRatio(long desiredEntryAccessRatio) {
        this.desiredEntryAccessRatio = desiredEntryAccessRatio;
    }

    public long getHitsCount() {
        return this.hitsCount;
    }

    public int getMaxAllocateIterations() {
        return this.maxAllocateIterations;
    }

    public void setMaxAllocateIterations(int maxAllocateIterations) {
        this.maxAllocateIterations = maxAllocateIterations;
    }

    public int getSpareNotFoundEntries() {
        return this.spareNotFoundEntries;
    }

    public void setSpareNotFoundEntries(int spareNotFoundEntries) {
        this.spareNotFoundEntries = spareNotFoundEntries;
    }

    public boolean allocate(int space) {
        int toFree = space - (this.cacheMaxSize - this.cacheSize);
        if (toFree < 0) {
            return true;
        }
        int size = this.notFoundCache.size();
        if (size > this.spareNotFoundEntries) {
            this.notFoundCache.clear();
            this.cacheSize -= size;
            toFree -= size;
        }
        if (toFree < 0) {
            return true;
        }
        int attempts = 0;
        long totalSpace = 0L;
        int[] toRemove = new int[this.maxAllocateIterations];
        while (toFree > 0) {
            if (attempts == this.maxAllocateIterations) {
                return false;
            }
            if (toFree > 0) {
                int entryPos = -1;
                entryPos = (int)Math.round(Math.random() * (double)(this.cache.length - 1));
                int i = 0;
                while (i < attempts) {
                    if (toRemove[i] == entryPos) {
                        // empty if block
                    }
                    ++i;
                }
                long entryAccessRatio = this.cache[entryPos].accessCount * 100L / this.accessCount;
                if (entryAccessRatio < this.desiredEntryAccessRatio) {
                    toRemove[attempts] = entryPos;
                    totalSpace += (long)this.cache[entryPos].size;
                    toFree -= this.cache[entryPos].size;
                }
            }
            ++attempts;
        }
        Arrays.sort(toRemove, 0, attempts);
        CacheEntry[] newCache = new CacheEntry[this.cache.length - attempts];
        int pos = 0;
        int i = 0;
        while (i < attempts) {
            System.arraycopy(this.cache, pos, newCache, pos - i, toRemove[i] - pos);
            pos = toRemove[i] + 1;
            if (pos == this.cache.length) break;
            ++i;
        }
        this.cache = newCache;
        this.cacheSize = (int)((long)this.cacheSize - totalSpace);
        return true;
    }

    public CacheEntry lookup(String name) {
        CacheEntry cacheEntry = null;
        ++this.accessCount;
        int pos = ResourceCache.find(this.cache, name);
        if (pos != -1 && name.equals(this.cache[pos].name)) {
            cacheEntry = this.cache[pos];
        }
        if (cacheEntry == null) {
            try {
                cacheEntry = (CacheEntry)this.notFoundCache.get(name);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (cacheEntry != null) {
            ++this.hitsCount;
        }
        return cacheEntry;
    }

    public void load(CacheEntry entry) {
        if (entry.exists) {
            this.insertCache(entry);
        } else {
            this.notFoundCache.put(entry.name, entry);
        }
        this.cacheSize += entry.size;
    }

    public boolean unload(String name) {
        CacheEntry removedEntry = this.removeCache(name);
        if (removedEntry != null) {
            this.cacheSize -= removedEntry.size;
            return true;
        }
        if (this.notFoundCache.remove(name) != null) {
            --this.cacheSize;
            return true;
        }
        return false;
    }

    private static final int find(CacheEntry[] map, String name) {
        int a = 0;
        int b = map.length - 1;
        if (b == -1) {
            return -1;
        }
        if (name.compareTo(map[0].name) < 0) {
            return -1;
        }
        if (b == 0) {
            return 0;
        }
        int i = 0;
        do {
            i = (b + a) / 2;
            int result = name.compareTo(map[i].name);
            if (result > 0) {
                a = i;
                continue;
            }
            if (result == 0) {
                return i;
            }
            b = i;
        } while (b - a != 1);
        int result2 = name.compareTo(map[b].name);
        if (result2 < 0) {
            return a;
        }
        return b;
    }

    private final boolean insertCache(CacheEntry newElement) {
        CacheEntry[] oldCache = this.cache;
        int pos = ResourceCache.find(oldCache, newElement.name);
        if (pos != -1 && newElement.name.equals(oldCache[pos].name)) {
            return false;
        }
        CacheEntry[] newCache = new CacheEntry[this.cache.length + 1];
        System.arraycopy(oldCache, 0, newCache, 0, pos + 1);
        newCache[pos + 1] = newElement;
        System.arraycopy(oldCache, pos + 1, newCache, pos + 2, oldCache.length - pos - 1);
        this.cache = newCache;
        return true;
    }

    private final CacheEntry removeCache(String name) {
        CacheEntry[] oldCache = this.cache;
        int pos = ResourceCache.find(oldCache, name);
        if (pos != -1 && name.equals(oldCache[pos].name)) {
            CacheEntry[] newCache = new CacheEntry[this.cache.length - 1];
            System.arraycopy(oldCache, 0, newCache, 0, pos);
            System.arraycopy(oldCache, pos + 1, newCache, pos, oldCache.length - pos - 1);
            this.cache = newCache;
            return oldCache[pos];
        }
        return null;
    }
}

