/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.perfdata.monitor.protocol.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.VmIdentifier;
import sun.jvmstat.perfdata.monitor.AbstractPerfDataBuffer;

public class PerfDataBuffer
extends AbstractPerfDataBuffer {
    public PerfDataBuffer(VmIdentifier vmIdentifier) throws MonitorException {
        File file = new File(vmIdentifier.getURI());
        String string = vmIdentifier.getMode();
        try {
            FileChannel fileChannel = new RandomAccessFile(file, string).getChannel();
            MappedByteBuffer mappedByteBuffer = null;
            if (string.compareTo("r") == 0) {
                mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, (int)fileChannel.size());
            } else if (string.compareTo("rw") == 0) {
                mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, (int)fileChannel.size());
            } else {
                throw new IllegalArgumentException("Invalid mode: " + string);
            }
            fileChannel.close();
            this.createPerfDataBuffer(mappedByteBuffer, 0);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new MonitorException("Could not find " + vmIdentifier.toString());
        }
        catch (IOException iOException) {
            throw new MonitorException("Could not read " + vmIdentifier.toString());
        }
    }
}

