/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.connect.spi.ClosedConnectionException;
import com.sun.jdi.connect.spi.Connection;
import java.io.IOException;

class SharedMemoryConnection
extends Connection {
    private long id;
    private Object receiveLock = new Object();
    private Object sendLock = new Object();
    private Object closeLock = new Object();
    private boolean closed = false;

    private native byte receiveByte0(long var1) throws IOException;

    private native void sendByte0(long var1, byte var3) throws IOException;

    private native void close0(long var1);

    private native byte[] receivePacket0(long var1) throws IOException;

    private native void sendPacket0(long var1, byte[] var3) throws IOException;

    void handshake(long l) throws IOException {
        int n;
        byte[] byArray = "JDWP-Handshake".getBytes("UTF-8");
        for (n = 0; n < byArray.length; ++n) {
            this.sendByte0(this.id, byArray[n]);
        }
        for (n = 0; n < byArray.length; ++n) {
            byte by = this.receiveByte0(this.id);
            if (by == byArray[n]) continue;
            throw new IOException("handshake failed - unrecognized message from target VM");
        }
    }

    SharedMemoryConnection(long l) throws IOException {
        this.id = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.closeLock;
        synchronized (object) {
            if (!this.closed) {
                this.close0(this.id);
                this.closed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        Object object = this.closeLock;
        synchronized (object) {
            return !this.closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readPacket() throws IOException {
        byte[] byArray;
        if (!this.isOpen()) {
            throw new ClosedConnectionException("Connection closed");
        }
        try {
            Object object = this.receiveLock;
            synchronized (object) {
                byArray = this.receivePacket0(this.id);
            }
        }
        catch (IOException iOException) {
            if (!this.isOpen()) {
                throw new ClosedConnectionException("Connection closed");
            }
            throw iOException;
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePacket(byte[] byArray) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedConnectionException("Connection closed");
        }
        if (byArray.length < 11) {
            throw new IllegalArgumentException("packet is insufficient size");
        }
        int n = byArray[0] & 0xFF;
        int n2 = byArray[1] & 0xFF;
        int n3 = byArray[2] & 0xFF;
        int n4 = byArray[3] & 0xFF;
        int n5 = n << 24 | n2 << 16 | n3 << 8 | n4 << 0;
        if (n5 < 11) {
            throw new IllegalArgumentException("packet is insufficient size");
        }
        if (n5 > byArray.length) {
            throw new IllegalArgumentException("length mis-match");
        }
        try {
            Object object = this.sendLock;
            synchronized (object) {
                this.sendPacket0(this.id, byArray);
            }
        }
        catch (IOException iOException) {
            if (!this.isOpen()) {
                throw new ClosedConnectionException("Connection closed");
            }
            throw iOException;
        }
    }
}

