/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.GenericSPSConstantAction;

class CreateSPSConstantAction
extends GenericSPSConstantAction {
    private String schemaName;
    private String spsName;
    private UUID schemaId;
    private UUID compSchemaId;
    private String spsText;
    private String usingText;
    private boolean okInSys;
    private boolean nocompile;

    CreateSPSConstantAction(String string, String string2, String string3, String string4, UUID uUID, boolean bl, boolean bl2) {
        this.schemaName = string;
        this.spsName = string2;
        this.spsText = string3;
        this.usingText = string4;
        this.okInSys = bl;
        this.nocompile = bl2;
        this.compSchemaId = uUID;
    }

    public String toString() {
        return this.constructToString("CREATE STATEMENT ", this.spsName);
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        SPSDescriptor sPSDescriptor;
        DataDictionary dataDictionary;
        TransactionController transactionController;
        block8: {
            Object[] objectArray = null;
            LanguageConnectionContext languageConnectionContext = activation != null ? activation.getLanguageConnectionContext() : (LanguageConnectionContext)ContextService.getContext("LanguageConnectionContext");
            transactionController = languageConnectionContext.getTransactionExecute();
            dataDictionary = languageConnectionContext.getDataDictionary();
            SchemaDescriptor schemaDescriptor = this.okInSys ? dataDictionary.getSchemaDescriptor(this.schemaName, transactionController, true) : CreateSPSConstantAction.getSchemaDescriptorForCreate(dataDictionary, activation, this.schemaName);
            if (this.usingText != null) {
                objectArray = this.getUsingResults(this.usingText);
            }
            sPSDescriptor = new SPSDescriptor(dataDictionary, this.spsName, dataDictionary.getUUIDFactory().createUUID(), schemaDescriptor.getUUID(), this.compSchemaId == null ? languageConnectionContext.getDefaultSchema().getUUID() : this.compSchemaId, 'S', !this.nocompile, this.spsText, this.usingText, objectArray, !this.nocompile);
            if (!this.nocompile) {
                sPSDescriptor.prepareAndRelease(languageConnectionContext);
            }
            dataDictionary.startWriting(languageConnectionContext);
            if (activation == null) {
                TransactionController transactionController2 = null;
                try {
                    transactionController2 = transactionController.startNestedUserTransaction(false);
                }
                catch (StandardException standardException) {
                    // empty catch block
                }
                if (transactionController2 != null) {
                    try {
                        dataDictionary.addSPSDescriptor(sPSDescriptor, transactionController2, false);
                        transactionController2.commit();
                        transactionController2.destroy();
                        return;
                    }
                    catch (StandardException standardException) {
                        transactionController2.abort();
                        transactionController2.destroy();
                        if (standardException.getMessageId().equals("40XL1")) break block8;
                        throw standardException;
                    }
                }
            }
        }
        dataDictionary.addSPSDescriptor(sPSDescriptor, transactionController, true);
    }
}

