/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.CheckConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.GenericDescriptorList;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.CurrentOfNode;
import org.apache.derby.impl.sql.compile.CurrentRowLocationNode;
import org.apache.derby.impl.sql.compile.DMLModStatementNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.NumericConstantNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.VTIDeferModPolicy;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.execute.FKInfo;

public final class UpdateNode
extends DMLModStatementNode {
    public int[] changedColumnIds;
    public ExecRow emptyHeapRow;
    public boolean deferred;
    public ValueNode checkConstraints;
    public FKInfo fkInfo;
    protected FromTable targetTable;
    protected FormatableBitSet readColsBitSet;
    protected boolean positionedUpdate;
    public static final String COLUMNNAME = "###RowLocationToUpdate";

    public void init(Object object, Object object2) {
        super.init(object2);
        this.targetTableName = (TableName)object;
    }

    public String toString() {
        return "";
    }

    public String statementToString() {
        return "UPDATE";
    }

    public void printSubNodes(int n) {
    }

    public QueryTreeNode bind() throws StandardException {
        int n;
        Object object;
        Object object2;
        FromList fromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
        ResultColumn resultColumn = null;
        ValueNode valueNode = null;
        TableName tableName = null;
        CurrentOfNode currentOfNode = null;
        ResultColumnList resultColumnList = null;
        DataDictionary dataDictionary = this.getDataDictionary();
        this.bindTables(dataDictionary);
        SelectNode selectNode = (SelectNode)this.resultSet;
        this.targetTable = (FromTable)selectNode.fromList.elementAt(0);
        if (this.targetTable instanceof CurrentOfNode) {
            this.positionedUpdate = true;
            currentOfNode = (CurrentOfNode)this.targetTable;
            tableName = currentOfNode.getBaseCursorTargetTableName();
        }
        if (this.targetTable instanceof FromVTI) {
            this.targetVTI = (FromVTI)this.targetTable;
            this.targetVTI.setTarget();
        } else {
            if (this.targetTableName == null) {
                this.targetTableName = tableName;
            } else if (tableName != null && !this.targetTableName.equals(tableName)) {
                throw StandardException.newException("42X29", this.targetTableName, (Object)currentOfNode.getCursorName());
            }
            this.verifyTargetTable();
        }
        this.resultSet.getResultColumns().markUpdated();
        FromList fromList2 = this.resultSet.getFromList();
        this.resultSet.bindResultColumns(this.targetTableDescriptor, this.targetVTI, this.resultSet.resultColumns, this, fromList);
        LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
        if (!languageConnectionContext.getAutoincrementUpdate()) {
            this.resultSet.getResultColumns().checkAutoincrement(null);
        }
        boolean bl = false;
        if (this.targetTable instanceof FromBaseTable) {
            ((FromBaseTable)this.targetTable).markUpdated(this.resultSet.getResultColumns());
        } else if (this.targetTable instanceof FromVTI) {
            this.resultColumnList = this.resultSet.getResultColumns();
        } else {
            object2 = currentOfNode.getCursorStatement();
            object = object2.getUpdateColumns();
            if (object == null || ((String[])object).length == 0) {
                this.getResultColumnList();
                resultColumnList = this.resultSet.getResultColumns().expandToAll(this.targetTableDescriptor, this.targetTable.getTableName());
                this.getAffectedIndexes(this.targetTableDescriptor, null, null);
                bl = true;
            } else {
                this.resultSet.getResultColumns().checkColumnUpdateability((String[])object, currentOfNode.getCursorName());
            }
        }
        this.changedColumnIds = this.getChangedColumnIds(this.resultSet.getResultColumns());
        if (!bl && this.targetVTI == null) {
            int n2;
            this.readColsBitSet = new FormatableBitSet();
            object2 = this.getResultColumnList(this.resultSet.getResultColumns());
            resultColumnList = this.resultSet.getResultColumns().copyListAndObjects();
            this.readColsBitSet = this.getReadMap(dataDictionary, this.targetTableDescriptor, resultColumnList);
            resultColumnList = ((FromBaseTable)object2).addColsToList(resultColumnList, this.readColsBitSet);
            this.resultColumnList = ((FromBaseTable)object2).addColsToList(this.resultColumnList, this.readColsBitSet);
            n = this.targetTableDescriptor.getMaxColumnID();
            for (n2 = 1; n2 <= n && this.readColsBitSet.get(n2); ++n2) {
            }
            if (n2 > n) {
                this.readColsBitSet = null;
                bl = true;
            }
        }
        if (this.targetVTI == null) {
            this.emptyHeapRow = this.targetTableDescriptor.getEmptyExecRow(this.getContextManager());
            this.resultColumnList.appendResultColumns(resultColumnList, false);
            valueNode = (CurrentRowLocationNode)this.getNodeFactory().getNode(2, this.getContextManager());
        } else {
            valueNode = (NumericConstantNode)this.getNodeFactory().getNode(70, ReuseFactory.getInteger(0), this.getContextManager());
        }
        resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, COLUMNNAME, valueNode, this.getContextManager());
        resultColumn.markGenerated();
        this.resultColumnList.addResultColumn(resultColumn);
        this.resultColumnList.clearTableNames();
        this.resultSet.setResultColumns(this.resultColumnList);
        super.bindExpressions();
        this.resultSet.getResultColumns().bindUntypedNullsToResultColumns(this.resultColumnList);
        if (null != resultColumn) {
            resultColumn.bindResultColumnToExpression();
        }
        this.resultColumnList.checkStorableExpressions();
        if (!this.resultColumnList.columnTypesAndLengthsMatch()) {
            this.resultSet = this.resultSet.genNormalizeResultSetNode(this.resultSet, true);
            this.resultColumnList.copyTypesAndLengthsToSource(this.resultSet.getResultColumns());
            if (this.hasCheckConstraints(dataDictionary, this.targetTableDescriptor)) {
                int n3 = resultColumnList.size();
                resultColumnList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
                object = this.resultSet.getResultColumns();
                for (n = 0; n < n3; ++n) {
                    resultColumnList.addElement(((QueryTreeNodeVector)object).elementAt(n + n3));
                }
            }
        }
        if (null != this.targetVTI) {
            this.deferred = VTIDeferModPolicy.deferIt(2, this.targetVTI, this.resultColumnList.getColumnNames(), selectNode.getWhereClause());
        } else {
            boolean bl2 = this.getAllRelevantTriggers(dataDictionary, this.targetTableDescriptor, this.changedColumnIds, true).size() > 0;
            this.checkConstraints = this.bindConstraints(dataDictionary, this.getNodeFactory(), this.targetTableDescriptor, null, bl2 ? this.resultColumnList : resultColumnList, this.changedColumnIds, this.readColsBitSet, false, true);
            if (this.resultSet.subqueryReferencesTarget(this.targetTableDescriptor.getName(), true) || this.requiresDeferredProcessing()) {
                this.deferred = true;
            }
        }
        return this;
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.resultSet.referencesSessionSchema();
    }

    public ConstantAction makeConstantAction() throws StandardException {
        ConglomerateDescriptor conglomerateDescriptor;
        if (!this.deferred && (conglomerateDescriptor = this.targetTable.getTrulyTheBestAccessPath().getConglomerateDescriptor()) != null && conglomerateDescriptor.isIndex()) {
            int[] nArray = conglomerateDescriptor.getIndexDescriptor().baseColumnPositions();
            if (this.resultSet.getResultColumns().updateOverlaps(nArray)) {
                this.deferred = true;
            }
        }
        if (null == this.targetTableDescriptor) {
            return this.getGenericConstantActionFactory().getUpdatableVTIConstantAction(2, this.deferred, this.changedColumnIds);
        }
        int n = this.resultSet.updateTargetLockMode();
        long l = this.targetTableDescriptor.getHeapConglomerateId();
        TransactionController transactionController = this.getLanguageConnectionContext().getTransactionCompile();
        StaticCompiledOpenConglomInfo[] staticCompiledOpenConglomInfoArray = new StaticCompiledOpenConglomInfo[this.indexConglomerateNumbers.length];
        for (int i = 0; i < staticCompiledOpenConglomInfoArray.length; ++i) {
            staticCompiledOpenConglomInfoArray[i] = transactionController.getStaticCompiledConglomInfo(this.indexConglomerateNumbers[i]);
        }
        if (this.targetTableDescriptor.getLockGranularity() == 'T') {
            n = 7;
        }
        return this.getGenericConstantActionFactory().getUpdateConstantAction(l, this.targetTableDescriptor.getTableType(), transactionController.getStaticCompiledConglomInfo(l), this.indicesToMaintain, this.indexConglomerateNumbers, staticCompiledOpenConglomInfoArray, this.indexNames, this.emptyHeapRow, this.deferred, this.targetTableDescriptor.getUUID(), n, false, this.changedColumnIds, null, null, this.getFKInfo(), this.getTriggerInfo(), this.readColsBitSet == null ? (FormatableBitSet)null : new FormatableBitSet(this.readColsBitSet), UpdateNode.getReadColMap(this.targetTableDescriptor.getNumberOfColumns(), this.readColsBitSet), this.resultColumnList.getStreamStorableColIds(this.targetTableDescriptor.getNumberOfColumns()), this.readColsBitSet == null ? this.targetTableDescriptor.getNumberOfColumns() : this.readColsBitSet.getNumBitsSet(), this.positionedUpdate, this.resultSet.isOneRowResultSet());
    }

    protected void setDeferredForUpdateOfIndexColumn() {
        ConglomerateDescriptor conglomerateDescriptor;
        if (!this.deferred && (conglomerateDescriptor = this.targetTable.getTrulyTheBestAccessPath().getConglomerateDescriptor()) != null && conglomerateDescriptor.isIndex()) {
            int[] nArray = conglomerateDescriptor.getIndexDescriptor().baseColumnPositions();
            if (this.resultSet.getResultColumns().updateOverlaps(nArray)) {
                this.deferred = true;
            }
        }
    }

    public void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.generateCodeForTemporaryTable(activationClassBuilder, methodBuilder);
        if (!this.isDependentTable) {
            this.generateParameterValueSet(activationClassBuilder);
        }
        activationClassBuilder.newFieldDeclaration(2, "org.apache.derby.iapi.sql.execute.CursorResultSet", activationClassBuilder.newRowLocationScanResultSetName());
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        this.resultSet.generate(activationClassBuilder, methodBuilder);
        if (null != this.targetVTI) {
            this.targetVTI.assignCostEstimate(this.resultSet.getNewCostEstimate());
            activationClassBuilder.pushThisAsActivation(methodBuilder);
            methodBuilder.callMethod((short)185, null, "getUpdateVTIResultSet", "org.apache.derby.iapi.sql.ResultSet", 2);
        } else {
            this.generateCheckConstraints(this.checkConstraints, activationClassBuilder, methodBuilder);
            activationClassBuilder.pushThisAsActivation(methodBuilder);
            if (this.isDependentTable) {
                methodBuilder.push(activationClassBuilder.addItem(this.makeConstantAction()));
                methodBuilder.push(activationClassBuilder.addItem(this.makeResultDescription()));
                methodBuilder.callMethod((short)185, null, "getDeleteCascadeUpdateResultSet", "org.apache.derby.iapi.sql.ResultSet", 5);
            } else {
                methodBuilder.callMethod((short)185, null, "getUpdateResultSet", "org.apache.derby.iapi.sql.ResultSet", 3);
            }
        }
        if (!this.isDependentTable) {
            this.generateParameterHolders(activationClassBuilder);
        }
    }

    protected final int getStatementType() {
        return 3;
    }

    public FormatableBitSet getReadMap(DataDictionary dataDictionary, TableDescriptor tableDescriptor, ResultColumnList resultColumnList) throws StandardException {
        boolean[] blArray = new boolean[]{this.requiresDeferredProcessing()};
        Vector vector = new Vector();
        this.relevantCdl = new ConstraintDescriptorList();
        this.relevantTriggers = new GenericDescriptorList();
        FormatableBitSet formatableBitSet = UpdateNode.getUpdateReadMap(tableDescriptor, resultColumnList, vector, this.relevantCdl, this.relevantTriggers, blArray);
        this.markAffectedIndexes(vector);
        this.adjustDeferredFlag(blArray[0]);
        return formatableBitSet;
    }

    private int[] getChangedColumnIds(ResultColumnList resultColumnList) {
        if (resultColumnList == null) {
            return null;
        }
        return resultColumnList.sortMe();
    }

    public static FormatableBitSet getUpdateReadMap(TableDescriptor tableDescriptor, ResultColumnList resultColumnList, Vector vector, ConstraintDescriptorList constraintDescriptorList, GenericDescriptorList genericDescriptorList, boolean[] blArray) throws StandardException {
        int n;
        int n2;
        int n3 = tableDescriptor.getMaxColumnID();
        FormatableBitSet formatableBitSet = new FormatableBitSet(n3 + 1);
        int[] nArray = resultColumnList.sortMe();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            formatableBitSet.set(nArray[n2]);
        }
        DMLModStatementNode.getXAffectedIndexes(tableDescriptor, resultColumnList, formatableBitSet, vector);
        tableDescriptor.getAllRelevantConstraints(3, false, nArray, blArray, constraintDescriptorList);
        n2 = constraintDescriptorList.size();
        for (n = 0; n < n2; ++n) {
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(n);
            if (constraintDescriptor.getConstraintType() != 4) continue;
            int[] nArray2 = ((CheckConstraintDescriptor)constraintDescriptor).getReferencedColumns();
            for (int i = 0; i < nArray2.length; ++i) {
                formatableBitSet.set(nArray2[i]);
            }
        }
        tableDescriptor.getAllRelevantTriggers(3, nArray, genericDescriptorList);
        if (genericDescriptorList.size() > 0) {
            blArray[0] = true;
        }
        if (genericDescriptorList.size() > 0) {
            for (n = 1; n <= n3; ++n) {
                formatableBitSet.set(n);
            }
        }
        return formatableBitSet;
    }
}

