/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AllResultColumn;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.DMLStatementNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.GroupByNode;
import org.apache.derby.impl.sql.compile.JoinNode;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VerifyAggregateExpressionsVisitor;

public class SelectNode
extends ResultSetNode {
    FromList fromList;
    FromTable targetTable;
    Vector selectAggregates;
    Vector whereAggregates;
    ValueNode whereClause;
    ValueNode originalWhereClause;
    GroupByList groupByList;
    OrderByList orderByList;
    boolean orderByQuery;
    PredicateList wherePredicates;
    SubqueryList selectSubquerys;
    SubqueryList whereSubquerys;
    private boolean bindTargetListOnly;
    private boolean isDistinct;
    private boolean orderByAndDistinctMerged;
    private boolean generatedForGroupByClause;
    private boolean generatedForHavingClause;
    private FromList preJoinFL;

    public void init(Object object, Object object2, Object object3, Object object4, Object object5) throws StandardException {
        this.resultColumns = (ResultColumnList)object;
        this.fromList = (FromList)object3;
        this.whereClause = (ValueNode)object4;
        this.originalWhereClause = (ValueNode)object4;
        this.groupByList = (GroupByList)object5;
        this.bindTargetListOnly = false;
    }

    public String toString() {
        return "";
    }

    public String statementToString() {
        return "SELECT";
    }

    public void makeDistinct() {
        this.isDistinct = true;
    }

    public void clearDistinct() {
        this.isDistinct = false;
    }

    boolean hasDistinct() {
        return this.isDistinct;
    }

    public void markAsForGroupByClause() {
        this.generatedForGroupByClause = true;
    }

    public boolean getGeneratedForGroupbyClause() {
        return this.generatedForGroupByClause;
    }

    public void markAsForHavingClause() {
        this.generatedForHavingClause = true;
    }

    public void printSubNodes(int n) {
    }

    public FromList getFromList() {
        return this.fromList;
    }

    public GroupByList getGroupByList() {
        return this.groupByList;
    }

    public ValueNode getWhereClause() {
        return this.whereClause;
    }

    public PredicateList getWherePredicates() {
        return this.wherePredicates;
    }

    public SubqueryList getSelectSubquerys() {
        return this.selectSubquerys;
    }

    public Vector getAggregateVector(int n) {
        switch (n) {
            case 1: {
                return this.selectAggregates;
            }
            case 2: {
                if (this.generatedForHavingClause) {
                    return null;
                }
                return this.whereAggregates;
            }
            case 3: {
                if (this.generatedForHavingClause) {
                    return this.whereAggregates;
                }
                return null;
            }
        }
        return null;
    }

    public SubqueryList getWhereSubquerys() {
        return this.whereSubquerys;
    }

    public ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromList) throws StandardException {
        int n;
        int n2 = fromList.size();
        int n3 = this.fromList.size();
        FromList fromList2 = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
        this.wherePredicates = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        this.preJoinFL = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
        int n4 = fromList.size() == 0 ? 0 : ((FromTable)fromList.elementAt(0)).getLevel() + 1;
        this.fromList.setLevel(n4);
        for (n = 0; n < n3; ++n) {
            fromList.insertElementAt(this.fromList.elementAt(n), 0);
        }
        this.fromList.bindTables(dataDictionary, fromList);
        for (n = 0; n < n3; ++n) {
            fromList.removeElementAt(0);
        }
        return this;
    }

    public void bindExpressions(FromList fromList) throws StandardException {
        int n;
        int n2;
        int n3 = fromList.size();
        int n4 = this.fromList.size();
        if (!this.bindTargetListOnly) {
            this.fromList.bindExpressions();
        }
        this.selectSubquerys = (SubqueryList)this.getNodeFactory().getNode(11, this.getContextManager());
        this.selectAggregates = new Vector();
        for (n2 = 0; n2 < n4; ++n2) {
            fromList.insertElementAt(this.fromList.elementAt(n2), n2);
        }
        this.resultColumns.setClause(1);
        this.resultColumns.bindExpressions(fromList, this.selectSubquerys, this.selectAggregates);
        if (this.bindTargetListOnly) {
            for (n2 = 0; n2 < n4; ++n2) {
                fromList.removeElementAt(0);
            }
            return;
        }
        this.whereAggregates = new Vector();
        this.whereSubquerys = (SubqueryList)this.getNodeFactory().getNode(11, this.getContextManager());
        if (this.whereClause != null) {
            this.whereClause = this.whereClause.bindExpression(fromList, this.whereSubquerys, this.whereAggregates);
            if (this.whereAggregates.size() > 0 && !this.generatedForHavingClause) {
                throw StandardException.newException("42903");
            }
            if (this.whereClause.isParameterNode()) {
                throw StandardException.newException("42X19", "PARAMETER");
            }
            this.whereClause = this.whereClause.checkIsBoolean();
        }
        for (n2 = 0; n2 < n4; ++n2) {
            fromList.removeElementAt(0);
        }
        if (this.groupByList != null) {
            Vector vector = new Vector();
            this.groupByList.bindGroupByColumns(this, vector);
        }
        if (this.groupByList != null || this.selectAggregates.size() > 0) {
            VerifyAggregateExpressionsVisitor verifyAggregateExpressionsVisitor = new VerifyAggregateExpressionsVisitor(this.groupByList);
            this.resultColumns.accept(verifyAggregateExpressionsVisitor);
        }
        if ((n = SelectNode.numDistinctAggregates(this.selectAggregates)) > 1) {
            throw StandardException.newException("42Z02");
        }
    }

    public void bindExpressionsWithTables(FromList fromList) throws StandardException {
        this.bindExpressions(fromList);
    }

    public void bindTargetExpressions(FromList fromList) throws StandardException {
        this.bindTargetListOnly = true;
        this.bindExpressions(fromList);
        this.bindTargetListOnly = false;
    }

    public void bindResultColumns(FromList fromList) throws StandardException {
        this.fromList.bindResultColumns(fromList);
        super.bindResultColumns(fromList);
        if (this.resultColumns.size() > 1012) {
            throw StandardException.newException("54004");
        }
        if (this.fromList.hasOuterJoins()) {
            this.resultColumns.setNullability(true);
        }
    }

    public void bindResultColumns(TableDescriptor tableDescriptor, FromVTI fromVTI, ResultColumnList resultColumnList, DMLStatementNode dMLStatementNode, FromList fromList) throws StandardException {
        this.fromList.bindResultColumns(fromList);
        super.bindResultColumns(tableDescriptor, fromVTI, resultColumnList, dMLStatementNode, fromList);
    }

    void pushExpressionsIntoSelect(Predicate predicate) throws StandardException {
        this.wherePredicates.pullExpressions(this.referencedTableMap.size(), predicate.getAndNode());
        this.fromList.pushPredicates(this.wherePredicates);
    }

    public void verifySelectStarSubquery(FromList fromList, int n) throws StandardException {
        if (!((ResultColumn)this.resultColumns.elementAt(0) instanceof AllResultColumn)) {
            return;
        }
        if (this.generatedForGroupByClause || this.generatedForHavingClause) {
            return;
        }
        if (n != 15) {
            throw StandardException.newException("42X38");
        }
        String string = ((AllResultColumn)this.resultColumns.elementAt(0)).getFullTableName();
        if (string != null && this.fromList.getFromTableByName(string, null, true) == null && fromList.getFromTableByName(string, null, true) == null && this.fromList.getFromTableByName(string, null, false) == null && fromList.getFromTableByName(string, null, false) == null) {
            throw StandardException.newException("42X10", string);
        }
    }

    protected FromTable getFromTableByName(String string, String string2, boolean bl) throws StandardException {
        return this.fromList.getFromTableByName(string, string2, bl);
    }

    public void rejectParameters() throws StandardException {
        super.rejectParameters();
        this.fromList.rejectParameters();
    }

    void pushOrderByList(OrderByList orderByList) {
        this.orderByList = orderByList;
        this.orderByQuery = true;
    }

    public ResultSetNode preprocess(int n, GroupByList groupByList, FromList fromList) throws StandardException {
        ResultSetNode resultSetNode = this;
        this.normExpressions();
        boolean bl = this.fromList.LOJ_reorderable(n);
        if (bl) {
            FromList fromList2 = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
            this.bindExpressions(fromList2);
        }
        this.fromList.preprocess(n, this.groupByList, this.whereClause);
        this.resultColumns.preprocess(n, this.fromList, this.whereSubquerys, this.wherePredicates);
        if (this.whereClause != null) {
            this.whereClause.preprocess(n, this.fromList, this.whereSubquerys, this.wherePredicates);
        }
        if (this.whereClause != null) {
            this.wherePredicates.pullExpressions(n, this.whereClause);
            this.whereClause = null;
        }
        this.fromList.flattenFromTables(this.resultColumns, this.wherePredicates, this.whereSubquerys, this.groupByList);
        if (this.wherePredicates != null && this.wherePredicates.size() > 0 && this.fromList.size() > 0) {
            if (this.fromList.size() > 1) {
                this.performTransitiveClosure(n);
            }
            if (this.orderByList != null) {
                this.orderByList.removeConstantColumns(this.wherePredicates);
                if (this.orderByList.size() == 0) {
                    this.orderByList = null;
                }
            }
        }
        if (this.groupByList != null && this.selectAggregates.size() == 0 && this.whereAggregates.size() == 0) {
            this.isDistinct = true;
            this.groupByList = null;
        }
        if (this.isDistinct && this.groupByList == null) {
            int n2 = this.resultColumns.allTopCRsFromSameTable();
            if (n2 != -1 && this.fromList.returnsAtMostSingleRow(this.resultColumns, this.whereClause, this.wherePredicates, this.getDataDictionary())) {
                this.isDistinct = false;
            }
            if (this.isDistinct && this.orderByList != null && this.orderByList.allAscending()) {
                if (this.orderByList.isInOrderPrefix(this.resultColumns)) {
                    this.orderByList = null;
                } else {
                    resultSetNode = this.genProjectRestrictForReordering();
                    this.orderByList.resetToSourceRCs();
                    this.resultColumns = this.orderByList.reorderRCL(this.resultColumns);
                    this.orderByList = null;
                }
                this.orderByAndDistinctMerged = true;
            }
        }
        this.fromList.pushPredicates(this.wherePredicates);
        this.referencedTableMap = new JBitSet(n);
        int n3 = this.fromList.size();
        for (int i = 0; i < n3; ++i) {
            this.referencedTableMap.or(((FromTable)this.fromList.elementAt(i)).getReferencedTableMap());
        }
        if (resultSetNode != this) {
            resultSetNode.setReferencedTableMap((JBitSet)this.referencedTableMap.clone());
        }
        return resultSetNode;
    }

    private void performTransitiveClosure(int n) throws StandardException {
        this.wherePredicates.joinClauseTransitiveClosure(n, this.fromList, this.getCompilerContext());
        this.wherePredicates.searchClauseTransitiveClosure(n, this.fromList.hashJoinSpecified());
    }

    private void normExpressions() throws StandardException {
        if (this.whereClause != null) {
            this.whereClause = this.whereClause.eliminateNots(false);
            this.whereClause = this.whereClause.putAndsOnTop();
            this.whereClause = this.whereClause.changeToCNF(true);
        }
    }

    public ResultSetNode addNewPredicate(Predicate predicate) throws StandardException {
        this.wherePredicates.addPredicate(predicate);
        return this;
    }

    public boolean flattenableInFromSubquery(FromList fromList) {
        if (this.isDistinct) {
            return false;
        }
        if (this.fromList.size() > 1) {
            return false;
        }
        if (this.selectSubquerys != null && this.selectSubquerys.size() > 0) {
            return false;
        }
        if (this.groupByList != null || this.generatedForHavingClause) {
            return false;
        }
        if (!this.resultColumns.isCloneable()) {
            return false;
        }
        return this.selectAggregates == null || this.selectAggregates.size() <= 0;
    }

    public ResultSetNode genProjectRestrict(int n) throws StandardException {
        boolean bl = false;
        ResultSetNode resultSetNode = (ResultSetNode)this.getNodeFactory().getNode(151, this.fromList.elementAt(0), this.resultColumns, this.whereClause, this.wherePredicates, this.selectSubquerys, this.whereSubquerys, null, this.getContextManager());
        if (this.selectAggregates != null && this.selectAggregates.size() > 0 || this.groupByList != null) {
            GroupByNode groupByNode = (GroupByNode)this.getNodeFactory().getNode(137, resultSetNode, this.groupByList, this.selectAggregates, null, this.getContextManager());
            groupByNode.considerPostOptimizeOptimizations(this.originalWhereClause != null);
            groupByNode.assignCostEstimate(this.optimizer.getOptimizedCost());
            this.groupByList = null;
            resultSetNode = groupByNode.getParent();
            boolean bl2 = bl = bl || groupByNode.getIsInSortedOrder();
        }
        if (this.isDistinct) {
            this.resultColumns.verifyAllOrderable();
            if (n == 1 && !this.orderByAndDistinctMerged && this.resultColumns.countNumberOfSimpleColumnReferences() == this.resultColumns.size() && resultSetNode.isPossibleDistinctScan()) {
                resultSetNode.markForDistinctScan();
            } else {
                boolean bl3 = this.isOrderedResult(this.resultColumns, resultSetNode, !this.orderByAndDistinctMerged);
                resultSetNode = (ResultSetNode)this.getNodeFactory().getNode(124, resultSetNode, new Boolean(bl3), null, this.getContextManager());
                resultSetNode.costEstimate = this.costEstimate.cloneMe();
                boolean bl4 = bl = bl || bl3;
            }
        }
        if (this.orderByList != null) {
            int n2;
            if (this.orderByList.getSortNeeded()) {
                resultSetNode = (ResultSetNode)this.getNodeFactory().getNode(140, resultSetNode, this.orderByList, null, this.getContextManager());
                resultSetNode.costEstimate = this.costEstimate.cloneMe();
            }
            if ((n2 = this.getResultColumns().getOrderBySelect()) > 0) {
                ResultColumnList resultColumnList = resultSetNode.getResultColumns().copyListAndObjects();
                int n3 = resultColumnList.size();
                int n4 = n3 - 1;
                while (n2 > 0) {
                    resultColumnList.removeElementAt(n4);
                    --n4;
                    --n2;
                }
                resultColumnList.genVirtualColumnNodes(resultSetNode, resultSetNode.getResultColumns());
                resultSetNode = (ResultSetNode)this.getNodeFactory().getNode(151, resultSetNode, resultColumnList, null, null, null, null, null, this.getContextManager());
            }
        }
        if ((this.orderByList == null || !this.orderByList.getSortNeeded()) && this.orderByQuery) {
            bl = true;
        }
        if (bl) {
            resultSetNode.markOrderingDependent();
        }
        resultSetNode.costEstimate = this.costEstimate.cloneMe();
        return resultSetNode;
    }

    private boolean isOrderedResult(ResultColumnList resultColumnList, ResultSetNode resultSetNode, boolean bl) throws StandardException {
        int n = resultColumnList.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(i);
            if (resultColumn.getExpression() instanceof ColumnReference) {
                ++n2;
                continue;
            }
            if (resultColumn.getExpression() instanceof ConstantNode) continue;
            return false;
        }
        if (n2 == 0) {
            return true;
        }
        ColumnReference[] columnReferenceArray = new ColumnReference[n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(i);
            if (!(resultColumn.getExpression() instanceof ColumnReference)) continue;
            columnReferenceArray[n3++] = (ColumnReference)resultColumn.getExpression();
        }
        return resultSetNode.isOrderedOn(columnReferenceArray, bl, null);
    }

    public ResultSetNode ensurePredicateList(int n) throws StandardException {
        return this;
    }

    public ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicateList, double d) throws StandardException {
        Optimizer optimizer = this.getOptimizer(this.fromList, this.wherePredicates, dataDictionary, this.orderByList);
        optimizer.setOuterRows(d);
        while (optimizer.getNextPermutation()) {
            while (optimizer.getNextDecoratedPermutation()) {
                optimizer.costPermutation();
            }
        }
        this.costEstimate = optimizer.getOptimizedCost();
        if (this.selectAggregates != null && this.selectAggregates.size() > 0) {
            this.costEstimate.setEstimatedRowCount((long)d);
            this.costEstimate.setSingleScanRowCount(1.0);
        }
        this.selectSubquerys.optimize(dataDictionary, this.costEstimate.rowCount());
        if (this.whereSubquerys != null && this.whereSubquerys.size() > 0) {
            this.whereSubquerys.optimize(dataDictionary, this.costEstimate.rowCount());
        }
        return this;
    }

    public ResultSetNode modifyAccessPaths() throws StandardException {
        int n = this.fromList.size();
        this.optimizer.modifyAccessPaths();
        this.selectSubquerys.modifyAccessPaths();
        if (this.whereSubquerys != null && this.whereSubquerys.size() > 0) {
            this.whereSubquerys.modifyAccessPaths();
        }
        this.preJoinFL.removeAllElements();
        this.preJoinFL.nondestructiveAppend(this.fromList);
        while (this.fromList.size() > 1) {
            ResultSetNode resultSetNode = (ResultSetNode)this.fromList.elementAt(0);
            ResultColumnList resultColumnList = resultSetNode.getResultColumns();
            resultSetNode.setResultColumns(resultColumnList.copyListAndObjects());
            resultColumnList.genVirtualColumnNodes(resultSetNode, resultSetNode.resultColumns);
            ResultSetNode resultSetNode2 = (ResultSetNode)this.fromList.elementAt(1);
            ResultColumnList resultColumnList2 = resultSetNode2.getResultColumns();
            resultSetNode2.setResultColumns(resultColumnList2.copyListAndObjects());
            resultColumnList2.genVirtualColumnNodes(resultSetNode2, resultSetNode2.resultColumns);
            resultColumnList2.adjustVirtualColumnIds(resultColumnList.size());
            resultColumnList.nondestructiveAppend(resultColumnList2);
            this.fromList.setElementAt((JoinNode)this.getNodeFactory().getNode(139, resultSetNode, resultSetNode2, null, null, resultColumnList, null, this.getContextManager()), 0);
            this.fromList.removeElementAt(1);
        }
        return this.genProjectRestrict(n);
    }

    boolean isUpdatableCursor(DataDictionary dataDictionary) throws StandardException {
        if (this.isDistinct) {
            return false;
        }
        if (this.selectAggregates == null || this.selectAggregates.size() > 0) {
            return false;
        }
        if (this.groupByList != null || this.generatedForHavingClause) {
            return false;
        }
        if (this.fromList.size() != 1) {
            return false;
        }
        this.targetTable = (FromTable)this.fromList.elementAt(0);
        if (this.targetTable instanceof FromVTI) {
            return ((FromVTI)this.targetTable).isUpdatableCursor();
        }
        if (!(this.targetTable instanceof FromBaseTable)) {
            return false;
        }
        TableDescriptor tableDescriptor = this.getTableDescriptor(((FromBaseTable)this.targetTable).getBaseTableName(), this.getSchemaDescriptor(((FromBaseTable)this.targetTable).getTableNameField().getSchemaName()));
        if (tableDescriptor.getTableType() == 1) {
            return false;
        }
        if (tableDescriptor.getTableType() == 2) {
            return false;
        }
        if (this.getSelectSubquerys() != null && this.getSelectSubquerys().size() != 0) {
            return false;
        }
        return this.getWhereSubquerys() == null || this.getWhereSubquerys().size() == 0;
    }

    FromTable getCursorTargetTable() {
        return this.targetTable;
    }

    public boolean referencesTarget(String string, boolean bl) throws StandardException {
        return this.fromList.referencesTarget(string, bl) || this.selectSubquerys != null && this.selectSubquerys.referencesTarget(string, bl) || this.whereSubquerys != null && this.whereSubquerys.referencesTarget(string, bl);
    }

    boolean subqueryReferencesTarget(String string, boolean bl) throws StandardException {
        return this.selectSubquerys != null && this.selectSubquerys.referencesTarget(string, bl) || this.whereSubquerys != null && this.whereSubquerys.referencesTarget(string, bl);
    }

    public void bindUntypedNullsToResultColumns(ResultColumnList resultColumnList) throws StandardException {
        this.fromList.bindUntypedNullsToResultColumns(resultColumnList);
    }

    void decrementLevel(int n) {
        this.fromList.decrementLevel(n);
        this.selectSubquerys.decrementLevel(n);
        this.whereSubquerys.decrementLevel(n);
        this.wherePredicates.decrementLevel(this.fromList, n);
    }

    boolean uniqueSubquery(boolean bl) throws StandardException {
        ColumnReference columnReference = null;
        ResultColumn resultColumn = (ResultColumn)this.getResultColumns().elementAt(0);
        if (bl && resultColumn.getExpression() instanceof ColumnReference && (columnReference = (ColumnReference)resultColumn.getExpression()).getCorrelated()) {
            columnReference = null;
        }
        return this.fromList.returnsAtMostSingleRow(columnReference == null ? null : this.getResultColumns(), this.whereClause, this.wherePredicates, this.getDataDictionary());
    }

    public int updateTargetLockMode() {
        return this.fromList.updateTargetLockMode();
    }

    boolean returnsAtMostOneRow() {
        return this.groupByList == null && this.selectAggregates != null && this.selectAggregates.size() != 0;
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.fromList.referencesSessionSchema() || this.selectSubquerys != null && this.selectSubquerys.referencesSessionSchema() || this.whereSubquerys != null && this.whereSubquerys.referencesSessionSchema();
    }

    public Visitable accept(Visitor visitor) throws StandardException {
        Visitable visitable = visitor.visit(this);
        if (visitor.skipChildren(this)) {
            return visitable;
        }
        if (!visitor.stopTraversal()) {
            super.accept(visitor);
        }
        if (this.fromList != null && !visitor.stopTraversal()) {
            this.fromList = (FromList)this.fromList.accept(visitor);
        }
        if (this.whereClause != null && !visitor.stopTraversal()) {
            this.whereClause = (ValueNode)this.whereClause.accept(visitor);
        }
        if (this.wherePredicates != null && !visitor.stopTraversal()) {
            this.wherePredicates = (PredicateList)this.wherePredicates.accept(visitor);
        }
        return visitable;
    }
}

