/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizableList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromSubquery;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.HalfOuterJoinNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class FromList
extends QueryTreeNodeVector
implements OptimizableList {
    Properties properties;
    boolean fixedJoinOrder = true;
    boolean useStatistics = true;

    public void init(Object object) {
        this.fixedJoinOrder = (Boolean)object == false;
    }

    public void init(Object object, Object object2) throws StandardException {
        this.init(object);
        this.addFromTable((FromTable)object2);
    }

    public Optimizable getOptimizable(int n) {
        return (Optimizable)((Object)this.elementAt(n));
    }

    public void setOptimizable(int n, Optimizable optimizable) {
        this.setElementAt((FromTable)optimizable, n);
    }

    public void verifyProperties(DataDictionary dataDictionary) throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ((Optimizable)((Object)this.elementAt(i))).verifyProperties(dataDictionary);
        }
    }

    public void addFromTable(FromTable fromTable) throws StandardException {
        if (!(fromTable instanceof TableOperatorNode)) {
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                if (!fromTable.getExposedName().equals(((FromTable)this.elementAt(i)).getExposedName())) continue;
                throw StandardException.newException("42X09", fromTable.getExposedName());
            }
        }
        this.addElement(fromTable);
    }

    public boolean referencesTarget(String string, boolean bl) throws StandardException {
        boolean bl2 = false;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            FromTable fromTable = (FromTable)this.elementAt(i);
            if (!fromTable.referencesTarget(string, bl)) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    public boolean referencesSessionSchema() throws StandardException {
        boolean bl = false;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            FromTable fromTable = (FromTable)this.elementAt(i);
            if (!fromTable.referencesSessionSchema()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected FromTable getFromTableByName(String string, String string2, boolean bl) throws StandardException {
        boolean bl2 = false;
        FromTable fromTable = null;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            FromTable fromTable2 = (FromTable)this.elementAt(i);
            fromTable = fromTable2.getFromTableByName(string, string2, bl);
            if (fromTable == null) continue;
            return fromTable;
        }
        return fromTable;
    }

    public void bindTables(DataDictionary dataDictionary, FromList fromList) throws StandardException {
        FromTable fromTable;
        int n;
        int n2 = this.size();
        for (n = 0; n < n2; ++n) {
            fromTable = (FromTable)this.elementAt(n);
            this.setElementAt(fromTable.bindNonVTITables(dataDictionary, fromList), n);
        }
        for (n = 0; n < n2; ++n) {
            fromTable = (FromTable)this.elementAt(n);
            this.setElementAt(fromTable.bindVTITables(fromList), n);
        }
    }

    public void bindExpressions() throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            FromTable fromTable = (FromTable)this.elementAt(i);
            fromTable.bindExpressions(this);
        }
    }

    public void bindResultColumns(FromList fromList) throws StandardException {
        int n = fromList.size();
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            FromTable fromTable = (FromTable)this.elementAt(i);
            if (fromTable.needsSpecialRCLBinding()) {
                fromTable.bindResultColumns(fromList);
            }
            fromList.insertElementAt(fromTable, 0);
        }
        while (fromList.size() > n) {
            fromList.removeElementAt(0);
        }
    }

    public boolean hasOuterJoins() throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            FromTable fromTable = (FromTable)this.elementAt(i);
            if (!(fromTable instanceof HalfOuterJoinNode)) continue;
            return true;
        }
        return false;
    }

    public ResultColumnList expandAll(String string) throws StandardException {
        ResultColumnList resultColumnList = null;
        ResultColumnList resultColumnList2 = null;
        boolean bl = false;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            FromTable fromTable = (FromTable)this.elementAt(i);
            fromTable.setAllColumnsProjected(true);
            resultColumnList2 = fromTable.getAllResultColumns(string);
            if (resultColumnList2 == null) continue;
            if (resultColumnList == null) {
                resultColumnList = resultColumnList2;
            } else {
                resultColumnList.nondestructiveAppend(resultColumnList2);
            }
            if (string == null) continue;
            bl = true;
        }
        if (resultColumnList == null) {
            throw StandardException.newException("42X10", string);
        }
        return resultColumnList;
    }

    public ResultColumn bindColumnReference(ColumnReference columnReference) throws StandardException {
        FromTable fromTable;
        boolean bl = false;
        boolean bl2 = false;
        int n = -1;
        int n2 = -1;
        ResultColumn resultColumn = null;
        String string = columnReference.getTableName();
        int n3 = this.size();
        for (int i = 0; i < n3 && (n2 == (n = (fromTable = (FromTable)this.elementAt(i)).getLevel()) || !bl && !bl2); ++i) {
            n2 = n;
            ResultColumn resultColumn2 = fromTable.getMatchingColumn(columnReference);
            if (resultColumn2 != null) {
                if (!bl) {
                    resultColumn = resultColumn2;
                    columnReference.setSource(resultColumn2);
                    columnReference.setType(resultColumn2.getTypeServices());
                    columnReference.setNestingLevel(((FromTable)this.elementAt(0)).getLevel());
                    columnReference.setSourceLevel(n);
                    bl = true;
                } else {
                    throw StandardException.newException("42X03", columnReference.getFullColumnName());
                }
            }
            bl2 = bl2 || string != null && string.equals(fromTable.getExposedName());
        }
        return resultColumn;
    }

    public void rejectParameters() throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            FromTable fromTable = (FromTable)this.elementAt(i);
            fromTable.rejectParameters();
        }
    }

    public boolean LOJ_reorderable(int n) throws StandardException {
        boolean bl = false;
        if (this.size() > 1) {
            return bl;
        }
        FromTable fromTable = (FromTable)this.elementAt(0);
        bl = fromTable.LOJ_reorderable(n);
        return bl;
    }

    public void preprocess(int n, GroupByList groupByList, ValueNode valueNode) throws StandardException {
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            FromTable fromTable = (FromTable)this.elementAt(i);
            fromTable = fromTable.transformOuterJoins(valueNode, n);
            this.setElementAt(fromTable.preprocess(n, groupByList, this), i);
        }
    }

    public void flattenFromTables(ResultColumnList resultColumnList, PredicateList predicateList, SubqueryList subqueryList, GroupByList groupByList) throws StandardException {
        QueryTreeNode queryTreeNode;
        FromTable fromTable;
        int n;
        boolean bl = true;
        Vector<Integer> vector = new Vector<Integer>();
        while (bl) {
            bl = false;
            for (n = 0; n < this.size() && !bl; ++n) {
                fromTable = (FromTable)this.elementAt(n);
                if (!(fromTable instanceof FromSubquery) && !fromTable.isFlattenableJoinNode()) continue;
                vector.addElement(new Integer(fromTable.getTableNumber()));
                queryTreeNode = fromTable.flatten(resultColumnList, predicateList, subqueryList, groupByList);
                if (queryTreeNode != null) {
                    this.setElementAt(((QueryTreeNodeVector)queryTreeNode).elementAt(0), n);
                    int n2 = ((QueryTreeNodeVector)queryTreeNode).size();
                    for (int i = 1; i < n2; ++i) {
                        this.insertElementAt(((QueryTreeNodeVector)queryTreeNode).elementAt(i), n + i);
                    }
                } else {
                    this.removeElementAt(n);
                }
                bl = true;
            }
        }
        if (vector.size() > 0) {
            for (n = 0; n < this.size(); ++n) {
                fromTable = (FromTable)this.elementAt(n);
                if (!(fromTable instanceof ProjectRestrictNode) || !((queryTreeNode = ((ProjectRestrictNode)fromTable).getChildResult()) instanceof FromBaseTable)) continue;
                ((FromBaseTable)queryTreeNode).clearDependency(vector);
            }
        }
    }

    void pushPredicates(PredicateList predicateList) throws StandardException {
        predicateList.categorize();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            FromTable fromTable = (FromTable)this.elementAt(i);
            fromTable.pushExpressions(predicateList);
        }
    }

    public void printSubNodes(int n) {
    }

    public void setLevel(int n) {
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            FromTable fromTable = (FromTable)this.elementAt(i);
            fromTable.setLevel(n);
        }
    }

    void markStatementResultSet() {
        ((FromTable)this.elementAt(0)).markStatementResultSet();
    }

    public FromTable getFromTableByResultColumn(ResultColumn resultColumn) {
        FromTable fromTable = null;
        int n = this.size();
        for (int i = 0; i < n && (fromTable = (FromTable)this.elementAt(i)).getResultColumns().indexOf(resultColumn) == -1; ++i) {
        }
        return fromTable;
    }

    public void setProperties(Properties properties) throws StandardException {
        this.properties = properties;
        Enumeration<Object> enumeration = this.properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.properties.get(string);
            if (string.equals("joinOrder")) {
                if (StringUtil.SQLEqualsIgnoreCase(string2, "fixed")) {
                    this.fixedJoinOrder = true;
                    continue;
                }
                if (StringUtil.SQLEqualsIgnoreCase(string2, "unfixed")) {
                    this.fixedJoinOrder = false;
                    continue;
                }
                throw StandardException.newException("42X17", string2);
            }
            if (string.equals("useStatistics")) {
                if (StringUtil.SQLEqualsIgnoreCase(string2, "true")) {
                    this.useStatistics = true;
                    continue;
                }
                if (StringUtil.SQLEqualsIgnoreCase(string2, "false")) {
                    this.useStatistics = false;
                    continue;
                }
                throw StandardException.newException("42X64", string2);
            }
            throw StandardException.newException("42X41", string, (Object)string2);
        }
    }

    public void reOrder(int[] nArray) {
        int n;
        FromTable[] fromTableArray = new FromTable[nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            fromTableArray[n] = this.elementAt(nArray[n]);
        }
        for (n = 0; n < nArray.length; ++n) {
            this.setElementAt(fromTableArray[n], n);
        }
    }

    public boolean useStatistics() {
        return this.useStatistics;
    }

    public boolean optimizeJoinOrder() {
        return !this.fixedJoinOrder;
    }

    public boolean legalJoinOrder(int n) {
        JBitSet jBitSet = new JBitSet(n);
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            FromTable fromTable = (FromTable)this.elementAt(i);
            jBitSet.or(fromTable.getReferencedTableMap());
            if (fromTable.legalJoinOrder(jBitSet)) continue;
            return false;
        }
        return true;
    }

    public void initAccessPaths(Optimizer optimizer) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            FromTable fromTable = (FromTable)this.elementAt(i);
            fromTable.initAccessPaths(optimizer);
        }
    }

    public void bindUntypedNullsToResultColumns(ResultColumnList resultColumnList) throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            FromTable fromTable = (FromTable)this.elementAt(i);
            fromTable.bindUntypedNullsToResultColumns(resultColumnList);
        }
    }

    void decrementLevel(int n) {
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            FromTable fromTable = (FromTable)this.elementAt(i);
            fromTable.decrementLevel(n);
            ProjectRestrictNode projectRestrictNode = (ProjectRestrictNode)fromTable;
            PredicateList predicateList = projectRestrictNode.getRestrictionList();
            if (predicateList == null) continue;
            predicateList.decrementLevel(this, n);
        }
    }

    boolean returnsAtMostSingleRow(ResultColumnList resultColumnList, ValueNode valueNode, PredicateList predicateList, DataDictionary dataDictionary) throws StandardException {
        int n;
        Object object;
        ResultColumn resultColumn;
        boolean bl = false;
        ColumnReference columnReference = null;
        if (resultColumnList != null && (resultColumn = (ResultColumn)resultColumnList.elementAt(0)).getExpression() instanceof ColumnReference) {
            columnReference = (ColumnReference)resultColumn.getExpression();
        }
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            object = (FromTable)this.elementAt(i);
            if (!(object instanceof ProjectRestrictNode)) {
                return false;
            }
            ProjectRestrictNode projectRestrictNode = (ProjectRestrictNode)object;
            if (projectRestrictNode.getChildResult() instanceof FromBaseTable) continue;
            return false;
        }
        int[] nArray = this.getTableNumbers();
        JBitSet[][] jBitSetArray = new JBitSet[n2][n2];
        object = new boolean[n2];
        boolean bl2 = false;
        for (n = 0; n < n2; ++n) {
            ProjectRestrictNode projectRestrictNode = (ProjectRestrictNode)this.elementAt(n);
            FromBaseTable fromBaseTable = (FromBaseTable)projectRestrictNode.getChildResult();
            if (fromBaseTable.getExistsBaseTable()) {
                object[n] = true;
                continue;
            }
            int n3 = fromBaseTable.getTableDescriptor().getNumberOfColumns();
            boolean[] blArray = new boolean[n3 + 1];
            int n4 = fromBaseTable.getTableNumber();
            boolean bl3 = false;
            for (int i = 0; i < n2; ++i) {
                jBitSetArray[n][i] = new JBitSet(n3 + 1);
            }
            if (columnReference != null && columnReference.getTableNumber() == n4) {
                resultColumnList.recordColumnReferences(blArray, jBitSetArray[n], n);
                bl3 = true;
            }
            if (valueNode != null) {
                valueNode.checkTopPredicatesForEqualsConditions(n4, blArray, nArray, jBitSetArray[n], bl3);
            }
            predicateList.checkTopPredicatesForEqualsConditions(n4, blArray, nArray, jBitSetArray[n], bl3);
            if (projectRestrictNode.getRestrictionList() != null) {
                projectRestrictNode.getRestrictionList().checkTopPredicatesForEqualsConditions(n4, blArray, nArray, jBitSetArray[n], bl3);
            }
            if (!fromBaseTable.supersetOfUniqueIndex(jBitSetArray[n])) {
                return false;
            }
            bl2 = fromBaseTable.supersetOfUniqueIndex(blArray);
            if (!bl2) continue;
            object[n] = true;
            bl = true;
        }
        if (bl) {
            n = 1;
            while (n != 0) {
                n = 0;
                for (int i = 0; i < n2; ++i) {
                    if (object[i] == false) continue;
                    for (int j = 0; j < n2; ++j) {
                        if (object[j] != false || !jBitSetArray[j][i].get(0)) continue;
                        object[j] = true;
                        n = 1;
                    }
                }
            }
            for (int i = 0; i < n2; ++i) {
                if (object[i] != false) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    int[] getTableNumbers() {
        int n = this.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            ProjectRestrictNode projectRestrictNode = (ProjectRestrictNode)this.elementAt(i);
            if (!(projectRestrictNode.getChildResult() instanceof FromTable)) continue;
            FromTable fromTable = (FromTable)projectRestrictNode.getChildResult();
            nArray[i] = fromTable.getTableNumber();
        }
        return nArray;
    }

    void genExistsBaseTables(JBitSet jBitSet, FromList fromList, boolean bl) throws StandardException {
        int n;
        JBitSet jBitSet2 = (JBitSet)jBitSet.clone();
        int n2 = this.size();
        for (n = 0; n < n2; ++n) {
            ResultSetNode resultSetNode = ((ProjectRestrictNode)this.elementAt(n)).getChildResult();
            if (!(resultSetNode instanceof FromTable)) continue;
            jBitSet2.clear(((FromTable)resultSetNode).getTableNumber());
        }
        if (jBitSet2.getFirstSetBit() == -1) {
            n = fromList.size();
            for (int i = 0; i < n; ++i) {
                jBitSet2.or(((FromTable)fromList.elementAt(i)).getReferencedTableMap());
            }
        }
        for (n = 0; n < n2; ++n) {
            ProjectRestrictNode projectRestrictNode;
            FromTable fromTable = (FromTable)this.elementAt(n);
            if (!(fromTable instanceof ProjectRestrictNode) || !((projectRestrictNode = (ProjectRestrictNode)fromTable).getChildResult() instanceof FromBaseTable)) continue;
            FromBaseTable fromBaseTable = (FromBaseTable)projectRestrictNode.getChildResult();
            fromBaseTable.setExistsBaseTable(true, (JBitSet)jBitSet2.clone(), bl);
        }
    }

    public int updateTargetLockMode() {
        return ((ResultSetNode)this.elementAt(0)).updateTargetLockMode();
    }

    boolean hashJoinSpecified() {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            FromTable fromTable = (FromTable)this.elementAt(i);
            String string = fromTable.getUserSpecifiedJoinStrategy();
            if (string == null || !StringUtil.SQLToUpperCase(string).equals("HASH")) continue;
            return true;
        }
        return false;
    }

    public Visitable accept(Visitor visitor) throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            FromTable fromTable = (FromTable)this.elementAt(i);
            this.setElementAt((QueryTreeNode)fromTable.accept(visitor), i);
        }
        return this;
    }
}

