/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.CursorActivation;
import org.apache.derby.iapi.sql.execute.ExecCursorTableReference;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.BaseColumnNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.TableName;

public final class CurrentOfNode
extends FromTable {
    private String cursorName;
    private ExecPreparedStatement preStmt;
    private TableName exposedTableName;
    private TableName baseTableName;
    private CostEstimate singleScanCostEstimate;

    public void init(Object object, Object object2) {
        super.init(null, object2);
        this.cursorName = (String)object;
    }

    public CostEstimate estimateCost(OptimizablePredicateList optimizablePredicateList, ConglomerateDescriptor conglomerateDescriptor, CostEstimate costEstimate, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        if (this.singleScanCostEstimate == null) {
            this.singleScanCostEstimate = optimizer.newCostEstimate();
        }
        this.singleScanCostEstimate.setCost(0.0, 1.0, 1.0);
        this.getBestAccessPath().setCostEstimate(this.singleScanCostEstimate);
        this.getBestSortAvoidancePath().setCostEstimate(this.singleScanCostEstimate);
        return this.singleScanCostEstimate;
    }

    public ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromList) throws StandardException {
        this.preStmt = this.getCursorStatement();
        if (this.preStmt != null && !this.preStmt.upToDate()) {
            this.preStmt.makeValid(this.getLanguageConnectionContext());
            if (!this.preStmt.isValid()) {
                this.preStmt = null;
            }
        }
        if (this.preStmt == null) {
            throw StandardException.newException("42X30", this.cursorName);
        }
        if (this.preStmt.getUpdateMode() != 2) {
            String string = this.cursorName == null ? "" : this.cursorName;
            throw StandardException.newException("42X23", string);
        }
        this.getCompilerContext().createDependency(this.preStmt);
        ExecCursorTableReference execCursorTableReference = this.preStmt.getTargetTable();
        String string = execCursorTableReference.getSchemaName();
        this.exposedTableName = this.makeTableName(null, execCursorTableReference.getExposedName());
        this.baseTableName = this.makeTableName(string, execCursorTableReference.getBaseName());
        SchemaDescriptor schemaDescriptor = null;
        schemaDescriptor = this.getSchemaDescriptor(execCursorTableReference.getSchemaName());
        if (schemaDescriptor == null) {
            throw StandardException.newException("42Y07", execCursorTableReference.getSchemaName());
        }
        TableDescriptor tableDescriptor = this.getTableDescriptor(execCursorTableReference.getBaseName(), schemaDescriptor);
        if (tableDescriptor == null) {
            throw StandardException.newException("42X05", execCursorTableReference.getBaseName());
        }
        this.resultColumns = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        ColumnDescriptorList columnDescriptorList = tableDescriptor.getColumnDescriptorList();
        int n = columnDescriptorList.size();
        for (int i = 0; i < n; ++i) {
            ColumnDescriptor columnDescriptor = columnDescriptorList.elementAt(i);
            BaseColumnNode baseColumnNode = (BaseColumnNode)this.getNodeFactory().getNode(94, columnDescriptor.getColumnName(), this.exposedTableName, columnDescriptor.getType(), this.getContextManager());
            ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, columnDescriptor, baseColumnNode, this.getContextManager());
            this.resultColumns.addResultColumn(resultColumn);
        }
        if (this.tableNumber == -1) {
            this.tableNumber = this.getCompilerContext().getNextTableNumber();
        }
        return this;
    }

    public void bindExpressions(FromList fromList) {
    }

    public ResultColumn getMatchingColumn(ColumnReference columnReference) throws StandardException {
        ResultColumn resultColumn = null;
        TableName tableName = columnReference.getTableNameNode();
        if (tableName == null || tableName.getFullTableName().equals(this.baseTableName.getFullTableName())) {
            boolean bl = false;
            resultColumn = this.resultColumns.getResultColumn(columnReference.getColumnName());
            bl = resultColumn != null ? resultColumn.updatableByCursor() && !this.foundString(this.preStmt.getUpdateColumns(), columnReference.getColumnName()) : true;
            if (bl) {
                String string = this.cursorName == null ? "" : this.cursorName;
                throw StandardException.newException("42X31", columnReference.getColumnName(), (Object)string);
            }
        }
        return resultColumn;
    }

    public ResultSetNode preprocess(int n, GroupByList groupByList, FromList fromList) throws StandardException {
        this.referencedTableMap = new JBitSet(n);
        return this;
    }

    public ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicateList, double d) throws StandardException {
        Optimizer optimizer = this.getOptimizer((FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this, this.getContextManager()), predicateList, dataDictionary, null);
        this.bestCostEstimate = optimizer.newCostEstimate();
        this.bestCostEstimate.setCost(0.0, d, d);
        return this;
    }

    public void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.assignResultSetNumber();
        methodBuilder.pushThis();
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        methodBuilder.push(this.cursorName);
        activationClassBuilder.pushThisAsActivation(methodBuilder);
        methodBuilder.push(this.resultSetNumber);
        methodBuilder.push(this.preStmt.getObjectName());
        methodBuilder.callMethod((short)185, null, "getCurrentOfResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 4);
        methodBuilder.cast("org.apache.derby.iapi.sql.execute.CursorResultSet");
        methodBuilder.putField(null, activationClassBuilder.getRowLocationScanResultSetName(), "org.apache.derby.iapi.sql.execute.CursorResultSet");
        methodBuilder.cast("org.apache.derby.iapi.sql.execute.NoPutResultSet");
        MethodBuilder methodBuilder2 = activationClassBuilder.startResetMethod();
        methodBuilder2.pushThis();
        methodBuilder2.push(this.cursorName);
        methodBuilder2.push(this.preStmt.getObjectName());
        methodBuilder2.callMethod((short)182, "org.apache.derby.impl.sql.execute.BaseActivation", "checkPositionedStatement", "void", 2);
        methodBuilder2.methodReturn();
        methodBuilder2.complete();
    }

    public void printSubNodes(int n) {
    }

    public String toString() {
        return "";
    }

    public String getExposedName() {
        return this.exposedTableName.getFullTableName();
    }

    public TableName getExposedTableName() {
        return this.exposedTableName;
    }

    public TableName getBaseCursorTargetTableName() {
        return this.baseTableName;
    }

    public String getCursorName() {
        return this.cursorName;
    }

    ExecPreparedStatement getCursorStatement() {
        CursorActivation cursorActivation = this.getLanguageConnectionContext().lookupCursorActivation(this.cursorName);
        if (cursorActivation == null) {
            return null;
        }
        return cursorActivation.getPreparedStatement();
    }

    public int updateTargetLockMode() {
        return 6;
    }
}

