/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.CreateStatementNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.TriggerReferencingStruct;

public class CreateTriggerNode
extends CreateStatementNode {
    private TableName triggerName;
    private TableName tableName;
    private int triggerEventMask;
    private ResultColumnList triggerCols;
    private boolean isBefore;
    private boolean isRow;
    private boolean isEnabled;
    private Vector refClause;
    private QueryTreeNode whenClause;
    private String whenText;
    private int whenOffset;
    private StatementNode actionNode;
    private String actionText;
    private String originalActionText;
    private int actionOffset;
    private SchemaDescriptor triggerSchemaDescriptor;
    private SchemaDescriptor compSchemaDescriptor;
    private int[] referencedColInts;
    private TableDescriptor triggerTableDescriptor;
    private UUID actionCompSchemaId;
    private String oldTableName;
    private String newTableName;
    private boolean oldTableInReferencingClause;
    private boolean newTableInReferencingClause;
    static /* synthetic */ Class class$org$apache$derby$impl$sql$compile$ColumnReference;
    static /* synthetic */ Class class$org$apache$derby$impl$sql$compile$FromBaseTable;

    public void init(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13, Object object14) throws StandardException {
        this.initAndCheck(object);
        this.triggerName = (TableName)object;
        this.tableName = (TableName)object2;
        this.triggerEventMask = (Integer)object3;
        this.triggerCols = (ResultColumnList)object4;
        this.isBefore = (Boolean)object5;
        this.isRow = (Boolean)object6;
        this.isEnabled = (Boolean)object7;
        this.refClause = (Vector)object8;
        this.whenClause = (QueryTreeNode)object9;
        this.whenText = object10 == null ? null : ((String)object10).trim();
        this.whenOffset = (Integer)object11;
        this.actionNode = (StatementNode)object12;
        this.originalActionText = (String)object13;
        this.actionText = object13 == null ? null : ((String)object13).trim();
        this.actionOffset = (Integer)object14;
        this.implicitCreateSchema = true;
    }

    public String statementToString() {
        return "CREATE TRIGGER";
    }

    public void printSubNodes(int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryTreeNode bind() throws StandardException {
        CompilerContext compilerContext = this.getCompilerContext();
        DataDictionary dataDictionary = this.getDataDictionary();
        LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
        this.compSchemaDescriptor = languageConnectionContext.getDefaultSchema();
        this.triggerSchemaDescriptor = this.getSchemaDescriptor();
        this.triggerTableDescriptor = this.getTableDescriptor(this.tableName);
        if (this.isSessionSchema(this.triggerTableDescriptor.getSchemaDescriptor())) {
            throw StandardException.newException("XCL478.S");
        }
        boolean bl = this.bindReferencesClause(dataDictionary);
        languageConnectionContext.pushTriggerTable(this.triggerTableDescriptor);
        try {
            if (bl) {
                compilerContext.setReliability(0);
            }
            this.actionNode.bind();
            if (this.whenClause != null) {
                this.whenClause.bind();
            }
        }
        finally {
            languageConnectionContext.popTriggerTable(this.triggerTableDescriptor);
        }
        compilerContext.createDependency(this.triggerTableDescriptor);
        if (this.triggerCols != null && this.triggerCols.size() != 0) {
            this.referencedColInts = new int[this.triggerCols.size()];
            Hashtable<String, ResultColumn> hashtable = new Hashtable<String, ResultColumn>();
            int n = this.triggerCols.size();
            for (int i = 0; i < n; ++i) {
                ResultColumn resultColumn = (ResultColumn)this.triggerCols.elementAt(i);
                if (hashtable.put(resultColumn.getName(), resultColumn) != null) {
                    throw StandardException.newException("42Y40", resultColumn.getName(), (Object)this.triggerName);
                }
                ColumnDescriptor columnDescriptor = this.triggerTableDescriptor.getColumnDescriptor(resultColumn.getName());
                if (columnDescriptor == null) {
                    throw StandardException.newException("42X14", resultColumn.getName(), (Object)this.tableName);
                }
                this.referencedColInts[i] = columnDescriptor.getPosition();
            }
            Arrays.sort(this.referencedColInts);
        }
        if (this.actionNode.referencesSessionSchema()) {
            throw StandardException.newException("XCL478.S");
        }
        return this;
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.isSessionSchema(this.triggerTableDescriptor.getSchemaName()) || this.actionNode.referencesSessionSchema();
    }

    private boolean bindReferencesClause(DataDictionary dataDictionary) throws StandardException {
        this.validateReferencesClause(dataDictionary);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = 0;
        if (this.isRow) {
            CollectNodesVisitor collectNodesVisitor = new CollectNodesVisitor(class$org$apache$derby$impl$sql$compile$ColumnReference == null ? (class$org$apache$derby$impl$sql$compile$ColumnReference = CreateTriggerNode.class$("org.apache.derby.impl.sql.compile.ColumnReference")) : class$org$apache$derby$impl$sql$compile$ColumnReference);
            this.actionNode.accept(collectNodesVisitor);
            Vector vector = collectNodesVisitor.getList();
            QueryTreeNode[] queryTreeNodeArray = this.sortRefs(vector, true);
            for (int i = 0; i < queryTreeNodeArray.length; ++i) {
                ColumnReference columnReference = (ColumnReference)queryTreeNodeArray[i];
                TableName tableName = columnReference.getTableNameNode();
                if (tableName == null || (this.oldTableName == null || !this.oldTableName.equals(tableName.getTableName())) && (this.newTableName == null || !this.newTableName.equals(tableName.getTableName()))) continue;
                int n2 = tableName.getTokenBeginOffset();
                int n3 = tableName.getTokenEndOffset();
                if (n2 == -1) continue;
                bl = true;
                this.checkInvalidTriggerReference(tableName.getTableName());
                String string = columnReference.getColumnName();
                int n4 = columnReference.getTokenEndOffset() - columnReference.getTokenBeginOffset() + 1;
                stringBuffer.append(this.originalActionText.substring(n, n2 - this.actionOffset));
                stringBuffer.append(this.genColumnReferenceSQL(dataDictionary, string, tableName.getTableName(), tableName.getTableName().equals(this.oldTableName)));
                n = n3 - this.actionOffset + n4 + 2;
            }
        } else {
            CollectNodesVisitor collectNodesVisitor = new CollectNodesVisitor(class$org$apache$derby$impl$sql$compile$FromBaseTable == null ? (class$org$apache$derby$impl$sql$compile$FromBaseTable = CreateTriggerNode.class$("org.apache.derby.impl.sql.compile.FromBaseTable")) : class$org$apache$derby$impl$sql$compile$FromBaseTable);
            this.actionNode.accept(collectNodesVisitor);
            Vector vector = collectNodesVisitor.getList();
            QueryTreeNode[] queryTreeNodeArray = this.sortRefs(vector, false);
            for (int i = 0; i < queryTreeNodeArray.length; ++i) {
                FromBaseTable fromBaseTable = (FromBaseTable)queryTreeNodeArray[i];
                String string = fromBaseTable.getTableName().getTableName();
                String string2 = fromBaseTable.getBaseTableName();
                if (string2 == null || (this.oldTableName == null || !this.oldTableName.equals(string2)) && (this.newTableName == null || !this.newTableName.equals(string2))) continue;
                int n5 = fromBaseTable.getTableNameField().getTokenBeginOffset();
                int n6 = fromBaseTable.getTableNameField().getTokenEndOffset();
                if (n5 == -1) continue;
                this.checkInvalidTriggerReference(string2);
                bl = true;
                stringBuffer.append(this.originalActionText.substring(n, n5 - this.actionOffset));
                stringBuffer.append(string2.equals(this.oldTableName) ? "new org.apache.derby.catalog.TriggerOldTransitionRows() " : "new org.apache.derby.catalog.TriggerNewTransitionRows() ");
                if (string.equals(string2)) {
                    stringBuffer.append(string2).append(" ");
                }
                n = n6 - this.actionOffset + 1;
            }
        }
        if (bl) {
            if (n < this.originalActionText.length()) {
                stringBuffer.append(this.originalActionText.substring(n));
            }
            this.actionText = stringBuffer.toString();
            this.actionNode = (StatementNode)this.reparseTriggerText(this.actionText);
        }
        return bl;
    }

    private QueryTreeNode[] sortRefs(Vector vector, boolean bl) {
        int n = vector.size();
        QueryTreeNode[] queryTreeNodeArray = new QueryTreeNode[n];
        int n2 = 0;
        Object object = vector.elements();
        while (object.hasMoreElements()) {
            if (bl) {
                queryTreeNodeArray[n2++] = (ColumnReference)object.nextElement();
                continue;
            }
            queryTreeNodeArray[n2++] = (FromBaseTable)object.nextElement();
        }
        for (n2 = 0; n2 < n - 1; ++n2) {
            object = null;
            for (int i = 0; i < n - n2 - 1; ++i) {
                if ((!bl || ((ColumnReference)queryTreeNodeArray[i]).getTokenBeginOffset() <= ((ColumnReference)queryTreeNodeArray[i + 1]).getTokenBeginOffset()) && (bl || ((FromBaseTable)queryTreeNodeArray[i]).getTableNameField().getTokenBeginOffset() <= ((FromBaseTable)queryTreeNodeArray[i + 1]).getTableNameField().getTokenBeginOffset())) continue;
                object = queryTreeNodeArray[i];
                queryTreeNodeArray[i] = queryTreeNodeArray[i + 1];
                queryTreeNodeArray[i + 1] = object;
            }
            if (object == null) break;
        }
        return queryTreeNodeArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryTreeNode reparseTriggerText(String string) throws StandardException {
        LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
        CompilerContext compilerContext = languageConnectionContext.pushCompilerContext();
        compilerContext.setReliability(0);
        try {
            QueryTreeNode queryTreeNode = QueryTreeNode.parseQueryText(compilerContext, string, null, languageConnectionContext);
            return queryTreeNode;
        }
        finally {
            languageConnectionContext.popCompilerContext(compilerContext);
        }
    }

    private String genColumnReferenceSQL(DataDictionary dataDictionary, String string, String string2, boolean bl) throws StandardException {
        ColumnDescriptor columnDescriptor = null;
        columnDescriptor = this.triggerTableDescriptor.getColumnDescriptor(string);
        if (columnDescriptor == null) {
            throw StandardException.newException("42X04", string2 + "." + string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("cast (org.apache.derby.iapi.db.Factory::getTriggerExecutionContext().");
        stringBuffer.append(bl ? "getOldRow()" : "getNewRow()");
        stringBuffer.append(".getObject('" + string + "') AS ");
        DataTypeDescriptor dataTypeDescriptor = columnDescriptor.getType();
        TypeId typeId = dataTypeDescriptor.getTypeId();
        stringBuffer.append((typeId.systemBuiltIn() ? dataTypeDescriptor.getSQLstring() : typeId.getSQLTypeName()) + ") ");
        return stringBuffer.toString();
    }

    private void checkInvalidTriggerReference(String string) throws StandardException {
        if (string.equals(this.oldTableName) && (this.triggerEventMask & 4) == 4) {
            throw StandardException.newException("42Y92", "INSERT", (Object)"new");
        }
        if (string.equals(this.newTableName) && (this.triggerEventMask & 2) == 2) {
            throw StandardException.newException("42Y92", "DELETE", (Object)"old");
        }
    }

    private void validateReferencesClause(DataDictionary dataDictionary) throws StandardException {
        if (this.refClause == null || this.refClause.size() == 0) {
            return;
        }
        Enumeration enumeration = this.refClause.elements();
        while (enumeration.hasMoreElements()) {
            TriggerReferencingStruct triggerReferencingStruct = (TriggerReferencingStruct)enumeration.nextElement();
            if (this.isRow && !triggerReferencingStruct.isRow) {
                throw StandardException.newException("42Y92", "ROW", (Object)"row");
            }
            if (!this.isRow && triggerReferencingStruct.isRow) {
                throw StandardException.newException("42Y92", "STATEMENT", (Object)"table");
            }
            if (triggerReferencingStruct.isNew) {
                if (this.newTableInReferencingClause) {
                    throw StandardException.newException("42Y93");
                }
                if ((this.triggerEventMask & 2) == 2) {
                    throw StandardException.newException("42Y92", "DELETE", (Object)"old");
                }
                this.newTableName = triggerReferencingStruct.identifier;
                this.newTableInReferencingClause = true;
            } else {
                if (this.oldTableInReferencingClause) {
                    throw StandardException.newException("42Y93");
                }
                if ((this.triggerEventMask & 4) == 4) {
                    throw StandardException.newException("42Y92", "INSERT", (Object)"new");
                }
                this.oldTableName = triggerReferencingStruct.identifier;
                this.oldTableInReferencingClause = true;
            }
            if (!this.isBefore || triggerReferencingStruct.isRow) continue;
            throw StandardException.newException("42Y92", "BEFORE", (Object)"row");
        }
    }

    public ConstantAction makeConstantAction() throws StandardException {
        String string = this.oldTableInReferencingClause ? this.oldTableName : null;
        String string2 = this.newTableInReferencingClause ? this.newTableName : null;
        return this.getGenericConstantActionFactory().getCreateTriggerConstantAction(this.triggerSchemaDescriptor.getSchemaName(), this.getRelativeName(), this.triggerEventMask, this.isBefore, this.isRow, this.isEnabled, this.triggerTableDescriptor, null, this.whenText, null, this.actionText, this.actionCompSchemaId == null ? this.compSchemaDescriptor.getUUID() : this.actionCompSchemaId, null, this.referencedColInts, this.originalActionText, this.oldTableInReferencingClause, this.newTableInReferencingClause, string, string2);
    }

    public String toString() {
        return "";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

