/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.catalog.DefaultInfo;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.CacheFactory;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.cache.CacheableFactory;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.locks.ShExLockable;
import org.apache.derby.iapi.services.locks.ShExQual;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionFactory;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DataDictionaryContext;
import org.apache.derby.iapi.sql.dictionary.DependencyDescriptor;
import org.apache.derby.iapi.sql.dictionary.FileInfoDescriptor;
import org.apache.derby.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.GenericDescriptorList;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.KeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.RowList;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.SubCheckConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SubConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SubKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TabInfo;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.dictionary.ViewDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.sql.execute.ScanQualifier;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.GenericScanController;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.catalog.DD_Version;
import org.apache.derby.impl.sql.catalog.DataDictionaryContextImpl;
import org.apache.derby.impl.sql.catalog.DropDependencyFilter;
import org.apache.derby.impl.sql.catalog.NameTDCacheable;
import org.apache.derby.impl.sql.catalog.OIDTDCacheable;
import org.apache.derby.impl.sql.catalog.SPSNameCacheable;
import org.apache.derby.impl.sql.catalog.SYSALIASESRowFactory;
import org.apache.derby.impl.sql.catalog.SYSCHECKSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSCOLUMNSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSCONGLOMERATESRowFactory;
import org.apache.derby.impl.sql.catalog.SYSCONSTRAINTSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSDEPENDSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSDUMMY1RowFactory;
import org.apache.derby.impl.sql.catalog.SYSFILESRowFactory;
import org.apache.derby.impl.sql.catalog.SYSFOREIGNKEYSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSKEYSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSSCHEMASRowFactory;
import org.apache.derby.impl.sql.catalog.SYSSTATEMENTSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSSTATISTICSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSTABLESRowFactory;
import org.apache.derby.impl.sql.catalog.SYSTRIGGERSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSVIEWSRowFactory;
import org.apache.derby.impl.sql.catalog.TDCacheable;
import org.apache.derby.impl.sql.catalog.TabInfoImpl;
import org.apache.derby.impl.sql.catalog.TableKey;
import org.apache.derby.impl.sql.depend.BasicDependencyManager;

public class DataDictionaryImpl
implements DataDictionary,
CacheableFactory,
ModuleControl,
ModuleSupportable,
PrivilegedAction {
    private static final String CFG_SYSTABLES_ID = "SystablesIdentifier";
    private static final String CFG_SYSTABLES_INDEX1_ID = "SystablesIndex1Identifier";
    private static final String CFG_SYSTABLES_INDEX2_ID = "SystablesIndex2Identifier";
    private static final String CFG_SYSCOLUMNS_ID = "SyscolumnsIdentifier";
    private static final String CFG_SYSCOLUMNS_INDEX1_ID = "SyscolumnsIndex1Identifier";
    private static final String CFG_SYSCOLUMNS_INDEX2_ID = "SyscolumnsIndex2Identifier";
    private static final String CFG_SYSCONGLOMERATES_ID = "SysconglomeratesIdentifier";
    private static final String CFG_SYSCONGLOMERATES_INDEX1_ID = "SysconglomeratesIndex1Identifier";
    private static final String CFG_SYSCONGLOMERATES_INDEX2_ID = "SysconglomeratesIndex2Identifier";
    private static final String CFG_SYSCONGLOMERATES_INDEX3_ID = "SysconglomeratesIndex3Identifier";
    private static final String CFG_SYSSCHEMAS_ID = "SysschemasIdentifier";
    private static final String CFG_SYSSCHEMAS_INDEX1_ID = "SysschemasIndex1Identifier";
    private static final String CFG_SYSSCHEMAS_INDEX2_ID = "SysschemasIndex2Identifier";
    private static final int SYSCONGLOMERATES_CORE_NUM = 0;
    private static final int SYSTABLES_CORE_NUM = 1;
    private static final int SYSCOLUMNS_CORE_NUM = 2;
    private static final int SYSSCHEMAS_CORE_NUM = 3;
    private static final int NUM_CORE = 4;
    private TabInfo[] coreInfo;
    protected SchemaDescriptor systemSchemaDesc;
    protected SchemaDescriptor sysIBMSchemaDesc;
    protected SchemaDescriptor declaredGlobalTemporaryTablesSchemaDesc;
    protected SchemaDescriptor systemDiagSchemaDesc;
    protected SchemaDescriptor systemUtilSchemaDesc;
    private String systemSchemaName;
    private String systemDiagSchemaName;
    private String systemUtilSchemaName;
    private String sysIBMSchemaName;
    private String declaredGlobalTemporaryTablesSchemaName;
    boolean builtinSchemasAreFromLCC;
    protected boolean convertIdToLower;
    private static final int NUM_NONCORE = 12;
    private static final String[] nonCoreNames = new String[]{"SYSCONSTRAINTS", "SYSKEYS", "SYSDEPENDS", "SYSALIASES", "SYSVIEWS", "SYSCHECKS", "SYSFOREIGNKEYS", "SYSSTATEMENTS", "SYSFILES", "SYSTRIGGERS", "SYSSTATISTICS", "SYSDUMMY1"};
    private static final String[] systemSchemaNames = new String[]{"SYSCAT", "SYSFUN", "SYSPROC", "SYSSTAT", "NULLID", "SYSCS_DIAG", "SYSCS_UTIL", "SYSIBM", "SQLJ", "SYS"};
    private DD_Version dictionaryVersion;
    private DD_Version softwareVersion;
    private TabInfo[] noncoreInfo;
    public DataDescriptorGenerator dataDescriptorGenerator;
    protected DataValueFactory dvf;
    protected AccessFactory af;
    private ExecutionFactory exFactory;
    protected UUIDFactory uuidFactory;
    Properties startupParameters;
    int engineType;
    protected boolean booting;
    private TransactionController bootingTC;
    protected DependencyManager dmgr;
    CacheManager OIDTdCache;
    CacheManager nameTdCache;
    private CacheManager spsNameCache;
    private Hashtable spsIdHash;
    int tdCacheSize;
    int stmtCacheSize;
    ShExLockable cacheCoordinator;
    public LockFactory lockFactory;
    volatile int cacheMode = 0;
    volatile int ddlUsers;
    volatile int readersInDDLMode;
    public boolean readOnlyUpgrade;
    private int systemSQLNameNumber;
    private GregorianCalendar calendarForLastSystemSQLName = new GregorianCalendar();
    private long timeForLastSystemSQLName;
    private String spsSet;

    public boolean canSupport(Properties properties) {
        return Monitor.isDesiredType(properties, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void boot(boolean bl, Properties properties) throws StandardException {
        this.softwareVersion = new DD_Version(this, 120);
        this.convertIdToLower = false;
        this.startupParameters = properties;
        this.uuidFactory = Monitor.getMonitor().getUUIDFactory();
        this.engineType = Monitor.getEngineType(properties);
        LanguageConnectionFactory languageConnectionFactory = (LanguageConnectionFactory)Monitor.bootServiceModule(bl, this, "org.apache.derby.iapi.sql.conn.LanguageConnectionFactory", properties);
        this.dvf = languageConnectionFactory.getDataValueFactory();
        this.exFactory = (ExecutionFactory)Monitor.bootServiceModule(bl, this, "org.apache.derby.iapi.sql.execute.ExecutionFactory", properties);
        this.initializeCatalogInfo();
        this.booting = true;
        if (this.dataDescriptorGenerator == null) {
            this.dataDescriptorGenerator = new DataDescriptorGenerator(this);
        }
        if (!bl) {
            this.coreInfo[1].setHeapConglomerate(this.getBootParameter(properties, CFG_SYSTABLES_ID, true));
            this.coreInfo[1].setIndexConglomerate(0, this.getBootParameter(properties, CFG_SYSTABLES_INDEX1_ID, true));
            this.coreInfo[1].setIndexConglomerate(1, this.getBootParameter(properties, CFG_SYSTABLES_INDEX2_ID, true));
            this.coreInfo[2].setHeapConglomerate(this.getBootParameter(properties, CFG_SYSCOLUMNS_ID, true));
            this.coreInfo[2].setIndexConglomerate(0, this.getBootParameter(properties, CFG_SYSCOLUMNS_INDEX1_ID, true));
            this.coreInfo[2].setIndexConglomerate(1, this.getBootParameter(properties, CFG_SYSCOLUMNS_INDEX2_ID, false));
            this.coreInfo[0].setHeapConglomerate(this.getBootParameter(properties, CFG_SYSCONGLOMERATES_ID, true));
            this.coreInfo[0].setIndexConglomerate(0, this.getBootParameter(properties, CFG_SYSCONGLOMERATES_INDEX1_ID, true));
            this.coreInfo[0].setIndexConglomerate(1, this.getBootParameter(properties, CFG_SYSCONGLOMERATES_INDEX2_ID, true));
            this.coreInfo[0].setIndexConglomerate(2, this.getBootParameter(properties, CFG_SYSCONGLOMERATES_INDEX3_ID, true));
            this.coreInfo[3].setHeapConglomerate(this.getBootParameter(properties, CFG_SYSSCHEMAS_ID, true));
            this.coreInfo[3].setIndexConglomerate(0, this.getBootParameter(properties, CFG_SYSSCHEMAS_INDEX1_ID, true));
            this.coreInfo[3].setIndexConglomerate(1, this.getBootParameter(properties, CFG_SYSSCHEMAS_INDEX2_ID, true));
        }
        String string = properties.getProperty("derby.language.tableDescriptorCacheSize");
        this.tdCacheSize = PropertyUtil.intPropertyValue("derby.language.tableDescriptorCacheSize", (Serializable)((Object)string), 0, Integer.MAX_VALUE, 64);
        string = properties.getProperty("derby.language.spsCacheSize");
        this.stmtCacheSize = PropertyUtil.intPropertyValue("derby.language.spsCacheSize", (Serializable)((Object)string), 0, Integer.MAX_VALUE, 32);
        CacheFactory cacheFactory = (CacheFactory)Monitor.startSystemModule("org.apache.derby.iapi.services.cache.CacheFactory");
        this.OIDTdCache = cacheFactory.newCacheManager(this, "TableDescriptorOIDCache", this.tdCacheSize, this.tdCacheSize);
        this.nameTdCache = cacheFactory.newCacheManager(this, "TableDescriptorNameCache", this.tdCacheSize, this.tdCacheSize);
        if (this.stmtCacheSize > 0) {
            this.spsNameCache = cacheFactory.newCacheManager(this, "SPSNameDescriptorCache", this.stmtCacheSize, this.stmtCacheSize);
            this.spsIdHash = new Hashtable(this.stmtCacheSize);
        }
        this.cacheCoordinator = new ShExLockable();
        this.af = (AccessFactory)Monitor.findServiceModule(this, "org.apache.derby.iapi.store.access.AccessFactory");
        this.lockFactory = this.af.getLockFactory();
        ContextService contextService = ContextService.getFactory();
        ContextManager contextManager = contextService.getCurrentContextManager();
        this.pushDataDictionaryContext(contextManager, false);
        this.bootingTC = null;
        try {
            this.bootingTC = this.af.getTransaction(contextManager);
            this.exFactory.newExecutionContext(contextManager);
            DataDescriptorGenerator dataDescriptorGenerator = this.getDataDescriptorGenerator();
            if (bl) {
                this.createDictionaryTables(properties, this.bootingTC, dataDescriptorGenerator);
                this.create_SYSIBM_procedures(this.bootingTC);
                this.createSystemSps(this.bootingTC);
                this.create_SYSCS_procedures(this.bootingTC);
                this.dictionaryVersion = this.softwareVersion;
                this.bootingTC.setProperty("DataDictionaryVersion", this.dictionaryVersion, true);
                this.bootingTC.setProperty("CreateDataDictionaryVersion", this.dictionaryVersion, true);
            } else {
                this.loadDictionaryTables(this.bootingTC, dataDescriptorGenerator, properties);
            }
            this.bootingTC.commit();
            contextManager.getContext("ExecutionContext").popMe();
            Object var10_9 = null;
            if (this.bootingTC != null) {
                this.bootingTC.destroy();
                this.bootingTC = null;
            }
            contextManager.popContext();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (this.bootingTC != null) {
                this.bootingTC.destroy();
                this.bootingTC = null;
            }
            contextManager.popContext();
            throw throwable;
        }
        this.setDependencyManager();
        this.booting = false;
    }

    protected void setDependencyManager() {
        this.dmgr = new BasicDependencyManager();
    }

    public DependencyManager getDependencyManager() {
        return this.dmgr;
    }

    public void stop() {
    }

    public Cacheable newCacheable(CacheManager cacheManager) {
        if (cacheManager == this.OIDTdCache) {
            return new OIDTDCacheable(this);
        }
        if (cacheManager == this.nameTdCache) {
            return new NameTDCacheable(this);
        }
        return new SPSNameCacheable(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startReading(LanguageConnectionContext languageConnectionContext) throws StandardException {
        int n;
        int n2 = languageConnectionContext.incrementBindCount();
        boolean bl = false;
        do {
            if (bl) {
                try {
                    this.lockFactory.zeroDurationlockObject(languageConnectionContext.getTransactionExecute().getLockObject(), this.cacheCoordinator, ShExQual.SH, -1);
                }
                catch (StandardException standardException) {
                    languageConnectionContext.decrementBindCount();
                    throw standardException;
                }
                bl = false;
            }
            DataDictionaryImpl dataDictionaryImpl = this;
            synchronized (dataDictionaryImpl) {
                n = this.getCacheMode();
                if (n2 == 1) {
                    if (n == 0) {
                        boolean bl2 = false;
                        try {
                            bl2 = this.lockFactory.lockObject(languageConnectionContext.getTransactionExecute().getLockObject(), languageConnectionContext.getTransactionExecute().getLockObject(), this.cacheCoordinator, ShExQual.SH, 0);
                        }
                        catch (StandardException standardException) {
                            languageConnectionContext.decrementBindCount();
                            throw standardException;
                        }
                        if (!bl2) {
                            bl = true;
                        }
                    } else {
                        ++this.readersInDDLMode;
                    }
                }
            }
        } while (bl);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doneReading(int n, LanguageConnectionContext languageConnectionContext) throws StandardException {
        int n2 = languageConnectionContext.decrementBindCount();
        DataDictionaryImpl dataDictionaryImpl = this;
        synchronized (dataDictionaryImpl) {
            if (n2 == 0) {
                if (n == 0) {
                    if (languageConnectionContext.getStatementContext() != null && languageConnectionContext.getStatementContext().inUse()) {
                        int n3 = this.lockFactory.unlock(languageConnectionContext.getTransactionExecute().getLockObject(), languageConnectionContext.getTransactionExecute().getLockObject(), this.cacheCoordinator, ShExQual.SH);
                    }
                } else {
                    --this.readersInDDLMode;
                    if (this.ddlUsers == 0 && this.readersInDDLMode == 0) {
                        this.clearCaches();
                        this.setCacheMode(0);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startWriting(LanguageConnectionContext languageConnectionContext) throws StandardException {
        boolean bl = true;
        if (languageConnectionContext.getBindCount() != 0) {
            throw StandardException.newException("XCL21.S");
        }
        if (!languageConnectionContext.dataDictionaryInWriteMode()) {
            int n = 0;
            while (bl) {
                block12: {
                    if (n > 4 && this.getCacheMode() == 0) {
                        this.lockFactory.zeroDurationlockObject(languageConnectionContext.getTransactionExecute().getLockObject(), this.cacheCoordinator, ShExQual.EX, -2);
                        n = 1;
                    }
                    if (n > 0) {
                        try {
                            Thread.sleep((long)(Math.random() * 1131.0 % 20.0));
                        }
                        catch (InterruptedException interruptedException) {
                            throw StandardException.interrupt(interruptedException);
                        }
                    }
                    DataDictionaryImpl dataDictionaryImpl = this;
                    synchronized (dataDictionaryImpl) {
                        if (this.getCacheMode() == 0) {
                            boolean bl2 = this.lockFactory.zeroDurationlockObject(languageConnectionContext.getTransactionExecute().getLockObject(), this.cacheCoordinator, ShExQual.EX, 0);
                            if (!bl2) {
                                break block12;
                            }
                            this.setCacheMode(1);
                            this.clearCaches();
                        }
                        ++this.ddlUsers;
                    }
                    languageConnectionContext.setDataDictionaryWriteMode();
                    bl = false;
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transactionFinished() throws StandardException {
        DataDictionaryImpl dataDictionaryImpl = this;
        synchronized (dataDictionaryImpl) {
            --this.ddlUsers;
            if (this.ddlUsers == 0 && this.readersInDDLMode == 0) {
                this.clearCaches();
                this.setCacheMode(0);
            }
        }
    }

    public int getCacheMode() {
        return this.cacheMode;
    }

    private void setCacheMode(int n) {
        this.cacheMode = n;
    }

    public DataDescriptorGenerator getDataDescriptorGenerator() {
        return this.dataDescriptorGenerator;
    }

    public DataValueFactory getDataValueFactory() {
        return this.dvf;
    }

    public ExecutionFactory getExecutionFactory() {
        return this.exFactory;
    }

    public DataDictionaryContext pushDataDictionaryContext(ContextManager contextManager, boolean bl) {
        DataDictionaryContextImpl dataDictionaryContextImpl = new DataDictionaryContextImpl(contextManager, this, bl);
        return dataDictionaryContextImpl;
    }

    private void getBuiltinSchemaNames() throws StandardException {
        if (this.builtinSchemasAreFromLCC) {
            return;
        }
        LanguageConnectionContext languageConnectionContext = DataDictionaryImpl.getLCC();
        if (null == languageConnectionContext) {
            this.systemSchemaName = "SYS";
            this.sysIBMSchemaName = "SYSIBM";
            this.systemDiagSchemaName = "SYSCS_DIAG";
            this.systemUtilSchemaName = "SYSCS_UTIL";
            this.declaredGlobalTemporaryTablesSchemaName = "SESSION";
        } else {
            this.systemSchemaName = languageConnectionContext.getSystemSchemaName();
            this.sysIBMSchemaName = languageConnectionContext.getSysIBMSchemaName();
            this.systemDiagSchemaName = languageConnectionContext.getSystemDiagSchemaName();
            this.systemUtilSchemaName = languageConnectionContext.getSystemUtilSchemaName();
            this.declaredGlobalTemporaryTablesSchemaName = languageConnectionContext.getDeclaredGlobalTemporaryTablesSchemaName();
            this.builtinSchemasAreFromLCC = true;
        }
    }

    private void getBuiltinSchemas() throws StandardException {
        if (this.builtinSchemasAreFromLCC && null != this.systemSchemaDesc && null != this.sysIBMSchemaDesc && null != this.systemDiagSchemaDesc && null != this.systemUtilSchemaDesc && null != this.declaredGlobalTemporaryTablesSchemaDesc) {
            return;
        }
        this.getBuiltinSchemaNames();
        this.systemSchemaDesc = this.newSystemSchemaDesc(this.systemSchemaName, "8000000d-00d0-fd77-3ed8-000a0a0b1900");
        this.sysIBMSchemaDesc = this.newSystemSchemaDesc(this.sysIBMSchemaName, "c013800d-00f8-5b53-28a9-00000019ed88");
        this.systemDiagSchemaDesc = this.newSystemSchemaDesc(this.systemDiagSchemaName, "c013800d-00fb-2646-07ec-000000134f30");
        this.systemUtilSchemaDesc = this.newSystemSchemaDesc(this.systemUtilSchemaName, "c013800d-00fb-2649-07ec-000000134f30");
        this.declaredGlobalTemporaryTablesSchemaDesc = this.newDeclaredGlobalTemporaryTablesSchemaDesc(this.declaredGlobalTemporaryTablesSchemaName);
    }

    public SchemaDescriptor getSystemSchemaDescriptor() throws StandardException {
        this.getBuiltinSchemas();
        return this.systemSchemaDesc;
    }

    public SchemaDescriptor getSystemUtilSchemaDescriptor() throws StandardException {
        this.getBuiltinSchemas();
        return this.systemUtilSchemaDesc;
    }

    public SchemaDescriptor getSystemDiagSchemaDescriptor() throws StandardException {
        this.getBuiltinSchemas();
        return this.systemDiagSchemaDesc;
    }

    public SchemaDescriptor getSysIBMSchemaDescriptor() throws StandardException {
        this.getBuiltinSchemas();
        return this.sysIBMSchemaDesc;
    }

    public SchemaDescriptor getDeclaredGlobalTemporaryTablesSchemaDescriptor() throws StandardException {
        this.getBuiltinSchemas();
        return this.declaredGlobalTemporaryTablesSchemaDesc;
    }

    public boolean isSystemSchemaName(String string) throws StandardException {
        this.getBuiltinSchemaNames();
        boolean bl = false;
        int n = systemSchemaNames.length - 1;
        while (n >= 0 && !(bl = systemSchemaNames[n--].equals(string))) {
        }
        return bl;
    }

    public SchemaDescriptor getSchemaDescriptor(String string, TransactionController transactionController, boolean bl) throws StandardException {
        if (transactionController == null) {
            transactionController = this.getTransactionCompile();
        }
        if (this.getSystemSchemaDescriptor().getSchemaName().equals(string)) {
            return this.getSystemSchemaDescriptor();
        }
        if (this.getSysIBMSchemaDescriptor().getSchemaName().equals(string) && this.dictionaryVersion.checkVersion(100, null)) {
            return this.getSysIBMSchemaDescriptor();
        }
        SchemaDescriptor schemaDescriptor = this.locateSchemaRow(string, transactionController);
        if (schemaDescriptor == null && this.getDeclaredGlobalTemporaryTablesSchemaDescriptor().getSchemaName().equals(string)) {
            return this.getDeclaredGlobalTemporaryTablesSchemaDescriptor();
        }
        if (schemaDescriptor == null && bl) {
            throw StandardException.newException("42Y07", string);
        }
        return schemaDescriptor;
    }

    private SchemaDescriptor locateSchemaRow(UUID uUID, TransactionController transactionController) throws StandardException {
        TabInfo tabInfo = this.coreInfo[3];
        StringDataValue stringDataValue = this.dvf.getCharDataValue(uUID.toString());
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, stringDataValue);
        return (SchemaDescriptor)this.getDescriptorViaIndex(1, execIndexRow, null, tabInfo, null, null, false);
    }

    private SchemaDescriptor locateSchemaRow(String string, TransactionController transactionController) throws StandardException {
        TabInfo tabInfo = this.coreInfo[3];
        StringDataValue stringDataValue = this.dvf.getVarcharDataValue(string);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, stringDataValue);
        return (SchemaDescriptor)this.getDescriptorViaIndex(0, execIndexRow, null, tabInfo, null, null, false);
    }

    public SchemaDescriptor getSchemaDescriptor(UUID uUID, TransactionController transactionController) throws StandardException {
        LanguageConnectionContext languageConnectionContext;
        SchemaDescriptor schemaDescriptor = null;
        if (transactionController == null) {
            transactionController = this.getTransactionCompile();
        }
        if (uUID != null) {
            if (this.getSystemSchemaDescriptor().getUUID().equals(uUID)) {
                return this.getSystemSchemaDescriptor();
            }
            if (this.getSysIBMSchemaDescriptor().getUUID().equals(uUID)) {
                return this.getSysIBMSchemaDescriptor();
            }
        }
        if (!this.booting && (languageConnectionContext = DataDictionaryImpl.getLCC()) != null && (schemaDescriptor = languageConnectionContext.getDefaultSchema()) != null && (uUID == null || uUID.equals(schemaDescriptor.getUUID()))) {
            return schemaDescriptor;
        }
        return this.locateSchemaRow(uUID, transactionController);
    }

    public void addDescriptor(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2, int n, boolean bl, TransactionController transactionController) throws StandardException {
        this.addDescriptorNow(tupleDescriptor, tupleDescriptor2, n, bl, transactionController, true);
    }

    private void addDescriptorNow(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2, int n, boolean bl, TransactionController transactionController, boolean bl2) throws StandardException {
        TabInfo tabInfo = n < 4 ? this.coreInfo[n] : this.getNonCoreTI(n);
        ExecRow execRow = tabInfo.getCatalogRowFactory().makeRow(tupleDescriptor, tupleDescriptor2);
        int n2 = tabInfo.insertRow(execRow, transactionController, bl2);
        if (!bl && n2 != -1) {
            throw this.duplicateDescriptorException(tupleDescriptor, tupleDescriptor2);
        }
    }

    private StandardException duplicateDescriptorException(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2) {
        if (tupleDescriptor2 != null) {
            return StandardException.newException("X0Y32.S", tupleDescriptor.getDescriptorType(), (Object)tupleDescriptor.getDescriptorName(), (Object)tupleDescriptor2.getDescriptorType(), (Object)tupleDescriptor2.getDescriptorName());
        }
        return StandardException.newException("X0Y68.S", tupleDescriptor.getDescriptorType(), (Object)tupleDescriptor.getDescriptorName());
    }

    public void addDescriptorArray(TupleDescriptor[] tupleDescriptorArray, TupleDescriptor tupleDescriptor, int n, boolean bl, TransactionController transactionController) throws StandardException {
        int n2;
        TabInfo tabInfo = n < 4 ? this.coreInfo[n] : this.getNonCoreTI(n);
        CatalogRowFactory catalogRowFactory = tabInfo.getCatalogRowFactory();
        RowList rowList = new RowList();
        for (n2 = 0; n2 < tupleDescriptorArray.length; ++n2) {
            ExecRow execRow = catalogRowFactory.makeRow(tupleDescriptorArray[n2], tupleDescriptor);
            rowList.add(execRow);
        }
        n2 = tabInfo.insertRowList(rowList, transactionController);
        if (!bl && n2 != -1) {
            throw this.duplicateDescriptorException(tupleDescriptorArray[n2], tupleDescriptor);
        }
    }

    public void dropSchemaDescriptor(String string, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow = null;
        TabInfo tabInfo = this.coreInfo[3];
        StringDataValue stringDataValue = this.dvf.getVarcharDataValue(string);
        execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, stringDataValue);
        tabInfo.deleteRow(transactionController, execIndexRow, 0);
    }

    public TableDescriptor getTableDescriptor(String string, SchemaDescriptor schemaDescriptor) throws StandardException {
        TableDescriptor tableDescriptor = null;
        SchemaDescriptor schemaDescriptor2 = schemaDescriptor == null ? this.getSystemSchemaDescriptor() : schemaDescriptor;
        UUID uUID = schemaDescriptor2.getUUID();
        TableKey tableKey = new TableKey(uUID, string);
        if (this.getCacheMode() == 0) {
            NameTDCacheable nameTDCacheable = (NameTDCacheable)this.nameTdCache.find(tableKey);
            if (nameTDCacheable != null) {
                tableDescriptor = nameTDCacheable.getTableDescriptor();
                tableDescriptor.setReferencedColumnMap(null);
                this.nameTdCache.release(nameTDCacheable);
            }
            return tableDescriptor;
        }
        return this.getTableDescriptorIndex1Scan(string, uUID.toString());
    }

    private TableDescriptor getTableDescriptorIndex1Scan(String string, String string2) throws StandardException {
        TabInfo tabInfo = this.coreInfo[1];
        StringDataValue stringDataValue = this.dvf.getVarcharDataValue(string);
        StringDataValue stringDataValue2 = this.dvf.getCharDataValue(string2);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, stringDataValue);
        execIndexRow.setColumn(2, stringDataValue2);
        TableDescriptor tableDescriptor = (TableDescriptor)this.getDescriptorViaIndex(0, execIndexRow, null, tabInfo, null, null, false);
        return this.finishTableDescriptor(tableDescriptor);
    }

    TableDescriptor getUncachedTableDescriptor(TableKey tableKey) throws StandardException {
        return this.getTableDescriptorIndex1Scan(tableKey.getTableName(), tableKey.getSchemaId().toString());
    }

    public TableDescriptor getTableDescriptor(UUID uUID) throws StandardException {
        TableDescriptor tableDescriptor = null;
        if (this.getCacheMode() == 0) {
            OIDTDCacheable oIDTDCacheable = (OIDTDCacheable)this.OIDTdCache.find(uUID);
            if (oIDTDCacheable != null) {
                tableDescriptor = oIDTDCacheable.getTableDescriptor();
                tableDescriptor.setReferencedColumnMap(null);
                this.OIDTdCache.release(oIDTDCacheable);
            }
            return tableDescriptor;
        }
        return this.getTableDescriptorIndex2Scan(uUID.toString());
    }

    protected TableDescriptor getUncachedTableDescriptor(UUID uUID) throws StandardException {
        return this.getTableDescriptorIndex2Scan(uUID.toString());
    }

    private TableDescriptor getTableDescriptorIndex2Scan(String string) throws StandardException {
        TabInfo tabInfo = this.coreInfo[1];
        StringDataValue stringDataValue = this.dvf.getCharDataValue(string);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, stringDataValue);
        TableDescriptor tableDescriptor = (TableDescriptor)this.getDescriptorViaIndex(1, execIndexRow, null, tabInfo, null, null, false);
        return this.finishTableDescriptor(tableDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableDescriptor finishTableDescriptor(TableDescriptor tableDescriptor) throws StandardException {
        if (tableDescriptor != null) {
            TableDescriptor tableDescriptor2 = tableDescriptor;
            synchronized (tableDescriptor2) {
                this.getColumnDescriptorsScan(tableDescriptor);
                this.getConglomerateDescriptorsScan(tableDescriptor);
            }
        }
        return tableDescriptor;
    }

    public boolean isSchemaEmpty(SchemaDescriptor schemaDescriptor) throws StandardException {
        DataValueDescriptor dataValueDescriptor;
        TransactionController transactionController = this.getTransactionCompile();
        if (this.isSchemaReferenced(transactionController, this.coreInfo[1], 0, 2, dataValueDescriptor = this.getValueAsDVD(schemaDescriptor.getUUID()))) {
            return false;
        }
        if (this.isSchemaReferenced(transactionController, this.getNonCoreTI(4), 1, 2, dataValueDescriptor)) {
            return false;
        }
        if (this.isSchemaReferenced(transactionController, this.getNonCoreTI(11), 1, 2, dataValueDescriptor)) {
            return false;
        }
        return !this.isSchemaReferenced(transactionController, this.getNonCoreTI(13), 1, 2, dataValueDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isSchemaReferenced(TransactionController transactionController, TabInfo tabInfo, int n, int n2, DataValueDescriptor dataValueDescriptor) throws StandardException {
        boolean bl;
        ConglomerateController conglomerateController;
        block5: {
            conglomerateController = null;
            GenericScanController genericScanController = null;
            FormatableBitSet formatableBitSet = new FormatableBitSet(n2);
            CatalogRowFactory catalogRowFactory = tabInfo.getCatalogRowFactory();
            formatableBitSet.set(n2 - 1);
            Qualifier[][] qualifierArray = this.exFactory.getScanQualifier(1);
            qualifierArray[0][0].setQualifier(n2 - 1, dataValueDescriptor, 2, false, false, false);
            ExecRow execRow = catalogRowFactory.makeEmptyRow();
            try {
                conglomerateController = transactionController.openConglomerate(tabInfo.getHeapConglomerate(), false, 0, 6, 4);
                genericScanController = transactionController.openScan(tabInfo.getIndexConglomerate(n), false, 0, 6, 4, formatableBitSet, null, 1, qualifierArray, null, -1);
                bl = genericScanController.next();
                Object var16_13 = null;
                if (genericScanController == null) break block5;
            }
            catch (Throwable throwable) {
                Object var16_14 = null;
                if (genericScanController != null) {
                    genericScanController.close();
                }
                if (conglomerateController != null) {
                    conglomerateController.close();
                }
                throw throwable;
            }
            genericScanController.close();
        }
        if (conglomerateController != null) {
            conglomerateController.close();
        }
        return bl;
    }

    public void dropTableDescriptor(TableDescriptor tableDescriptor, SchemaDescriptor schemaDescriptor, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow = null;
        TabInfo tabInfo = this.coreInfo[1];
        StringDataValue stringDataValue = this.dvf.getVarcharDataValue(tableDescriptor.getName());
        DataValueDescriptor dataValueDescriptor = this.getValueAsDVD(schemaDescriptor.getUUID());
        execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, stringDataValue);
        execIndexRow.setColumn(2, dataValueDescriptor);
        tabInfo.deleteRow(transactionController, execIndexRow, 0);
    }

    public void updateLockGranularity(TableDescriptor tableDescriptor, SchemaDescriptor schemaDescriptor, char c, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow = null;
        TabInfo tabInfo = this.coreInfo[1];
        SYSTABLESRowFactory sYSTABLESRowFactory = (SYSTABLESRowFactory)tabInfo.getCatalogRowFactory();
        StringDataValue stringDataValue = this.dvf.getVarcharDataValue(tableDescriptor.getName());
        DataValueDescriptor dataValueDescriptor = this.getValueAsDVD(schemaDescriptor.getUUID());
        execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, stringDataValue);
        execIndexRow.setColumn(2, dataValueDescriptor);
        ExecRow execRow = sYSTABLESRowFactory.makeRow(tableDescriptor, schemaDescriptor);
        boolean[] blArray = new boolean[2];
        for (int i = 0; i < 2; ++i) {
            blArray[i] = false;
        }
        tabInfo.updateRow(execIndexRow, execRow, 0, blArray, (int[])null, transactionController);
    }

    public ColumnDescriptor getColumnDescriptorByDefaultId(UUID uUID) throws StandardException {
        TabInfo tabInfo = this.coreInfo[2];
        StringDataValue stringDataValue = this.dvf.getCharDataValue(uUID.toString());
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, stringDataValue);
        return (ColumnDescriptor)this.getDescriptorViaIndex(1, execIndexRow, null, tabInfo, null, null, false);
    }

    private void getColumnDescriptorsScan(TableDescriptor tableDescriptor) throws StandardException {
        this.getColumnDescriptorsScan(tableDescriptor.getUUID(), tableDescriptor.getColumnDescriptorList(), tableDescriptor);
    }

    private void getColumnDescriptorsScan(UUID uUID, ColumnDescriptorList columnDescriptorList, TupleDescriptor tupleDescriptor) throws StandardException {
        int n;
        ColumnDescriptorList columnDescriptorList2 = new ColumnDescriptorList();
        DataValueDescriptor dataValueDescriptor = null;
        TabInfo tabInfo = this.coreInfo[2];
        dataValueDescriptor = this.getValueAsDVD(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, dataValueDescriptor);
        this.getDescriptorViaIndex(0, execIndexRow, null, tabInfo, tupleDescriptor, columnDescriptorList, false);
        int n2 = columnDescriptorList.size();
        for (n = 0; n < n2; ++n) {
            columnDescriptorList2.add(columnDescriptorList.get(n));
        }
        for (n = 0; n < n2; ++n) {
            ColumnDescriptor columnDescriptor = columnDescriptorList2.elementAt(n);
            columnDescriptorList.set(columnDescriptor.getPosition() - 1, columnDescriptor);
        }
    }

    public void dropColumnDescriptor(UUID uUID, String string, TransactionController transactionController) throws StandardException {
        DataValueDescriptor dataValueDescriptor = this.getValueAsDVD(uUID);
        StringDataValue stringDataValue = this.dvf.getVarcharDataValue(string);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, dataValueDescriptor);
        execIndexRow.setColumn(2, stringDataValue);
        this.dropColumnDescriptorCore(transactionController, execIndexRow);
    }

    public void dropAllColumnDescriptors(UUID uUID, TransactionController transactionController) throws StandardException {
        DataValueDescriptor dataValueDescriptor = this.getValueAsDVD(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, dataValueDescriptor);
        this.dropColumnDescriptorCore(transactionController, execIndexRow);
    }

    private void dropColumnDescriptorCore(TransactionController transactionController, ExecIndexRow execIndexRow) throws StandardException {
        TabInfo tabInfo = this.coreInfo[2];
        tabInfo.deleteRow(transactionController, execIndexRow, 0);
    }

    private void updateColumnDescriptor(ColumnDescriptor columnDescriptor, UUID uUID, String string, int[] nArray, TransactionController transactionController, boolean bl) throws StandardException {
        boolean[] blArray;
        ExecRow execRow;
        TabInfo tabInfo;
        ExecIndexRow execIndexRow;
        block4: {
            block3: {
                execIndexRow = null;
                tabInfo = this.coreInfo[2];
                SYSCOLUMNSRowFactory sYSCOLUMNSRowFactory = (SYSCOLUMNSRowFactory)tabInfo.getCatalogRowFactory();
                DataValueDescriptor dataValueDescriptor = this.getValueAsDVD(uUID);
                StringDataValue stringDataValue = this.dvf.getVarcharDataValue(string);
                execIndexRow = this.exFactory.getIndexableRow(2);
                execIndexRow.setColumn(1, dataValueDescriptor);
                execIndexRow.setColumn(2, stringDataValue);
                execRow = sYSCOLUMNSRowFactory.makeRow(columnDescriptor, null);
                blArray = new boolean[sYSCOLUMNSRowFactory.getNumIndexes()];
                if (nArray != null) break block3;
                blArray[0] = true;
                blArray[1] = true;
                break block4;
            }
            for (int i = 0; i < nArray.length; ++i) {
                block6: {
                    block5: {
                        if (nArray[i] == 2) break block5;
                        if (nArray[i] != 1) break block6;
                    }
                    blArray[0] = true;
                    break;
                }
                if (nArray[i] != 6) continue;
                blArray[1] = true;
                break;
            }
        }
        tabInfo.updateRow(execIndexRow, execRow, 0, blArray, nArray, transactionController, bl);
    }

    public ViewDescriptor getViewDescriptor(UUID uUID) throws StandardException {
        return this.getViewDescriptor(this.getTableDescriptor(uUID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewDescriptor getViewDescriptor(TableDescriptor tableDescriptor) throws StandardException {
        TableDescriptor tableDescriptor2 = tableDescriptor;
        if (tableDescriptor2.getViewDescriptor() != null) {
            return tableDescriptor2.getViewDescriptor();
        }
        TableDescriptor tableDescriptor3 = tableDescriptor2;
        synchronized (tableDescriptor3) {
            if (tableDescriptor2.getViewDescriptor() != null) {
                return tableDescriptor2.getViewDescriptor();
            }
            tableDescriptor2.setViewDescriptor(this.getViewDescriptorScan(tableDescriptor2));
        }
        return tableDescriptor2.getViewDescriptor();
    }

    private ViewDescriptor getViewDescriptorScan(TableDescriptor tableDescriptor) throws StandardException {
        TabInfo tabInfo = this.getNonCoreTI(8);
        UUID uUID = tableDescriptor.getUUID();
        StringDataValue stringDataValue = this.dvf.getCharDataValue(uUID.toString());
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, stringDataValue);
        ViewDescriptor viewDescriptor = (ViewDescriptor)this.getDescriptorViaIndex(0, execIndexRow, null, tabInfo, null, null, false);
        if (viewDescriptor != null) {
            viewDescriptor.setViewName(tableDescriptor.getName());
        }
        return viewDescriptor;
    }

    public void dropViewDescriptor(ViewDescriptor viewDescriptor, TransactionController transactionController) throws StandardException {
        TabInfo tabInfo = this.getNonCoreTI(8);
        DataValueDescriptor dataValueDescriptor = this.getValueAsDVD(viewDescriptor.getUUID());
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, dataValueDescriptor);
        tabInfo.deleteRow(transactionController, execIndexRow, 0);
    }

    private FileInfoDescriptor getFileInfoDescriptorIndex2Scan(UUID uUID) throws StandardException {
        TabInfo tabInfo = this.getNonCoreTI(12);
        StringDataValue stringDataValue = this.dvf.getCharDataValue(uUID.toString());
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, stringDataValue);
        return (FileInfoDescriptor)this.getDescriptorViaIndex(1, execIndexRow, null, tabInfo, null, null, false);
    }

    public FileInfoDescriptor getFileInfoDescriptor(UUID uUID) throws StandardException {
        return this.getFileInfoDescriptorIndex2Scan(uUID);
    }

    private FileInfoDescriptor getFileInfoDescriptorIndex1Scan(UUID uUID, String string) throws StandardException {
        TabInfo tabInfo = this.getNonCoreTI(12);
        StringDataValue stringDataValue = this.dvf.getVarcharDataValue(string);
        StringDataValue stringDataValue2 = this.dvf.getCharDataValue(uUID.toString());
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, stringDataValue);
        execIndexRow.setColumn(2, stringDataValue2);
        FileInfoDescriptor fileInfoDescriptor = (FileInfoDescriptor)this.getDescriptorViaIndex(0, execIndexRow, null, tabInfo, null, null, false);
        return fileInfoDescriptor;
    }

    public FileInfoDescriptor getFileInfoDescriptor(SchemaDescriptor schemaDescriptor, String string) throws StandardException {
        return this.getFileInfoDescriptorIndex1Scan(schemaDescriptor.getUUID(), string);
    }

    public void dropFileInfoDescriptor(FileInfoDescriptor fileInfoDescriptor) throws StandardException {
        ExecIndexRow execIndexRow = null;
        TabInfo tabInfo = this.getNonCoreTI(12);
        TransactionController transactionController = this.getTransactionExecute();
        DataValueDescriptor dataValueDescriptor = this.getValueAsDVD(fileInfoDescriptor.getUUID());
        execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, dataValueDescriptor);
        tabInfo.deleteRow(transactionController, execIndexRow, 1);
    }

    public SPSDescriptor getSPSDescriptor(UUID uUID) throws StandardException {
        SPSDescriptor sPSDescriptor;
        this.getNonCoreTI(11);
        if (this.spsNameCache != null && this.getCacheMode() == 0) {
            sPSDescriptor = (SPSDescriptor)this.spsIdHash.get(uUID);
            if (sPSDescriptor != null) {
                return sPSDescriptor;
            }
            sPSDescriptor = this.getSPSDescriptorIndex2Scan(uUID.toString());
            TableKey tableKey = new TableKey(sPSDescriptor.getSchemaDescriptor().getUUID(), sPSDescriptor.getName());
            try {
                SPSNameCacheable sPSNameCacheable = (SPSNameCacheable)this.spsNameCache.create(tableKey, sPSDescriptor);
                this.spsNameCache.release(sPSNameCacheable);
            }
            catch (StandardException standardException) {
                if ("XBCA0.S".equals(standardException.getMessageId())) {
                    return sPSDescriptor;
                }
                throw standardException;
            }
        } else {
            sPSDescriptor = this.getSPSDescriptorIndex2Scan(uUID.toString());
        }
        return sPSDescriptor;
    }

    void spsCacheEntryAdded(SPSDescriptor sPSDescriptor) {
        this.spsIdHash.put(sPSDescriptor.getUUID(), sPSDescriptor);
    }

    void spsCacheEntryRemoved(SPSDescriptor sPSDescriptor) {
        this.spsIdHash.remove(sPSDescriptor.getUUID());
    }

    public SPSDescriptor getUncachedSPSDescriptor(TableKey tableKey) throws StandardException {
        return this.getSPSDescriptorIndex1Scan(tableKey.getTableName(), tableKey.getSchemaId().toString());
    }

    protected SPSDescriptor getUncachedSPSDescriptor(UUID uUID) throws StandardException {
        return this.getSPSDescriptorIndex2Scan(uUID.toString());
    }

    private SPSDescriptor getSPSDescriptorIndex2Scan(String string) throws StandardException {
        TabInfo tabInfo = this.getNonCoreTI(11);
        StringDataValue stringDataValue = this.dvf.getCharDataValue(string);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, stringDataValue);
        SPSDescriptor sPSDescriptor = (SPSDescriptor)this.getDescriptorViaIndex(0, execIndexRow, null, tabInfo, null, null, false);
        return sPSDescriptor;
    }

    public SPSDescriptor getSPSDescriptor(String string, SchemaDescriptor schemaDescriptor) throws StandardException {
        SPSDescriptor sPSDescriptor = null;
        UUID uUID = schemaDescriptor.getUUID();
        TableKey tableKey = new TableKey(uUID, string);
        if (this.spsNameCache != null && this.getCacheMode() == 0) {
            SPSNameCacheable sPSNameCacheable = (SPSNameCacheable)this.spsNameCache.find(tableKey);
            if (sPSNameCacheable != null) {
                sPSDescriptor = sPSNameCacheable.getSPSDescriptor();
                this.spsNameCache.release(sPSNameCacheable);
            }
            return sPSDescriptor;
        }
        return this.getSPSDescriptorIndex1Scan(string, uUID.toString());
    }

    private SPSDescriptor getSPSDescriptorIndex1Scan(String string, String string2) throws StandardException {
        TabInfo tabInfo = this.getNonCoreTI(11);
        StringDataValue stringDataValue = this.dvf.getVarcharDataValue(string);
        StringDataValue stringDataValue2 = this.dvf.getCharDataValue(string2);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, stringDataValue);
        execIndexRow.setColumn(2, stringDataValue2);
        SPSDescriptor sPSDescriptor = (SPSDescriptor)this.getDescriptorViaIndex(1, execIndexRow, null, tabInfo, null, null, false);
        if (sPSDescriptor != null) {
            Vector vector = new Vector();
            sPSDescriptor.setParams(this.getSPSParams(sPSDescriptor, vector));
            Object[] objectArray = new Object[vector.size()];
            vector.copyInto(objectArray);
            sPSDescriptor.setParameterDefaults(objectArray);
        }
        return sPSDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSPSDescriptor(SPSDescriptor sPSDescriptor, TransactionController transactionController, boolean bl) throws StandardException {
        int n;
        TabInfo tabInfo = this.getNonCoreTI(11);
        SYSSTATEMENTSRowFactory sYSSTATEMENTSRowFactory = (SYSSTATEMENTSRowFactory)tabInfo.getCatalogRowFactory();
        SPSDescriptor sPSDescriptor2 = sPSDescriptor;
        synchronized (sPSDescriptor2) {
            boolean bl2 = sPSDescriptor.initiallyCompilable();
            ExecRow execRow = sYSSTATEMENTSRowFactory.makeSYSSTATEMENTSrow(bl2, sPSDescriptor);
            n = tabInfo.insertRow(execRow, transactionController, bl);
        }
        if (n != -1) {
            throw StandardException.newException("X0Y32.S", sPSDescriptor.getDescriptorType(), (Object)sPSDescriptor.getDescriptorName(), (Object)sPSDescriptor.getSchemaDescriptor().getDescriptorType(), (Object)sPSDescriptor.getSchemaDescriptor().getSchemaName());
        }
        this.addSPSParams(sPSDescriptor, transactionController, bl);
    }

    private void addSPSParams(SPSDescriptor sPSDescriptor, TransactionController transactionController, boolean bl) throws StandardException {
        UUID uUID = sPSDescriptor.getUUID();
        DataTypeDescriptor[] dataTypeDescriptorArray = sPSDescriptor.getParams();
        Object[] objectArray = sPSDescriptor.getParameterDefaults();
        if (dataTypeDescriptorArray == null) {
            return;
        }
        int n = dataTypeDescriptorArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = i + 1;
            ColumnDescriptor columnDescriptor = new ColumnDescriptor("PARAM" + n2, n2, dataTypeDescriptorArray[i], objectArray == null || i >= objectArray.length ? (DataValueDescriptor)null : (DataValueDescriptor)objectArray[i], (DefaultInfo)null, uUID, (UUID)null, 0L, 0L, false);
            this.addDescriptorNow(columnDescriptor, null, 2, false, transactionController, bl);
        }
    }

    public DataTypeDescriptor[] getSPSParams(SPSDescriptor sPSDescriptor, Vector vector) throws StandardException {
        ColumnDescriptorList columnDescriptorList = new ColumnDescriptorList();
        this.getColumnDescriptorsScan(sPSDescriptor.getUUID(), columnDescriptorList, sPSDescriptor);
        int n = columnDescriptorList.size();
        DataTypeDescriptor[] dataTypeDescriptorArray = new DataTypeDescriptor[n];
        for (int i = 0; i < n; ++i) {
            ColumnDescriptor columnDescriptor = columnDescriptorList.elementAt(i);
            dataTypeDescriptorArray[i] = columnDescriptor.getType();
            if (vector == null) continue;
            vector.addElement(columnDescriptor.getDefaultValue());
        }
        return dataTypeDescriptorArray;
    }

    public void updateSPS(SPSDescriptor sPSDescriptor, TransactionController transactionController, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws StandardException {
        ExecIndexRow execIndexRow = null;
        TabInfo tabInfo = this.getNonCoreTI(11);
        SYSSTATEMENTSRowFactory sYSSTATEMENTSRowFactory = (SYSSTATEMENTSRowFactory)tabInfo.getCatalogRowFactory();
        int[] nArray = bl ? (bl4 ? new int[]{5, 7, 9, 10, 11} : new int[]{5, 7, 9, 10}) : new int[]{5};
        DataValueDescriptor dataValueDescriptor = this.getValueAsDVD(sPSDescriptor.getUUID());
        execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, dataValueDescriptor);
        ExecRow execRow = sYSSTATEMENTSRowFactory.makeSYSSTATEMENTSrow(false, sPSDescriptor);
        boolean[] blArray = new boolean[2];
        tabInfo.updateRow(execIndexRow, execRow, 0, blArray, nArray, transactionController, bl3);
        if (!bl2) {
            return;
        }
        DataTypeDescriptor[] dataTypeDescriptorArray = sPSDescriptor.getParams();
        if (dataTypeDescriptorArray == null) {
            return;
        }
        if (bl4) {
            this.addSPSParams(sPSDescriptor, transactionController, bl3);
        } else {
            Object[] objectArray = sPSDescriptor.getParameterDefaults();
            int[] nArray2 = new int[]{4, 5};
            UUID uUID = sPSDescriptor.getUUID();
            for (int i = 0; i < dataTypeDescriptorArray.length; ++i) {
                int n = i + 1;
                ColumnDescriptor columnDescriptor = new ColumnDescriptor("PARAM" + n, n, dataTypeDescriptorArray[i], objectArray == null || i >= objectArray.length ? (DataValueDescriptor)null : (DataValueDescriptor)objectArray[i], (DefaultInfo)null, uUID, (UUID)null, 0L, 0L, false);
                this.updateColumnDescriptor(columnDescriptor, columnDescriptor.getReferencingUUID(), columnDescriptor.getColumnName(), nArray2, transactionController, bl3);
            }
        }
    }

    public void invalidateAllSPSPlans() throws StandardException {
        LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)ContextService.getContext("LanguageConnectionContext");
        this.startWriting(languageConnectionContext);
        Iterator iterator = this.getAllSPSDescriptors().iterator();
        while (iterator.hasNext()) {
            SPSDescriptor sPSDescriptor = (SPSDescriptor)iterator.next();
            sPSDescriptor.makeInvalid(14, languageConnectionContext);
        }
    }

    void clearSPSPlans() throws StandardException {
        TabInfo tabInfo = this.getNonCoreTI(11);
        this.faultInTabInfo(tabInfo);
        TransactionController transactionController = this.getTransactionExecute();
        FormatableBitSet formatableBitSet = new FormatableBitSet(11);
        FormatableBitSet formatableBitSet2 = new FormatableBitSet(11);
        formatableBitSet2.set(4);
        formatableBitSet2.set(9);
        DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[11];
        dataValueDescriptorArray[4] = this.dvf.getDataValue(false);
        dataValueDescriptorArray[9] = this.dvf.getDataValue((Object)null);
        ScanController scanController = transactionController.openScan(tabInfo.getHeapConglomerate(), false, 4, 7, 4, formatableBitSet, null, 0, null, null, 0);
        while (scanController.fetchNext(null)) {
            scanController.replace(dataValueDescriptorArray, formatableBitSet2);
        }
        scanController.close();
    }

    public void dropSPSDescriptor(SPSDescriptor sPSDescriptor, TransactionController transactionController) throws StandardException {
        this.dropSPSDescriptor(sPSDescriptor.getUUID(), transactionController);
    }

    public void dropSPSDescriptor(UUID uUID, TransactionController transactionController) throws StandardException {
        TabInfo tabInfo = this.getNonCoreTI(11);
        DataValueDescriptor dataValueDescriptor = this.getValueAsDVD(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, dataValueDescriptor);
        tabInfo.deleteRow(transactionController, execIndexRow, 0);
        this.dropAllColumnDescriptors(uUID, transactionController);
    }

    public List getAllSPSDescriptors() throws StandardException {
        TabInfo tabInfo = this.getNonCoreTI(11);
        List list = DataDictionaryImpl.newSList();
        this.getDescriptorViaHeap(null, tabInfo, null, list);
        return list;
    }

    private ConstraintDescriptorList getAllConstraintDescriptors() throws StandardException {
        TabInfo tabInfo = this.getNonCoreTI(4);
        ConstraintDescriptorList constraintDescriptorList = new ConstraintDescriptorList();
        this.getConstraintDescriptorViaHeap(null, tabInfo, null, constraintDescriptorList);
        return constraintDescriptorList;
    }

    private GenericDescriptorList getAllTriggerDescriptors() throws StandardException {
        TabInfo tabInfo = this.getNonCoreTI(13);
        GenericDescriptorList genericDescriptorList = new GenericDescriptorList();
        this.getDescriptorViaHeap(null, tabInfo, null, genericDescriptorList);
        return genericDescriptorList;
    }

    public TriggerDescriptor getTriggerDescriptor(UUID uUID) throws StandardException {
        TabInfo tabInfo = this.getNonCoreTI(13);
        StringDataValue stringDataValue = this.dvf.getCharDataValue(uUID.toString());
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, stringDataValue);
        return (TriggerDescriptor)this.getDescriptorViaIndex(0, execIndexRow, null, tabInfo, null, null, false);
    }

    public TriggerDescriptor getTriggerDescriptor(String string, SchemaDescriptor schemaDescriptor) throws StandardException {
        TabInfo tabInfo = this.getNonCoreTI(13);
        StringDataValue stringDataValue = this.dvf.getVarcharDataValue(string);
        StringDataValue stringDataValue2 = this.dvf.getCharDataValue(schemaDescriptor.getUUID().toString());
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, stringDataValue);
        execIndexRow.setColumn(2, stringDataValue2);
        return (TriggerDescriptor)this.getDescriptorViaIndex(1, execIndexRow, null, tabInfo, null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericDescriptorList getTriggerDescriptors(TableDescriptor tableDescriptor) throws StandardException {
        GenericDescriptorList genericDescriptorList;
        if (tableDescriptor == null) {
            return this.getAllTriggerDescriptors();
        }
        GenericDescriptorList genericDescriptorList2 = genericDescriptorList = tableDescriptor.getTriggerDescriptorList();
        synchronized (genericDescriptorList2) {
            if (!genericDescriptorList.getScanned()) {
                this.getTriggerDescriptorsScan(tableDescriptor, false);
            }
        }
        return genericDescriptorList;
    }

    private void getTriggerDescriptorsScan(TableDescriptor tableDescriptor, boolean bl) throws StandardException {
        GenericDescriptorList genericDescriptorList = tableDescriptor.getTriggerDescriptorList();
        DataValueDescriptor dataValueDescriptor = null;
        TabInfo tabInfo = this.getNonCoreTI(13);
        dataValueDescriptor = this.getValueAsDVD(tableDescriptor.getUUID());
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, dataValueDescriptor);
        this.getDescriptorViaIndex(2, execIndexRow, null, tabInfo, null, genericDescriptorList, bl);
        genericDescriptorList.setScanned(true);
    }

    public void dropTriggerDescriptor(TriggerDescriptor triggerDescriptor, TransactionController transactionController) throws StandardException {
        TabInfo tabInfo = this.getNonCoreTI(13);
        DataValueDescriptor dataValueDescriptor = this.getValueAsDVD(triggerDescriptor.getUUID());
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, dataValueDescriptor);
        tabInfo.deleteRow(transactionController, execIndexRow, 0);
    }

    public void updateTriggerDescriptor(TriggerDescriptor triggerDescriptor, UUID uUID, int[] nArray, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow = null;
        TabInfo tabInfo = this.getNonCoreTI(13);
        SYSTRIGGERSRowFactory sYSTRIGGERSRowFactory = (SYSTRIGGERSRowFactory)tabInfo.getCatalogRowFactory();
        DataValueDescriptor dataValueDescriptor = this.getValueAsDVD(uUID);
        execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, dataValueDescriptor);
        ExecRow execRow = sYSTRIGGERSRowFactory.makeRow(triggerDescriptor, null);
        boolean[] blArray = new boolean[3];
        if (nArray == null) {
            blArray[0] = true;
            blArray[1] = true;
            blArray[2] = true;
        } else {
            block5: for (int i = 0; i < nArray.length; ++i) {
                switch (nArray[i]) {
                    case 1: {
                        blArray[0] = true;
                        continue block5;
                    }
                    case 2: 
                    case 3: {
                        blArray[1] = true;
                        continue block5;
                    }
                    case 9: {
                        blArray[2] = true;
                    }
                }
            }
        }
        tabInfo.updateRow(execIndexRow, execRow, 0, blArray, nArray, transactionController);
    }

    public ConstraintDescriptor getConstraintDescriptor(UUID uUID) throws StandardException {
        TabInfo tabInfo = this.getNonCoreTI(4);
        StringDataValue stringDataValue = this.dvf.getCharDataValue(uUID.toString());
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, stringDataValue);
        return this.getConstraintDescriptorViaIndex(0, execIndexRow, tabInfo, null, null, false);
    }

    public ConstraintDescriptor getConstraintDescriptor(String string, UUID uUID) throws StandardException {
        TabInfo tabInfo = this.getNonCoreTI(4);
        StringDataValue stringDataValue = this.dvf.getVarcharDataValue(string);
        StringDataValue stringDataValue2 = this.dvf.getCharDataValue(uUID.toString());
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, stringDataValue);
        execIndexRow.setColumn(2, stringDataValue2);
        return this.getConstraintDescriptorViaIndex(1, execIndexRow, tabInfo, null, null, false);
    }

    public List getStatisticsDescriptors(TableDescriptor tableDescriptor) throws StandardException {
        TabInfo tabInfo = this.getNonCoreTI(14);
        List list = DataDictionaryImpl.newSList();
        StringDataValue stringDataValue = this.dvf.getCharDataValue(tableDescriptor.getUUID().toString());
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, stringDataValue);
        this.getDescriptorViaIndex(0, execIndexRow, null, tabInfo, null, list, false);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConstraintDescriptorList getConstraintDescriptors(TableDescriptor tableDescriptor) throws StandardException {
        ConstraintDescriptorList constraintDescriptorList;
        if (tableDescriptor == null) {
            return this.getAllConstraintDescriptors();
        }
        ConstraintDescriptorList constraintDescriptorList2 = constraintDescriptorList = tableDescriptor.getConstraintDescriptorList();
        synchronized (constraintDescriptorList2) {
            if (!constraintDescriptorList.getScanned()) {
                this.getConstraintDescriptorsScan(tableDescriptor, false);
            }
        }
        return constraintDescriptorList;
    }

    public ConstraintDescriptorList getActiveConstraintDescriptors(ConstraintDescriptorList constraintDescriptorList) throws StandardException {
        return constraintDescriptorList;
    }

    public boolean activeConstraint(ConstraintDescriptor constraintDescriptor) throws StandardException {
        return true;
    }

    public ConstraintDescriptor getConstraintDescriptor(TableDescriptor tableDescriptor, UUID uUID) throws StandardException {
        return this.getConstraintDescriptors(tableDescriptor).getConstraintDescriptor(uUID);
    }

    public ConstraintDescriptor getConstraintDescriptorById(TableDescriptor tableDescriptor, UUID uUID) throws StandardException {
        return this.getConstraintDescriptors(tableDescriptor).getConstraintDescriptorById(uUID);
    }

    public ConstraintDescriptor getConstraintDescriptorByName(TableDescriptor tableDescriptor, SchemaDescriptor schemaDescriptor, String string, boolean bl) throws StandardException {
        if (bl) {
            tableDescriptor.emptyConstraintDescriptorList();
            this.getConstraintDescriptorsScan(tableDescriptor, true);
        }
        return this.getConstraintDescriptors(tableDescriptor).getConstraintDescriptorByName(schemaDescriptor, string);
    }

    private void getConstraintDescriptorsScan(TableDescriptor tableDescriptor, boolean bl) throws StandardException {
        ConstraintDescriptorList constraintDescriptorList = tableDescriptor.getConstraintDescriptorList();
        DataValueDescriptor dataValueDescriptor = null;
        TabInfo tabInfo = this.getNonCoreTI(4);
        dataValueDescriptor = this.getValueAsDVD(tableDescriptor.getUUID());
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, dataValueDescriptor);
        this.getConstraintDescriptorViaIndex(2, execIndexRow, tabInfo, tableDescriptor, constraintDescriptorList, bl);
        constraintDescriptorList.setScanned(true);
    }

    protected ConstraintDescriptor getConstraintDescriptorViaIndex(int n, ExecIndexRow execIndexRow, TabInfo tabInfo, TableDescriptor tableDescriptor, ConstraintDescriptorList constraintDescriptorList, boolean bl) throws StandardException {
        SYSCONSTRAINTSRowFactory sYSCONSTRAINTSRowFactory = (SYSCONSTRAINTSRowFactory)tabInfo.getCatalogRowFactory();
        ConstraintDescriptor constraintDescriptor = null;
        TransactionController transactionController = this.getTransactionCompile();
        ExecRow execRow = sYSCONSTRAINTSRowFactory.makeEmptyRow();
        ConglomerateController conglomerateController = transactionController.openConglomerate(tabInfo.getHeapConglomerate(), false, 0, 6, 4);
        ScanController scanController = transactionController.openScan(tabInfo.getIndexConglomerate(n), false, bl ? 4 : 0, 6, 4, null, execIndexRow.getRowArray(), 1, null, execIndexRow.getRowArray(), -1);
        while (scanController.next()) {
            SubConstraintDescriptor subConstraintDescriptor = null;
            ExecIndexRow execIndexRow2 = DataDictionaryImpl.getIndexRowFromHeapRow(tabInfo.getIndexRowGenerator(n), conglomerateController.newRowLocationTemplate(), execRow);
            scanController.fetch(execIndexRow2.getRowArray());
            RowLocation rowLocation = (RowLocation)execIndexRow2.getColumn(execIndexRow2.nColumns());
            boolean bl2 = conglomerateController.fetch(rowLocation, execRow.getRowArray(), null);
            switch (sYSCONSTRAINTSRowFactory.getConstraintType(execRow)) {
                case 2: 
                case 3: 
                case 6: {
                    subConstraintDescriptor = this.getSubKeyConstraint(sYSCONSTRAINTSRowFactory.getConstraintId(execRow), sYSCONSTRAINTSRowFactory.getConstraintType(execRow));
                    break;
                }
                case 4: {
                    subConstraintDescriptor = this.getSubCheckConstraint(sYSCONSTRAINTSRowFactory.getConstraintId(execRow));
                    break;
                }
            }
            subConstraintDescriptor.setTableDescriptor(tableDescriptor);
            constraintDescriptor = (ConstraintDescriptor)sYSCONSTRAINTSRowFactory.buildDescriptor(execRow, subConstraintDescriptor, this);
            if (constraintDescriptorList == null) break;
            constraintDescriptorList.add(constraintDescriptor);
        }
        scanController.close();
        conglomerateController.close();
        return constraintDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TupleDescriptor getConstraintDescriptorViaHeap(ScanQualifier[][] scanQualifierArray, TabInfo tabInfo, TupleDescriptor tupleDescriptor, List list) throws StandardException {
        SYSCONSTRAINTSRowFactory sYSCONSTRAINTSRowFactory = (SYSCONSTRAINTSRowFactory)tabInfo.getCatalogRowFactory();
        ConstraintDescriptor constraintDescriptor = null;
        TransactionController transactionController = this.getTransactionCompile();
        ExecRow execRow = sYSCONSTRAINTSRowFactory.makeEmptyRow();
        ScanController scanController = transactionController.openScan(tabInfo.getHeapConglomerate(), false, 0, 7, 4, null, null, 0, scanQualifierArray, null, 0);
        try {
            while (scanController.fetchNext(execRow.getRowArray())) {
                SubConstraintDescriptor subConstraintDescriptor = null;
                switch (sYSCONSTRAINTSRowFactory.getConstraintType(execRow)) {
                    case 2: 
                    case 3: 
                    case 6: {
                        subConstraintDescriptor = this.getSubKeyConstraint(sYSCONSTRAINTSRowFactory.getConstraintId(execRow), sYSCONSTRAINTSRowFactory.getConstraintType(execRow));
                        break;
                    }
                    case 4: {
                        subConstraintDescriptor = this.getSubCheckConstraint(sYSCONSTRAINTSRowFactory.getConstraintId(execRow));
                        break;
                    }
                }
                constraintDescriptor = (ConstraintDescriptor)sYSCONSTRAINTSRowFactory.buildDescriptor(execRow, subConstraintDescriptor, this);
                if (list == null) {
                    break;
                }
                list.add(constraintDescriptor);
            }
        }
        finally {
            scanController.close();
        }
        return constraintDescriptor;
    }

    public TableDescriptor getConstraintTableDescriptor(UUID uUID) throws StandardException {
        List list = this.getConstraints(uUID, 0, 2);
        if (list.size() == 0) {
            return null;
        }
        return this.getTableDescriptor((UUID)list.get(0));
    }

    public ConstraintDescriptorList getForeignKeys(UUID uUID) throws StandardException {
        TabInfo tabInfo = this.getNonCoreTI(10);
        List list = DataDictionaryImpl.newSList();
        DataValueDescriptor dataValueDescriptor = this.getValueAsDVD(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, dataValueDescriptor);
        this.getDescriptorViaIndex(1, execIndexRow, null, tabInfo, null, list, false);
        ConstraintDescriptorList constraintDescriptorList = new ConstraintDescriptorList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SubKeyConstraintDescriptor subKeyConstraintDescriptor = (SubKeyConstraintDescriptor)iterator.next();
            TableDescriptor tableDescriptor = this.getConstraintTableDescriptor(subKeyConstraintDescriptor.getUUID());
            constraintDescriptorList.add(this.getConstraintDescriptors(tableDescriptor).getConstraintDescriptorById(subKeyConstraintDescriptor.getUUID()));
        }
        return constraintDescriptorList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getConstraints(UUID uUID, int n, int n2) throws StandardException {
        List list;
        GenericScanController genericScanController;
        block6: {
            ConglomerateController conglomerateController = null;
            genericScanController = null;
            TabInfo tabInfo = this.getNonCoreTI(4);
            SYSCONSTRAINTSRowFactory sYSCONSTRAINTSRowFactory = (SYSCONSTRAINTSRowFactory)tabInfo.getCatalogRowFactory();
            Object var13_8 = null;
            list = DataDictionaryImpl.newSList();
            try {
                DataValueDescriptor dataValueDescriptor = this.getValueAsDVD(uUID);
                ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
                execIndexRow.setColumn(1, dataValueDescriptor);
                TransactionController transactionController = this.getTransactionCompile();
                ExecRow execRow = sYSCONSTRAINTSRowFactory.makeEmptyRow();
                conglomerateController = transactionController.openConglomerate(tabInfo.getHeapConglomerate(), false, 0, 6, 4);
                ExecIndexRow execIndexRow2 = DataDictionaryImpl.getIndexRowFromHeapRow(tabInfo.getIndexRowGenerator(n), conglomerateController.newRowLocationTemplate(), execRow);
                DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[7];
                FormatableBitSet formatableBitSet = new FormatableBitSet(7);
                formatableBitSet.set(n2 - 1);
                dataValueDescriptorArray[n2 - 1] = this.dvf.getNullChar(null);
                genericScanController = transactionController.openScan(tabInfo.getIndexConglomerate(n), false, 0, 6, 4, null, execIndexRow.getRowArray(), 1, null, execIndexRow.getRowArray(), -1);
                while (genericScanController.fetchNext(execIndexRow2.getRowArray())) {
                    RowLocation rowLocation = (RowLocation)execIndexRow2.getColumn(execIndexRow2.nColumns());
                    boolean bl = conglomerateController.fetch(rowLocation, dataValueDescriptorArray, formatableBitSet);
                    list.add(this.uuidFactory.recreateUUID((String)dataValueDescriptorArray[n2 - 1].getObject()));
                }
                Object var21_19 = null;
                if (conglomerateController == null) break block6;
            }
            catch (Throwable throwable) {
                Object var21_20 = null;
                if (conglomerateController != null) {
                    conglomerateController.close();
                }
                if (genericScanController != null) {
                    genericScanController.close();
                }
                throw throwable;
            }
            conglomerateController.close();
        }
        if (genericScanController != null) {
            genericScanController.close();
        }
        return list;
    }

    public void addConstraintDescriptor(ConstraintDescriptor constraintDescriptor, TransactionController transactionController) throws StandardException {
        Object var3_3 = null;
        int n = constraintDescriptor.getConstraintType();
        TabInfo tabInfo = this.getNonCoreTI(4);
        SYSCONSTRAINTSRowFactory sYSCONSTRAINTSRowFactory = (SYSCONSTRAINTSRowFactory)tabInfo.getCatalogRowFactory();
        this.addDescriptor(constraintDescriptor, constraintDescriptor.getSchemaDescriptor(), 4, false, transactionController);
        switch (n) {
            case 2: 
            case 3: 
            case 6: {
                this.addSubKeyConstraint((KeyConstraintDescriptor)constraintDescriptor, transactionController);
                break;
            }
            case 4: {
                this.addDescriptor(constraintDescriptor, null, 9, true, transactionController);
            }
        }
    }

    public void updateConstraintDescriptor(ConstraintDescriptor constraintDescriptor, UUID uUID, int[] nArray, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow = null;
        TabInfo tabInfo = this.getNonCoreTI(4);
        SYSCONSTRAINTSRowFactory sYSCONSTRAINTSRowFactory = (SYSCONSTRAINTSRowFactory)tabInfo.getCatalogRowFactory();
        DataValueDescriptor dataValueDescriptor = this.getValueAsDVD(uUID);
        execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, dataValueDescriptor);
        ExecRow execRow = sYSCONSTRAINTSRowFactory.makeRow(constraintDescriptor, null);
        boolean[] blArray = new boolean[3];
        if (nArray == null) {
            blArray[0] = true;
            blArray[1] = true;
            blArray[2] = true;
        } else {
            block5: for (int i = 0; i < nArray.length; ++i) {
                switch (nArray[i]) {
                    case 1: {
                        blArray[0] = true;
                        continue block5;
                    }
                    case 3: 
                    case 5: {
                        blArray[1] = true;
                        continue block5;
                    }
                    case 2: {
                        blArray[2] = true;
                    }
                }
            }
        }
        tabInfo.updateRow(execIndexRow, execRow, 0, blArray, nArray, transactionController);
    }

    public void dropConstraintDescriptor(TableDescriptor tableDescriptor, ConstraintDescriptor constraintDescriptor, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow = null;
        TabInfo tabInfo = this.getNonCoreTI(4);
        switch (constraintDescriptor.getConstraintType()) {
            case 2: 
            case 3: 
            case 6: {
                this.dropSubKeyConstraint(constraintDescriptor, transactionController);
                break;
            }
            case 4: {
                this.dropSubCheckConstraint(constraintDescriptor.getUUID(), transactionController);
            }
        }
        StringDataValue stringDataValue = this.dvf.getVarcharDataValue(constraintDescriptor.getConstraintName());
        DataValueDescriptor dataValueDescriptor = this.getValueAsDVD(constraintDescriptor.getSchemaDescriptor().getUUID());
        execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, stringDataValue);
        execIndexRow.setColumn(2, dataValueDescriptor);
        tabInfo.deleteRow(transactionController, execIndexRow, 1);
    }

    public void dropAllConstraintDescriptors(TableDescriptor tableDescriptor, TransactionController transactionController) throws StandardException {
        ConstraintDescriptorList constraintDescriptorList = this.getConstraintDescriptors(tableDescriptor);
        Iterator iterator = constraintDescriptorList.iterator();
        while (iterator.hasNext()) {
            ConstraintDescriptor constraintDescriptor = (ConstraintDescriptor)iterator.next();
            this.dropConstraintDescriptor(tableDescriptor, constraintDescriptor, transactionController);
        }
        tableDescriptor.setConstraintDescriptorList(null);
    }

    public SubKeyConstraintDescriptor getSubKeyConstraint(UUID uUID, int n) throws StandardException {
        int n2;
        int n3;
        DataValueDescriptor dataValueDescriptor = null;
        if (n == 6) {
            n3 = 10;
            n2 = 0;
        } else {
            n3 = 5;
            n2 = 0;
        }
        TabInfo tabInfo = this.getNonCoreTI(n3);
        dataValueDescriptor = this.getValueAsDVD(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, dataValueDescriptor);
        return (SubKeyConstraintDescriptor)this.getDescriptorViaIndex(n2, execIndexRow, null, tabInfo, null, null, false);
    }

    private void addSubKeyConstraint(KeyConstraintDescriptor keyConstraintDescriptor, TransactionController transactionController) throws StandardException {
        ExecRow execRow;
        TabInfo tabInfo;
        if (keyConstraintDescriptor.getConstraintType() == 6) {
            ForeignKeyConstraintDescriptor foreignKeyConstraintDescriptor = (ForeignKeyConstraintDescriptor)keyConstraintDescriptor;
            tabInfo = this.getNonCoreTI(10);
            SYSFOREIGNKEYSRowFactory sYSFOREIGNKEYSRowFactory = (SYSFOREIGNKEYSRowFactory)tabInfo.getCatalogRowFactory();
            execRow = sYSFOREIGNKEYSRowFactory.makeRow(foreignKeyConstraintDescriptor, null);
            ReferencedKeyConstraintDescriptor referencedKeyConstraintDescriptor = foreignKeyConstraintDescriptor.getReferencedConstraint();
            referencedKeyConstraintDescriptor.incrementReferenceCount();
            int[] nArray = new int[]{7};
            this.updateConstraintDescriptor(referencedKeyConstraintDescriptor, referencedKeyConstraintDescriptor.getUUID(), nArray, transactionController);
        } else {
            tabInfo = this.getNonCoreTI(5);
            SYSKEYSRowFactory sYSKEYSRowFactory = (SYSKEYSRowFactory)tabInfo.getCatalogRowFactory();
            execRow = sYSKEYSRowFactory.makeRow(keyConstraintDescriptor, null);
        }
        tabInfo.insertRow(execRow, transactionController, true);
    }

    private void dropSubKeyConstraint(ConstraintDescriptor constraintDescriptor, TransactionController transactionController) throws StandardException {
        int n;
        int n2;
        ExecIndexRow execIndexRow = null;
        if (constraintDescriptor.getConstraintType() == 6) {
            ReferencedKeyConstraintDescriptor referencedKeyConstraintDescriptor;
            n2 = 10;
            n = 0;
            if (constraintDescriptor.getConstraintType() == 6 && (referencedKeyConstraintDescriptor = (ReferencedKeyConstraintDescriptor)this.getConstraintDescriptor(((ForeignKeyConstraintDescriptor)constraintDescriptor).getReferencedConstraintId())) != null) {
                referencedKeyConstraintDescriptor.decrementReferenceCount();
                int[] nArray = new int[]{7};
                this.updateConstraintDescriptor(referencedKeyConstraintDescriptor, referencedKeyConstraintDescriptor.getUUID(), nArray, transactionController);
            }
        } else {
            n2 = 5;
            n = 0;
        }
        TabInfo tabInfo = this.getNonCoreTI(n2);
        DataValueDescriptor dataValueDescriptor = this.getValueAsDVD(constraintDescriptor.getUUID());
        execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, dataValueDescriptor);
        tabInfo.deleteRow(transactionController, execIndexRow, n);
    }

    private SubCheckConstraintDescriptor getSubCheckConstraint(UUID uUID) throws StandardException {
        DataValueDescriptor dataValueDescriptor = null;
        TabInfo tabInfo = this.getNonCoreTI(9);
        SYSCHECKSRowFactory sYSCHECKSRowFactory = (SYSCHECKSRowFactory)tabInfo.getCatalogRowFactory();
        dataValueDescriptor = this.getValueAsDVD(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, dataValueDescriptor);
        return (SubCheckConstraintDescriptor)this.getDescriptorViaIndex(0, execIndexRow, null, tabInfo, null, null, false);
    }

    private void dropSubCheckConstraint(UUID uUID, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow = null;
        TabInfo tabInfo = this.getNonCoreTI(9);
        DataValueDescriptor dataValueDescriptor = this.getValueAsDVD(uUID);
        execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, dataValueDescriptor);
        tabInfo.deleteRow(transactionController, execIndexRow, 0);
    }

    public Hashtable hashAllConglomerateDescriptorsByNumber(TransactionController transactionController) throws StandardException {
        Hashtable<Long, ConglomerateDescriptor> hashtable = new Hashtable<Long, ConglomerateDescriptor>();
        ConglomerateDescriptor conglomerateDescriptor = null;
        TabInfo tabInfo = this.coreInfo[0];
        SYSCONGLOMERATESRowFactory sYSCONGLOMERATESRowFactory = (SYSCONGLOMERATESRowFactory)tabInfo.getCatalogRowFactory();
        ExecRow execRow = sYSCONGLOMERATESRowFactory.makeEmptyRow();
        ScanController scanController = transactionController.openScan(tabInfo.getHeapConglomerate(), false, 0, 6, 1, null, null, 1, null, null, -1);
        while (scanController.fetchNext(execRow.getRowArray())) {
            conglomerateDescriptor = (ConglomerateDescriptor)sYSCONGLOMERATESRowFactory.buildDescriptor(execRow, null, this);
            Long l = new Long(conglomerateDescriptor.getConglomerateNumber());
            hashtable.put(l, conglomerateDescriptor);
        }
        scanController.close();
        return hashtable;
    }

    public Hashtable hashAllTableDescriptorsByTableId(TransactionController transactionController) throws StandardException {
        Hashtable<UUID, TableDescriptor> hashtable = new Hashtable<UUID, TableDescriptor>();
        TabInfo tabInfo = this.coreInfo[1];
        SYSTABLESRowFactory sYSTABLESRowFactory = (SYSTABLESRowFactory)tabInfo.getCatalogRowFactory();
        ExecRow execRow = sYSTABLESRowFactory.makeEmptyRow();
        ScanController scanController = transactionController.openScan(tabInfo.getHeapConglomerate(), false, 0, 6, 1, null, null, 1, null, null, -1);
        while (scanController.fetchNext(execRow.getRowArray())) {
            TableDescriptor tableDescriptor = (TableDescriptor)sYSTABLESRowFactory.buildDescriptor(execRow, null, this);
            hashtable.put(tableDescriptor.getUUID(), tableDescriptor);
        }
        scanController.close();
        return hashtable;
    }

    public ConglomerateDescriptor getConglomerateDescriptor(UUID uUID) throws StandardException {
        ConglomerateDescriptor[] conglomerateDescriptorArray = this.getConglomerateDescriptors(uUID);
        if (conglomerateDescriptorArray.length == 0) {
            return null;
        }
        return conglomerateDescriptorArray[0];
    }

    public ConglomerateDescriptor[] getConglomerateDescriptors(UUID uUID) throws StandardException {
        TabInfo tabInfo = this.coreInfo[0];
        StringDataValue stringDataValue = this.dvf.getCharDataValue(uUID.toString());
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, stringDataValue);
        List list = DataDictionaryImpl.newSList();
        this.getDescriptorViaIndex(0, execIndexRow, null, tabInfo, null, list, false);
        ConglomerateDescriptor[] conglomerateDescriptorArray = new ConglomerateDescriptor[list.size()];
        list.toArray(conglomerateDescriptorArray);
        return conglomerateDescriptorArray;
    }

    public ConglomerateDescriptor getConglomerateDescriptor(long l) throws StandardException {
        ConglomerateDescriptor[] conglomerateDescriptorArray = this.getConglomerateDescriptors(l);
        if (conglomerateDescriptorArray.length == 0) {
            return null;
        }
        return conglomerateDescriptorArray[0];
    }

    public ConglomerateDescriptor[] getConglomerateDescriptors(long l) throws StandardException {
        NumberDataValue numberDataValue = null;
        TabInfo tabInfo = this.coreInfo[0];
        SYSCONGLOMERATESRowFactory sYSCONGLOMERATESRowFactory = (SYSCONGLOMERATESRowFactory)tabInfo.getCatalogRowFactory();
        numberDataValue = this.dvf.getDataValue(l);
        ScanQualifier[][] scanQualifierArray = this.exFactory.getScanQualifier(1);
        scanQualifierArray[0][0].setQualifier(3 - 1, numberDataValue, 2, false, false, false);
        ConglomerateDescriptorList conglomerateDescriptorList = new ConglomerateDescriptorList();
        this.getDescriptorViaHeap(scanQualifierArray, tabInfo, null, conglomerateDescriptorList);
        int n = conglomerateDescriptorList.size();
        ConglomerateDescriptor[] conglomerateDescriptorArray = new ConglomerateDescriptor[n];
        for (int i = 0; i < n; ++i) {
            conglomerateDescriptorArray[i] = (ConglomerateDescriptor)conglomerateDescriptorList.get(i);
        }
        return conglomerateDescriptorArray;
    }

    private void getConglomerateDescriptorsScan(TableDescriptor tableDescriptor) throws StandardException {
        ConglomerateDescriptorList conglomerateDescriptorList = tableDescriptor.getConglomerateDescriptorList();
        ExecIndexRow execIndexRow = null;
        TabInfo tabInfo = this.coreInfo[0];
        DataValueDescriptor dataValueDescriptor = this.getValueAsDVD(tableDescriptor.getUUID());
        execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, dataValueDescriptor);
        this.getDescriptorViaIndex(2, execIndexRow, null, tabInfo, null, conglomerateDescriptorList, false);
    }

    public ConglomerateDescriptor getConglomerateDescriptor(String string, SchemaDescriptor schemaDescriptor, boolean bl) throws StandardException {
        ExecIndexRow execIndexRow = null;
        DataValueDescriptor dataValueDescriptor = null;
        TabInfo tabInfo = this.coreInfo[0];
        StringDataValue stringDataValue = this.dvf.getVarcharDataValue(string);
        dataValueDescriptor = this.getValueAsDVD(schemaDescriptor.getUUID());
        execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, stringDataValue);
        execIndexRow.setColumn(2, dataValueDescriptor);
        return (ConglomerateDescriptor)this.getDescriptorViaIndex(1, execIndexRow, null, tabInfo, null, null, bl);
    }

    public void dropConglomerateDescriptor(ConglomerateDescriptor conglomerateDescriptor, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow = null;
        DataValueDescriptor dataValueDescriptor = null;
        TabInfo tabInfo = this.coreInfo[0];
        StringDataValue stringDataValue = this.dvf.getVarcharDataValue(conglomerateDescriptor.getConglomerateName());
        dataValueDescriptor = this.getValueAsDVD(conglomerateDescriptor.getSchemaID());
        execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, stringDataValue);
        execIndexRow.setColumn(2, dataValueDescriptor);
        tabInfo.deleteRow(transactionController, execIndexRow, 1);
    }

    public void dropAllConglomerateDescriptors(TableDescriptor tableDescriptor, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow = null;
        TabInfo tabInfo = this.coreInfo[0];
        DataValueDescriptor dataValueDescriptor = this.getValueAsDVD(tableDescriptor.getUUID());
        execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, dataValueDescriptor);
        tabInfo.deleteRow(transactionController, execIndexRow, 2);
    }

    public void updateConglomerateDescriptor(ConglomerateDescriptor conglomerateDescriptor, long l, TransactionController transactionController) throws StandardException {
        ConglomerateDescriptor[] conglomerateDescriptorArray = new ConglomerateDescriptor[]{conglomerateDescriptor};
        this.updateConglomerateDescriptor(conglomerateDescriptorArray, l, transactionController);
    }

    public void updateConglomerateDescriptor(ConglomerateDescriptor[] conglomerateDescriptorArray, long l, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow = null;
        ExecRow[] execRowArray = new ExecRow[conglomerateDescriptorArray.length];
        TabInfo tabInfo = this.coreInfo[0];
        SYSCONGLOMERATESRowFactory sYSCONGLOMERATESRowFactory = (SYSCONGLOMERATESRowFactory)tabInfo.getCatalogRowFactory();
        DataValueDescriptor dataValueDescriptor = this.getValueAsDVD(conglomerateDescriptorArray[0].getUUID());
        execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, dataValueDescriptor);
        for (int i = 0; i < conglomerateDescriptorArray.length; ++i) {
            conglomerateDescriptorArray[i].setConglomerateNumber(l);
            execRowArray[i] = sYSCONGLOMERATESRowFactory.makeRow(conglomerateDescriptorArray[i], null);
        }
        boolean[] blArray = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            blArray[i] = false;
        }
        tabInfo.updateRow(execIndexRow, execRowArray, 0, blArray, (int[])null, transactionController);
    }

    public List getDependentsDescriptorList(String string) throws StandardException {
        List list = DataDictionaryImpl.newSList();
        TabInfo tabInfo = this.getNonCoreTI(6);
        StringDataValue stringDataValue = this.dvf.getCharDataValue(string);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, stringDataValue);
        this.getDescriptorViaIndex(0, execIndexRow, null, tabInfo, null, list, false);
        return list;
    }

    public List getProvidersDescriptorList(String string) throws StandardException {
        List list = DataDictionaryImpl.newSList();
        TabInfo tabInfo = this.getNonCoreTI(6);
        StringDataValue stringDataValue = this.dvf.getCharDataValue(string);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, stringDataValue);
        this.getDescriptorViaIndex(1, execIndexRow, null, tabInfo, null, list, false);
        return list;
    }

    public List getAllDependencyDescriptorsList() throws StandardException {
        List list = DataDictionaryImpl.newSList();
        TabInfo tabInfo = this.getNonCoreTI(6);
        SYSDEPENDSRowFactory sYSDEPENDSRowFactory = (SYSDEPENDSRowFactory)tabInfo.getCatalogRowFactory();
        TransactionController transactionController = this.getTransactionCompile();
        ExecRow execRow = sYSDEPENDSRowFactory.makeEmptyRow();
        ScanController scanController = transactionController.openScan(tabInfo.getHeapConglomerate(), false, 0, 7, 4, null, null, 1, null, null, -1);
        while (scanController.fetchNext(execRow.getRowArray())) {
            DependencyDescriptor dependencyDescriptor = (DependencyDescriptor)sYSDEPENDSRowFactory.buildDescriptor(execRow, null, this);
            list.add(dependencyDescriptor);
        }
        scanController.close();
        return list;
    }

    public void dropStoredDependency(DependencyDescriptor dependencyDescriptor, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow = null;
        UUID uUID = dependencyDescriptor.getUUID();
        UUID uUID2 = dependencyDescriptor.getProviderID();
        DataValueDescriptor dataValueDescriptor = this.getValueAsDVD(uUID);
        TabInfo tabInfo = this.getNonCoreTI(6);
        execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, dataValueDescriptor);
        DropDependencyFilter dropDependencyFilter = new DropDependencyFilter(uUID2);
        tabInfo.deleteRows(transactionController, execIndexRow, 1, null, dropDependencyFilter, execIndexRow, -1, 0);
    }

    public void dropDependentsStoredDependencies(UUID uUID, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow = null;
        TabInfo tabInfo = this.getNonCoreTI(6);
        DataValueDescriptor dataValueDescriptor = this.getValueAsDVD(uUID);
        execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, dataValueDescriptor);
        tabInfo.deleteRow(transactionController, execIndexRow, 0);
    }

    public UUIDFactory getUUIDFactory() {
        return this.uuidFactory;
    }

    public AliasDescriptor getAliasDescriptor(UUID uUID) throws StandardException {
        TabInfo tabInfo = this.getNonCoreTI(7);
        SYSALIASESRowFactory sYSALIASESRowFactory = (SYSALIASESRowFactory)tabInfo.getCatalogRowFactory();
        StringDataValue stringDataValue = this.dvf.getCharDataValue(uUID.toString());
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, stringDataValue);
        return (AliasDescriptor)this.getDescriptorViaIndex(1, execIndexRow, null, tabInfo, null, null, false);
    }

    public AliasDescriptor getAliasDescriptor(String string, String string2, char c) throws StandardException {
        TabInfo tabInfo = this.getNonCoreTI(7);
        SYSALIASESRowFactory sYSALIASESRowFactory = (SYSALIASESRowFactory)tabInfo.getCatalogRowFactory();
        StringDataValue stringDataValue = this.dvf.getVarcharDataValue(string2);
        char[] cArray = new char[]{c};
        StringDataValue stringDataValue2 = this.dvf.getCharDataValue(new String(cArray));
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(3);
        execIndexRow.setColumn(1, this.dvf.getCharDataValue(string));
        execIndexRow.setColumn(2, stringDataValue);
        execIndexRow.setColumn(3, stringDataValue2);
        return (AliasDescriptor)this.getDescriptorViaIndex(0, execIndexRow, null, tabInfo, null, null, false);
    }

    public List getRoutineList(String string, String string2, char c) throws StandardException {
        ArrayList<AliasDescriptor> arrayList = new ArrayList<AliasDescriptor>();
        AliasDescriptor aliasDescriptor = this.getAliasDescriptor(string, string2, c);
        if (aliasDescriptor != null) {
            arrayList.add(aliasDescriptor);
        }
        return arrayList;
    }

    public void dropAliasDescriptor(AliasDescriptor aliasDescriptor, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow = null;
        TabInfo tabInfo = this.getNonCoreTI(7);
        StringDataValue stringDataValue = this.dvf.getVarcharDataValue(aliasDescriptor.getDescriptorName());
        char[] cArray = new char[]{aliasDescriptor.getNameSpace()};
        StringDataValue stringDataValue2 = this.dvf.getCharDataValue(new String(cArray));
        execIndexRow = this.exFactory.getIndexableRow(3);
        execIndexRow.setColumn(1, this.dvf.getCharDataValue(aliasDescriptor.getSchemaUUID().toString()));
        execIndexRow.setColumn(2, stringDataValue);
        execIndexRow.setColumn(3, stringDataValue2);
        tabInfo.deleteRow(transactionController, execIndexRow, 0);
    }

    protected void loadDictionaryTables(TransactionController transactionController, DataDescriptorGenerator dataDescriptorGenerator, Properties properties) throws StandardException {
        this.loadCatalogs(dataDescriptorGenerator, this.coreInfo);
        this.dictionaryVersion = (DD_Version)transactionController.getProperty("DataDictionaryVersion");
        this.softwareVersion.upgradeIfNeeded(this.dictionaryVersion, transactionController, properties);
    }

    public void loadCatalogs(DataDescriptorGenerator dataDescriptorGenerator, TabInfo[] tabInfoArray) throws StandardException {
        int n = tabInfoArray.length;
        for (int i = 0; i < n; ++i) {
            TabInfo tabInfo = tabInfoArray[i];
            int n2 = tabInfo.getNumberOfIndexes();
            if (n2 <= 0) continue;
            for (int j = 0; j < n2; ++j) {
                this.initSystemIndexVariables(dataDescriptorGenerator, tabInfo, j);
            }
        }
    }

    protected void createDictionaryTables(Properties properties, TransactionController transactionController, DataDescriptorGenerator dataDescriptorGenerator) throws StandardException {
        TabInfo tabInfo;
        int n;
        this.systemSchemaDesc = this.newSystemSchemaDesc(this.convertIdToLower ? StringUtil.SQLToLowerCase("SYS") : "SYS", "8000000d-00d0-fd77-3ed8-000a0a0b1900");
        for (n = 0; n < 4; ++n) {
            tabInfo = this.coreInfo[n];
            Properties properties2 = tabInfo.getCreateHeapProperties();
            tabInfo.setHeapConglomerate(this.createConglomerate(tabInfo.getTableName(), transactionController, tabInfo.getCatalogRowFactory().makeEmptyRow(), properties2));
            if (this.coreInfo[n].getNumberOfIndexes() <= 0) continue;
            this.bootStrapSystemIndexes(this.systemSchemaDesc, transactionController, dataDescriptorGenerator, tabInfo);
        }
        for (n = 0; n < 4; ++n) {
            tabInfo = this.coreInfo[n];
            this.addSystemTableToDictionary(tabInfo, this.systemSchemaDesc, transactionController, dataDescriptorGenerator);
        }
        properties.put(CFG_SYSTABLES_ID, Long.toString(this.coreInfo[1].getHeapConglomerate()));
        SYSTABLESRowFactory cfr_ignored_0 = (SYSTABLESRowFactory)this.coreInfo[1].getCatalogRowFactory();
        properties.put(CFG_SYSTABLES_INDEX1_ID, Long.toString(this.coreInfo[1].getIndexConglomerate(0)));
        SYSTABLESRowFactory cfr_ignored_1 = (SYSTABLESRowFactory)this.coreInfo[1].getCatalogRowFactory();
        properties.put(CFG_SYSTABLES_INDEX2_ID, Long.toString(this.coreInfo[1].getIndexConglomerate(1)));
        properties.put(CFG_SYSCOLUMNS_ID, Long.toString(this.coreInfo[2].getHeapConglomerate()));
        SYSCOLUMNSRowFactory cfr_ignored_2 = (SYSCOLUMNSRowFactory)this.coreInfo[2].getCatalogRowFactory();
        properties.put(CFG_SYSCOLUMNS_INDEX1_ID, Long.toString(this.coreInfo[2].getIndexConglomerate(0)));
        SYSCOLUMNSRowFactory cfr_ignored_3 = (SYSCOLUMNSRowFactory)this.coreInfo[2].getCatalogRowFactory();
        properties.put(CFG_SYSCOLUMNS_INDEX2_ID, Long.toString(this.coreInfo[2].getIndexConglomerate(1)));
        properties.put(CFG_SYSCONGLOMERATES_ID, Long.toString(this.coreInfo[0].getHeapConglomerate()));
        SYSCONGLOMERATESRowFactory cfr_ignored_4 = (SYSCONGLOMERATESRowFactory)this.coreInfo[0].getCatalogRowFactory();
        properties.put(CFG_SYSCONGLOMERATES_INDEX1_ID, Long.toString(this.coreInfo[0].getIndexConglomerate(0)));
        SYSCONGLOMERATESRowFactory cfr_ignored_5 = (SYSCONGLOMERATESRowFactory)this.coreInfo[0].getCatalogRowFactory();
        properties.put(CFG_SYSCONGLOMERATES_INDEX2_ID, Long.toString(this.coreInfo[0].getIndexConglomerate(1)));
        SYSCONGLOMERATESRowFactory cfr_ignored_6 = (SYSCONGLOMERATESRowFactory)this.coreInfo[0].getCatalogRowFactory();
        properties.put(CFG_SYSCONGLOMERATES_INDEX3_ID, Long.toString(this.coreInfo[0].getIndexConglomerate(2)));
        properties.put(CFG_SYSSCHEMAS_ID, Long.toString(this.coreInfo[3].getHeapConglomerate()));
        SYSSCHEMASRowFactory cfr_ignored_7 = (SYSSCHEMASRowFactory)this.coreInfo[3].getCatalogRowFactory();
        properties.put(CFG_SYSSCHEMAS_INDEX1_ID, Long.toString(this.coreInfo[3].getIndexConglomerate(0)));
        SYSSCHEMASRowFactory cfr_ignored_8 = (SYSSCHEMASRowFactory)this.coreInfo[3].getCatalogRowFactory();
        properties.put(CFG_SYSSCHEMAS_INDEX2_ID, Long.toString(this.coreInfo[3].getIndexConglomerate(1)));
        this.sysIBMSchemaDesc = this.addSystemSchema("SYSIBM", "c013800d-00f8-5b53-28a9-00000019ed88", transactionController);
        for (n = 0; n < 12; ++n) {
            int n2 = n + 4;
            boolean bl = n2 == 15;
            TabInfo tabInfo2 = this.getNonCoreTIByNumber(n2);
            this.makeCatalog(tabInfo2, bl ? this.sysIBMSchemaDesc : this.systemSchemaDesc, transactionController);
            if (bl) {
                this.populateSYSDUMMY1(transactionController);
            }
            this.clearNoncoreTable(n);
        }
        this.addDescriptor(this.systemSchemaDesc, null, 3, false, transactionController);
        this.addSystemSchema("SYSCAT", "c013800d-00fb-2641-07ec-000000134f30", transactionController);
        this.addSystemSchema("SYSFUN", "c013800d-00fb-2642-07ec-000000134f30", transactionController);
        this.addSystemSchema("SYSPROC", "c013800d-00fb-2643-07ec-000000134f30", transactionController);
        this.addSystemSchema("SYSSTAT", "c013800d-00fb-2644-07ec-000000134f30", transactionController);
        this.addSystemSchema("NULLID", "c013800d-00fb-2647-07ec-000000134f30", transactionController);
        this.addSystemSchema("SQLJ", "c013800d-00fb-2648-07ec-000000134f30", transactionController);
        this.addSystemSchema("SYSCS_DIAG", "c013800d-00fb-2646-07ec-000000134f30", transactionController);
        this.addSystemSchema("SYSCS_UTIL", "c013800d-00fb-2649-07ec-000000134f30", transactionController);
        SchemaDescriptor schemaDescriptor = new SchemaDescriptor(this, "APP", "APP", this.uuidFactory.recreateUUID("80000000-00d2-b38f-4cda-000a0a412c00"), false);
        this.addDescriptor(schemaDescriptor, null, 3, false, transactionController);
    }

    private SchemaDescriptor addSystemSchema(String string, String string2, TransactionController transactionController) throws StandardException {
        SchemaDescriptor schemaDescriptor = new SchemaDescriptor(this, this.convertIdToLower ? string.toLowerCase() : string, "DBA", this.uuidFactory.recreateUUID(string2), true);
        this.addDescriptor(schemaDescriptor, null, 3, false, transactionController);
        return schemaDescriptor;
    }

    protected void upgradeMakeCatalog(TransactionController transactionController, int n) throws StandardException {
        TabInfo tabInfo = n >= 4 ? this.getNonCoreTIByNumber(n) : this.coreInfo[n];
        this.makeCatalog(tabInfo, n == 15 ? this.getSysIBMSchemaDescriptor() : this.getSystemSchemaDescriptor(), transactionController);
    }

    public void makeCatalog(TabInfo tabInfo, SchemaDescriptor schemaDescriptor, TransactionController transactionController) throws StandardException {
        DataDescriptorGenerator dataDescriptorGenerator = this.getDataDescriptorGenerator();
        Properties properties = tabInfo.getCreateHeapProperties();
        tabInfo.setHeapConglomerate(this.createConglomerate(tabInfo.getTableName(), transactionController, tabInfo.getCatalogRowFactory().makeEmptyRow(), properties));
        if (tabInfo.getNumberOfIndexes() > 0) {
            this.bootStrapSystemIndexes(schemaDescriptor, transactionController, dataDescriptorGenerator, tabInfo);
        }
        this.addSystemTableToDictionary(tabInfo, schemaDescriptor, transactionController, dataDescriptorGenerator);
    }

    public void upgrade_setNullability(CatalogRowFactory catalogRowFactory, int n, boolean bl, TransactionController transactionController) throws StandardException {
        SystemColumn[] systemColumnArray = catalogRowFactory.buildColumnList();
        SchemaDescriptor schemaDescriptor = this.getSystemSchemaDescriptor();
        TableDescriptor tableDescriptor = this.getTableDescriptor(catalogRowFactory.getCatalogName(), schemaDescriptor);
        SystemColumn systemColumn = systemColumnArray[n - 1];
        ColumnDescriptor columnDescriptor = this.makeColumnDescriptor(systemColumn, tableDescriptor);
        String string = columnDescriptor.getColumnName();
        columnDescriptor.getType().setNullability(bl);
        int[] nArray = new int[]{4};
        this.updateColumnDescriptor(columnDescriptor, tableDescriptor.getUUID(), string, nArray, transactionController, true);
    }

    public void upgrade_addColumns(CatalogRowFactory catalogRowFactory, int[] nArray, TransactionController transactionController) throws StandardException {
        long l;
        TableDescriptor tableDescriptor;
        SystemColumn[] systemColumnArray = catalogRowFactory.buildColumnList();
        ExecRow execRow = catalogRowFactory.makeEmptyRow();
        int n = nArray.length;
        SchemaDescriptor schemaDescriptor = this.getSystemSchemaDescriptor();
        if (catalogRowFactory instanceof SYSTABLESRowFactory) {
            tableDescriptor = this.dataDescriptorGenerator.newTableDescriptor("SYSTABLES", schemaDescriptor, 0, 'R');
            tableDescriptor.setUUID(this.getUUIDForCoreTable("SYSTABLES", schemaDescriptor.getUUID().toString(), transactionController));
            l = this.coreInfo[1].getHeapConglomerate();
        } else if (catalogRowFactory instanceof SYSCOLUMNSRowFactory) {
            tableDescriptor = this.dataDescriptorGenerator.newTableDescriptor("SYSCOLUMNS", schemaDescriptor, 0, 'R');
            tableDescriptor.setUUID(this.getUUIDForCoreTable("SYSCOLUMNS", schemaDescriptor.getUUID().toString(), transactionController));
            l = this.coreInfo[2].getHeapConglomerate();
        } else {
            tableDescriptor = this.getTableDescriptor(catalogRowFactory.getCatalogName(), schemaDescriptor);
            l = tableDescriptor.getHeapConglomerateId();
        }
        this.widenConglomerate(execRow, nArray, l, transactionController);
        TupleDescriptor[] tupleDescriptorArray = new ColumnDescriptor[n];
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            SystemColumn systemColumn = systemColumnArray[n2 - 1];
            tupleDescriptorArray[i] = this.makeColumnDescriptor(systemColumn, tableDescriptor);
        }
        this.addDescriptorArray(tupleDescriptorArray, tableDescriptor, 2, false, transactionController);
    }

    public void upgrade_addInvisibleColumns(CatalogRowFactory catalogRowFactory, int[] nArray, TransactionController transactionController) throws StandardException {
        ExecRow execRow = catalogRowFactory.makeEmptyRow();
        SchemaDescriptor schemaDescriptor = this.getSystemSchemaDescriptor();
        long l = this.getTableDescriptor(catalogRowFactory.getCatalogName(), schemaDescriptor).getHeapConglomerateId();
        this.widenConglomerate(execRow, nArray, l, transactionController);
    }

    private void widenConglomerate(ExecRow execRow, int[] nArray, long l, TransactionController transactionController) throws StandardException {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            int n3 = n2 - 1;
            transactionController.addColumnToConglomerate(l, n3, execRow.getColumn(n2));
        }
    }

    public long upgrade_makeOneIndex(TransactionController transactionController, TabInfo tabInfo, int n, long l) throws StandardException {
        SchemaDescriptor schemaDescriptor = this.getSystemSchemaDescriptor();
        DataDescriptorGenerator dataDescriptorGenerator = this.getDataDescriptorGenerator();
        ConglomerateDescriptor conglomerateDescriptor = this.bootstrapOneIndex(schemaDescriptor, transactionController, dataDescriptorGenerator, tabInfo, n, l);
        long l2 = conglomerateDescriptor.getConglomerateNumber();
        this.addDescriptor(conglomerateDescriptor, schemaDescriptor, 0, false, transactionController);
        return l2;
    }

    private UUID getUUIDForCoreTable(String string, String string2, TransactionController transactionController) throws StandardException {
        TabInfo tabInfo = this.coreInfo[1];
        CatalogRowFactory catalogRowFactory = tabInfo.getCatalogRowFactory();
        ExecRow execRow = this.exFactory.getValueRow(1);
        StringDataValue stringDataValue = this.dvf.getVarcharDataValue(string);
        StringDataValue stringDataValue2 = this.dvf.getCharDataValue(string2);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, stringDataValue);
        execIndexRow.setColumn(2, stringDataValue2);
        ConglomerateController conglomerateController = transactionController.openConglomerate(tabInfo.getHeapConglomerate(), false, 0, 6, 4);
        ExecIndexRow execIndexRow2 = catalogRowFactory.buildEmptyIndexRow(0, conglomerateController.newRowLocationTemplate());
        ScanController scanController = transactionController.openScan(tabInfo.getIndexConglomerate(0), false, 0, 6, 4, null, execIndexRow.getRowArray(), 1, null, execIndexRow.getRowArray(), -1);
        if (scanController.fetchNext(execIndexRow2.getRowArray())) {
            RowLocation rowLocation = (RowLocation)execIndexRow2.getColumn(execIndexRow2.nColumns());
            execRow.setColumn(1, this.dvf.getCharDataValue(null));
            FormatableBitSet formatableBitSet = new FormatableBitSet(1);
            formatableBitSet.set(0);
            boolean bl = conglomerateController.fetch(rowLocation, execRow.getRowArray(), null);
        }
        scanController.close();
        conglomerateController.close();
        return this.uuidFactory.recreateUUID(execRow.getColumn(1).toString());
    }

    void upgrade_initSystemTableCols(TransactionController transactionController, boolean bl, int n, FormatableBitSet formatableBitSet, DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        TabInfo tabInfo;
        TabInfo tabInfo2 = tabInfo = bl ? this.coreInfo[n] : this.getNonCoreTIByNumber(n);
        if (!bl) {
            this.faultInTabInfo(tabInfo);
        }
        ScanController scanController = transactionController.openScan(tabInfo.getHeapConglomerate(), false, 4, 7, 4, RowUtil.EMPTY_ROW_BITSET, null, 0, null, null, 0);
        while (scanController.next()) {
            scanController.replace(dataValueDescriptorArray, formatableBitSet);
        }
        scanController.close();
    }

    private void bootStrapSystemIndexes(SchemaDescriptor schemaDescriptor, TransactionController transactionController, DataDescriptorGenerator dataDescriptorGenerator, TabInfo tabInfo) throws StandardException {
        int n;
        ConglomerateDescriptor[] conglomerateDescriptorArray = new ConglomerateDescriptor[tabInfo.getNumberOfIndexes()];
        for (n = 0; n < tabInfo.getNumberOfIndexes(); ++n) {
            conglomerateDescriptorArray[n] = this.bootstrapOneIndex(schemaDescriptor, transactionController, dataDescriptorGenerator, tabInfo, n, tabInfo.getHeapConglomerate());
        }
        for (n = 0; n < tabInfo.getNumberOfIndexes(); ++n) {
            this.addDescriptor(conglomerateDescriptorArray[n], schemaDescriptor, 0, false, transactionController);
        }
    }

    public RowLocation[] computeAutoincRowLocations(TransactionController transactionController, TableDescriptor tableDescriptor) throws StandardException {
        if (!tableDescriptor.tableHasAutoincrement()) {
            return null;
        }
        int n = tableDescriptor.getNumberOfColumns();
        RowLocation[] rowLocationArray = new RowLocation[n];
        for (int i = 0; i < n; ++i) {
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(i + 1);
            if (!columnDescriptor.isAutoincrement()) continue;
            rowLocationArray[i] = this.computeRowLocation(transactionController, tableDescriptor, columnDescriptor.getColumnName());
        }
        return rowLocationArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NumberDataValue getSetAutoincrementValue(RowLocation rowLocation, TransactionController transactionController, boolean bl, NumberDataValue numberDataValue, boolean bl2) throws StandardException {
        FormatableBitSet formatableBitSet = new FormatableBitSet(9);
        int n = 7;
        TabInfo tabInfo = this.coreInfo[2];
        ConglomerateController conglomerateController = null;
        SYSCOLUMNSRowFactory sYSCOLUMNSRowFactory = (SYSCOLUMNSRowFactory)tabInfo.getCatalogRowFactory();
        ExecRow execRow = sYSCOLUMNSRowFactory.makeEmptyRow();
        FormatableBitSet formatableBitSet2 = new FormatableBitSet(9);
        formatableBitSet2.set(n - 1);
        formatableBitSet2.set(n);
        formatableBitSet2.set(n + 1);
        try {
            conglomerateController = transactionController.openConglomerate(tabInfo.getHeapConglomerate(), false, 4 | (bl2 ? 0 : 128), 6, 4);
            boolean bl3 = conglomerateController.fetch(rowLocation, execRow.getRowArray(), formatableBitSet2, bl2);
            formatableBitSet.set(n - 1);
            NumberDataValue numberDataValue2 = (NumberDataValue)execRow.getColumn(n);
            long l = numberDataValue2.getLong();
            NumberDataValue numberDataValue3 = (NumberDataValue)execRow.getColumn(n + 2);
            if (bl) {
                numberDataValue2 = numberDataValue2.plus(numberDataValue2, numberDataValue3, numberDataValue2);
                execRow.setColumn(n, numberDataValue2);
                conglomerateController.replace(rowLocation, execRow.getRowArray(), formatableBitSet);
            }
            if (numberDataValue != null) {
                numberDataValue.setValue(l);
                NumberDataValue numberDataValue4 = numberDataValue;
                return numberDataValue4;
            }
            numberDataValue2.setValue(l);
            NumberDataValue numberDataValue5 = numberDataValue2;
            return numberDataValue5;
        }
        finally {
            if (conglomerateController != null) {
                conglomerateController.close();
            }
        }
    }

    private ConglomerateDescriptor bootstrapOneIndex(SchemaDescriptor schemaDescriptor, TransactionController transactionController, DataDescriptorGenerator dataDescriptorGenerator, TabInfo tabInfo, int n, long l) throws StandardException {
        CatalogRowFactory catalogRowFactory = tabInfo.getCatalogRowFactory();
        this.initSystemIndexVariables(dataDescriptorGenerator, tabInfo, n);
        IndexRowGenerator indexRowGenerator = tabInfo.getIndexRowGenerator(n);
        int n2 = tabInfo.getIndexColumnCount(n);
        boolean bl = tabInfo.isIndexUnique(n);
        ExecIndexRow execIndexRow = indexRowGenerator.getIndexRowTemplate();
        ExecRow execRow = catalogRowFactory.makeEmptyRow();
        ConglomerateController conglomerateController = transactionController.openConglomerate(l, false, 0, 6, 4);
        RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
        conglomerateController.close();
        indexRowGenerator.getIndexRow(execRow, rowLocation, execIndexRow, null);
        Properties properties = tabInfo.getCreateIndexProperties(n);
        properties.put("baseConglomerateId", Long.toString(l));
        properties.put("nUniqueColumns", Integer.toString(bl ? n2 : n2 + 1));
        properties.put("rowLocationColumn", Integer.toString(n2));
        properties.put("nKeyFields", Integer.toString(n2 + 1));
        long l2 = transactionController.createConglomerate("BTREE", execIndexRow.getRowArray(), null, properties, 0);
        ConglomerateDescriptor conglomerateDescriptor = dataDescriptorGenerator.newConglomerateDescriptor(l2, catalogRowFactory.getIndexName(n), true, indexRowGenerator, false, catalogRowFactory.getCanonicalIndexUUID(n), catalogRowFactory.getCanonicalTableUUID(), schemaDescriptor.getUUID());
        tabInfo.setIndexConglomerate(conglomerateDescriptor);
        return conglomerateDescriptor;
    }

    public void initSystemIndexVariables(DataDescriptorGenerator dataDescriptorGenerator, TabInfo tabInfo, int n) throws StandardException {
        int n2 = tabInfo.getIndexColumnCount(n);
        int[] nArray = new int[n2];
        CatalogRowFactory catalogRowFactory = tabInfo.getCatalogRowFactory();
        for (int i = 0; i < n2; ++i) {
            nArray[i] = tabInfo.getBaseColumnPosition(n, i);
        }
        boolean[] blArray = new boolean[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            blArray[i] = true;
        }
        tabInfo.setIndexRowGenerator(n, new IndexRowGenerator("BTREE", tabInfo.isIndexUnique(n), nArray, blArray, nArray.length));
    }

    protected void populateSYSDUMMY1(TransactionController transactionController) throws StandardException {
        TabInfo tabInfo = this.getNonCoreTI(15);
        SYSDUMMY1RowFactory sYSDUMMY1RowFactory = (SYSDUMMY1RowFactory)tabInfo.getCatalogRowFactory();
        ExecRow execRow = tabInfo.getCatalogRowFactory().makeRow(null, null);
        int n = tabInfo.insertRow(execRow, transactionController, true);
    }

    public void clearCaches() throws StandardException {
        this.nameTdCache.cleanAll();
        this.nameTdCache.ageOut();
        this.OIDTdCache.cleanAll();
        this.OIDTdCache.ageOut();
        if (this.spsNameCache != null) {
            this.spsNameCache.cleanAll();
            this.spsNameCache.ageOut();
            this.spsIdHash.clear();
        }
    }

    private void addSystemTableToDictionary(TabInfo tabInfo, SchemaDescriptor schemaDescriptor, TransactionController transactionController, DataDescriptorGenerator dataDescriptorGenerator) throws StandardException {
        CatalogRowFactory catalogRowFactory = tabInfo.getCatalogRowFactory();
        String string = tabInfo.getTableName();
        long l = tabInfo.getHeapConglomerate();
        SystemColumn[] systemColumnArray = catalogRowFactory.buildColumnList();
        UUID uUID = catalogRowFactory.getCanonicalHeapUUID();
        String string2 = catalogRowFactory.getCanonicalHeapName();
        int n = systemColumnArray.length;
        TableDescriptor tableDescriptor = dataDescriptorGenerator.newTableDescriptor(string, schemaDescriptor, 1, 'R');
        tableDescriptor.setUUID(catalogRowFactory.getCanonicalTableUUID());
        this.addDescriptor(tableDescriptor, schemaDescriptor, 1, false, transactionController);
        UUID uUID2 = tableDescriptor.getUUID();
        ConglomerateDescriptor conglomerateDescriptor = dataDescriptorGenerator.newConglomerateDescriptor(l, string2, false, null, false, uUID, uUID2, schemaDescriptor.getUUID());
        this.addDescriptor(conglomerateDescriptor, schemaDescriptor, 0, false, transactionController);
        TupleDescriptor[] tupleDescriptorArray = new ColumnDescriptor[n];
        for (int i = 0; i < n; ++i) {
            SystemColumn systemColumn = systemColumnArray[i];
            tupleDescriptorArray[i] = this.makeColumnDescriptor(systemColumn, tableDescriptor);
        }
        this.addDescriptorArray(tupleDescriptorArray, tableDescriptor, 2, false, transactionController);
        ColumnDescriptorList columnDescriptorList = tableDescriptor.getColumnDescriptorList();
        for (int i = 0; i < n; ++i) {
            columnDescriptorList.add(tupleDescriptorArray[i]);
        }
    }

    private ColumnDescriptor makeColumnDescriptor(SystemColumn systemColumn, TableDescriptor tableDescriptor) throws StandardException {
        TypeId typeId = systemColumn.builtInType() ? TypeId.getBuiltInTypeId(systemColumn.getDataType()) : TypeId.getUserDefinedTypeId(systemColumn.getDataType(), false);
        DataTypeDescriptor dataTypeDescriptor = new DataTypeDescriptor(typeId, systemColumn.getPrecision(), systemColumn.getScale(), systemColumn.getNullability(), systemColumn.getMaxLength());
        return new ColumnDescriptor(systemColumn.getName(), systemColumn.getID(), dataTypeDescriptor, null, null, tableDescriptor, (UUID)null, 0L, 0L, false);
    }

    private long createConglomerate(String string, TransactionController transactionController, ExecRow execRow, Properties properties) throws StandardException {
        long l = transactionController.createConglomerate("heap", execRow.getRowArray(), null, properties, 0);
        return l;
    }

    public DataValueDescriptor getValueAsDVD(UUID uUID) throws StandardException {
        String string = uUID.toString();
        return this.dvf.getCharDataValue(string);
    }

    public void initializeCatalogInfo() throws StandardException {
        this.initializeCoreInfo();
        this.initializeNoncoreInfo();
    }

    private void initializeCoreInfo() throws StandardException {
        this.coreInfo = new TabInfo[4];
        TabInfo[] tabInfoArray = this.coreInfo;
        UUIDFactory uUIDFactory = this.uuidFactory;
        tabInfoArray[1] = new TabInfoImpl(new SYSTABLESRowFactory(uUIDFactory, this.exFactory, this.dvf, this.convertIdToLower));
        tabInfoArray[2] = new TabInfoImpl(new SYSCOLUMNSRowFactory(uUIDFactory, this.exFactory, this.dvf, this.convertIdToLower));
        tabInfoArray[0] = new TabInfoImpl(new SYSCONGLOMERATESRowFactory(uUIDFactory, this.exFactory, this.dvf, this.convertIdToLower));
        tabInfoArray[3] = new TabInfoImpl(new SYSSCHEMASRowFactory(uUIDFactory, this.exFactory, this.dvf, this.convertIdToLower));
    }

    private void initializeNoncoreInfo() throws StandardException {
        this.noncoreInfo = new TabInfo[12];
    }

    public TabInfo getTabInfo(String string) throws StandardException {
        int n;
        for (n = 0; n < this.coreInfo.length; ++n) {
            TabInfo tabInfo = this.coreInfo[n];
            if (!tabInfo.getTableName().equals(string)) continue;
            return tabInfo;
        }
        for (n = 0; n < nonCoreNames.length; ++n) {
            if (!nonCoreNames[n].equals(string)) continue;
            return this.getNonCoreTI(n);
        }
        return null;
    }

    public TransactionController getTransactionCompile() throws StandardException {
        if (this.bootingTC != null) {
            return this.bootingTC;
        }
        LanguageConnectionContext languageConnectionContext = DataDictionaryImpl.getLCC();
        return languageConnectionContext.getTransactionCompile();
    }

    public TransactionController getTransactionExecute() throws StandardException {
        if (this.bootingTC != null) {
            return this.bootingTC;
        }
        LanguageConnectionContext languageConnectionContext = DataDictionaryImpl.getLCC();
        return languageConnectionContext.getTransactionExecute();
    }

    private final TupleDescriptor getDescriptorViaIndex(int n, ExecIndexRow execIndexRow, ScanQualifier[][] scanQualifierArray, TabInfo tabInfo, TupleDescriptor tupleDescriptor, List list, boolean bl) throws StandardException {
        CatalogRowFactory catalogRowFactory = tabInfo.getCatalogRowFactory();
        TupleDescriptor tupleDescriptor2 = null;
        TransactionController transactionController = this.getTransactionCompile();
        ExecRow execRow = catalogRowFactory.makeEmptyRow();
        ConglomerateController conglomerateController = transactionController.openConglomerate(tabInfo.getHeapConglomerate(), false, 0, 6, 4);
        ScanController scanController = transactionController.openScan(tabInfo.getIndexConglomerate(n), false, bl ? 4 : 0, 6, 4, null, execIndexRow.getRowArray(), 1, scanQualifierArray, execIndexRow.getRowArray(), -1);
        while (scanController.next()) {
            ExecIndexRow execIndexRow2 = DataDictionaryImpl.getIndexRowFromHeapRow(tabInfo.getIndexRowGenerator(n), conglomerateController.newRowLocationTemplate(), execRow);
            scanController.fetch(execIndexRow2.getRowArray());
            RowLocation rowLocation = (RowLocation)execIndexRow2.getColumn(execIndexRow2.nColumns());
            boolean bl2 = false;
            try {
                bl2 = conglomerateController.fetch(rowLocation, execRow.getRowArray(), null);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (StandardException standardException) {
                throw standardException;
            }
            tupleDescriptor2 = catalogRowFactory.buildDescriptor(execRow, tupleDescriptor, this);
            if (list == null) break;
            list.add(tupleDescriptor2);
        }
        scanController.close();
        conglomerateController.close();
        return tupleDescriptor2;
    }

    private void debugGenerateInfo(StringBuffer stringBuffer, TransactionController transactionController, ConglomerateController conglomerateController, TabInfo tabInfo, int n) {
    }

    protected TupleDescriptor getDescriptorViaHeap(ScanQualifier[][] scanQualifierArray, TabInfo tabInfo, TupleDescriptor tupleDescriptor, List list) throws StandardException {
        CatalogRowFactory catalogRowFactory = tabInfo.getCatalogRowFactory();
        TupleDescriptor tupleDescriptor2 = null;
        TransactionController transactionController = this.getTransactionCompile();
        ExecRow execRow = catalogRowFactory.makeEmptyRow();
        ScanController scanController = transactionController.openScan(tabInfo.getHeapConglomerate(), false, 0, 7, 4, null, null, 0, scanQualifierArray, null, 0);
        while (scanController.fetchNext(execRow.getRowArray())) {
            tupleDescriptor2 = catalogRowFactory.buildDescriptor(execRow, tupleDescriptor, this);
            if (list == null) break;
            list.add(tupleDescriptor2);
        }
        scanController.close();
        return tupleDescriptor2;
    }

    private TabInfo getNonCoreTI(int n) throws StandardException {
        TabInfo tabInfo = this.getNonCoreTIByNumber(n);
        this.faultInTabInfo(tabInfo);
        return tabInfo;
    }

    protected TabInfo getNonCoreTIByNumber(int n) throws StandardException {
        int n2 = n - 4;
        TabInfo tabInfo = this.noncoreInfo[n2];
        if (tabInfo == null) {
            UUIDFactory uUIDFactory = this.uuidFactory;
            switch (n) {
                case 4: {
                    tabInfo = new TabInfoImpl(new SYSCONSTRAINTSRowFactory(uUIDFactory, this.exFactory, this.dvf, this.convertIdToLower));
                    break;
                }
                case 5: {
                    tabInfo = new TabInfoImpl(new SYSKEYSRowFactory(uUIDFactory, this.exFactory, this.dvf, this.convertIdToLower));
                    break;
                }
                case 6: {
                    tabInfo = new TabInfoImpl(new SYSDEPENDSRowFactory(uUIDFactory, this.exFactory, this.dvf, this.convertIdToLower));
                    break;
                }
                case 8: {
                    tabInfo = new TabInfoImpl(new SYSVIEWSRowFactory(uUIDFactory, this.exFactory, this.dvf, this.convertIdToLower));
                    break;
                }
                case 9: {
                    tabInfo = new TabInfoImpl(new SYSCHECKSRowFactory(uUIDFactory, this.exFactory, this.dvf, this.convertIdToLower));
                    break;
                }
                case 10: {
                    tabInfo = new TabInfoImpl(new SYSFOREIGNKEYSRowFactory(uUIDFactory, this.exFactory, this.dvf, this.convertIdToLower));
                    break;
                }
                case 11: {
                    tabInfo = new TabInfoImpl(new SYSSTATEMENTSRowFactory(uUIDFactory, this.exFactory, this.dvf, this.convertIdToLower));
                    break;
                }
                case 12: {
                    tabInfo = new TabInfoImpl(new SYSFILESRowFactory(uUIDFactory, this.exFactory, this.dvf, this.convertIdToLower));
                    break;
                }
                case 7: {
                    tabInfo = new TabInfoImpl(new SYSALIASESRowFactory(uUIDFactory, this.exFactory, this.dvf, this.convertIdToLower));
                    break;
                }
                case 13: {
                    tabInfo = new TabInfoImpl(new SYSTRIGGERSRowFactory(uUIDFactory, this.exFactory, this.dvf, this.convertIdToLower));
                    break;
                }
                case 14: {
                    tabInfo = new TabInfoImpl(new SYSSTATISTICSRowFactory(uUIDFactory, this.exFactory, this.dvf, this.convertIdToLower));
                    break;
                }
                case 15: {
                    tabInfo = new TabInfoImpl(new SYSDUMMY1RowFactory(uUIDFactory, this.exFactory, this.dvf, this.convertIdToLower));
                }
            }
            this.initSystemIndexVariables(tabInfo);
            this.noncoreInfo[n2] = tabInfo;
        }
        return tabInfo;
    }

    protected void initSystemIndexVariables(TabInfo tabInfo) throws StandardException {
        int n = tabInfo.getNumberOfIndexes();
        if (n > 0) {
            DataDescriptorGenerator dataDescriptorGenerator = this.getDataDescriptorGenerator();
            for (int i = 0; i < n; ++i) {
                this.initSystemIndexVariables(dataDescriptorGenerator, tabInfo, i);
            }
        }
    }

    private void clearNoncoreTable(int n) {
        this.noncoreInfo[n] = null;
    }

    public TabInfo getCoreCatalog(int n) throws StandardException {
        return this.coreInfo[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void faultInTabInfo(TabInfo tabInfo) throws StandardException {
        if (tabInfo.isComplete()) {
            return;
        }
        TabInfo tabInfo2 = tabInfo;
        synchronized (tabInfo2) {
            int n;
            if (tabInfo.isComplete()) {
                return;
            }
            TableDescriptor tableDescriptor = this.getTableDescriptor(tabInfo.getTableName(), this.getSystemSchemaDescriptor());
            if (tableDescriptor == null) {
                return;
            }
            ConglomerateDescriptor conglomerateDescriptor = null;
            ConglomerateDescriptor[] conglomerateDescriptorArray = tableDescriptor.getConglomerateDescriptors();
            for (int i = 0; i < conglomerateDescriptorArray.length; ++i) {
                conglomerateDescriptor = conglomerateDescriptorArray[i];
                if (conglomerateDescriptor.isIndex()) continue;
                tabInfo.setHeapConglomerate(conglomerateDescriptor.getConglomerateNumber());
                break;
            }
            if ((n = tabInfo.getCatalogRowFactory().getNumIndexes()) == 0) {
                return;
            }
            ConglomerateDescriptor conglomerateDescriptor2 = null;
            int n2 = 0;
            for (int i = 0; i < conglomerateDescriptorArray.length; ++i) {
                conglomerateDescriptor2 = conglomerateDescriptorArray[i];
                if (!conglomerateDescriptor2.isIndex()) continue;
                tabInfo.setIndexConglomerate(conglomerateDescriptor2);
                ++n2;
            }
        }
    }

    public static ExecIndexRow getIndexRowFromHeapRow(IndexRowGenerator indexRowGenerator, RowLocation rowLocation, ExecRow execRow) throws StandardException {
        ExecIndexRow execIndexRow = indexRowGenerator.getIndexRowTemplate();
        indexRowGenerator.getIndexRow(execRow, rowLocation, execIndexRow, null);
        return execIndexRow;
    }

    public int getEngineType() {
        return this.engineType;
    }

    public long getSYSCOLUMNSHeapConglomerateNumber() {
        return this.coreInfo[2].getHeapConglomerate();
    }

    void addSYSCOLUMNSIndex2Property(TransactionController transactionController, long l) {
        this.startupParameters.put(CFG_SYSCOLUMNS_INDEX2_ID, Long.toString(l));
    }

    private long getBootParameter(Properties properties, String string, boolean bl) throws StandardException {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            if (!bl) {
                return -1L;
            }
            throw StandardException.newException("XCY03.S", string);
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("XCY00.S", string, (Object)string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSystemSQLName() {
        StringBuffer stringBuffer = new StringBuffer("SQL");
        DataDictionaryImpl dataDictionaryImpl = this;
        synchronized (dataDictionaryImpl) {
            long l = System.currentTimeMillis() / 10L * 10L;
            if (l > this.timeForLastSystemSQLName) {
                this.systemSQLNameNumber = 0;
                this.calendarForLastSystemSQLName.setTime(new Date(l));
                this.timeForLastSystemSQLName = l;
            } else {
                ++this.systemSQLNameNumber;
                if (this.systemSQLNameNumber == 10) {
                    this.systemSQLNameNumber = 0;
                    this.timeForLastSystemSQLName += 10L;
                    this.calendarForLastSystemSQLName.setTime(new Date(this.timeForLastSystemSQLName));
                }
            }
            stringBuffer.append(DataDictionaryImpl.twoDigits(this.calendarForLastSystemSQLName.get(1)));
            stringBuffer.append(DataDictionaryImpl.twoDigits(this.calendarForLastSystemSQLName.get(2) + 1));
            stringBuffer.append(DataDictionaryImpl.twoDigits(this.calendarForLastSystemSQLName.get(5)));
            stringBuffer.append(DataDictionaryImpl.twoDigits(this.calendarForLastSystemSQLName.get(10)));
            stringBuffer.append(DataDictionaryImpl.twoDigits(this.calendarForLastSystemSQLName.get(12)));
            stringBuffer.append(DataDictionaryImpl.twoDigits(this.calendarForLastSystemSQLName.get(13)));
            stringBuffer.append(DataDictionaryImpl.twoDigits(this.calendarForLastSystemSQLName.get(14) / 10));
            stringBuffer.append(this.systemSQLNameNumber);
        }
        return stringBuffer.toString();
    }

    private static String twoDigits(int n) {
        String string;
        if (n < 10) {
            string = "0" + n;
        } else {
            int n2 = Integer.toString(n).length();
            string = Integer.toString(n).substring(n2 - 2);
        }
        return string;
    }

    public void setAutoincrementValue(TransactionController transactionController, UUID uUID, String string, long l, boolean bl) throws StandardException {
        TabInfo tabInfo = this.coreInfo[2];
        ExecIndexRow execIndexRow = null;
        execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, this.dvf.getCharDataValue(uUID.toString()));
        execIndexRow.setColumn(2, this.dvf.getCharDataValue(string));
        SYSCOLUMNSRowFactory sYSCOLUMNSRowFactory = (SYSCOLUMNSRowFactory)tabInfo.getCatalogRowFactory();
        ExecRow execRow = sYSCOLUMNSRowFactory.makeEmptyRow();
        boolean[] blArray = new boolean[2];
        for (int i = 0; i < 2; ++i) {
            blArray[i] = false;
        }
        int[] nArray = new int[]{7};
        if (bl) {
            ExecRow execRow2 = tabInfo.getRow(transactionController, execIndexRow, 0);
            NumberDataValue numberDataValue = (NumberDataValue)execRow2.getColumn(9);
            l += numberDataValue.getLong();
        }
        execRow.setColumn(7, this.dvf.getDataValue(l));
        tabInfo.updateRow(execIndexRow, execRow, 0, blArray, nArray, transactionController);
    }

    private RowLocation computeRowLocation(TransactionController transactionController, TableDescriptor tableDescriptor, String string) throws StandardException {
        TabInfo tabInfo = this.coreInfo[2];
        ExecIndexRow execIndexRow = null;
        UUID uUID = tableDescriptor.getUUID();
        execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, this.dvf.getCharDataValue(uUID.toString()));
        execIndexRow.setColumn(2, this.dvf.getCharDataValue(string));
        return tabInfo.getRowLocation(transactionController, execIndexRow, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowLocation getRowLocationTemplate(LanguageConnectionContext languageConnectionContext, TableDescriptor tableDescriptor) throws StandardException {
        RowLocation rowLocation;
        ConglomerateController conglomerateController = null;
        TransactionController transactionController = languageConnectionContext.getTransactionCompile();
        long l = tableDescriptor.getHeapConglomerateId();
        conglomerateController = transactionController.openConglomerate(l, false, 0, 6, 2);
        try {
            rowLocation = conglomerateController.newRowLocationTemplate();
        }
        finally {
            conglomerateController.close();
        }
        return rowLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTableDescriptorToOtherCache(TableDescriptor tableDescriptor, Cacheable cacheable) throws StandardException {
        CacheManager cacheManager = cacheable instanceof OIDTDCacheable ? this.nameTdCache : this.OIDTdCache;
        TDCacheable tDCacheable = null;
        Object object = cacheManager == this.nameTdCache ? new TableKey(tableDescriptor.getSchemaDescriptor().getUUID(), tableDescriptor.getName()) : tableDescriptor.getUUID();
        try {
            tDCacheable = (TDCacheable)cacheManager.create(object, tableDescriptor);
        }
        catch (StandardException standardException) {
            if (!standardException.getMessageId().equals("XBCA0.S")) {
                throw standardException;
            }
        }
        finally {
            if (tDCacheable != null) {
                cacheManager.release(tDCacheable);
            }
        }
    }

    public void dropStatisticsDescriptors(UUID uUID, UUID uUID2, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow;
        TabInfo tabInfo = this.getNonCoreTI(14);
        StringDataValue stringDataValue = this.dvf.getCharDataValue(uUID.toString());
        if (uUID2 != null) {
            execIndexRow = this.exFactory.getIndexableRow(2);
            StringDataValue stringDataValue2 = this.dvf.getCharDataValue(uUID2.toString());
            execIndexRow.setColumn(2, stringDataValue2);
        } else {
            execIndexRow = this.exFactory.getIndexableRow(1);
        }
        execIndexRow.setColumn(1, stringDataValue);
        tabInfo.deleteRow(transactionController, execIndexRow, 0);
    }

    private static LanguageConnectionContext getLCC() {
        return (LanguageConnectionContext)ContextService.getContextOrNull("LanguageConnectionContext");
    }

    private SchemaDescriptor newSystemSchemaDesc(String string, String string2) {
        return new SchemaDescriptor(this, string, "DBA", this.uuidFactory.recreateUUID(string2), true);
    }

    private SchemaDescriptor newDeclaredGlobalTemporaryTablesSchemaDesc(String string) {
        return new SchemaDescriptor(this, string, "DBA", null, false);
    }

    public boolean checkVersion(int n, String string) throws StandardException {
        if (n == -1) {
            n = this.softwareVersion.majorVersionNumber;
        }
        return this.dictionaryVersion.checkVersion(n, string);
    }

    void createSystemSps(TransactionController transactionController) throws StandardException {
        this.createSPSSet(transactionController, false, this.getSystemSchemaDescriptor().getUUID());
        this.createSPSSet(transactionController, true, this.getSysIBMSchemaDescriptor().getUUID());
    }

    private void createSPSSet(TransactionController transactionController, boolean bl, UUID uUID) throws StandardException {
        Properties properties = this.getQueryDescriptions(bl);
        Enumeration<Object> enumeration = properties.keys();
        boolean bl2 = true;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            SPSDescriptor sPSDescriptor = new SPSDescriptor(this, string, this.getUUIDFactory().createUUID(), uUID, uUID, 'S', !bl2, string2, null, null, !bl2);
            this.addSPSDescriptor(sPSDescriptor, transactionController, true);
        }
    }

    private final void createSystemProcedureOrFunction(String string, UUID uUID, String[] stringArray, TypeDescriptor[] typeDescriptorArray, int n, int n2, short s, TypeDescriptor typeDescriptor, TransactionController transactionController) throws StandardException {
        int n3 = 0;
        if (stringArray != null) {
            n3 = stringArray.length;
        }
        String string2 = "org.apache.derby.catalog.SystemProcedures";
        int[] nArray = null;
        if (n3 != 0) {
            int n4;
            nArray = new int[n3];
            int n5 = n3 - n;
            for (n4 = 0; n4 < n5; ++n4) {
                nArray[n4] = 1;
            }
            for (n4 = 0; n4 < n; ++n4) {
                nArray[n5 + n4] = 4;
            }
        }
        RoutineAliasInfo routineAliasInfo = new RoutineAliasInfo(string, n3, stringArray, typeDescriptorArray, nArray, n2, 0, s, true, typeDescriptor);
        AliasDescriptor aliasDescriptor = new AliasDescriptor(this, this.getUUIDFactory().createUUID(), string, uUID, string2, typeDescriptor == null ? (char)'P' : 'F', typeDescriptor == null ? (char)'P' : 'F', false, routineAliasInfo, null);
        this.addDescriptor(aliasDescriptor, null, 7, false, transactionController);
    }

    private final void create_SYSCS_procedures(TransactionController transactionController) throws StandardException {
        UUID uUID = this.getSystemUtilSchemaDescriptor().getUUID();
        Object object = new String[]{"KEY", "VALUE"};
        Object[] objectArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672)};
        this.createSystemProcedureOrFunction("SYSCS_SET_DATABASE_PROPERTY", uUID, (String[])object, (TypeDescriptor[])objectArray, 0, 0, (short)0, null, transactionController);
        object = new String[]{"SCHEMANAME", "TABLENAME", "SEQUENTIAL"};
        objectArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(5)};
        this.createSystemProcedureOrFunction("SYSCS_COMPRESS_TABLE", uUID, (String[])object, (TypeDescriptor[])objectArray, 0, 0, (short)0, null, transactionController);
        this.createSystemProcedureOrFunction("SYSCS_CHECKPOINT_DATABASE", uUID, null, null, 0, 0, (short)2, null, transactionController);
        this.createSystemProcedureOrFunction("SYSCS_FREEZE_DATABASE", uUID, null, null, 0, 0, (short)2, null, transactionController);
        this.createSystemProcedureOrFunction("SYSCS_UNFREEZE_DATABASE", uUID, null, null, 0, 0, (short)2, null, transactionController);
        object = new String[]{"BACKUPDIR"};
        objectArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672)};
        this.createSystemProcedureOrFunction("SYSCS_BACKUP_DATABASE", uUID, (String[])object, (TypeDescriptor[])objectArray, 0, 0, (short)0, null, transactionController);
        object = new String[]{"BACKUPDIR", "DELETE_ARCHIVED_LOG_FILES"};
        objectArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672), DataTypeDescriptor.getBuiltInDataTypeDescriptor(5)};
        this.createSystemProcedureOrFunction("SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE", uUID, (String[])object, (TypeDescriptor[])objectArray, 0, 0, (short)0, null, transactionController);
        object = new String[]{"DELETE_ARCHIVED_LOG_FILES"};
        objectArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(5)};
        this.createSystemProcedureOrFunction("SYSCS_DISABLE_LOG_ARCHIVE_MODE", uUID, (String[])object, (TypeDescriptor[])objectArray, 0, 0, (short)0, null, transactionController);
        object = new String[]{"ENABLE"};
        objectArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(5)};
        this.createSystemProcedureOrFunction("SYSCS_SET_RUNTIMESTATISTICS", uUID, (String[])object, (TypeDescriptor[])objectArray, 0, 0, (short)2, null, transactionController);
        object = new String[]{"ENABLE"};
        objectArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(5)};
        this.createSystemProcedureOrFunction("SYSCS_SET_STATISTICS_TIMING", uUID, (String[])object, (TypeDescriptor[])objectArray, 0, 0, (short)2, null, transactionController);
        object = new String[]{"KEY"};
        objectArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128)};
        this.createSystemProcedureOrFunction("SYSCS_GET_DATABASE_PROPERTY", uUID, (String[])object, (TypeDescriptor[])objectArray, 0, 0, (short)1, DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672), transactionController);
        object = new String[]{"SCHEMANAME", "TABLENAME"};
        objectArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128)};
        this.createSystemProcedureOrFunction("SYSCS_CHECK_TABLE", uUID, (String[])object, (TypeDescriptor[])objectArray, 0, 0, (short)1, DataTypeDescriptor.getBuiltInDataTypeDescriptor(4), transactionController);
        this.createSystemProcedureOrFunction("SYSCS_GET_RUNTIMESTATISTICS", uUID, null, null, 0, 0, (short)2, DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672), transactionController);
        object = this.getSchemaDescriptor("SQLJ", transactionController, true).getUUID();
        objectArray = new String[]{"URL", "JAR", "DEPLOY"};
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 256), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(4)};
        this.createSystemProcedureOrFunction("INSTALL_JAR", (UUID)object, (String[])objectArray, typeDescriptorArray, 0, 0, (short)0, null, transactionController);
        objectArray = new String[]{"URL", "JAR"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 256), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128)};
        this.createSystemProcedureOrFunction("REPLACE_JAR", (UUID)object, (String[])objectArray, typeDescriptorArray, 0, 0, (short)0, null, transactionController);
        objectArray = new String[]{"JAR", "UNDEPLOY"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(4)};
        this.createSystemProcedureOrFunction("REMOVE_JAR", (UUID)object, (String[])objectArray, typeDescriptorArray, 0, 0, (short)0, null, transactionController);
        objectArray = new String[]{"schemaName", "tableName", "fileName", " columnDelimiter", "characterDelimiter", "codeset"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 1), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 1), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128)};
        this.createSystemProcedureOrFunction("SYSCS_EXPORT_TABLE", uUID, (String[])objectArray, typeDescriptorArray, 0, 0, (short)1, null, transactionController);
        objectArray = new String[]{"selectStatement", "fileName", " columnDelimiter", "characterDelimiter", "codeset"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 1), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 1), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128)};
        this.createSystemProcedureOrFunction("SYSCS_EXPORT_QUERY", uUID, (String[])objectArray, typeDescriptorArray, 0, 0, (short)1, null, transactionController);
        objectArray = new String[]{"schemaName", "tableName", "fileName", " columnDelimiter", "characterDelimiter", "codeset", "replace"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 1), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 1), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(5)};
        this.createSystemProcedureOrFunction("SYSCS_IMPORT_TABLE", uUID, (String[])objectArray, typeDescriptorArray, 0, 0, (short)0, null, transactionController);
        objectArray = new String[]{"schemaName", "tableName", "insertColumnList", "columnIndexes", "fileName", " columnDelimiter", "characterDelimiter", "codeset", "replace"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 1), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 1), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(5)};
        this.createSystemProcedureOrFunction("SYSCS_IMPORT_DATA", uUID, (String[])objectArray, typeDescriptorArray, 0, 0, (short)0, null, transactionController);
        objectArray = new String[]{"schemaName", "tableName", "vtiName", "vtiArg"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672)};
        this.createSystemProcedureOrFunction("SYSCS_BULK_INSERT", uUID, (String[])objectArray, typeDescriptorArray, 0, 0, (short)0, null, transactionController);
    }

    protected final void create_SYSIBM_procedures(TransactionController transactionController) throws StandardException {
        UUID uUID = this.getSysIBMSchemaDescriptor().getUUID();
        String[] stringArray = new String[]{"SQLCODE", "SQLERRML", "SQLERRMC", "SQLERRP", "SQLERRD0", "SQLERRD1", "SQLERRD2", "SQLERRD3", "SQLERRD4", "SQLERRD5", "SQLWARN", "SQLSTATE", "FILE", "LOCALE", "MESSAGE", "RETURNCODE"};
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(4), DataTypeDescriptor.getBuiltInDataTypeDescriptor(5), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 2400), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 8), DataTypeDescriptor.getBuiltInDataTypeDescriptor(4), DataTypeDescriptor.getBuiltInDataTypeDescriptor(4), DataTypeDescriptor.getBuiltInDataTypeDescriptor(4), DataTypeDescriptor.getBuiltInDataTypeDescriptor(4), DataTypeDescriptor.getBuiltInDataTypeDescriptor(4), DataTypeDescriptor.getBuiltInDataTypeDescriptor(4), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 11), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 5), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 50), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 5), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 2400), DataTypeDescriptor.getBuiltInDataTypeDescriptor(4)};
        this.createSystemProcedureOrFunction("SQLCAMESSAGE", uUID, stringArray, typeDescriptorArray, 2, 0, (short)1, null, transactionController);
        stringArray = new String[]{"CATALOGNAME", "SCHEMANAME", "PROCNAME", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 4000)};
        this.createSystemProcedureOrFunction("SQLPROCEDURES", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, null, transactionController);
        stringArray = new String[]{"CATALOGNAME", "SCHEMANAME", "TABLENAME", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 4000)};
        this.createSystemProcedureOrFunction("SQLTABLEPRIVILEGES", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, null, transactionController);
        stringArray = new String[]{"CATALOGNAME", "SCHEMANAME", "TABLENAME", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 4000)};
        this.createSystemProcedureOrFunction("SQLPRIMARYKEYS", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, null, transactionController);
        stringArray = new String[]{"CATALOGNAME", "SCHEMANAME", "TABLENAME", "TABLETYPE", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 4000), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 4000)};
        this.createSystemProcedureOrFunction("SQLTABLES", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, null, transactionController);
        stringArray = new String[]{"CATALOGNAME", "SCHEMANAME", "PROCNAME", "PARAMNAME", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 4000)};
        this.createSystemProcedureOrFunction("SQLPROCEDURECOLS", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, null, transactionController);
        stringArray = new String[]{"CATALOGNAME", "SCHEMANAME", "TABLENAME", "COLUMNNAME", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 4000)};
        this.createSystemProcedureOrFunction("SQLCOLUMNS", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, null, transactionController);
        stringArray = new String[]{"CATALOGNAME", "SCHEMANAME", "TABLENAME", "COLUMNNAME", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 4000)};
        this.createSystemProcedureOrFunction("SQLCOLPRIVILEGES", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, null, transactionController);
        stringArray = new String[]{"CATALOGNAME", "SCHEMAPATTERN", "TYPENAMEPATTERN", "UDTTYPES", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 4000)};
        this.createSystemProcedureOrFunction("SQLUDTS", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, null, transactionController);
        stringArray = new String[]{"PKCATALOGNAME", "PKSCHEMANAME", "PKTABLENAME", "FKCATALOGNAME", "FKSCHEMANAME", "FKTABLENAME", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 4000)};
        this.createSystemProcedureOrFunction("SQLFOREIGNKEYS", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, null, transactionController);
        stringArray = new String[]{"COLTYPE", "CATALOGNAME", "SCHEMANAME", "TABLENAME", "SCOPE", "NULLABLE", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(5), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(5), DataTypeDescriptor.getBuiltInDataTypeDescriptor(5), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 4000)};
        this.createSystemProcedureOrFunction("SQLSPECIALCOLUMNS", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, null, transactionController);
        stringArray = new String[]{"DATATYPE", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(5), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 4000)};
        this.createSystemProcedureOrFunction("SQLGETTYPEINFO", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, null, transactionController);
        stringArray = new String[]{"CATALOGNAME", "SCHEMANAME", "TABLENAME", "UNIQUE", "RESERVED", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(5), DataTypeDescriptor.getBuiltInDataTypeDescriptor(5), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 4000)};
        this.createSystemProcedureOrFunction("SQLSTATISTICS", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, null, transactionController);
        this.createSystemProcedureOrFunction("METADATA", uUID, null, null, 0, 1, (short)1, null, transactionController);
    }

    private final synchronized Properties getQueryDescriptions(boolean bl) {
        this.spsSet = bl ? "metadata_net.properties" : "/org/apache/derby/impl/jdbc/metadata.properties";
        return (Properties)AccessController.doPrivileged(this);
    }

    public final Object run() {
        Properties properties = new Properties();
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(this.spsSet);
            properties.load(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    private static List newSList() {
        return Collections.synchronizedList(new LinkedList());
    }
}

