/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.impl.load.ColumnInfo;
import org.apache.derby.impl.load.ControlInfo;
import org.apache.derby.impl.load.ImportAbstract;
import org.apache.derby.impl.load.ImportReadData;
import org.apache.derby.impl.load.LoadError;

public class Import
extends ImportAbstract {
    private String inputFileName;

    public Import(String string, String string2, String string3, String string4, int n) throws SQLException {
        try {
            this.inputFileName = string;
            this.noOfColumnsExpected = n;
            this.controlFileReader = new ControlInfo();
            this.controlFileReader.setControlProperties(string3, string2, string4);
            this.doImport();
        }
        catch (Exception exception) {
            throw LoadError.unexpectedError(exception);
        }
    }

    private void doImport() throws Exception {
        if (this.inputFileName == null) {
            throw LoadError.dataFileNull();
        }
        this.doAllTheWork();
    }

    public static void importTable(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, short s) throws SQLException {
        Import.performImport(connection, string, null, null, string2, string3, string4, string5, string6, s);
    }

    public static void importData(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, short s) throws SQLException {
        Import.performImport(connection, string, string3, string4, string2, string5, string6, string7, string8, s);
    }

    private static void performImport(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, short s) throws SQLException {
        String string9;
        if (connection == null) {
            throw LoadError.connectionNull();
        }
        String string10 = string9 = string == null ? string4 : string + "." + string4;
        if (string9 == null) {
            throw LoadError.entityNameMissing();
        }
        ColumnInfo columnInfo = new ColumnInfo(connection, string, string4, string2, string3, "COLUMN");
        if (string7 != null && string7.equals("'")) {
            string7 = "''";
        }
        if (string6 != null && string6.equals("'")) {
            string6 = "''";
        }
        StringBuffer stringBuffer = new StringBuffer("new ");
        stringBuffer.append("org.apache.derby.impl.load.Import");
        stringBuffer.append("(");
        stringBuffer.append(string5 != null ? "'" + string5 + "'" : null);
        stringBuffer.append(",");
        stringBuffer.append(string6 != null ? "'" + string6 + "'" : null);
        stringBuffer.append(",");
        stringBuffer.append(string7 != null ? "'" + string7 + "'" : null);
        stringBuffer.append(",");
        stringBuffer.append(string8 != null ? "'" + string8 + "'" : null);
        stringBuffer.append(", ");
        stringBuffer.append(columnInfo.getExpectedNumberOfColumnsInFile());
        stringBuffer.append(" )");
        String string11 = stringBuffer.toString();
        String string12 = s > 0 ? "replace" : "bulkInsert";
        String string13 = columnInfo.getColumnNamesWithCasts();
        String string14 = columnInfo.getInsertColumnNames();
        string14 = string14 != null ? "(" + string14 + ") " : "";
        String string15 = "INSERT INTO " + string9 + string14 + " PROPERTIES insertMode=" + string12 + " SELECT " + string13 + " from " + string11 + " AS importvti";
        PreparedStatement preparedStatement = connection.prepareStatement(string15);
        Statement statement = connection.createStatement();
        String string16 = "LOCK TABLE " + string9 + " IN EXCLUSIVE MODE";
        statement.executeUpdate(string16);
        preparedStatement.executeUpdate();
        statement.close();
        preparedStatement.close();
    }

    protected ImportReadData getImportReadData() throws Exception {
        return new ImportReadData(this.inputFileName, this.controlFileReader);
    }
}

