/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.LimitInputStream;
import org.apache.derby.iapi.services.io.NewByteArrayInputStream;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.BinaryToRawStream;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedResultSetMetaData;
import org.apache.derby.impl.jdbc.EmbedStatement;
import org.apache.derby.impl.jdbc.ReaderToAscii;
import org.apache.derby.impl.jdbc.TransactionResourceImpl;
import org.apache.derby.impl.jdbc.UTF8Reader;
import org.apache.derby.impl.jdbc.Util;

public abstract class EmbedResultSet
extends ConnectionChild
implements java.sql.ResultSet,
Comparable {
    protected static final int FIRST = 1;
    protected static final int NEXT = 2;
    protected static final int LAST = 3;
    protected static final int PREVIOUS = 4;
    protected static final int BEFOREFIRST = 5;
    protected static final int AFTERLAST = 6;
    protected static final int ABSOLUTE = 7;
    protected static final int RELATIVE = 8;
    protected ExecRow currentRow;
    private DataValueDescriptor[] rowData;
    protected boolean wasNull;
    protected boolean isClosed;
    private Object currentStream;
    protected ResultSet theResults;
    private boolean forMetaData;
    private ResultSetMetaData rMetaData;
    private SQLWarning topWarning;
    Activation finalizeActivation;
    final int order;
    private final ResultDescription resultDescription;
    private final int[] jdbcColumnTypes;
    private int maxRows;
    private int maxFieldSize;
    private int NumberofFetchedRows;
    protected final EmbedStatement stmt;
    private EmbedStatement owningStmt;
    protected final boolean isAtomic;

    public EmbedResultSet(EmbedConnection embedConnection, ResultSet resultSet, boolean bl, EmbedStatement embedStatement, boolean bl2) {
        super(embedConnection);
        this.theResults = resultSet;
        this.forMetaData = bl;
        this.stmt = this.owningStmt = embedStatement;
        this.isAtomic = bl2;
        ResultDescription resultDescription = this.resultDescription = this.theResults.getResultDescription();
        this.jdbcColumnTypes = new int[resultDescription.getColumnCount() + 1];
        for (int i = 1; i < this.jdbcColumnTypes.length; ++i) {
            this.jdbcColumnTypes[i] = resultDescription.getColumnDescriptor(i).getType().getTypeId().getJDBCTypeId();
        }
        if (embedStatement != null) {
            if (embedStatement.resultSetType == 1003) {
                this.maxRows = embedStatement.maxRows;
            }
            this.maxFieldSize = embedStatement.MaxFieldSize;
        }
        this.order = embedConnection.getResultSetOrderId();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.finalizeActivation != null) {
            this.finalizeActivation.markUnused();
        }
    }

    protected final DataValueDescriptor[] checkOnRow() throws SQLException {
        DataValueDescriptor[] dataValueDescriptorArray = this.rowData;
        if (dataValueDescriptorArray == null) {
            throw this.newSQLException("24000");
        }
        return dataValueDescriptorArray;
    }

    protected int getColumnType(int n) throws SQLException {
        this.checkOnRow();
        if (n < 1 || n >= this.jdbcColumnTypes.length) {
            throw this.newSQLException("S0022", new Integer(n));
        }
        return this.jdbcColumnTypes[n];
    }

    public boolean next() throws SQLException {
        if (this.maxRows != 0) {
            ++this.NumberofFetchedRows;
            if (this.NumberofFetchedRows > this.maxRows) {
                this.closeCurrentStream();
                return false;
            }
        }
        return this.movePosition(2, 0, "next");
    }

    protected boolean movePosition(int n, String string) throws SQLException {
        return this.movePosition(n, 0, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean movePosition(int n, int n2, String string) throws SQLException {
        this.closeCurrentStream();
        this.checkExecIfClosed(string);
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            boolean bl;
            this.setupContextStack();
            try {
                boolean bl2;
                Object object2;
                LanguageConnectionContext languageConnectionContext = this.getEmbedConnection().getLanguageConnection();
                try {
                    object2 = languageConnectionContext.pushStatementContext(this.isAtomic, this.getSQLText(), this.getParameterValueSet(), false);
                    switch (n) {
                        case 5: {
                            this.currentRow = this.theResults.setBeforeFirstRow();
                            break;
                        }
                        case 1: {
                            this.currentRow = this.theResults.getFirstRow();
                            break;
                        }
                        case 2: {
                            this.currentRow = this.theResults.getNextRow();
                            break;
                        }
                        case 3: {
                            this.currentRow = this.theResults.getLastRow();
                            break;
                        }
                        case 6: {
                            this.currentRow = this.theResults.setAfterLastRow();
                            break;
                        }
                        case 4: {
                            this.currentRow = this.theResults.getPreviousRow();
                            break;
                        }
                        case 7: {
                            this.currentRow = this.theResults.getAbsoluteRow(n2);
                            break;
                        }
                        case 8: {
                            this.currentRow = this.theResults.getRelativeRow(n2);
                            break;
                        }
                    }
                    languageConnectionContext.popStatementContext((StatementContext)object2, null);
                }
                catch (Throwable throwable) {
                    throw this.closeOnTransactionError(throwable);
                }
                object2 = this.theResults.getWarnings();
                if (object2 != null) {
                    if (this.topWarning == null) {
                        this.topWarning = object2;
                    } else {
                        this.topWarning.setNextWarning((SQLWarning)object2);
                    }
                }
                boolean bl3 = bl2 = this.currentRow != null;
                if (!(bl2 || n != 2 || this.forMetaData && languageConnectionContext.getActivationCount() > 1 || this.owningStmt == null)) {
                    this.owningStmt.resultSetClosing(this);
                }
                this.rowData = bl2 ? this.currentRow.getRowArray() : null;
                bl = bl2;
            }
            catch (Throwable throwable) {
                this.restoreContextStack();
                throw throwable;
            }
            this.restoreContextStack();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.closeCurrentStream();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            try {
                this.setupContextStack();
            }
            catch (SQLException sQLException) {
                return;
            }
            try {
                try {
                    this.theResults.finish();
                }
                catch (Throwable throwable) {
                    throw this.handleException(throwable);
                }
                if (this.forMetaData) {
                    LanguageConnectionContext languageConnectionContext = this.getEmbedConnection().getLanguageConnection();
                    if (languageConnectionContext.getActivationCount() > 1) {
                    } else if (this.owningStmt != null) {
                        this.owningStmt.resultSetClosing(this);
                    }
                } else if (this.owningStmt != null) {
                    this.owningStmt.resultSetClosing(this);
                }
            }
            finally {
                this.isClosed = true;
                this.restoreContextStack();
            }
            this.currentRow = null;
            this.rowData = null;
            this.rMetaData = null;
        }
    }

    public final boolean wasNull() throws SQLException {
        this.checkIfClosed("wasNull");
        return this.wasNull;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getString(int n) throws SQLException {
        try {
            String string;
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            int n2 = this.jdbcColumnTypes[n];
            if (n2 == 1111 || n2 == 2000) {
                Object object = this.getConnectionSynchronization();
                synchronized (object) {
                    this.setupContextStack();
                    try {
                        string = dataValueDescriptor.getString();
                    }
                    finally {
                        this.restoreContextStack();
                    }
                }
            }
            string = dataValueDescriptor.getString();
            if (this.maxFieldSize > 0 && EmbedResultSet.isMaxFieldSizeType(n2) && string.length() > this.maxFieldSize) {
                string = string.substring(0, this.maxFieldSize);
            }
            return string;
        }
        catch (Throwable throwable) {
            throw EmbedResultSet.noStateChangeException(throwable);
        }
    }

    public final boolean getBoolean(int n) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return false;
            }
            return dataValueDescriptor.getBoolean();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final byte getByte(int n) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return 0;
            }
            return dataValueDescriptor.getByte();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final short getShort(int n) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return 0;
            }
            return dataValueDescriptor.getShort();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final int getInt(int n) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return 0;
            }
            return dataValueDescriptor.getInt();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final long getLong(int n) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return 0L;
            }
            return dataValueDescriptor.getLong();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final float getFloat(int n) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return 0.0f;
            }
            return dataValueDescriptor.getFloat();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final double getDouble(int n) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return 0.0;
            }
            return dataValueDescriptor.getDouble();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final byte[] getBytes(int n) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            byte[] byArray = dataValueDescriptor.getBytes();
            if (this.maxFieldSize > 0 && EmbedResultSet.isMaxFieldSizeType(this.jdbcColumnTypes[n]) && byArray.length > this.maxFieldSize) {
                byte[] byArray2 = new byte[this.maxFieldSize];
                System.arraycopy(byArray, 0, byArray2, 0, this.maxFieldSize);
                byArray = byArray2;
            }
            return byArray;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final Date getDate(int n) throws SQLException {
        return this.getDate(n, (Calendar)null);
    }

    public final Time getTime(int n) throws SQLException {
        return this.getTime(n, (Calendar)null);
    }

    public final Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestamp(n, (Calendar)null);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            if (calendar == null) {
                calendar = this.getCal();
            }
            return dataValueDescriptor.getDate(calendar);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumnName(string), calendar);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            if (calendar == null) {
                calendar = this.getCal();
            }
            return dataValueDescriptor.getTime(calendar);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumnName(string), calendar);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumnName(string), calendar);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            if (calendar == null) {
                calendar = this.getCal();
            }
            return dataValueDescriptor.getTimestamp(calendar);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Reader getCharacterStream(int n) throws SQLException {
        int n2;
        int n3 = this.getColumnType(n);
        switch (n3) {
            case -1: 
            case 1: 
            case 12: {
                n2 = this.maxFieldSize;
                break;
            }
            case 2005: {
                n2 = 0;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                try {
                    InputStream inputStream = this.getBinaryStream(n);
                    if (inputStream == null) {
                        return null;
                    }
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-16BE");
                    this.currentStream = inputStreamReader;
                    return inputStreamReader;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SQLException(unsupportedEncodingException.getMessage());
                }
            }
            default: {
                throw this.dataTypeConversion("java.io.Reader", n);
            }
        }
        Object object = this.getConnectionSynchronization();
        Object object2 = this.getConnectionSynchronization();
        synchronized (object2) {
            boolean bl = false;
            try {
                DataValueDescriptor dataValueDescriptor = this.getColumn(n);
                this.wasNull = dataValueDescriptor.isNull();
                if (this.wasNull) {
                    Reader reader = null;
                    return reader;
                }
                bl = true;
                this.setupContextStack();
                StreamStorable streamStorable = (StreamStorable)((Object)dataValueDescriptor);
                InputStream inputStream = streamStorable.returnStream();
                if (inputStream == null) {
                    String string = dataValueDescriptor.getString();
                    if (n2 > 0 && string.length() > n2) {
                        string = string.substring(0, n2);
                    }
                    StringReader stringReader = new StringReader(string);
                    this.currentStream = stringReader;
                    StringReader stringReader2 = stringReader;
                    return stringReader2;
                }
                UTF8Reader uTF8Reader = new UTF8Reader(inputStream, n2, this, object);
                this.currentStream = uTF8Reader;
                UTF8Reader uTF8Reader2 = uTF8Reader;
                return uTF8Reader2;
            }
            catch (Throwable throwable) {
                throw EmbedResultSet.noStateChangeException(throwable);
            }
            finally {
                if (bl) {
                    this.restoreContextStack();
                }
            }
        }
    }

    public final InputStream getAsciiStream(int n) throws SQLException {
        int n2 = this.getColumnType(n);
        switch (n2) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return this.getBinaryStream(n);
            }
            default: {
                throw this.dataTypeConversion("java.io.InputStream(ASCII)", n);
            }
        }
        Reader reader = this.getCharacterStream(n);
        if (reader == null) {
            return null;
        }
        return new ReaderToAscii(reader);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final InputStream getBinaryStream(int n) throws SQLException {
        int n2;
        int n3 = this.getColumnType(n);
        switch (n3) {
            case -4: 
            case -3: 
            case -2: {
                n2 = this.maxFieldSize;
                break;
            }
            case 2004: {
                n2 = 0;
                break;
            }
            default: {
                throw this.dataTypeConversion("java.io.InputStream", n);
            }
        }
        Object object = this.getConnectionSynchronization();
        Object object2 = this.getConnectionSynchronization();
        synchronized (object2) {
            boolean bl = false;
            try {
                InputStream inputStream;
                DataValueDescriptor dataValueDescriptor = this.getColumn(n);
                this.wasNull = dataValueDescriptor.isNull();
                if (this.wasNull) {
                    InputStream inputStream2 = null;
                    return inputStream2;
                }
                bl = true;
                this.setupContextStack();
                StreamStorable streamStorable = (StreamStorable)((Object)dataValueDescriptor);
                InputStream inputStream3 = streamStorable.returnStream();
                inputStream3 = inputStream3 == null ? new NewByteArrayInputStream(dataValueDescriptor.getBytes()) : new BinaryToRawStream(inputStream3, dataValueDescriptor);
                if (n2 > 0) {
                    inputStream = new LimitInputStream(inputStream3);
                    ((LimitInputStream)inputStream).setLimit(n2);
                    inputStream3 = inputStream;
                }
                this.currentStream = inputStream3;
                inputStream = inputStream3;
                return inputStream;
            }
            catch (Throwable throwable) {
                throw EmbedResultSet.noStateChangeException(throwable);
            }
            finally {
                if (bl) {
                    this.restoreContextStack();
                }
            }
        }
    }

    public final String getString(String string) throws SQLException {
        return this.getString(this.findColumnName(string));
    }

    public final boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumnName(string));
    }

    public final byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumnName(string));
    }

    public final short getShort(String string) throws SQLException {
        return this.getShort(this.findColumnName(string));
    }

    public final int getInt(String string) throws SQLException {
        return this.getInt(this.findColumnName(string));
    }

    public final long getLong(String string) throws SQLException {
        return this.getLong(this.findColumnName(string));
    }

    public final float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumnName(string));
    }

    public final double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumnName(string));
    }

    public final byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumnName(string));
    }

    public final Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumnName(string));
    }

    public final Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumnName(string));
    }

    public final Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumnName(string));
    }

    public final Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumnName(string));
    }

    public final InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumnName(string));
    }

    public final InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumnName(string));
    }

    public final SQLWarning getWarnings() throws SQLException {
        this.checkIfClosed("getWarnings");
        return this.topWarning;
    }

    public final void clearWarnings() throws SQLException {
        this.checkIfClosed("clearWarnings");
        this.topWarning = null;
    }

    public final String getCursorName() throws SQLException {
        this.checkIfClosed("getCursorName");
        return this.theResults.getCursorName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkIfClosed("getMetaData");
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            if (this.rMetaData == null) {
                this.rMetaData = this.newEmbedResultSetMetaData(this.resultDescription);
            }
            return this.rMetaData;
        }
    }

    public final Object getObject(int n) throws SQLException {
        int n2 = this.getColumnType(n);
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                return this.getString(n);
            }
            case 2005: {
                return this.getClob(n);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(n);
            }
            case 2004: {
                return this.getBlob(n);
            }
        }
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            return dataValueDescriptor.getObject();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumnName(string));
    }

    public final int findColumn(String string) throws SQLException {
        this.checkIfClosed("findColumn");
        return this.findColumnName(string);
    }

    protected int findColumnName(String string) throws SQLException {
        if (string == null) {
            throw this.newSQLException("XJ018.S");
        }
        ResultDescription resultDescription = this.resultDescription;
        for (int i = resultDescription.getColumnCount(); i >= 1; --i) {
            String string2 = resultDescription.getColumnDescriptor(i).getName();
            if (!StringUtil.SQLEqualsIgnoreCase(string, string2)) continue;
            return i;
        }
        throw this.newSQLException("S0022", string);
    }

    protected EmbedResultSetMetaData newEmbedResultSetMetaData(ResultDescription resultDescription) {
        return new EmbedResultSetMetaData(resultDescription.getColumnInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void closeCurrentStream() {
        if (this.currentStream != null) {
            try {
                EmbedResultSet embedResultSet = this;
                synchronized (embedResultSet) {
                    if (this.currentStream != null) {
                        if (this.currentStream instanceof Reader) {
                            ((Reader)this.currentStream).close();
                        } else {
                            ((InputStream)this.currentStream).close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.currentStream = null;
            }
        }
    }

    protected final void checkIfClosed(String string) throws SQLException {
        if (this.isClosed) {
            throw this.newSQLException("XCL16.S", string);
        }
    }

    protected final void checkExecIfClosed(String string) throws SQLException {
        this.checkIfClosed(string);
        Connection connection = this.getEmbedConnection().getApplicationConnection();
        if (connection == null || connection.isClosed()) {
            throw Util.noCurrentConnection();
        }
    }

    protected String getSQLText() {
        if (this.stmt == null) {
            return null;
        }
        return this.stmt.getSQLText();
    }

    protected ParameterValueSet getParameterValueSet() {
        if (this.stmt == null) {
            return null;
        }
        return this.stmt.getParameterValueSet();
    }

    private static boolean isMaxFieldSizeType(int n) {
        return n == -2 || n == -3 || n == -4 || n == 1 || n == 12 || n == -1;
    }

    protected final SQLException closeOnTransactionError(Throwable throwable) throws SQLException {
        StandardException standardException;
        int n;
        SQLException sQLException = this.handleException(throwable);
        if (throwable instanceof StandardException && (n = (standardException = (StandardException)throwable).getSeverity()) == 30000) {
            try {
                this.close();
            }
            catch (Throwable throwable2) {
                SQLException sQLException2 = this.handleException(throwable2);
                sQLException2.setNextException(sQLException);
                sQLException = sQLException2;
            }
        }
        return sQLException;
    }

    protected final DataValueDescriptor getColumn(int n) throws SQLException, StandardException {
        this.closeCurrentStream();
        this.checkIfClosed("getXXX");
        DataValueDescriptor[] dataValueDescriptorArray = this.checkOnRow();
        try {
            return dataValueDescriptorArray[n - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.newSQLException("S0022", new Integer(n));
        }
    }

    public static final SQLException noStateChangeException(Throwable throwable) {
        return TransactionResourceImpl.wrapInSQLException(null, throwable);
    }

    void setDynamicResultSet(EmbedStatement embedStatement) {
        this.owningStmt = embedStatement;
        this.localConn = embedStatement.getEmbedConnection();
    }

    public final int compareTo(Object object) {
        EmbedResultSet embedResultSet = (EmbedResultSet)object;
        return this.order - embedResultSet.order;
    }

    public final boolean isForUpdate() {
        if (this.theResults instanceof NoPutResultSet) {
            return ((NoPutResultSet)this.theResults).isForUpdate();
        }
        return false;
    }

    protected final SQLException dataTypeConversion(String string, int n) {
        return this.newSQLException("22005", string, this.resultDescription.getColumnDescriptor(n).getType().getTypeId().getSQLTypeName());
    }
}

