/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLChar;

public class SQLVarchar
extends SQLChar {
    public String getTypeName() {
        return "VARCHAR";
    }

    public DataValueDescriptor getClone() {
        try {
            return new SQLVarchar(this.getString());
        }
        catch (StandardException standardException) {
            return null;
        }
    }

    public DataValueDescriptor getNewNull() {
        return new SQLVarchar();
    }

    public int getTypeFormatId() {
        return 85;
    }

    public SQLVarchar() {
    }

    public SQLVarchar(String string) {
        super(string);
    }

    public void normalize(DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor) throws StandardException {
        this.normalize(dataTypeDescriptor, dataValueDescriptor.getString());
    }

    protected void normalize(DataTypeDescriptor dataTypeDescriptor, String string) throws StandardException {
        int n = dataTypeDescriptor.getMaximumWidth();
        int n2 = string.length();
        if (n2 > n) {
            this.hasNonBlankChars(string, n, n2);
            string = string.substring(0, n);
        }
        this.setValue(string);
    }

    public int typePrecedence() {
        return 10;
    }
}

