/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.filter;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.internal.filter.PathTokenFilter;
import com.jayway.jsonpath.spi.JsonProvider;
import java.util.regex.Pattern;

public class ArrayIndexFilter
extends PathTokenFilter {
    private static final Pattern SINGLE_ARRAY_INDEX_PATTERN = Pattern.compile("\\[\\d+\\]");
    private static final Pattern COMMA = Pattern.compile(",");
    private static final Pattern SPACE = Pattern.compile(" ");
    private static final String OPERATOR = ":";
    private final String trimmedCondition;
    private boolean usesLenght;

    public ArrayIndexFilter(String condition) {
        super(condition);
        String trimmedCondition = ArrayIndexFilter.trim(condition, 1, 1);
        this.usesLenght = trimmedCondition.contains("@.length");
        if (this.usesLenght) {
            trimmedCondition = ArrayIndexFilter.trim(trimmedCondition, 1, 1);
            trimmedCondition = trimmedCondition.replace("@.length", "");
            trimmedCondition = trimmedCondition + OPERATOR;
        }
        this.trimmedCondition = trimmedCondition;
    }

    @Override
    public Object filter(Object obj, Configuration configuration) {
        JsonProvider jsonProvider = configuration.getProvider();
        Iterable result = jsonProvider.createArray();
        if (this.trimmedCondition.contains(OPERATOR)) {
            if (this.trimmedCondition.startsWith(OPERATOR)) {
                String trimmedCondition = ArrayIndexFilter.trim(this.trimmedCondition, 1, 0);
                int get = Integer.parseInt(trimmedCondition);
                for (int i = 0; i < get; ++i) {
                    try {
                        jsonProvider.setProperty(result, jsonProvider.length(result), jsonProvider.getProperty(obj, i));
                        continue;
                    }
                    catch (IndexOutOfBoundsException e) {
                        break;
                    }
                }
                return result;
            }
            if (this.trimmedCondition.endsWith(OPERATOR)) {
                String trimmedCondition = ArrayIndexFilter.trim(SPACE.matcher(this.trimmedCondition).replaceAll(""), 0, 1);
                int get = Integer.parseInt(trimmedCondition);
                if (get > 0 || this.usesLenght) {
                    if (get > 0) {
                        get *= -1;
                    }
                    return jsonProvider.getProperty(obj, jsonProvider.length(obj) + get);
                }
                int start = jsonProvider.length(obj) + get;
                int stop = jsonProvider.length(obj);
                if (start < 0) {
                    start = 0;
                }
                for (int i = start; i < stop; ++i) {
                    jsonProvider.setProperty(result, jsonProvider.length(result), jsonProvider.getProperty(obj, i));
                }
                return result;
            }
            String[] indexes = this.trimmedCondition.split(OPERATOR);
            int start = Integer.parseInt(indexes[0]);
            int stop = Integer.parseInt(indexes[1]);
            for (int i = start; i < stop; ++i) {
                try {
                    jsonProvider.setProperty(result, jsonProvider.length(result), jsonProvider.getProperty(obj, i));
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    break;
                }
            }
            return result;
        }
        String[] indexArr = COMMA.split(this.trimmedCondition);
        if (obj == null) {
            return result;
        }
        try {
            if (indexArr.length == 1) {
                return jsonProvider.getProperty(obj, indexArr[0]);
            }
            for (String idx : indexArr) {
                jsonProvider.setProperty(result, jsonProvider.length(result), jsonProvider.getProperty(obj, idx.trim()));
            }
            return result;
        }
        catch (IndexOutOfBoundsException e) {
            throw new PathNotFoundException("Array index " + indexArr + " not found in path", e);
        }
    }

    @Override
    public Object getRef(Object obj, Configuration configuration) {
        if (SINGLE_ARRAY_INDEX_PATTERN.matcher(this.condition).matches()) {
            String trimmedCondition = ArrayIndexFilter.trim(this.condition, 1, 1);
            return configuration.getProvider().getProperty(obj, trimmedCondition);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isArrayFilter() {
        return true;
    }
}

