/*
 * Decompiled with CFR 0.152.
 */
package hermes.ext.joram;

import hermes.Domain;
import hermes.Hermes;
import hermes.HermesAdmin;
import hermes.HermesException;
import hermes.JNDIConnectionFactory;
import hermes.browser.HermesBrowser;
import hermes.config.DestinationConfig;
import hermes.ext.HermesAdminSupport;
import hermes.ext.joram.JoramAdminFactory;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import org.apache.log4j.Logger;
import org.objectweb.joram.client.jms.Destination;
import org.objectweb.joram.client.jms.Message;
import org.objectweb.joram.client.jms.Topic;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.admin.Subscription;
import org.objectweb.joram.client.jms.admin.User;

public class JoramAdmin
extends HermesAdminSupport
implements HermesAdmin {
    private static final Logger log = Logger.getLogger(JoramAdmin.class);
    private JoramAdminFactory factory;
    private Hermes hermes;
    private JNDIConnectionFactory jndiCF;
    private boolean connected = false;
    private User user;

    public JoramAdmin(JoramAdminFactory factory, Hermes hermes, JNDIConnectionFactory jndiCF) {
        super(hermes);
        this.factory = factory;
        this.jndiCF = jndiCF;
    }

    private synchronized void checkConnected() throws JMSException {
        if (!this.connected) {
            try {
                AdminModule.connect((String)this.factory.getHostname(), (int)this.factory.getPort(), (String)this.factory.getUsername(), (String)this.factory.getPassword(), (int)this.factory.getCnxTimer());
            }
            catch (ConnectException e) {
                throw new HermesException((Exception)e);
            }
            catch (UnknownHostException e) {
                throw new HermesException((Exception)e);
            }
            catch (AdminException e) {
                throw new HermesException((Exception)((Object)e));
            }
            this.connected = true;
        }
    }

    protected User getUser(String userName) throws JMSException {
        this.checkConnected();
        try {
            for (User u : AdminModule.getUsers()) {
                if (!u.getName().equals(userName)) continue;
                return u;
            }
            throw new HermesException("No such user " + userName);
        }
        catch (ConnectException e) {
            throw new HermesException((Exception)e);
        }
        catch (AdminException e) {
            throw new HermesException((Exception)((Object)e));
        }
    }

    public synchronized Collection discoverDestinationConfigs() throws JMSException {
        this.checkConnected();
        ArrayList<DestinationConfig> rval = new ArrayList<DestinationConfig>();
        try {
            List destList = AdminModule.getDestinations();
            for (int i = 0; i < destList.size(); ++i) {
                DestinationConfig dConfig = new DestinationConfig();
                dConfig.setName(((Destination)destList.get(i)).getName());
                dConfig.setShortName(((Destination)destList.get(i)).getAdminName());
                if (((Destination)destList.get(i)).getType() == "queue") {
                    dConfig.setDomain(Integer.valueOf(Domain.QUEUE.getId()));
                    rval.add(dConfig);
                    continue;
                }
                if (((Destination)destList.get(i)).getType() != "topic") continue;
                dConfig.setDomain(Integer.valueOf(Domain.TOPIC.getId()));
                rval.add(dConfig);
                rval.addAll(this.discoverDurableSubscriptions(dConfig.getName(), dConfig.getName()));
            }
        }
        catch (Exception ex) {
            throw new HermesException(ex);
        }
        return rval;
    }

    protected Collection discoverDurableSubscriptions(String topicName, String jndiName) throws JMSException {
        ArrayList<DestinationConfig> rval = new ArrayList<DestinationConfig>();
        this.checkConnected();
        try {
            for (User u : AdminModule.getUsers()) {
                if (u.getName() == this.factory.getUsername()) continue;
                Subscription[] subs = u.getSubscriptions();
                for (int i = 0; i < subs.length; ++i) {
                    if (!subs[i].getTopicId().equals(topicName)) continue;
                    DestinationConfig dConfig = HermesBrowser.getConfigDAO().createDestinationConfig();
                    dConfig.setName(jndiName);
                    dConfig.setShortName(u.getProxyId());
                    dConfig.setDurable(Boolean.valueOf(true));
                    dConfig.setClientID(subs[i].getName());
                    dConfig.setDomain(Integer.valueOf(Domain.TOPIC.getId()));
                    rval.add(dConfig);
                }
            }
        }
        catch (ConnectException e) {
            throw new HermesException((Exception)e);
        }
        catch (AdminException e) {
            throw new HermesException((Exception)((Object)e));
        }
        return rval;
    }

    public int getDepth(DestinationConfig dest) throws JMSException {
        this.checkConnected();
        try {
            if (dest.getDomain().intValue() == Domain.QUEUE.getId()) {
                org.objectweb.joram.client.jms.Queue queue = (org.objectweb.joram.client.jms.Queue)this.getHermes().getDestination(dest.getName(), Domain.QUEUE);
                return queue.getPendingMessages();
            }
            Topic topic = (Topic)this.getHermes().getDestination(dest.getName(), Domain.TOPIC);
            throw new HermesException("Cannot get depth, " + dest.getName() + " is a topic");
        }
        catch (ConnectException e) {
            throw new HermesException((Exception)e);
        }
        catch (AdminException e) {
            throw new HermesException((Exception)((Object)e));
        }
        catch (Exception e) {
            throw new HermesException(e);
        }
    }

    public QueueBrowser createDurableSubscriptionBrowser(final DestinationConfig dConfig) throws JMSException {
        this.checkConnected();
        try {
            Topic topic = (Topic)this.getHermes().getSession().createTopic(dConfig.getName());
            this.checkConnected();
            final ArrayList<Message> messages = new ArrayList<Message>();
            boolean fin = false;
            String[] ids = topic.getSubscriberIds();
            for (int i = 0; i < ids.length && !fin; ++i) {
                if (dConfig.getShortName() != null && dConfig.getShortName().equals(ids[i])) {
                    User u = new User("user" + i, ids[i]);
                    Subscription[] subs = u.getSubscriptions();
                    for (int j = 0; j < subs.length && !fin; ++j) {
                        if (!subs[j].getName().equals(dConfig.getClientID())) continue;
                        String[] msgids = u.getMessageIds(dConfig.getClientID());
                        for (int k = 0; k < msgids.length; ++k) {
                            messages.add(u.readMessage(dConfig.getClientID(), msgids[k]));
                        }
                        fin = true;
                    }
                    continue;
                }
                if (dConfig.getShortName() == null) {
                    throw new HermesException(new Exception("ShortName(userID) is null"));
                }
                throw new HermesException(new Exception("ShortName(userID) is incorrect"));
            }
            return new QueueBrowser(){

                public void close() throws JMSException {
                }

                public Enumeration getEnumeration() throws JMSException {
                    return new Enumeration(){
                        int i = 0;

                        public Object nextElement() {
                            return messages.get(this.i++);
                        }

                        public boolean hasMoreElements() {
                            return this.i < messages.size();
                        }
                    };
                }

                public String getMessageSelector() throws JMSException {
                    return dConfig.getSelector();
                }

                public Queue getQueue() throws JMSException {
                    return null;
                }
            };
        }
        catch (AdminException e) {
            throw new HermesException((Exception)((Object)e));
        }
        catch (ConnectException e) {
            throw new HermesException((Exception)e);
        }
    }

    public void close() throws JMSException {
        AdminModule.disconnect();
    }

    public Map getStatistics(DestinationConfig dConfig) throws JMSException {
        LinkedHashMap<String, Object> rval = new LinkedHashMap<String, Object>();
        if (dConfig.getDomain().intValue() == Domain.QUEUE.getId()) {
            org.objectweb.joram.client.jms.Queue queue = (org.objectweb.joram.client.jms.Queue)this.getHermes().getSession().createQueue(dConfig.getName());
            try {
                this.checkConnected();
                rval.put("Name", queue.getName());
                rval.put("AdminName", queue.getAdminName());
                rval.put("Threshold", Integer.toString(queue.getThreshold()));
                rval.put("NbMaxMsg", Integer.toString(queue.getNbMaxMsg()));
                rval.put("getPendingMessages", Integer.toString(queue.getPendingMessages()));
                rval.put("getPendingRequests", Integer.toString(queue.getPendingRequests()));
            }
            catch (ConnectException e) {
                throw new HermesException((Exception)e);
            }
            catch (AdminException e) {
                throw new HermesException((Exception)((Object)e));
            }
        }
        Topic topic = (Topic)this.getHermes().getSession().createTopic(dConfig.getName());
        try {
            this.checkConnected();
            rval.put("Name", topic.getName());
            rval.put("AdminName", topic.getAdminName());
            rval.put("number of subscription", topic.getSubscriptions());
            String[] ids = topic.getSubscriberIds();
            for (int i = 0; i < ids.length; ++i) {
                User u = new User("user" + i, ids[i]);
                Subscription[] subs = u.getSubscriptions();
                for (int j = 0; j < subs.length; ++j) {
                    rval.put("subscriber " + j, ids[i] + " : " + subs[j].getName() + "; Durable:" + subs[j].isDurable());
                }
            }
        }
        catch (ConnectException e) {
            throw new HermesException((Exception)e);
        }
        catch (AdminException e) {
            throw new HermesException((Exception)((Object)e));
        }
        return rval;
    }

    public int truncate(DestinationConfig dConfig) throws JMSException {
        try {
            int fin = 0;
            this.checkConnected();
            if (dConfig.getDomain().intValue() == Domain.QUEUE.getId()) {
                org.objectweb.joram.client.jms.Queue queue = (org.objectweb.joram.client.jms.Queue)this.getHermes().getSession().createQueue(dConfig.getName());
                fin = queue.getPendingMessages();
                queue.clear();
            } else {
                Topic topic = (Topic)this.getHermes().getSession().createTopic(dConfig.getName());
                String[] ids = topic.getSubscriberIds();
                for (int i = 0; i < ids.length && fin == 0; ++i) {
                    if (dConfig.getShortName() != null && dConfig.getShortName().equals(ids[i])) {
                        User u = new User("user" + i, ids[i]);
                        Subscription[] subs = u.getSubscriptions();
                        for (int j = 0; j < subs.length && fin == 0; ++j) {
                            if (!subs[j].getName().equals(dConfig.getClientID())) continue;
                            String[] msgids = u.getMessageIds(dConfig.getClientID());
                            for (int k = 0; k < msgids.length; ++k) {
                                u.deleteMessage(dConfig.getClientID(), msgids[k]);
                            }
                            ++fin;
                        }
                        continue;
                    }
                    if (dConfig.getShortName() == null) {
                        throw new HermesException(new Exception("ShortName(userID) is null"));
                    }
                    throw new HermesException(new Exception("ShortName(userID) is incorrect"));
                }
            }
            return fin;
        }
        catch (Exception e) {
            throw new HermesException(e);
        }
    }

    public void delete(DestinationConfig dConfig, Collection messageIds) throws JMSException {
        block9: {
            try {
                this.checkConnected();
                if (dConfig.getDomain().intValue() == Domain.QUEUE.getId()) {
                    org.objectweb.joram.client.jms.Queue queue = (org.objectweb.joram.client.jms.Queue)this.getHermes().getSession().createQueue(dConfig.getName());
                    Iterator iter = messageIds.iterator();
                    while (iter.hasNext()) {
                        queue.deleteMessage((String)iter.next());
                    }
                    break block9;
                }
                if (dConfig.isDurable()) {
                    Topic topic = (Topic)this.getHermes().getSession().createTopic(dConfig.getName());
                    boolean fin = false;
                    String[] ids = topic.getSubscriberIds();
                    for (int i = 0; i < ids.length && !fin; ++i) {
                        if (dConfig.getShortName() != null && dConfig.getShortName().equals(ids[i])) {
                            User u = new User("user" + i, ids[i]);
                            Subscription[] subs = u.getSubscriptions();
                            for (int j = 0; j < subs.length && !fin; ++j) {
                                if (!subs[j].getName().equals(dConfig.getClientID())) continue;
                                Iterator iter = messageIds.iterator();
                                while (iter.hasNext()) {
                                    u.deleteMessage(dConfig.getClientID(), (String)iter.next());
                                }
                                fin = true;
                            }
                            continue;
                        }
                        throw new HermesException(new Exception("Error when delete"));
                    }
                    break block9;
                }
                throw new HermesException(new Exception("Error when delete"));
            }
            catch (Exception e) {
                throw new HermesException(e);
            }
        }
    }
}

