/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.marker;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.caret.CaretPosition;
import com.jidesoft.editor.folding.FoldingSpan;
import com.jidesoft.editor.marker.Marker;
import com.jidesoft.editor.marker.MarkerArea;
import com.jidesoft.editor.marker.MarkerModel;
import com.jidesoft.editor.marker.MarkerStripePainter;
import com.jidesoft.editor.marker.b;
import com.jidesoft.editor.marker.c;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerStripe
extends JPanel
implements MouseListener,
MouseMotionListener {
    private CodeEditor a;
    private MarkerArea b;
    private MarkerStripePainter c;

    public MarkerStripe(CodeEditor codeEditor, MarkerArea markerArea) {
        this.a = codeEditor;
        this.b = markerArea;
        ToolTipManager.sharedInstance().registerComponent(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public MarkerStripePainter getPainter() {
        MarkerStripePainter markerStripePainter = this.c;
        if (MarkerArea.j == 0) {
            if (markerStripePainter == null) {
                this.c = new b();
            }
            markerStripePainter = this.c;
        }
        return markerStripePainter;
    }

    public void setPainter(MarkerStripePainter markerStripePainter) {
        this.c = markerStripePainter;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n = MarkerArea.j;
        super.paintComponent(graphics);
        MarkerModel markerModel = this.a.getMarkerModel();
        List<Marker> list = markerModel.getMarkers();
        Color color = graphics.getColor();
        if (n == 0) {
            if (list != null) {
                for (Marker marker : list) {
                    this.paintLineMarker(graphics, marker);
                    if (n == 0) {
                        if (n == 0) continue;
                    }
                    break;
                }
            } else {
                graphics.setColor(color);
            }
        }
    }

    protected List<Marker> getMarkersAt(int n) {
        int n2 = this.b.getVisualLineCount();
        c c2 = com.jidesoft.editor.marker.c.yToLineRange(n - 2, n2, this.getHeight(), this.a.getLineHeight());
        c c3 = com.jidesoft.editor.marker.c.yToLineRange(n + 2, n2, this.getHeight(), this.a.getLineHeight());
        c c4 = new c(this.a.viewToModelLine(c2.a), this.a.viewToModelLine(c3.b + 1) - 1);
        MarkerModel markerModel = this.a.getMarkerModel();
        return markerModel.getMarkersAt(this.a.modelPositionToOffset(new CaretPosition(c4.a, 0)), this.a.modelPositionToOffset(new CaretPosition(c4.b, this.a.getLineLength(c4.b))));
    }

    protected void paintLineMarker(Graphics graphics, Marker marker) {
        int n;
        int n2;
        int n3;
        int n4;
        block4: {
            block5: {
                int n5 = MarkerArea.j;
                CaretPosition caretPosition = this.a.offsetToViewPosition(marker.getStartOffset());
                int n6 = caretPosition.line;
                int n7 = this.b.getVisualLineCount();
                n4 = MarkerStripe.lineToY(n6, n7, this.getHeight(), this.a.getLineHeight());
                CaretPosition caretPosition2 = this.a.offsetToViewPosition(marker.getEndOffset());
                int n8 = caretPosition2.line;
                n3 = 3;
                n2 = n8;
                if (n5 != 0) break block4;
                if (n2 == n6) break block5;
                n = MarkerStripe.lineToY(n8, n7, this.getHeight(), this.a.getLineHeight());
                n2 = n - n4;
                if (n5 != 0) break block4;
                if (n2 > n3) {
                    n3 = n - n4;
                }
            }
            n2 = this.getWidth();
        }
        n = n2;
        this.getPainter().paint(this.b, graphics, marker, new Rectangle(0, n4, n - 1, n3));
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        block9: {
            List<Marker> list;
            List<Marker> list2;
            int n;
            block8: {
                n = MarkerArea.j;
                list = list2 = this.getMarkersAt(mouseEvent.getY());
                if (n != 0) break block8;
                if (list == null) break block9;
                list = list2;
            }
            if (list.size() > 0) {
                StringBuffer stringBuffer;
                block7: {
                    stringBuffer = new StringBuffer("<html>");
                    int n2 = 0;
                    while (n2 < list2.size()) {
                        Marker marker = list2.get(n2);
                        stringBuffer.append(marker.getToolTipText());
                        if (n == 0) {
                            if (n == 0) {
                                if (n2 != list2.size() - 1) {
                                    stringBuffer.append("<br>");
                                }
                                ++n2;
                            }
                            if (n == 0) continue;
                        }
                        break block7;
                    }
                    stringBuffer.append("</html>");
                }
                return stringBuffer.toString();
            }
        }
        return null;
    }

    protected static int lineToY(int n, int n2, int n3, int n4) {
        int n5 = n2 * n4;
        int n6 = n3;
        if (MarkerArea.j == 0) {
            if (n5 < n6) {
                return n * n4;
            }
            n5 = n;
            n6 = n3;
        }
        return (int)((double)(n5 * n6) / (double)n2);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        block7: {
            block5: {
                int n;
                block9: {
                    Object object;
                    int n2;
                    block8: {
                        List<Marker> list;
                        block6: {
                            n2 = MarkerArea.j;
                            list = this.getMarkersAt(mouseEvent.getY());
                            object = list;
                            if (n2 != 0) break block6;
                            if (object == null) break block7;
                            object = list;
                        }
                        if (n2 != 0) break block8;
                        if (object.size() <= 0) break block7;
                        object = list.get(0);
                    }
                    Marker marker = (Marker)object;
                    n = marker.getStartOffset();
                    FoldingSpan[] foldingSpanArray = this.a.getFoldingModel().getFoldingSpans();
                    if (n2 != 0) break block5;
                    if (foldingSpanArray == null) break block9;
                    FoldingSpan[] foldingSpanArray2 = foldingSpanArray;
                    int n3 = foldingSpanArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        block10: {
                            block11: {
                                int n5;
                                int n6;
                                FoldingSpan foldingSpan;
                                block13: {
                                    block12: {
                                        foldingSpan = foldingSpanArray2[n4];
                                        if (n2 != 0) break block5;
                                        if (n2 != 0) break block10;
                                        if (foldingSpan == null) break block11;
                                        n6 = foldingSpan.isExpanded();
                                        if (n2 != 0) break block12;
                                        if (n6 != 0) break block11;
                                        n6 = n;
                                    }
                                    n5 = foldingSpan.getStartOffset();
                                    if (n2 != 0) break block13;
                                    if (n6 < n5) break block11;
                                    n6 = n;
                                    n5 = foldingSpan.getEndOffset();
                                }
                                if (n6 <= n5) {
                                    this.a.getFoldingModel().expandFoldingSpan(foldingSpan);
                                    if (n2 == 0) break;
                                }
                            }
                            ++n4;
                        }
                        if (n2 == 0) continue;
                    }
                }
                this.a.select(n, n);
            }
            this.a.requestFocus();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        block4: {
            block3: {
                List<Marker> list;
                int n;
                block2: {
                    List<Marker> list2;
                    n = MarkerArea.j;
                    list = list2 = this.getMarkersAt(mouseEvent.getY());
                    if (n != 0) break block2;
                    if (list == null) break block3;
                    list = list2;
                }
                if (list.size() <= 0) break block3;
                this.setCursor(Cursor.getPredefinedCursor(12));
                if (n == 0) break block4;
            }
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public static void main(String[] stringArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        block3: {
            n5 = MarkerArea.j;
            n4 = 100;
            n3 = 1560;
            n2 = 16;
            for (n = 0; n < n4; ++n) {
                c c2 = com.jidesoft.editor.marker.c.yToLineRange(n, n3, n4, n2);
                System.out.println(n + " " + c2);
                if (n5 == 0) {
                    if (n5 == 0) continue;
                }
                break block3;
            }
            System.out.println("==================");
        }
        for (n = 0; n < n3; ++n) {
            int n6 = MarkerStripe.lineToY(n, n3, n4, n2);
            System.out.println(n + " " + n6);
            if (n5 == 0) continue;
        }
    }
}

