/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.marker;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.folding.FoldingSpanEvent;
import com.jidesoft.editor.folding.FoldingSpanListener;
import com.jidesoft.editor.marker.MarkerEye;
import com.jidesoft.editor.marker.MarkerEyePainter;
import com.jidesoft.editor.marker.MarkerStripe;
import com.jidesoft.editor.marker.MarkerStripePainter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class MarkerArea
extends JPanel {
    private static Logger a = Logger.getLogger(MarkerArea.class.getName());
    public static final int MODE_FINE = 0;
    public static final int MODE_WARNING = 100;
    public static final int MODE_ERROR = 200;
    public static final Color DEFAULT_FINE_COLOR = Color.GREEN;
    public static final Color DEFAULT_WARNING_COLOR = Color.YELLOW;
    public static final Color DEFAULT_ERROR_COLOR = Color.RED;
    public static final Color DEFAULT_INSPECTING_COLOR = Color.YELLOW;
    private CodeEditor b;
    private MarkerEye c;
    private MarkerStripe d;
    private MarkerEyePainter e;
    private MarkerStripePainter f;
    private int g;
    private int h;
    private boolean i;
    public static int j;

    public MarkerArea(CodeEditor codeEditor) {
        this.b = codeEditor;
        this.b.setMarkerArea(this);
        this.g = 0;
        this.h = 0;
        this.setLayout(new BorderLayout());
        b_ b_2 = new b_();
        codeEditor.getDocument().addDocumentListener(b_2);
        codeEditor.getFoldingModel().addFoldingSpanListener(b_2);
        this.c = this.createMarkerEye(codeEditor);
        this.d = this.createMarkerStripe(codeEditor);
        this.add((Component)this.c, "First");
        this.add((Component)this.d, "Center");
    }

    protected MarkerStripe createMarkerStripe(CodeEditor codeEditor) {
        return new MarkerStripe(codeEditor, this);
    }

    protected MarkerEye createMarkerEye(CodeEditor codeEditor) {
        return new MarkerEye(codeEditor, this);
    }

    public MarkerStripe getMarkerStripe() {
        return this.d;
    }

    public MarkerEye getMarkerEye() {
        return this.c;
    }

    public MarkerEyePainter getEyePainter() {
        return this.e;
    }

    public void setEyePainter(MarkerEyePainter markerEyePainter) {
        this.e = markerEyePainter;
        this.c.setPainter(this.e);
    }

    public MarkerStripePainter getStripePainter() {
        return this.f;
    }

    public void setStripePainter(MarkerStripePainter markerStripePainter) {
        this.f = markerStripePainter;
        this.d.setPainter(this.f);
    }

    public CodeEditor getCodeEditor() {
        return this.b;
    }

    public void setCodeEditor(CodeEditor codeEditor) {
        this.b = codeEditor;
    }

    public boolean isInspecting() {
        return this.i;
    }

    public void setInspecting(boolean bl) {
        block9: {
            MarkerArea markerArea;
            block7: {
                block8: {
                    boolean bl2;
                    int n;
                    block4: {
                        block5: {
                            block6: {
                                n = j;
                                bl2 = a.isLoggable(Level.FINE);
                                if (n != 0) break block4;
                                if (!bl2) break block5;
                                if (!bl) break block6;
                                a.fine("Inspection started");
                                if (n == 0) break block5;
                            }
                            a.fine("Inspection finished");
                        }
                        this.i = bl;
                        markerArea = this;
                        if (n != 0) break block7;
                        bl2 = markerArea.i;
                    }
                    if (!bl2) break block8;
                    this.h = 0;
                    a.fine("Set minimum mode " + this.h);
                    if (n == 0) break block9;
                }
                markerArea = this;
            }
            markerArea.applyMinimumMode();
        }
        this.repaint();
    }

    public int getMode() {
        return this.g;
    }

    public void setMode(int n) {
        block3: {
            Logger logger;
            block2: {
                logger = a;
                if (j != 0) break block2;
                if (!logger.isLoggable(Level.FINE)) break block3;
                logger = a;
            }
            logger.fine("Set mode " + n);
        }
        this.g = n;
        this.repaint();
    }

    public void applyMinimumMode() {
        this.setMode(this.h);
        this.h = 0;
    }

    public void requireMinimumMode(int n) {
        block8: {
            block6: {
                MarkerArea markerArea;
                int n2;
                block7: {
                    int n3;
                    block5: {
                        n2 = j;
                        n3 = a.isLoggable(Level.FINE);
                        if (n2 == 0) {
                            if (n3 != 0) {
                                a.fine("Requiring minimum mode " + n);
                            }
                            n3 = this.isInspecting();
                        }
                        if (n2 != 0) break block5;
                        if (n3 == 0) break block6;
                        markerArea = this;
                        if (n2 != 0) break block7;
                        n3 = markerArea.h;
                    }
                    if (n3 >= n) break block6;
                    this.h = n;
                    markerArea = this;
                }
                markerArea.setMode(n);
                a.fine("Required minimum mode " + n);
                if (n2 == 0) break block8;
            }
            a.fine("Not required " + n);
        }
    }

    public int getVisualLineCount() {
        return Math.max(this.b.getVisualLineCount(), this.b.getVisibleLines());
    }

    public Color getColor(int n) {
        int n2 = j;
        switch (n) {
            case 1: {
                Color color;
                Color color2 = color = this.b.getStyles().getStyle(12).getStripeColor();
                if (n2 == 0) {
                    if (color2 == null) {
                        return DEFAULT_WARNING_COLOR;
                    }
                    color2 = color;
                }
                return color2;
            }
            case 0: {
                Color color;
                Color color3 = color = this.b.getStyles().getStyle(11).getStripeColor();
                if (n2 == 0) {
                    if (color3 == null) {
                        return DEFAULT_ERROR_COLOR;
                    }
                    color3 = color;
                }
                return color3;
            }
        }
        return null;
    }

    private class b_
    implements DocumentListener,
    FoldingSpanListener {
        private b_() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            try {
                String string = documentEvent.getDocument().getText(documentEvent.getOffset(), documentEvent.getLength());
                if (string.indexOf(10) != -1) {
                    MarkerArea.this.repaint();
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            MarkerArea.this.repaint();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void foldingSpanChanged(FoldingSpanEvent foldingSpanEvent) {
            if (!foldingSpanEvent.isAdjusting()) {
                MarkerArea.this.repaint();
            }
        }
    }
}

