/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.ColorStyle;
import com.jidesoft.editor.EffectStyle;
import com.jidesoft.editor.FontStyle;
import com.jidesoft.editor.KeywordMap;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class SyntaxStyle
implements ColorStyle,
FontStyle,
EffectStyle {
    private int a;
    private Color b;
    private Color c;
    private int d;
    private Color e;
    private Color f;
    private transient Font g;
    private transient Font h;
    private transient FontMetrics i;

    public SyntaxStyle() {
    }

    public SyntaxStyle(Color color, int n) {
        this.b = color;
        this.a = n;
    }

    public SyntaxStyle(int n, Color color) {
        this.d = n;
        this.e = color;
    }

    public SyntaxStyle(int n, Color color, Color color2) {
        this.d = n;
        this.e = color;
        this.f = color2;
    }

    public SyntaxStyle(Color color) {
        this.c = color;
    }

    public SyntaxStyle(Color color, Color color2) {
        this.c = color;
        this.b = color2;
    }

    public SyntaxStyle(Color color, Color color2, Color color3) {
        this.c = color;
        this.b = color2;
        this.f = color3;
    }

    public Color getForeground() {
        return this.b;
    }

    public void setForeground(Color color) {
        this.b = color;
    }

    public int getFontStyle() {
        return this.a;
    }

    public void setFontStyle(int n) {
        this.a = n;
        this.a();
    }

    private void a() {
        this.g = null;
        this.h = null;
        this.i = null;
    }

    public boolean isItalic() {
        boolean bl = this.getFontStyle() & 2;
        if (KeywordMap.c == 0) {
            bl = bl;
        }
        return bl;
    }

    public boolean isBold() {
        boolean bl = this.getFontStyle() & 1;
        if (KeywordMap.c == 0) {
            bl = bl;
        }
        return bl;
    }

    public boolean isPlain() {
        boolean bl = this.getFontStyle();
        if (KeywordMap.c == 0) {
            bl = !bl;
        }
        return bl;
    }

    public Color getBackground() {
        return this.c;
    }

    public void setBackground(Color color) {
        this.c = color;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Color getEffectColor() {
        Color color;
        int n = KeywordMap.c;
        SyntaxStyle syntaxStyle = this;
        if (n == 0) {
            if (syntaxStyle.getEffect() != 0) {
                color = this.e;
                if (n != 0) return color;
                if (color == null) {
                    return Color.RED;
                }
            }
            syntaxStyle = this;
        }
        color = syntaxStyle.e;
        return color;
    }

    public void setEffectColor(Color color) {
        this.e = color;
    }

    public int getEffect() {
        return this.d;
    }

    public void setEffect(int n) {
        this.d = n;
    }

    public Color getStripeColor() {
        return this.f;
    }

    public void setStripeColor(Color color) {
        this.f = color;
    }

    public Font getStyledFont(Font font) {
        int n = KeywordMap.c;
        Font font2 = font;
        if (n == 0) {
            if (font2 == null) {
                throw new NullPointerException("font param must not be null");
            }
            font2 = font;
        }
        if (n == 0) {
            if (font2.equals(this.g)) {
                return this.h;
            }
            this.g = font;
            font2 = this.h = new Font(font.getFamily(), this.getFontStyle(), font.getSize());
        }
        return font2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FontMetrics getFontMetrics(Font font, Graphics graphics) {
        FontMetrics fontMetrics;
        int n = KeywordMap.c;
        Font font2 = font;
        if (n == 0) {
            if (font2 == null) {
                throw new NullPointerException("font param must not be null");
            }
            font2 = font;
        }
        if (font2.equals(this.g)) {
            fontMetrics = this.i;
            if (n != 0) return fontMetrics;
            if (fontMetrics != null) {
                return this.i;
            }
        }
        this.g = font;
        this.h = new Font(font.getFamily(), this.getFontStyle(), font.getSize());
        fontMetrics = this.i = graphics.getFontMetrics(this.h);
        return fontMetrics;
    }

    public void setGraphicsFlags(Graphics graphics, Font font) {
        Font font2 = this.getStyledFont(font);
        graphics.setFont(font2);
        graphics.setColor(this.b);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(this.getClass().getName());
        String string = "[color=";
        if (KeywordMap.c == 0) {
            stringBuilder = stringBuilder.append(string).append(this.b);
            string = this.isItalic() ? ",italic" : "";
        }
        return stringBuilder.append(string).append(this.isBold() ? ",bold" : "").append("]").toString();
    }

    public void paintMarker(Graphics graphics, int n, int n2, int n3, FontMetrics fontMetrics) {
        int n4 = KeywordMap.c;
        Color color = graphics.getColor();
        SyntaxStyle syntaxStyle = this;
        if (n4 == 0) {
            switch (syntaxStyle.getEffect()) {
                case 2: {
                    int n5;
                    graphics.setColor(this.getEffectColor());
                    int n6 = n3 + fontMetrics.getHeight() + 1;
                    for (n5 = n + 3; n5 < n2; n5 += 4) {
                        int n7 = n5 + 2;
                        int n8 = n2 - 1;
                        if (n4 == 0) {
                            if (n7 <= n8) {
                                graphics.drawLine(n5, n6 + 2, n5 + 2, n6);
                            }
                            n7 = n5 + 4;
                            n8 = n2 - 1;
                        }
                        if (n7 > n8) continue;
                        graphics.drawLine(n5 + 3, n6 + 1, n5 + 4, n6 + 2);
                        if (n4 == 0) continue;
                    }
                    if (n4 == 0) break;
                }
                case 1: {
                    graphics.setColor(this.getEffectColor());
                    int n5 = n3 + fontMetrics.getHeight() + 1;
                    graphics.drawLine(n, n5, n2, n5);
                    if (n4 == 0) break;
                }
                case 3: {
                    graphics.setColor(this.getEffectColor());
                    int n9 = n3 + fontMetrics.getLeading() + fontMetrics.getMaxDescent() + fontMetrics.getHeight() / 2 + 1;
                    graphics.drawLine(n, n9, n2, n9);
                    if (n4 == 0) break;
                }
                case 4: {
                    graphics.setColor(this.getEffectColor());
                    graphics.drawRect(n, n3 + fontMetrics.getLeading() + fontMetrics.getMaxDescent(), n2 - n, fontMetrics.getHeight() - 1);
                    break;
                }
            }
            syntaxStyle = this;
        }
        if (syntaxStyle.getBackground() != null) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(n, n3 + fontMetrics.getLeading() + fontMetrics.getMaxDescent(), n2 - n, fontMetrics.getHeight());
        }
        graphics.setColor(color);
    }
}

