/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.KeywordMap;
import com.jidesoft.search.FindAndReplaceTarget;
import com.jidesoft.search.FindResultIntepreter;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class CodeEditorFindAndReplaceTarget
implements FindAndReplaceTarget,
DocumentListener {
    private CodeEditor a;
    private boolean b = false;

    public CodeEditorFindAndReplaceTarget(CodeEditor codeEditor) {
        this.a = codeEditor;
        this.a.getDocument().addDocumentListener(this);
    }

    public FindResultIntepreter getIntepreter() {
        return this.a;
    }

    public CodeEditor getCodeEditor() {
        return this.a;
    }

    public JComponent getConfigurationPanel() {
        return new JLabel("Global");
    }

    public boolean hasNext() {
        return false;
    }

    public void next() {
    }

    public boolean hasPrevious() {
        return false;
    }

    public void previous() {
    }

    public int getCurrentPosition(boolean bl) {
        int n = KeywordMap.c;
        int n2 = this.getCodeEditor().getSelectionModel().hasSelection();
        if (n == 0) {
            if (n2 != 0) {
                int n3 = bl;
                if (n == 0) {
                    n3 = n3 != 0 ? this.getCodeEditor().getSelectionModel().getSelectionEnd() : this.getCodeEditor().getSelectionModel().getSelectionStart();
                }
                return n3;
            }
            n2 = this.getCodeEditor().getCaretModel().getOffset();
        }
        return n2;
    }

    public void highlight(int n, int n2) {
        this.getCodeEditor().select(n, n2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(int n, int n2, String string) throws BadLocationException {
        this.getCodeEditor().getDocument().beginCompoundEdit();
        try {
            this.getCodeEditor().getDocument().remove(n, n2);
            this.getCodeEditor().getDocument().insertString(n, string, null);
            this.getCodeEditor().getCaretModel().setOffset(n + string.length());
        }
        finally {
            this.getCodeEditor().getDocument().endCompoundEdit();
        }
    }

    public Window getPromptDialogParent() {
        return JideSwingUtilities.getWindowForComponent(this.getCodeEditor());
    }

    public Point getPromptDialogLocation() {
        Point point = this.getCodeEditor().getCaretLocation();
        Point point2 = new Point(Math.min(100, this.getCodeEditor().getPainter().getWidth() / 3), point.y + 50);
        SwingUtilities.convertPointToScreen(point2, this.getCodeEditor().getPainter());
        return point2;
    }

    public Point getPromptDialogLocation(int n) {
        Point point = this.getCodeEditor().getCaretLocation();
        Point point2 = new Point(Math.min(100, this.getCodeEditor().getPainter().getWidth() / 3), Math.min(point.y + 50, this.getCodeEditor().getPainter().getHeight() - n - 50));
        SwingUtilities.convertPointToScreen(point2, this.getCodeEditor().getPainter());
        return point2;
    }

    public String getCurrentName() {
        return this.getCodeEditor().getName();
    }

    public String getCurrentText() {
        String string = this.getCodeEditor().getRawText();
        this.setTargetChanged(false);
        return string;
    }

    public void showMessage(String string) {
        this.getCodeEditor().showMessage(string);
    }

    public void replaceAllStarts() {
        this.getCodeEditor().getDocument().beginCompoundEdit();
    }

    public void replaceAllEnds() {
        this.getCodeEditor().getDocument().endCompoundEdit();
    }

    protected void setTargetChanged(boolean bl) {
        this.b = bl;
    }

    public boolean isTargetChanged() {
        return this.b;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.setTargetChanged(true);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.setTargetChanged(true);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }
}

