/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.EntryStruct;
import com.tonicsystems.jarjar.IoUtils;
import com.tonicsystems.jarjar.JarProcessor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;

class StandaloneJarProcessor {
    StandaloneJarProcessor() {
    }

    public static void run(File from, File to, JarProcessor proc) throws IOException {
        JarFile in = new JarFile(from);
        JarOutputStream out = new JarOutputStream(new FileOutputStream(to));
        byte[] buf = new byte[8192];
        EntryStruct struct = new EntryStruct();
        Enumeration<JarEntry> e = in.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            struct.in = in.getInputStream(entry);
            struct.name = entry.getName();
            struct.time = entry.getTime();
            struct.file = from;
            if (!proc.process(struct)) continue;
            entry = new JarEntry(struct.name);
            entry.setTime(struct.time);
            entry.setCompressedSize(-1L);
            out.putNextEntry(entry);
            IoUtils.pipe(struct.in, out, buf);
            struct.in.close();
        }
        out.close();
        out = null;
    }
}

