/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina.initiator;

import edu.emory.mathcs.backport.java.util.concurrent.Future;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.IOException;
import java.net.SocketAddress;
import org.apache.mina.common.CloseFuture;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSession;
import quickfix.Session;
import quickfix.SystemTime;
import quickfix.mina.EventHandlingStrategy;
import quickfix.mina.NetworkingOptions;
import quickfix.mina.ProtocolFactory;
import quickfix.mina.initiator.InitiatorIoHandler;

class IoSessionInitiator {
    private final long reconnectIntervalInMillis;
    private final SocketAddress[] socketAddresses;
    private final IoHandler ioHandler;
    private IoSession ioSession;
    private long lastReconnectAttemptTime = 0L;
    private int nextSocketAddressIndex = 0;
    private Future reconnectFuture;
    private Session quickfixSession;

    public IoSessionInitiator(Session qfSession, SocketAddress[] socketAddresses, long reconnectIntervalInSeconds, ScheduledExecutorService executor, NetworkingOptions networkingOptions, EventHandlingStrategy eventHandlingStrategy) {
        if (socketAddresses.length == 0) {
            throw new IllegalArgumentException("socketAddresses must not be empty");
        }
        this.quickfixSession = qfSession;
        this.socketAddresses = socketAddresses;
        this.reconnectIntervalInMillis = reconnectIntervalInSeconds * 1000L;
        this.ioHandler = new InitiatorIoHandler(qfSession, networkingOptions, eventHandlingStrategy);
        this.reconnectFuture = executor.scheduleWithFixedDelay((Runnable)new ReconnectTask(), 1L, 1L, TimeUnit.SECONDS);
    }

    public synchronized void connect() {
        this.lastReconnectAttemptTime = SystemTime.currentTimeMillis();
        try {
            IoConnector ioConnector = ProtocolFactory.createIoConnector(this.getNextSocketAddress());
            ConnectFuture connectFuture = ioConnector.connect(this.getNextSocketAddress(), this.ioHandler);
            connectFuture.join();
            this.ioSession = connectFuture.getSession();
        }
        catch (Throwable e) {
            this.quickfixSession.getLog().onEvent("Connection failed: " + e.getMessage());
        }
    }

    public void close() throws IOException {
        if (this.reconnectFuture != null) {
            this.reconnectFuture.cancel(true);
        }
        if (this.ioSession != null) {
            CloseFuture closeFuture = this.ioSession.close();
            closeFuture.join();
            this.ioSession = null;
        }
        this.nextSocketAddressIndex = 0;
    }

    private SocketAddress getNextSocketAddress() {
        SocketAddress socketAddress = this.socketAddresses[this.nextSocketAddressIndex];
        this.nextSocketAddressIndex = (this.nextSocketAddressIndex + 1) % this.socketAddresses.length;
        return socketAddress;
    }

    private boolean shouldReconnect() {
        return (this.ioSession == null || !this.ioSession.isConnected()) && this.isTimeForReconnect() && this.quickfixSession.isEnabled() && this.quickfixSession.isSessionTime();
    }

    private boolean isTimeForReconnect() {
        return SystemTime.currentTimeMillis() - this.lastReconnectAttemptTime >= this.reconnectIntervalInMillis;
    }

    private class ReconnectTask
    implements Runnable {
        private ReconnectTask() {
        }

        public void run() {
            if (IoSessionInitiator.this.shouldReconnect()) {
                IoSessionInitiator.this.connect();
            }
        }
    }
}

