/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina.initiator;

import org.apache.mina.common.IoSession;
import quickfix.Message;
import quickfix.Session;
import quickfix.mina.AbstractIoHandler;
import quickfix.mina.EventHandlingStrategy;
import quickfix.mina.IoSessionResponder;
import quickfix.mina.NetworkingOptions;

class InitiatorIoHandler
extends AbstractIoHandler {
    private final Session quickfixSession;
    private final EventHandlingStrategy eventHandlingStrategy;

    public InitiatorIoHandler(Session quickfixSession, NetworkingOptions networkingOptions, EventHandlingStrategy eventHandlingStrategy) {
        super(networkingOptions);
        this.quickfixSession = quickfixSession;
        this.eventHandlingStrategy = eventHandlingStrategy;
    }

    public void sessionCreated(IoSession session) throws Exception {
        super.sessionCreated(session);
        session.setAttribute("QF_SESSION", (Object)this.quickfixSession);
        this.quickfixSession.setResponder(new IoSessionResponder(session));
        this.log.info("MINA session created: " + session.getLocalAddress());
    }

    protected void processMessage(IoSession protocolSession, Message message) throws Exception {
        this.eventHandlingStrategy.onMessage(this.quickfixSession, message);
    }
}

