/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina.initiator;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.mina.common.TransportType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.Application;
import quickfix.ConfigError;
import quickfix.DefaultSessionFactory;
import quickfix.FieldConvertError;
import quickfix.Initiator;
import quickfix.LogFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.Session;
import quickfix.SessionFactory;
import quickfix.SessionID;
import quickfix.SessionSettings;
import quickfix.mina.EventHandlingStrategy;
import quickfix.mina.NetworkingOptions;
import quickfix.mina.ProtocolFactory;
import quickfix.mina.SessionConnector;
import quickfix.mina.initiator.IoSessionInitiator;

public abstract class AbstractSocketInitiator
extends SessionConnector
implements Initiator {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    protected AbstractSocketInitiator(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, LogFactory logFactory, MessageFactory messageFactory) throws ConfigError {
        this(settings, new DefaultSessionFactory(application, messageStoreFactory, logFactory, messageFactory));
    }

    protected AbstractSocketInitiator(SessionSettings settings, SessionFactory sessionFactory) throws ConfigError {
        super(settings, sessionFactory);
        try {
            this.createSessions();
        }
        catch (FieldConvertError e) {
            throw new ConfigError(e);
        }
    }

    protected void initiateSessions(EventHandlingStrategy eventHandlingStrategy) throws ConfigError {
        try {
            Iterator sessionItr = this.getSessionMap().values().iterator();
            while (sessionItr.hasNext()) {
                Session quickfixSession = (Session)sessionItr.next();
                SessionID sessionID = quickfixSession.getSessionID();
                int reconnectingInterval = this.getReconnectIntervalInSeconds(sessionID);
                SocketAddress[] socketAddresses = this.getSocketAddresses(sessionID);
                NetworkingOptions networkingOptions = new NetworkingOptions(this.getSettings().getSessionProperties(sessionID));
                IoSessionInitiator ioSessionInitiator = new IoSessionInitiator(quickfixSession, socketAddresses, reconnectingInterval, this.getScheduledExecutorService(), networkingOptions, eventHandlingStrategy);
                ioSessionInitiator.connect();
            }
            this.startSessionTimer();
        }
        catch (FieldConvertError e) {
            throw new ConfigError(e);
        }
    }

    private void createSessions() throws ConfigError, FieldConvertError {
        SessionSettings settings = this.getSettings();
        boolean continueInitOnError = false;
        if (settings.isSetting("ContinueInitializationOnError")) {
            continueInitOnError = settings.getBool("ContinueInitializationOnError");
        }
        HashMap<SessionID, Session> initiatorSessions = new HashMap<SessionID, Session>();
        Iterator i = settings.sectionIterator();
        while (i.hasNext()) {
            SessionID sessionID = (SessionID)i.next();
            if (!this.isInitiatorSession(sessionID)) continue;
            try {
                Session quickfixSession = this.createSession(sessionID);
                initiatorSessions.put(sessionID, quickfixSession);
            }
            catch (Throwable e) {
                if (continueInitOnError) {
                    this.log.error("error during session initialization, continuing...", e);
                    continue;
                }
                throw e instanceof ConfigError ? (ConfigError)e : new ConfigError("error during session initialization", e);
            }
        }
        if (initiatorSessions.isEmpty()) {
            throw new ConfigError("no initiators in settings");
        }
        this.setSessions(initiatorSessions);
    }

    private int getReconnectIntervalInSeconds(SessionID sessionID) throws ConfigError {
        int reconnectInterval = 30;
        SessionSettings settings = this.getSettings();
        if (settings.isSetting(sessionID, "ReconnectInterval")) {
            try {
                reconnectInterval = (int)settings.getLong(sessionID, "ReconnectInterval");
            }
            catch (FieldConvertError e) {
                throw new ConfigError(e);
            }
        }
        return reconnectInterval;
    }

    private SocketAddress[] getSocketAddresses(SessionID sessionID) throws ConfigError {
        SessionSettings settings = this.getSettings();
        ArrayList<SocketAddress> addresses = new ArrayList<SocketAddress>();
        int index = 0;
        while (true) {
            try {
                String protocolKey = "SocketConnectProtocol" + (index == 0 ? "" : Integer.toString(index));
                String hostKey = "SocketConnectHost" + (index == 0 ? "" : Integer.toString(index));
                String portKey = "SocketConnectPort" + (index == 0 ? "" : Integer.toString(index));
                TransportType transportType = TransportType.SOCKET;
                if (settings.isSetting(sessionID, protocolKey)) {
                    try {
                        transportType = TransportType.getInstance((String)settings.getString(sessionID, protocolKey));
                    }
                    catch (IllegalArgumentException e) {
                        throw new ConfigError(e);
                    }
                }
                if (!settings.isSetting(sessionID, hostKey) || !settings.isSetting(sessionID, portKey)) break;
                String host = settings.getString(sessionID, hostKey);
                int port = (int)settings.getLong(sessionID, portKey);
                addresses.add(ProtocolFactory.createSocketAddress(transportType, host, port));
            }
            catch (FieldConvertError e) {
                throw (ConfigError)new ConfigError(e.getMessage()).initCause(e);
            }
            ++index;
        }
        return addresses.toArray(new SocketAddress[addresses.size()]);
    }

    private boolean isInitiatorSession(Object sectionKey) throws ConfigError, FieldConvertError {
        SessionSettings settings = this.getSettings();
        return !settings.isSetting((SessionID)sectionKey, "ConnectionType") || settings.getString((SessionID)sectionKey, "ConnectionType").equals("initiator");
    }
}

