/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina.acceptor;

import java.util.Map;
import org.apache.mina.common.IoSession;
import quickfix.Log;
import quickfix.Message;
import quickfix.MessageUtils;
import quickfix.Session;
import quickfix.SessionID;
import quickfix.mina.AbstractIoHandler;
import quickfix.mina.EventHandlingStrategy;
import quickfix.mina.IoSessionResponder;
import quickfix.mina.NetworkingOptions;

class AcceptorIoHandler
extends AbstractIoHandler {
    private final Map acceptorSessions;
    private final EventHandlingStrategy eventHandlingStrategy;

    public AcceptorIoHandler(Map acceptorSessions, NetworkingOptions networkingOptions, EventHandlingStrategy eventHandingStrategy) {
        super(networkingOptions);
        this.acceptorSessions = acceptorSessions;
        this.eventHandlingStrategy = eventHandingStrategy;
    }

    public void sessionCreated(IoSession session) throws Exception {
        super.sessionCreated(session);
        this.log.info("MINA session created: " + session.getRemoteAddress());
    }

    protected void processMessage(IoSession protocolSession, Message message) throws Exception {
        SessionID sessionID = MessageUtils.getReverseSessionID(message);
        Session qfSession = (Session)protocolSession.getAttribute("QF_SESSION");
        if (qfSession == null && message.getHeader().getString(35).equals("A")) {
            qfSession = (Session)this.acceptorSessions.get(sessionID);
            Log sessionLog = qfSession.getLog();
            if (qfSession != null) {
                if (qfSession.getResponder() != null) {
                    sessionLog.onEvent("Multiple logons/connections for this session are not allowed");
                    protocolSession.close();
                    return;
                }
                sessionLog.onEvent("Accepting session " + qfSession.getSessionID() + " from " + protocolSession.getRemoteAddress());
                int heartbeatInterval = message.getInt(108);
                qfSession.getState().setHeartBeatInterval(heartbeatInterval);
                sessionLog.onEvent("Acceptor heartbeat set to " + heartbeatInterval + " seconds");
                protocolSession.setAttribute("QF_SESSION", (Object)qfSession);
                qfSession.setResponder(new IoSessionResponder(protocolSession));
            } else {
                this.log.error("Unknown session ID during logon: " + sessionID);
            }
        }
        this.eventHandlingStrategy.onMessage(qfSession, message);
    }
}

