/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina.acceptor;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.TransportType;
import quickfix.Acceptor;
import quickfix.Application;
import quickfix.ConfigError;
import quickfix.DefaultSessionFactory;
import quickfix.FieldConvertError;
import quickfix.LogFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.RuntimeError;
import quickfix.ScreenLogFactory;
import quickfix.Session;
import quickfix.SessionFactory;
import quickfix.SessionID;
import quickfix.SessionSettings;
import quickfix.mina.EventHandlingStrategy;
import quickfix.mina.NetworkingOptions;
import quickfix.mina.ProtocolFactory;
import quickfix.mina.SessionConnector;
import quickfix.mina.acceptor.AcceptorIoHandler;

public abstract class AbstractSocketAcceptor
extends SessionConnector
implements Acceptor {
    private final SessionFactory sessionFactory;
    private IoAcceptor ioAcceptor;
    private SocketAddress acceptorSocketAddress;

    protected AbstractSocketAcceptor(SessionSettings settings, SessionFactory sessionFactory) throws ConfigError {
        super(settings, sessionFactory);
        this.sessionFactory = sessionFactory;
        try {
            this.createSessions(settings);
        }
        catch (FieldConvertError e) {
            throw new ConfigError(e);
        }
    }

    protected AbstractSocketAcceptor(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, MessageFactory messageFactory) throws ConfigError {
        this(application, messageStoreFactory, settings, new ScreenLogFactory(settings), messageFactory);
    }

    protected AbstractSocketAcceptor(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, LogFactory logFactory, MessageFactory messageFactory) throws ConfigError {
        this(settings, new DefaultSessionFactory(application, messageStoreFactory, logFactory, messageFactory));
    }

    protected synchronized void startAcceptingConnections(EventHandlingStrategy eventHandlingStrategy) throws ConfigError {
        try {
            this.startSessionTimer();
            SessionSettings settings = this.getSettings();
            TransportType acceptTransportType = TransportType.SOCKET;
            if (settings.isSetting("SocketAcceptProtocol")) {
                try {
                    acceptTransportType = TransportType.getInstance((String)settings.getString("SocketAcceptProtocol"));
                }
                catch (IllegalArgumentException e) {
                    throw new ConfigError(e);
                }
            }
            int acceptPort = this.getIntSetting("SocketAcceptPort");
            String acceptHost = null;
            if (settings.isSetting("SocketAcceptAddress")) {
                acceptHost = settings.getString("SocketAcceptAddress");
            }
            this.acceptorSocketAddress = ProtocolFactory.createSocketAddress(acceptTransportType, acceptHost, acceptPort);
            this.ioAcceptor = ProtocolFactory.createIoAcceptor(this.acceptorSocketAddress);
            this.ioAcceptor.bind(this.acceptorSocketAddress, (IoHandler)new AcceptorIoHandler(this.getSessionMap(), new NetworkingOptions(settings.getDefaultProperties()), eventHandlingStrategy));
            this.log.info("listening for connections at " + this.acceptorSocketAddress);
        }
        catch (FieldConvertError e) {
            throw new ConfigError(e);
        }
        catch (IOException e) {
            throw new RuntimeError(e);
        }
    }

    private void createSessions(SessionSettings settings) throws ConfigError, FieldConvertError {
        HashMap<SessionID, Session> acceptorSessions = new HashMap<SessionID, Session>();
        Iterator i = settings.sectionIterator();
        while (i.hasNext()) {
            Object sectionKey = i.next();
            SessionID sessionID = (SessionID)sectionKey;
            String connectionType = settings.getString(sessionID, "ConnectionType");
            if (!connectionType.equals("acceptor")) continue;
            acceptorSessions.put(sessionID, this.sessionFactory.create(sessionID, settings));
        }
        this.setSessions(acceptorSessions);
        if (acceptorSessions.size() == 0) {
            throw new ConfigError("No acceptor sessions found in settings.");
        }
    }

    protected void stopAcceptingConnections() {
        this.log.info("No longer accepting connections on " + this.acceptorSocketAddress);
        this.ioAcceptor.unbind(this.acceptorSocketAddress);
        this.acceptorSocketAddress = null;
    }
}

