/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.TransportType;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketConnector;
import org.apache.mina.transport.vmpipe.VmPipeAcceptor;
import org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.apache.mina.transport.vmpipe.VmPipeConnector;
import quickfix.ConfigError;

public class ProtocolFactory {
    public static SocketAddress createSocketAddress(TransportType transportType, String host, int port) throws ConfigError {
        if (transportType == TransportType.SOCKET) {
            return host != null ? new InetSocketAddress(host, port) : new InetSocketAddress(port);
        }
        if (transportType == TransportType.VM_PIPE) {
            return new VmPipeAddress(port);
        }
        throw new ConfigError("Unknown session transport type: " + transportType);
    }

    public static IoAcceptor createIoAcceptor(SocketAddress address) throws ConfigError {
        if (address instanceof InetSocketAddress) {
            return new SocketAcceptor();
        }
        if (address instanceof VmPipeAddress) {
            return new VmPipeAcceptor();
        }
        throw new ConfigError("Unknown session acceptor address type: " + address.getClass().getName());
    }

    public static IoConnector createIoConnector(SocketAddress address) throws ConfigError {
        if (address instanceof InetSocketAddress) {
            return new SocketConnector();
        }
        if (address instanceof VmPipeAddress) {
            return new VmPipeConnector();
        }
        throw new ConfigError("Unknown session acceptor address type: " + address.getClass().getName());
    }
}

