/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina;

import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.transport.socket.nio.SocketSessionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.FieldConvertError;
import quickfix.field.converter.BooleanConverter;
import quickfix.field.converter.IntConverter;

public class NetworkingOptions {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Boolean keepAlive;
    private Boolean oobInline;
    private Integer receiveBufferSize;
    private Boolean reuseAddress;
    private Integer sendBufferSize;
    private Integer soLinger;
    private Boolean tcpNoDelay;
    private Integer trafficClass;
    public static final String SETTING_SOCKET_KEEPALIVE = "SocketKeepAlive";
    public static final String SETTING_SOCKET_OOBINLINE = "SocketOobInline";
    public static final String SETTING_SOCKET_RECEIVE_BUFFER_SIZE = "SocketReceiveBufferSize";
    public static final String SETTING_SOCKET_REUSE_ADDRESS = "SocketReuseAddress";
    public static final String SETTING_SOCKET_SEND_BUFFER_SIZE = "SocketSendBufferSize";
    public static final String SETTING_SOCKET_LINGER = "SocketLinger";
    public static final String SETTING_SOCKET_TCP_NODELAY = "SocketTcpNoDelay";
    public static final String SETTING_SOCKET_TRAFFIC_CLASS = "SocketTrafficClass";
    public static final String IPTOC_LOWCOST = "IPTOS_LOWCOST";
    public static final String IPTOC_RELIABILITY = "IPTOS_RELIABILITY";
    public static final String IPTOC_THROUGHPUT = "IPTOS_THROUGHPUT";
    public static final String IPTOC_LOWDELAY = "IPTOS_LOWDELAY";
    public static final Map trafficClasses = new HashMap();

    public NetworkingOptions(Properties properties) throws FieldConvertError {
        this.keepAlive = this.getBoolean(properties, SETTING_SOCKET_KEEPALIVE);
        this.oobInline = this.getBoolean(properties, SETTING_SOCKET_OOBINLINE);
        this.receiveBufferSize = this.getInteger(properties, SETTING_SOCKET_RECEIVE_BUFFER_SIZE);
        this.reuseAddress = this.getBoolean(properties, SETTING_SOCKET_REUSE_ADDRESS);
        this.sendBufferSize = this.getInteger(properties, SETTING_SOCKET_SEND_BUFFER_SIZE);
        this.soLinger = this.getInteger(properties, SETTING_SOCKET_LINGER);
        this.tcpNoDelay = this.getBoolean(properties, SETTING_SOCKET_TCP_NODELAY);
        try {
            this.trafficClass = this.getInteger(properties, SETTING_SOCKET_TRAFFIC_CLASS);
        }
        catch (FieldConvertError e) {
            String trafficClassEnumString = properties.getProperty(SETTING_SOCKET_TRAFFIC_CLASS);
            int trafficClassBits = 0;
            String[] trafficClassEnums = trafficClassEnumString.split("[,|]");
            for (int i = 0; i < trafficClassEnums.length; ++i) {
                if (trafficClasses.containsKey(trafficClassEnums[i])) {
                    trafficClassBits |= ((Integer)trafficClasses.get(trafficClassEnums[i])).intValue();
                    continue;
                }
                throw new FieldConvertError("Can't parse traffic class: " + trafficClassEnums[i]);
            }
            this.trafficClass = new Integer(trafficClassBits);
            this.log.info("Socket option: SocketTrafficClass= 0x" + Integer.toHexString(trafficClassBits) + " (" + trafficClassEnumString + ")");
        }
    }

    private Boolean getBoolean(Properties properties, String key) throws FieldConvertError {
        Boolean value = properties.containsKey(key) ? new Boolean(BooleanConverter.convert(properties.getProperty(key))) : null;
        this.logOption(key, value);
        return value;
    }

    private void logOption(String key, Object value) {
        if (value != null) {
            this.log.info("Socket option: " + key + "=" + value);
        }
    }

    private Integer getInteger(Properties properties, String key) throws FieldConvertError {
        Integer value = properties.containsKey(key) ? new Integer(IntConverter.convert(properties.getProperty(key))) : null;
        this.logOption(key, value);
        return value;
    }

    public void apply(IoSession session) throws SocketException {
        IoSessionConfig sessionConfig = session.getConfig();
        if (sessionConfig instanceof SocketSessionConfig) {
            SocketSessionConfig socketSessionConfig = (SocketSessionConfig)sessionConfig;
            if (this.keepAlive != null) {
                socketSessionConfig.setKeepAlive(this.keepAlive.booleanValue());
            }
            if (this.oobInline != null) {
                socketSessionConfig.setOobInline(this.oobInline.booleanValue());
            }
            if (this.receiveBufferSize != null) {
                socketSessionConfig.setReceiveBufferSize(this.receiveBufferSize.intValue());
            }
            if (this.reuseAddress != null) {
                socketSessionConfig.setReuseAddress(this.reuseAddress.booleanValue());
            }
            if (this.sendBufferSize != null) {
                socketSessionConfig.setSendBufferSize(this.sendBufferSize.intValue());
            }
            if (this.soLinger != null) {
                int linger = this.soLinger;
                socketSessionConfig.setSoLinger(linger);
            }
            if (this.tcpNoDelay != null) {
                socketSessionConfig.setTcpNoDelay(this.tcpNoDelay.booleanValue());
            }
            if (this.trafficClass != null) {
                socketSessionConfig.setTrafficClass(this.trafficClass.intValue());
            }
        }
    }

    static {
        trafficClasses.put(IPTOC_LOWCOST, new Integer(2));
        trafficClasses.put(IPTOC_RELIABILITY, new Integer(4));
        trafficClasses.put(IPTOC_THROUGHPUT, new Integer(8));
        trafficClasses.put(IPTOC_LOWDELAY, new Integer(16));
    }
}

