/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina;

import java.io.IOException;
import java.net.SocketAddress;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecException;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.ProtocolDecoderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.DataDictionary;
import quickfix.InvalidMessage;
import quickfix.LogUtil;
import quickfix.Message;
import quickfix.MessageFactory;
import quickfix.MessageUtils;
import quickfix.Session;
import quickfix.SessionID;
import quickfix.mina.CriticalProtocolCodecException;
import quickfix.mina.NetworkingOptions;
import quickfix.mina.message.FIXProtocolCodecFactory;

public abstract class AbstractIoHandler
extends IoHandlerAdapter {
    private static final FIXProtocolCodecFactory CODEC = new FIXProtocolCodecFactory();
    protected Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final NetworkingOptions networkingOptions;

    public AbstractIoHandler(NetworkingOptions options) {
        this.networkingOptions = options;
    }

    public void exceptionCaught(IoSession ioSession, Throwable cause) throws Exception {
        boolean disconnectNeeded = false;
        Session quickFixSession = this.findQFSession(ioSession);
        if (cause instanceof ProtocolDecoderException && cause.getCause() != null) {
            cause = cause.getCause();
        }
        if (cause instanceof IOException) {
            SocketAddress remoteAddress = ioSession.getRemoteAddress();
            String message = cause.getMessage();
            this.log.error("socket exception (" + remoteAddress + "): " + message);
            disconnectNeeded = true;
        } else if (cause instanceof CriticalProtocolCodecException) {
            disconnectNeeded = true;
        } else if (cause instanceof ProtocolCodecException) {
            String text = "protocol handler exception: " + cause.getMessage();
            if (quickFixSession != null) {
                quickFixSession.getLog().onEvent(text);
            } else {
                this.log.error(text);
            }
        } else if (quickFixSession != null) {
            LogUtil.logThrowable(quickFixSession.getLog(), cause.getMessage(), cause);
        } else {
            this.log.error("protocol handler exception", cause);
        }
        if (disconnectNeeded) {
            if (quickFixSession != null) {
                quickFixSession.disconnect();
            } else {
                ioSession.close();
            }
        }
    }

    public void sessionCreated(IoSession ioSession) throws Exception {
        super.sessionCreated(ioSession);
        this.networkingOptions.apply(ioSession);
        ioSession.getFilterChain().addFirst("protocolCodecFilter", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)CODEC));
    }

    public void sessionClosed(IoSession ioSession) throws Exception {
        Session quickFixSession = this.findQFSession(ioSession);
        if (quickFixSession != null) {
            ioSession.removeAttribute("QF_SESSION");
            if (quickFixSession.getResponder() != null) {
                quickFixSession.disconnect();
            }
        }
    }

    public void messageReceived(IoSession ioSession, Object message) throws Exception {
        String messageString = (String)message;
        SessionID remoteSessionID = MessageUtils.getReverseSessionID(messageString);
        Session quickFixSession = this.findQFSession(ioSession, remoteSessionID);
        if (quickFixSession != null) {
            quickFixSession.getLog().onIncoming(messageString);
            MessageFactory messageFactory = quickFixSession.getMessageFactory();
            DataDictionary dataDictionary = quickFixSession.getDataDictionary();
            try {
                Message fixMessage = MessageUtils.parse(messageFactory, dataDictionary, messageString);
                this.processMessage(ioSession, fixMessage);
            }
            catch (InvalidMessage e) {
                this.log.error("Invalid message: " + e.getMessage());
            }
        } else {
            this.log.error("Disconnecting; received message for unknown session: " + messageString);
            ioSession.close();
        }
    }

    private Session findQFSession(IoSession protocolSession, SessionID sessionID) {
        Session quickfixSession = this.findQFSession(protocolSession);
        if (quickfixSession == null) {
            quickfixSession = Session.lookupSession(sessionID);
        }
        return quickfixSession;
    }

    private Session findQFSession(IoSession protocolSession) {
        return (Session)protocolSession.getAttribute("QF_SESSION");
    }

    protected abstract void processMessage(IoSession var1, Message var2) throws Exception;
}

