/*
 * Decompiled with CFR 0.152.
 */
package quickfix.examples.banzai.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import quickfix.examples.banzai.BanzaiApplication;
import quickfix.examples.banzai.DoubleNumberTextField;
import quickfix.examples.banzai.IntegerNumberTextField;
import quickfix.examples.banzai.Order;

public class CancelReplacePanel
extends JPanel {
    private JLabel quantityLabel = new JLabel("Quantity");
    private JLabel limitPriceLabel = new JLabel("Limit");
    private IntegerNumberTextField quantityTextField = new IntegerNumberTextField();
    private DoubleNumberTextField limitPriceTextField = new DoubleNumberTextField();
    private JButton cancelButton = new JButton("Cancel");
    private JButton replaceButton = new JButton("Replace");
    private Order order = null;
    private GridBagConstraints constraints = new GridBagConstraints();
    private BanzaiApplication application;

    public CancelReplacePanel(BanzaiApplication application) {
        this.application = application;
        this.cancelButton.addActionListener(new CancelListener());
        this.replaceButton.addActionListener(new ReplaceListener());
        this.setLayout(new GridBagLayout());
        this.createComponents();
    }

    public void addActionListener(ActionListener listener) {
        this.cancelButton.addActionListener(listener);
        this.replaceButton.addActionListener(listener);
    }

    private void createComponents() {
        this.constraints.fill = 1;
        this.constraints.weightx = 1.0;
        int x = 0;
        int y = 0;
        this.constraints.insets = new Insets(0, 0, 5, 5);
        this.add(this.cancelButton, x, y);
        this.add(this.replaceButton, ++x, y);
        this.constraints.weightx = 0.0;
        this.add(this.quantityLabel, ++x, y);
        this.constraints.weightx = 5.0;
        this.add(this.quantityTextField, ++x, y);
        this.constraints.weightx = 0.0;
        this.add(this.limitPriceLabel, ++x, y);
        this.constraints.weightx = 5.0;
        this.add(this.limitPriceTextField, ++x, y);
    }

    public void setEnabled(boolean enabled) {
        this.cancelButton.setEnabled(enabled);
        this.replaceButton.setEnabled(enabled);
        this.quantityTextField.setEnabled(enabled);
        this.limitPriceTextField.setEnabled(enabled);
        Color labelColor = enabled ? Color.black : Color.gray;
        Color bgColor = enabled ? Color.white : Color.gray;
        this.quantityTextField.setBackground(bgColor);
        this.limitPriceTextField.setBackground(bgColor);
        this.quantityLabel.setForeground(labelColor);
        this.limitPriceLabel.setForeground(labelColor);
    }

    public void update() {
        this.setOrder(this.order);
    }

    public void setOrder(Order order) {
        if (order == null) {
            return;
        }
        this.order = order;
        this.quantityTextField.setText(new Integer(order.getOpen()).toString());
        Double limit = order.getLimit();
        if (limit != null) {
            this.limitPriceTextField.setText(order.getLimit().toString());
        }
        this.setEnabled(order.getOpen() > 0);
    }

    private JComponent add(JComponent component, int x, int y) {
        this.constraints.gridx = x;
        this.constraints.gridy = y;
        this.add((Component)component, this.constraints);
        return component;
    }

    private class ReplaceListener
    implements ActionListener {
        private ReplaceListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Order newOrder = (Order)CancelReplacePanel.this.order.clone();
            newOrder.setQuantity(Integer.parseInt(CancelReplacePanel.this.quantityTextField.getText()));
            newOrder.setLimit(new Double(CancelReplacePanel.this.limitPriceTextField.getText()));
            newOrder.setRejected(false);
            newOrder.setCanceled(false);
            newOrder.setOpen(0);
            newOrder.setExecuted(0);
            CancelReplacePanel.this.application.replace(CancelReplacePanel.this.order, newOrder);
        }
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        public void actionPerformed(ActionEvent e) {
            CancelReplacePanel.this.application.cancel(CancelReplacePanel.this.order);
        }
    }
}

