/*
 * Decompiled with CFR 0.152.
 */
package quickfix.examples.banzai.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import quickfix.examples.banzai.Banzai;
import quickfix.examples.banzai.BanzaiApplication;
import quickfix.examples.banzai.ExecutionTableModel;
import quickfix.examples.banzai.OrderTableModel;
import quickfix.examples.banzai.ui.BanzaiPanel;

public class BanzaiFrame
extends JFrame {
    public BanzaiFrame(OrderTableModel orderTableModel, ExecutionTableModel executionTableModel, BanzaiApplication application) {
        this.setTitle("Banzai!");
        this.setSize(600, 400);
        if (System.getProperties().containsKey("openfix")) {
            this.createMenuBar(application);
        }
        this.getContentPane().add((Component)new BanzaiPanel(orderTableModel, executionTableModel, application), "Center");
        this.setVisible(true);
    }

    private void createMenuBar(final BanzaiApplication application) {
        JMenuBar menubar = new JMenuBar();
        JMenu sessionMenu = new JMenu("Session");
        menubar.add(sessionMenu);
        JMenuItem logonItem = new JMenuItem("Logon");
        logonItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Banzai.get().logon();
            }
        });
        sessionMenu.add(logonItem);
        JMenuItem logoffItem = new JMenuItem("Logoff");
        logoffItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Banzai.get().logout();
            }
        });
        sessionMenu.add(logoffItem);
        JMenu appMenu = new JMenu("Application");
        menubar.add(appMenu);
        JCheckBoxMenuItem appAvailableItem = new JCheckBoxMenuItem("Available");
        appAvailableItem.setSelected(application.isAvailable());
        appAvailableItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                application.setAvailable(((JCheckBoxMenuItem)e.getSource()).isSelected());
            }
        });
        appMenu.add(appAvailableItem);
        JCheckBoxMenuItem sendMissingFieldRejectItem = new JCheckBoxMenuItem("Send Missing Field Reject");
        sendMissingFieldRejectItem.setSelected(application.isMissingField());
        sendMissingFieldRejectItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                application.setMissingField(((JCheckBoxMenuItem)e.getSource()).isSelected());
            }
        });
        appMenu.add(sendMissingFieldRejectItem);
        this.setJMenuBar(menubar);
    }
}

