/*
 * Decompiled with CFR 0.152.
 */
package quickfix.examples.banzai;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Observable;
import java.util.Observer;
import javax.swing.SwingUtilities;
import quickfix.Application;
import quickfix.DefaultMessageFactory;
import quickfix.DoNotSend;
import quickfix.FieldNotFound;
import quickfix.IncorrectDataFormat;
import quickfix.IncorrectTagValue;
import quickfix.Message;
import quickfix.RejectLogon;
import quickfix.Session;
import quickfix.SessionID;
import quickfix.SessionNotFound;
import quickfix.UnsupportedMessageType;
import quickfix.examples.banzai.Execution;
import quickfix.examples.banzai.ExecutionTableModel;
import quickfix.examples.banzai.LogonEvent;
import quickfix.examples.banzai.Order;
import quickfix.examples.banzai.OrderSide;
import quickfix.examples.banzai.OrderTIF;
import quickfix.examples.banzai.OrderTableModel;
import quickfix.examples.banzai.OrderType;
import quickfix.examples.banzai.TwoWayMap;
import quickfix.field.AvgPx;
import quickfix.field.ClOrdID;
import quickfix.field.CumQty;
import quickfix.field.CxlType;
import quickfix.field.ExecID;
import quickfix.field.HandlInst;
import quickfix.field.LastPx;
import quickfix.field.LastShares;
import quickfix.field.LeavesQty;
import quickfix.field.LocateReqd;
import quickfix.field.MsgType;
import quickfix.field.OrdStatus;
import quickfix.field.OrdType;
import quickfix.field.OrderQty;
import quickfix.field.OrigClOrdID;
import quickfix.field.Price;
import quickfix.field.Side;
import quickfix.field.StopPx;
import quickfix.field.Symbol;
import quickfix.field.Text;
import quickfix.field.TimeInForce;
import quickfix.field.TransactTime;
import quickfix.fix41.NewOrderSingle;
import quickfix.fix41.OrderCancelReplaceRequest;
import quickfix.fix41.OrderCancelRequest;

public class BanzaiApplication
implements Application {
    private DefaultMessageFactory messageFactory = new DefaultMessageFactory();
    private OrderTableModel orderTableModel = null;
    private ExecutionTableModel executionTableModel = null;
    private ObservableOrder observableOrder = new ObservableOrder();
    private ObservableLogon observableLogon = new ObservableLogon();
    private boolean isAvailable = true;
    private boolean isMissingField;
    private static TwoWayMap sideMap = new TwoWayMap();
    private static TwoWayMap typeMap = new TwoWayMap();
    private static TwoWayMap tifMap = new TwoWayMap();
    private static HashMap execIDs = new HashMap();

    public BanzaiApplication(OrderTableModel orderTableModel, ExecutionTableModel executionTableModel) {
        this.orderTableModel = orderTableModel;
        this.executionTableModel = executionTableModel;
    }

    public void onCreate(SessionID sessionID) {
    }

    public void onLogon(SessionID sessionID) {
        this.observableLogon.logon(sessionID);
    }

    public void onLogout(SessionID sessionID) {
        this.observableLogon.logoff(sessionID);
    }

    public void toAdmin(Message message, SessionID sessionID) {
    }

    public void toApp(Message message, SessionID sessionID) throws DoNotSend {
    }

    public void fromAdmin(Message message, SessionID sessionID) throws FieldNotFound, IncorrectDataFormat, IncorrectTagValue, RejectLogon {
    }

    public void fromApp(Message message, SessionID sessionID) throws FieldNotFound, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType {
        try {
            SwingUtilities.invokeLater(new doFromApp(message, sessionID));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sendSessionReject(Message message, int rejectReason) throws FieldNotFound, SessionNotFound {
        Message reply = this.createMessage(message, "3");
        this.reverseRoute(message, reply);
        String refSeqNum = message.getHeader().getString(34);
        reply.setString(45, refSeqNum);
        reply.setString(372, message.getHeader().getString(35));
        reply.setInt(373, rejectReason);
        Session.sendToTarget(reply);
    }

    private void sendBusinessReject(Message message, int rejectReason, String rejectText) throws FieldNotFound, SessionNotFound {
        Message reply = this.createMessage(message, "j");
        this.reverseRoute(message, reply);
        String refSeqNum = message.getHeader().getString(34);
        reply.setString(45, refSeqNum);
        reply.setString(372, message.getHeader().getString(35));
        reply.setInt(380, rejectReason);
        reply.setString(58, rejectText);
        Session.sendToTarget(reply);
    }

    private Message createMessage(Message message, String msgType) throws FieldNotFound {
        return this.messageFactory.create(message.getHeader().getString(8), msgType);
    }

    private void reverseRoute(Message message, Message reply) throws FieldNotFound {
        reply.getHeader().setString(49, message.getHeader().getString(56));
        reply.getHeader().setString(56, message.getHeader().getString(49));
    }

    private void executionReport(Message message, SessionID sessionID) throws FieldNotFound {
        ExecID execID = (ExecID)message.getField(new ExecID());
        if (this.alreadyProcessed(execID, sessionID)) {
            return;
        }
        String id = message.getField(new ClOrdID()).getValue();
        Order order = this.orderTableModel.getOrder(id);
        if (order == null) {
            return;
        }
        LastShares lastShares = new LastShares(0.0);
        try {
            OrderQty orderQty = (OrderQty)message.getField(new OrderQty());
            int diff = order.getQuantity() - (int)orderQty.getValue();
            order.setQuantity((int)orderQty.getValue());
            order.setOpen(order.getOpen() - diff);
        }
        catch (FieldNotFound e) {
            // empty catch block
        }
        try {
            Price price = (Price)message.getField(new Price());
            order.setLimit(new Double(price.getValue()));
        }
        catch (FieldNotFound e) {
            // empty catch block
        }
        try {
            message.getField(lastShares);
        }
        catch (FieldNotFound e) {
            // empty catch block
        }
        if (lastShares.getValue() > 0.0) {
            order.setExecuted((int)message.getField(new CumQty()).getValue());
            order.setAvgPx(message.getField(new AvgPx()).getValue());
        }
        OrdStatus ordStatus = (OrdStatus)message.getField(new OrdStatus());
        try {
            order.setOpen((int)message.getField(new LeavesQty()).getValue());
        }
        catch (FieldNotFound e) {
            if (ordStatus.valueEquals('8') || ordStatus.valueEquals('4')) {
                order.setOpen(0);
            } else if (ordStatus.valueEquals('0') && order.isNew()) {
                order.setOpen(order.getQuantity());
                order.setNew(false);
            }
            order.setOpen(order.getOpen() - (int)lastShares.getValue());
        }
        if (ordStatus.valueEquals('8')) {
            order.setRejected(true);
        } else if (ordStatus.valueEquals('4') || ordStatus.valueEquals('3')) {
            order.setCanceled(true);
        }
        try {
            order.setMessage(message.getField(new Text()).getValue());
        }
        catch (FieldNotFound e) {
            order.setMessage(null);
        }
        this.orderTableModel.updateOrder(order, id);
        this.observableOrder.update(order);
        if (lastShares.getValue() > 0.0) {
            Execution execution = new Execution();
            execution.setExchangeID(sessionID + message.getField(new ExecID()).getValue());
            execution.setSymbol(message.getField(new Symbol()).getValue());
            execution.setQuantity((int)lastShares.getValue());
            execution.setPrice(message.getField(new LastPx()).getValue());
            Side side = (Side)message.getField(new Side());
            execution.setSide(this.FIXSideToSide(side));
            this.executionTableModel.addExecution(execution);
        }
    }

    private void cancelReject(Message message, SessionID sessionID) throws FieldNotFound {
        String id = message.getField(new ClOrdID()).getValue();
        Order order = this.orderTableModel.getOrder(id);
        if (order == null) {
            return;
        }
        if (order.getOriginalID() != null) {
            order = this.orderTableModel.getOrder(order.getOriginalID());
        }
        try {
            order.setMessage(message.getField(new Text()).getValue());
        }
        catch (FieldNotFound e) {
            // empty catch block
        }
        this.orderTableModel.updateOrder(order, order.getID());
    }

    private boolean alreadyProcessed(ExecID execID, SessionID sessionID) {
        HashSet<ExecID> set = (HashSet<ExecID>)execIDs.get(sessionID);
        if (set == null) {
            set = new HashSet<ExecID>();
            set.add(execID);
            execIDs.put(sessionID, set);
            return false;
        }
        if (set.contains(execID)) {
            return true;
        }
        set.add(execID);
        return false;
    }

    private void send(Message message, SessionID sessionID) {
        try {
            Session.sendToTarget(message, sessionID);
        }
        catch (SessionNotFound e) {
            System.out.println(e);
        }
    }

    public void send(Order order) {
        String beginString = order.getSessionID().getBeginString();
        if (beginString.equals("FIX.4.0")) {
            this.send40(order);
        } else if (beginString.equals("FIX.4.1")) {
            this.send41(order);
        } else if (beginString.equals("FIX.4.2")) {
            this.send42(order);
        }
    }

    public void send40(Order order) {
        quickfix.fix40.NewOrderSingle newOrderSingle = new quickfix.fix40.NewOrderSingle(new ClOrdID(order.getID()), new HandlInst('1'), new Symbol(order.getSymbol()), this.sideToFIXSide(order.getSide()), new OrderQty((double)order.getQuantity()), this.typeToFIXType(order.getType()));
        this.send(this.populateOrder(order, newOrderSingle), order.getSessionID());
    }

    public void send41(Order order) {
        NewOrderSingle newOrderSingle = new NewOrderSingle(new ClOrdID(order.getID()), new HandlInst('1'), new Symbol(order.getSymbol()), this.sideToFIXSide(order.getSide()), this.typeToFIXType(order.getType()));
        newOrderSingle.set(new OrderQty((double)order.getQuantity()));
        this.send(this.populateOrder(order, newOrderSingle), order.getSessionID());
    }

    public void send42(Order order) {
        quickfix.fix42.NewOrderSingle newOrderSingle = new quickfix.fix42.NewOrderSingle(new ClOrdID(order.getID()), new HandlInst('1'), new Symbol(order.getSymbol()), this.sideToFIXSide(order.getSide()), new TransactTime(), this.typeToFIXType(order.getType()));
        newOrderSingle.set(new OrderQty((double)order.getQuantity()));
        this.send(this.populateOrder(order, newOrderSingle), order.getSessionID());
    }

    public Message populateOrder(Order order, Message newOrderSingle) {
        OrderType type = order.getType();
        if (type == OrderType.LIMIT) {
            newOrderSingle.setField(new Price(order.getLimit()));
        } else if (type == OrderType.STOP) {
            newOrderSingle.setField(new StopPx(order.getStop()));
        } else if (type == OrderType.STOP_LIMIT) {
            newOrderSingle.setField(new Price(order.getLimit()));
            newOrderSingle.setField(new StopPx(order.getStop()));
        }
        if (order.getSide() == OrderSide.SHORT_SELL || order.getSide() == OrderSide.SHORT_SELL_EXEMPT) {
            newOrderSingle.setField(new LocateReqd(false));
        }
        newOrderSingle.setField(this.tifToFIXTif(order.getTIF()));
        return newOrderSingle;
    }

    public void cancel(Order order) {
        String beginString = order.getSessionID().getBeginString();
        if (beginString.equals("FIX.4.0")) {
            this.cancel40(order);
        } else if (beginString.equals("FIX.4.1")) {
            this.cancel41(order);
        } else if (beginString.equals("FIX.4.2")) {
            this.cancel42(order);
        }
    }

    public void cancel40(Order order) {
        String id = order.generateID();
        quickfix.fix40.OrderCancelRequest message = new quickfix.fix40.OrderCancelRequest(new OrigClOrdID(order.getID()), new ClOrdID(id), new CxlType('F'), new Symbol(order.getSymbol()), this.sideToFIXSide(order.getSide()), new OrderQty((double)order.getQuantity()));
        this.orderTableModel.addID(order, id);
        this.send(message, order.getSessionID());
    }

    public void cancel41(Order order) {
        String id = order.generateID();
        OrderCancelRequest message = new OrderCancelRequest(new OrigClOrdID(order.getID()), new ClOrdID(id), new Symbol(order.getSymbol()), this.sideToFIXSide(order.getSide()));
        message.setField(new OrderQty((double)order.getQuantity()));
        this.orderTableModel.addID(order, id);
        this.send(message, order.getSessionID());
    }

    public void cancel42(Order order) {
        String id = order.generateID();
        quickfix.fix42.OrderCancelRequest message = new quickfix.fix42.OrderCancelRequest(new OrigClOrdID(order.getID()), new ClOrdID(id), new Symbol(order.getSymbol()), this.sideToFIXSide(order.getSide()), new TransactTime());
        message.setField(new OrderQty((double)order.getQuantity()));
        this.orderTableModel.addID(order, id);
        this.send(message, order.getSessionID());
    }

    public void replace(Order order, Order newOrder) {
        String beginString = order.getSessionID().getBeginString();
        if (beginString.equals("FIX.4.0")) {
            this.replace40(order, newOrder);
        } else if (beginString.equals("FIX.4.1")) {
            this.replace41(order, newOrder);
        } else if (beginString.equals("FIX.4.2")) {
            this.replace42(order, newOrder);
        }
    }

    public void replace40(Order order, Order newOrder) {
        quickfix.fix40.OrderCancelReplaceRequest message = new quickfix.fix40.OrderCancelReplaceRequest(new OrigClOrdID(order.getID()), new ClOrdID(newOrder.getID()), new HandlInst('1'), new Symbol(order.getSymbol()), this.sideToFIXSide(order.getSide()), new OrderQty((double)newOrder.getQuantity()), this.typeToFIXType(order.getType()));
        this.orderTableModel.addID(order, newOrder.getID());
        this.send(this.populateCancelReplace(order, newOrder, message), order.getSessionID());
    }

    public void replace41(Order order, Order newOrder) {
        OrderCancelReplaceRequest message = new OrderCancelReplaceRequest(new OrigClOrdID(order.getID()), new ClOrdID(newOrder.getID()), new HandlInst('1'), new Symbol(order.getSymbol()), this.sideToFIXSide(order.getSide()), this.typeToFIXType(order.getType()));
        this.orderTableModel.addID(order, newOrder.getID());
        this.send(this.populateCancelReplace(order, newOrder, message), order.getSessionID());
    }

    public void replace42(Order order, Order newOrder) {
        quickfix.fix42.OrderCancelReplaceRequest message = new quickfix.fix42.OrderCancelReplaceRequest(new OrigClOrdID(order.getID()), new ClOrdID(newOrder.getID()), new HandlInst('1'), new Symbol(order.getSymbol()), this.sideToFIXSide(order.getSide()), new TransactTime(), this.typeToFIXType(order.getType()));
        this.orderTableModel.addID(order, newOrder.getID());
        this.send(this.populateCancelReplace(order, newOrder, message), order.getSessionID());
    }

    Message populateCancelReplace(Order order, Order newOrder, Message message) {
        if (order.getQuantity() != newOrder.getQuantity()) {
            message.setField(new OrderQty((double)newOrder.getQuantity()));
        }
        if (order.getLimit() != newOrder.getLimit()) {
            message.setField(new Price(newOrder.getLimit()));
        }
        return message;
    }

    public Side sideToFIXSide(OrderSide side) {
        return (Side)sideMap.getFirst(side);
    }

    public OrderSide FIXSideToSide(Side side) {
        return (OrderSide)sideMap.getSecond(side);
    }

    public OrdType typeToFIXType(OrderType type) {
        return (OrdType)typeMap.getFirst(type);
    }

    public OrderType FIXTypeToType(OrdType type) {
        return (OrderType)typeMap.getSecond(type);
    }

    public TimeInForce tifToFIXTif(OrderTIF tif) {
        return (TimeInForce)tifMap.getFirst(tif);
    }

    public OrderTIF FIXTifToTif(TimeInForce tif) {
        return (OrderTIF)typeMap.getSecond(tif);
    }

    public void addLogonObserver(Observer observer) {
        this.observableLogon.addObserver(observer);
    }

    public void deleteLogonObserver(Observer observer) {
        this.observableLogon.deleteObserver(observer);
    }

    public void addOrderObserver(Observer observer) {
        this.observableOrder.addObserver(observer);
    }

    public void deleteOrderObserver(Observer observer) {
        this.observableOrder.deleteObserver(observer);
    }

    public boolean isMissingField() {
        return this.isMissingField;
    }

    public void setMissingField(boolean isMissingField) {
        this.isMissingField = isMissingField;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public void setAvailable(boolean isAvailable) {
        this.isAvailable = isAvailable;
    }

    static {
        sideMap.put(OrderSide.BUY, new Side('1'));
        sideMap.put(OrderSide.SELL, new Side('2'));
        sideMap.put(OrderSide.SHORT_SELL, new Side('5'));
        sideMap.put(OrderSide.SHORT_SELL_EXEMPT, new Side('6'));
        sideMap.put(OrderSide.CROSS, new Side('8'));
        sideMap.put(OrderSide.CROSS_SHORT, new Side('9'));
        typeMap.put(OrderType.MARKET, new OrdType('1'));
        typeMap.put(OrderType.LIMIT, new OrdType('2'));
        typeMap.put(OrderType.STOP, new OrdType('3'));
        typeMap.put(OrderType.STOP_LIMIT, new OrdType('4'));
        tifMap.put(OrderTIF.DAY, new TimeInForce('0'));
        tifMap.put(OrderTIF.IOC, new TimeInForce('3'));
        tifMap.put(OrderTIF.OPG, new TimeInForce('2'));
        tifMap.put(OrderTIF.GTC, new TimeInForce('1'));
        tifMap.put(OrderTIF.GTX, new TimeInForce('5'));
    }

    public class ObservableLogon
    extends Observable {
        private HashSet set = new HashSet();

        public void logon(SessionID sessionID) {
            this.set.add(sessionID);
            this.setChanged();
            this.notifyObservers(new LogonEvent(sessionID, true));
            this.clearChanged();
        }

        public void logoff(SessionID sessionID) {
            this.set.remove(sessionID);
            this.setChanged();
            this.notifyObservers(new LogonEvent(sessionID, false));
            this.clearChanged();
        }
    }

    public class ObservableOrder
    extends Observable {
        public void update(Order order) {
            this.setChanged();
            this.notifyObservers(order);
            this.clearChanged();
        }
    }

    public class doFromApp
    implements Runnable {
        private Message message;
        private SessionID sessionID;

        public doFromApp(Message message, SessionID sessionID) {
            this.message = message;
            this.sessionID = sessionID;
        }

        public void run() {
            try {
                MsgType msgType = new MsgType();
                if (BanzaiApplication.this.isAvailable) {
                    if (BanzaiApplication.this.isMissingField) {
                        BanzaiApplication.this.sendBusinessReject(this.message, 5, "Conditionally required field missing");
                    } else if (this.message.getHeader().isSetField(128)) {
                        BanzaiApplication.this.sendSessionReject(this.message, 9);
                    } else if (this.message.getHeader().getField(msgType).valueEquals("8")) {
                        BanzaiApplication.this.executionReport(this.message, this.sessionID);
                    } else if (this.message.getHeader().getField(msgType).valueEquals("9")) {
                        BanzaiApplication.this.cancelReject(this.message, this.sessionID);
                    } else {
                        BanzaiApplication.this.sendBusinessReject(this.message, 3, "Unsupported Message Type");
                    }
                } else {
                    BanzaiApplication.this.sendBusinessReject(this.message, 4, "Application not available");
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }
}

