/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.RefreshableMessageStore;
import quickfix.SessionID;
import quickfix.SystemTime;

public class SleepycatStore
implements RefreshableMessageStore {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final SessionID sessionID;
    private SessionInfo info;
    private final String dbDir;
    private String seqDbName = "seq";
    private String msgDbName = "outmsg";
    private Database messageDatabase;
    private Database sequenceDatabase;
    private SessionIDTupleBinding sessionIDBinding = new SessionIDTupleBinding();
    private SessionInfoTupleBinding sessionInfoBinding = new SessionInfoTupleBinding();
    private Environment environment;
    private final DatabaseEntry sessionIDKey = new DatabaseEntry();
    private final DatabaseEntry sessionInfoBytes = new DatabaseEntry();
    static /* synthetic */ Class class$java$lang$Integer;

    public SleepycatStore(SessionID sessionID, String databaseDir, String sequenceDbName, String messageDbName) throws IOException {
        this.sessionID = sessionID;
        this.dbDir = databaseDir;
        this.seqDbName = sequenceDbName;
        this.msgDbName = messageDbName;
        this.open();
    }

    void open() throws IOException {
        try {
            EnvironmentConfig envConfig = new EnvironmentConfig();
            envConfig.setAllowCreate(true);
            this.environment = new Environment(new File(this.dbDir), envConfig);
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setAllowCreate(true);
            this.messageDatabase = this.environment.openDatabase(null, this.msgDbName, dbConfig);
            this.sequenceDatabase = this.environment.openDatabase(null, this.seqDbName, dbConfig);
            this.loadSessionInfo();
        }
        catch (DatabaseException dbe) {
            this.convertToIOExceptionAndRethrow((Exception)((Object)dbe));
        }
    }

    void close() throws IOException {
        try {
            this.messageDatabase.close();
            this.sequenceDatabase.close();
            this.environment.close();
        }
        catch (DatabaseException e) {
            this.convertToIOExceptionAndRethrow((Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void get(int startSequence, int endSequence, Collection messages) throws IOException {
        Cursor cursor = null;
        try {
            DatabaseEntry sequenceKey = new DatabaseEntry();
            TupleBinding sequenceBinding = TupleBinding.getPrimitiveBinding((Class)(class$java$lang$Integer == null ? (class$java$lang$Integer = SleepycatStore.class$("java.lang.Integer")) : class$java$lang$Integer));
            sequenceBinding.objectToEntry((Object)new Integer(startSequence - 1), sequenceKey);
            cursor = this.messageDatabase.openCursor(null, null);
            DatabaseEntry messageBytes = new DatabaseEntry();
            OperationStatus retVal = cursor.getSearchKeyRange(sequenceKey, messageBytes, LockMode.DEFAULT);
            if (retVal == OperationStatus.NOTFOUND) {
                this.log.debug(sequenceKey + "/" + messageBytes + " not matched in database " + this.messageDatabase.getDatabaseName());
                return;
            }
            Integer sequenceNumber = (Integer)sequenceBinding.entryToObject(sequenceKey);
            while (sequenceNumber <= endSequence) {
                messages.add(new String(messageBytes.getData()));
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Found record " + sequenceNumber + "=>" + new String(messageBytes.getData()) + " for search key/data: " + sequenceKey + "=>" + messageBytes);
                }
                cursor.getNext(sequenceKey, messageBytes, LockMode.DEFAULT);
                sequenceNumber = (Integer)sequenceBinding.entryToObject(sequenceKey);
            }
        }
        catch (Exception e) {
            this.convertToIOExceptionAndRethrow(e);
        }
        finally {
            try {
                cursor.close();
            }
            catch (DatabaseException dbe) {
                this.convertToIOExceptionAndRethrow((Exception)((Object)dbe));
            }
        }
    }

    private void convertToIOExceptionAndRethrow(Exception e) throws IOException {
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        IOException ioe = new IOException(e.getMessage());
        ioe.setStackTrace(e.getStackTrace());
        throw ioe;
    }

    public Date getCreationTime() throws IOException {
        return this.info.getCreationTime().getTime();
    }

    public int getNextSenderMsgSeqNum() throws IOException {
        return this.info.getNextSenderMsgSeqNum();
    }

    public int getNextTargetMsgSeqNum() throws IOException {
        return this.info.getNextTargetMsgSeqNum();
    }

    public void incrNextSenderMsgSeqNum() throws IOException {
        this.info.setNextSenderMsgSeqNum(this.info.getNextSenderMsgSeqNum() + 1);
        this.storeSessionInfo();
    }

    public void incrNextTargetMsgSeqNum() throws IOException {
        this.info.setNextTargetMsgSeqNum(this.info.getNextTargetMsgSeqNum() + 1);
        this.storeSessionInfo();
    }

    public void reset() throws IOException {
        try {
            this.info = new SessionInfo();
            this.storeSessionInfo();
            this.sequenceDatabase.close();
            this.messageDatabase.close();
            this.environment.truncateDatabase(null, this.seqDbName, false);
            this.environment.truncateDatabase(null, this.msgDbName, false);
            this.environment.close();
            this.open();
        }
        catch (DatabaseException e) {
            this.convertToIOExceptionAndRethrow((Exception)((Object)e));
        }
    }

    public boolean set(int sequence, String message) throws IOException {
        try {
            DatabaseEntry sequenceKey = new DatabaseEntry();
            TupleBinding sequenceBinding = TupleBinding.getPrimitiveBinding((Class)(class$java$lang$Integer == null ? (class$java$lang$Integer = SleepycatStore.class$("java.lang.Integer")) : class$java$lang$Integer));
            sequenceBinding.objectToEntry((Object)new Integer(sequence), sequenceKey);
            DatabaseEntry messageBytes = new DatabaseEntry(message.getBytes("UTF-8"));
            this.messageDatabase.put(null, sequenceKey, messageBytes);
        }
        catch (Exception e) {
            this.convertToIOExceptionAndRethrow(e);
        }
        return true;
    }

    public void setNextSenderMsgSeqNum(int next) throws IOException {
        this.info.setNextSenderMsgSeqNum(next);
        this.storeSessionInfo();
    }

    public void setNextTargetMsgSeqNum(int next) throws IOException {
        this.info.setNextTargetMsgSeqNum(next);
        this.storeSessionInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSessionInfo() throws IOException {
        DatabaseEntry databaseEntry = this.sessionIDKey;
        synchronized (databaseEntry) {
            this.sessionIDBinding.objectToEntry(this.sessionID, this.sessionIDKey);
            try {
                this.sequenceDatabase.get(null, this.sessionIDKey, this.sessionInfoBytes, LockMode.DEFAULT);
                if (this.sessionInfoBytes.getSize() > 0) {
                    this.info = (SessionInfo)this.sessionInfoBinding.entryToObject(this.sessionInfoBytes);
                } else {
                    this.info = new SessionInfo();
                    this.storeSessionInfo();
                }
            }
            catch (DatabaseException e) {
                this.convertToIOExceptionAndRethrow((Exception)((Object)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeSessionInfo() throws IOException {
        DatabaseEntry databaseEntry = this.sessionIDKey;
        synchronized (databaseEntry) {
            this.sessionIDBinding.objectToEntry(this.sessionID, this.sessionIDKey);
            this.sessionInfoBinding.objectToEntry(this.info, this.sessionInfoBytes);
            try {
                this.sequenceDatabase.put(null, this.sessionIDKey, this.sessionInfoBytes);
            }
            catch (DatabaseException e) {
                this.convertToIOExceptionAndRethrow((Exception)((Object)e));
            }
        }
    }

    public void refresh() throws IOException {
        this.loadSessionInfo();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class SessionInfo {
        private int nextSenderMsgSeqNum;
        private int nextTargetMsgSeqNum;
        private Calendar creationTime;

        public SessionInfo() {
            this(SystemTime.getUtcCalendar(), 1, 1);
        }

        public SessionInfo(Calendar creationTime, int nextSenderMsgSeqNum, int nextTargetMsgSeqNum) {
            this.creationTime = creationTime;
            this.nextSenderMsgSeqNum = nextSenderMsgSeqNum;
            this.nextTargetMsgSeqNum = nextTargetMsgSeqNum;
        }

        public Calendar getCreationTime() {
            return this.creationTime;
        }

        public int getNextSenderMsgSeqNum() {
            return this.nextSenderMsgSeqNum;
        }

        public int getNextTargetMsgSeqNum() {
            return this.nextTargetMsgSeqNum;
        }

        public void setCreationTime(Calendar creationTime) {
            this.creationTime = creationTime;
        }

        public void setNextSenderMsgSeqNum(int nextSenderMsgSeqNum) {
            this.nextSenderMsgSeqNum = nextSenderMsgSeqNum;
        }

        public void setNextTargetMsgSeqNum(int nextTargetMsgSeqNum) {
            this.nextTargetMsgSeqNum = nextTargetMsgSeqNum;
        }
    }

    private static class SessionInfoTupleBinding
    extends TupleBinding {
        private SessionInfoTupleBinding() {
        }

        public Object entryToObject(TupleInput tupleIn) {
            return new SessionInfo(SystemTime.getUtcCalendar(new Date(tupleIn.readLong())), tupleIn.readInt(), tupleIn.readInt());
        }

        public void objectToEntry(Object object, TupleOutput tupleOut) {
            SessionInfo sessionInfo = (SessionInfo)object;
            tupleOut.writeLong(sessionInfo.getCreationTime().getTimeInMillis());
            tupleOut.writeInt(sessionInfo.getNextSenderMsgSeqNum());
            tupleOut.writeInt(sessionInfo.getNextTargetMsgSeqNum());
        }
    }

    private static class SessionIDTupleBinding
    extends TupleBinding {
        private SessionIDTupleBinding() {
        }

        public Object entryToObject(TupleInput tupleIn) {
            return new SessionID(tupleIn.readString(), tupleIn.readString(), tupleIn.readString(), tupleIn.readString());
        }

        public void objectToEntry(Object object, TupleOutput tupleOut) {
            SessionID sessionID = (SessionID)object;
            tupleOut.writeString(sessionID.getBeginString());
            tupleOut.writeString(sessionID.getSenderCompID());
            tupleOut.writeString(sessionID.getTargetCompID());
            tupleOut.writeString(sessionID.getSessionQualifier());
        }
    }
}

