/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import quickfix.ConfigError;
import quickfix.Dictionary;
import quickfix.FieldConvertError;
import quickfix.SessionID;
import quickfix.field.converter.BooleanConverter;

public class SessionSettings {
    private static final SessionID DEFAULT_SESSION_ID = new SessionID("DEFAULT", "", "");
    private static final String SESSION_SECTION_NAME = "session";
    private static final String DEFAULT_SECTION_NAME = "default";
    public static final String TARGETCOMPID = "TargetCompID";
    public static final String SESSION_QUALIFIER = "SessionQualifier";
    private static final String NEWLINE = "\r\n";
    private Properties variableValues = System.getProperties();
    private HashMap sections = new HashMap();
    private Pattern variablePattern = Pattern.compile("\\$\\{(.+?)}");

    public SessionSettings() {
        this.sections.put(DEFAULT_SESSION_ID, new Properties());
    }

    public SessionSettings(String filename) throws ConfigError {
        this();
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(filename);
        if (in == null) {
            try {
                in = new FileInputStream(filename);
            }
            catch (IOException e) {
                throw new ConfigError(e.getMessage());
            }
        }
        this.load(in);
    }

    public SessionSettings(InputStream stream) throws ConfigError {
        this();
        this.load(stream);
    }

    public String getString(String key) throws ConfigError, FieldConvertError {
        return this.getString(DEFAULT_SESSION_ID, key);
    }

    public String getString(SessionID sessionID, String key) throws ConfigError, FieldConvertError {
        String value = this.interpolate(this.getSessionProperties(sessionID).getProperty(key));
        if (value == null) {
            throw new ConfigError(key + " not defined");
        }
        return value;
    }

    public Properties getSessionProperties(SessionID sessionID) throws ConfigError {
        Properties p = (Properties)this.sections.get(sessionID);
        if (p == null) {
            throw new ConfigError("Session not found");
        }
        return p;
    }

    public Properties getDefaultProperties() throws ConfigError {
        return this.getSessionProperties(DEFAULT_SESSION_ID);
    }

    public long getLong(String key) throws ConfigError, FieldConvertError {
        return this.getLong(DEFAULT_SESSION_ID, key);
    }

    public long getLong(SessionID sessionID, String key) throws ConfigError, FieldConvertError {
        try {
            return Long.parseLong(this.getString(sessionID, key));
        }
        catch (NumberFormatException e) {
            throw new FieldConvertError(e.getMessage());
        }
    }

    private Properties getOrCreateSessionProperties(SessionID sessionID) {
        Properties p = (Properties)this.sections.get(sessionID);
        if (p == null) {
            p = new Properties((Properties)this.sections.get(DEFAULT_SESSION_ID));
            this.sections.put(sessionID, p);
        }
        return p;
    }

    public double getDouble(String key) throws ConfigError, FieldConvertError {
        return this.getDouble(DEFAULT_SESSION_ID, key);
    }

    public double getDouble(SessionID sessionID, String key) throws ConfigError, FieldConvertError {
        try {
            return Double.parseDouble(this.getString(sessionID, key));
        }
        catch (NumberFormatException e) {
            throw new FieldConvertError(e.getMessage());
        }
    }

    public boolean getBool(String key) throws ConfigError, FieldConvertError {
        return this.getBool(DEFAULT_SESSION_ID, key);
    }

    public boolean getBool(SessionID sessionID, String key) throws ConfigError, FieldConvertError {
        try {
            return BooleanConverter.convert(this.getString(sessionID, key));
        }
        catch (FieldConvertError e) {
            throw new ConfigError(e);
        }
    }

    public void setString(SessionID sessionID, String key, String value) {
        this.getOrCreateSessionProperties(sessionID).setProperty(key, value.trim());
    }

    public void setLong(SessionID sessionID, String key, long value) {
        this.getOrCreateSessionProperties(sessionID).setProperty(key, Long.toString(value));
    }

    public void setDouble(SessionID sessionID, String key, double value) {
        this.getOrCreateSessionProperties(sessionID).setProperty(key, Double.toString(value));
    }

    public void setBool(SessionID sessionID, String key, boolean value) {
        this.getOrCreateSessionProperties(sessionID).setProperty(key, BooleanConverter.convert(value));
    }

    public Iterator sectionIterator() {
        HashSet nondefaultSessions = new HashSet(this.sections.keySet());
        nondefaultSessions.remove(DEFAULT_SESSION_ID);
        return nondefaultSessions.iterator();
    }

    private void load(InputStream inputStream) throws ConfigError {
        try {
            Properties currentSection = null;
            String currentSectionId = null;
            Tokenizer tokenizer = new Tokenizer();
            Tokenizer.Token token = tokenizer.getToken(inputStream);
            while (token != null) {
                if (token.getType() == 4) {
                    this.storeSection(currentSectionId, currentSection);
                    if (token.getValue().equalsIgnoreCase(DEFAULT_SECTION_NAME)) {
                        currentSectionId = DEFAULT_SECTION_NAME;
                        currentSection = this.getSessionProperties(DEFAULT_SESSION_ID);
                    } else if (token.getValue().equalsIgnoreCase(SESSION_SECTION_NAME)) {
                        currentSectionId = SESSION_SECTION_NAME;
                        currentSection = new Properties(this.getSessionProperties(DEFAULT_SESSION_ID));
                    }
                } else if (token.getType() == 2) {
                    Tokenizer.Token valueToken = tokenizer.getToken(inputStream);
                    if (currentSection != null && token != null) {
                        currentSection.put(token.getValue(), valueToken.getValue());
                    }
                }
                token = tokenizer.getToken(inputStream);
            }
            this.storeSection(currentSectionId, currentSection);
        }
        catch (IOException e) {
            ConfigError configError = new ConfigError(e.getMessage());
            configError.fillInStackTrace();
            throw configError;
        }
    }

    private void storeSection(String currentSectionId, Properties currentSection) {
        if (currentSectionId != null && currentSectionId.equals(SESSION_SECTION_NAME)) {
            SessionID sessionId = new SessionID(currentSection.getProperty("BeginString"), currentSection.getProperty("SenderCompID"), currentSection.getProperty(TARGETCOMPID), currentSection.getProperty(SESSION_QUALIFIER, ""));
            this.sections.put(sessionId, currentSection);
            currentSectionId = null;
            currentSection = null;
        }
    }

    public boolean isSetting(String key) {
        return this.isSetting(DEFAULT_SESSION_ID, key);
    }

    public boolean isSetting(SessionID sessionID, String key) {
        return this.getOrCreateSessionProperties(sessionID).getProperty(key) != null;
    }

    public void removeSetting(SessionID sessionID, String key) {
        this.getOrCreateSessionProperties(sessionID).remove(key);
    }

    private String interpolate(String value) {
        if (value == null || value.indexOf(36) == -1) {
            return value;
        }
        StringBuffer buffer = new StringBuffer();
        Matcher m = this.variablePattern.matcher(value);
        while (m.find()) {
            String variable;
            String variableValue;
            if (m.start() > 0 && value.charAt(m.start() - 1) == '\\' || (variableValue = this.variableValues.getProperty(variable = m.group(1))) == null) continue;
            m.appendReplacement(buffer, variableValue);
        }
        m.appendTail(buffer);
        return buffer.toString();
    }

    public void setVariableValues(Properties variableValues) {
        this.variableValues = variableValues;
    }

    public void set(Map defaults) {
        this.getOrCreateSessionProperties(DEFAULT_SESSION_ID).putAll((Map<?, ?>)defaults);
    }

    public void setBool(String key, boolean value) {
        this.setBool(DEFAULT_SESSION_ID, key, value);
    }

    public void setDouble(String key, double value) {
        this.setDouble(DEFAULT_SESSION_ID, key, value);
    }

    public void setLong(String key, long value) {
        this.setLong(DEFAULT_SESSION_ID, key, value);
    }

    public void setString(String key, String value) {
        this.setString(DEFAULT_SESSION_ID, key, value.trim());
    }

    public int size() {
        return this.sections.size() - 1;
    }

    public Dictionary get(SessionID sessionID) throws ConfigError {
        return new Dictionary(null, this.getSessionProperties(sessionID));
    }

    public void set(SessionID sessionID, Dictionary dictionary) throws ConfigError {
        Properties p = this.getOrCreateSessionProperties(sessionID);
        p.clear();
        p.putAll((Map<?, ?>)dictionary.toMap());
    }

    public Dictionary get() {
        try {
            return new Dictionary(null, this.getDefaultProperties());
        }
        catch (ConfigError e) {
            return null;
        }
    }

    public void set(Dictionary dictionary) throws ConfigError {
        this.getDefaultProperties().putAll((Map<?, ?>)dictionary.toMap());
    }

    private static class Tokenizer {
        public static final int NONE_TOKEN = 1;
        public static final int ID_TOKEN = 2;
        public static final int VALUE_TOKEN = 3;
        public static final int SECTION_TOKEN = 4;
        private char ch = '\u0000';
        private StringBuffer sb = new StringBuffer();

        private Tokenizer() {
        }

        private Token getToken(InputStream inputStream) throws IOException {
            if (this.ch == '\u0000') {
                this.ch = this.nextCharacter(inputStream);
            }
            this.skipWhitespace(inputStream);
            if (this.isLabelCharacter(this.ch)) {
                this.sb.setLength(0);
                do {
                    this.sb.append(this.ch);
                    this.ch = this.nextCharacter(inputStream);
                } while (this.isLabelCharacter(this.ch));
                return new Token(2, this.sb.toString());
            }
            if (this.ch == '=') {
                this.ch = this.nextCharacter(inputStream);
                this.sb.setLength(0);
                if (this.isValueCharacter(this.ch)) {
                    do {
                        this.sb.append(this.ch);
                        this.ch = this.nextCharacter(inputStream);
                    } while (this.isValueCharacter(this.ch));
                }
                return new Token(3, this.sb.toString().trim());
            }
            if (this.ch == '[') {
                this.ch = this.nextCharacter(inputStream);
                Token id = this.getToken(inputStream);
                this.ch = this.nextCharacter(inputStream);
                return new Token(4, id.getValue());
            }
            if (this.ch == '#') {
                do {
                    this.ch = this.nextCharacter(inputStream);
                } while (!this.isNewLineCharacter(this.ch));
                return this.getToken(inputStream);
            }
            return null;
        }

        private boolean isNewLineCharacter(char ch) {
            return SessionSettings.NEWLINE.indexOf(ch) != -1;
        }

        private boolean isLabelCharacter(char ch) {
            return !this.isEndOfStream(ch) && "[]=#".indexOf(ch) == -1;
        }

        private boolean isValueCharacter(char ch) {
            return !this.isEndOfStream(ch) && !this.isNewLineCharacter(ch);
        }

        private boolean isEndOfStream(char ch) {
            return (byte)ch == -1;
        }

        private char nextCharacter(InputStream inputStream) throws IOException {
            return (char)inputStream.read();
        }

        private void skipWhitespace(InputStream inputStream) throws IOException {
            if (Character.isWhitespace(this.ch)) {
                do {
                    this.ch = this.nextCharacter(inputStream);
                } while (Character.isWhitespace(this.ch));
            }
        }

        private class Token {
            private int type;
            private String value;

            public Token(int type, String value) {
                this.type = type;
                this.value = value;
            }

            public int getType() {
                return this.type;
            }

            public String getValue() {
                return this.value;
            }

            public String toString() {
                return this.type + ": " + this.value;
            }
        }
    }
}

