/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import quickfix.RuntimeError;

public class SessionID {
    private String beginString;
    private String senderCompID;
    private String targetCompID;
    private String sessionQualifier;
    private String id;

    public SessionID() {
        this("", "", "");
    }

    public SessionID(String beginString, String senderCompID, String targetCompID) {
        this.create(beginString, senderCompID, targetCompID, "");
    }

    public SessionID(String beginString, String senderCompID, String targetCompID, String sessionQualifier) {
        if (sessionQualifier == null) {
            sessionQualifier = "";
        }
        this.create(beginString, senderCompID, targetCompID, sessionQualifier);
    }

    public String getBeginString() {
        return this.beginString;
    }

    public String getSenderCompID() {
        return this.senderCompID;
    }

    public String getTargetCompID() {
        return this.targetCompID;
    }

    public String getSessionQualifier() {
        return this.sessionQualifier;
    }

    public boolean equals(Object object) {
        return object != null ? this.toString().equals(object.toString()) : false;
    }

    public String toString() {
        return this.id;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private void create(String beginString, String senderCompID, String targetCompID, String sessionQualifier) {
        this.beginString = beginString;
        this.senderCompID = senderCompID;
        this.targetCompID = targetCompID;
        this.sessionQualifier = sessionQualifier;
        this.id = beginString + ":" + senderCompID + "->" + targetCompID + (sessionQualifier != null && !sessionQualifier.equals("") ? ":" + sessionQualifier : "");
    }

    public String fromString(String sessionIDString) {
        int start = 0;
        int end = sessionIDString.indexOf(58);
        if (end == -1) {
            throw new RuntimeError("Couldn't parse session ID");
        }
        String beginString = sessionIDString.substring(start, end);
        start = end + 1;
        if ((end = sessionIDString.indexOf("->", start)) == -1) {
            throw new RuntimeError("Couldn't parse session ID");
        }
        String senderCompID = sessionIDString.substring(start, end);
        start = end + 2;
        if ((end = sessionIDString.indexOf(":", start)) == -1) {
            end = sessionIDString.length();
        }
        String targetCompID = sessionIDString.substring(start, end);
        if (end < sessionIDString.length()) {
            start = end + 1;
            end = sessionIDString.length();
            this.sessionQualifier = end != -1 ? sessionIDString.substring(start, end) : "";
        }
        this.beginString = beginString;
        this.senderCompID = senderCompID;
        this.targetCompID = targetCompID;
        return sessionIDString;
    }
}

