/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import quickfix.DataDictionary;
import quickfix.FieldMap;
import quickfix.FieldNotFound;
import quickfix.InvalidMessage;
import quickfix.Message;
import quickfix.MessageFactory;
import quickfix.SessionID;

public class MessageUtils {
    public static SessionID getSessionID(Message fixMessage) {
        Message.Header header = fixMessage.getHeader();
        return new SessionID(MessageUtils.getFieldOrDefault(header, 8, null), MessageUtils.getFieldOrDefault(header, 49, null), MessageUtils.getFieldOrDefault(header, 56, null));
    }

    public static SessionID getSessionID(String messageString) {
        return new SessionID(MessageUtils.getStringField(messageString, 8), MessageUtils.getStringField(messageString, 49), MessageUtils.getStringField(messageString, 56));
    }

    public static SessionID getReverseSessionID(Message fixMessage) {
        Message.Header header = fixMessage.getHeader();
        return new SessionID(MessageUtils.getFieldOrDefault(header, 8, null), MessageUtils.getFieldOrDefault(header, 56, null), MessageUtils.getFieldOrDefault(header, 49, null));
    }

    public static SessionID getReverseSessionID(String messageString) {
        return new SessionID(MessageUtils.getStringField(messageString, 8), MessageUtils.getStringField(messageString, 56), MessageUtils.getStringField(messageString, 49));
    }

    private static String getFieldOrDefault(FieldMap fields, int tag, String defaultValue) {
        if (fields.isSetField(tag)) {
            try {
                return fields.getString(tag);
            }
            catch (FieldNotFound e) {
                return null;
            }
        }
        return defaultValue;
    }

    public static Message parse(MessageFactory messageFactory, DataDictionary dataDictionary, String messageString) throws InvalidMessage {
        String beginString = messageString.substring(2, 9);
        String messageType = MessageUtils.getMessageType(messageString);
        Message message = messageFactory.create(beginString, messageType);
        message.fromString(messageString, dataDictionary, dataDictionary != null);
        return message;
    }

    public static String getStringField(String messageString, int tag) {
        String tagString = Integer.toString(tag);
        String value = null;
        int start = messageString.indexOf(tagString, 0);
        while (start != -1 && value == null) {
            int end;
            if ((start == 0 || messageString.charAt(start - 1) == '\u0001') && (end = start + tagString.length()) + 1 < messageString.length() && messageString.charAt(end) == '=') {
                start = ++end;
                while (end < messageString.length() && messageString.charAt(end) != '\u0001') {
                    ++end;
                }
                if (end == messageString.length()) {
                    return null;
                }
                value = messageString.substring(start, end);
            }
            start = messageString.indexOf(tagString, start + 1);
        }
        return value;
    }

    public static String getMessageType(String messageString) throws InvalidMessage {
        int messageTypeTagStart = messageString.indexOf("35=");
        if (messageTypeTagStart == -1) {
            throw new InvalidMessage("missing message type");
        }
        int messageTypeValueStart = messageTypeTagStart + 3;
        int messageTypeEnd = Math.min(messageString.length(), messageTypeValueStart);
        while (messageString.charAt(messageTypeEnd) != '\u0001') {
            if (++messageTypeEnd < messageString.length()) continue;
            throw new InvalidMessage("couldn't extract message type");
        }
        return messageString.substring(messageTypeValueStart, messageTypeEnd);
    }
}

