/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.sql.DataSource;
import quickfix.ConfigError;
import quickfix.FieldConvertError;
import quickfix.JdbcUtil;
import quickfix.Log;
import quickfix.LogUtil;
import quickfix.SessionID;
import quickfix.SessionSettings;
import quickfix.SystemTime;

class JdbcLog
implements Log {
    private static final String MESSAGES_LOG_TABLE = "messages_log";
    private static final String EVENT_LOG_TABLE = "event_log";
    private final SessionID sessionID;
    private final DataSource dataSource;

    public JdbcLog(SessionSettings settings, SessionID sessionID) throws SQLException, ClassNotFoundException, ConfigError, FieldConvertError {
        this.sessionID = sessionID;
        this.dataSource = JdbcUtil.getDataSource(settings, sessionID);
    }

    public void onEvent(String value) {
        this.insert(EVENT_LOG_TABLE, value);
    }

    public void onIncoming(String value) {
        this.insert(MESSAGES_LOG_TABLE, value);
    }

    public void onOutgoing(String value) {
        this.insert(MESSAGES_LOG_TABLE, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert(String tableName, String value) {
        block5: {
            Connection connection = null;
            PreparedStatement insert = null;
            try {
                connection = this.dataSource.getConnection();
                insert = connection.prepareStatement("INSERT INTO " + tableName + " (time, beginstring, sendercompid, targetcompid, session_qualifier, text) " + "VALUES (?,?,?,?,?,?)");
                insert.setTimestamp(1, new Timestamp(SystemTime.getUtcCalendar().getTimeInMillis()));
                insert.setString(2, this.sessionID.getBeginString());
                insert.setString(3, this.sessionID.getSenderCompID());
                insert.setString(4, this.sessionID.getTargetCompID());
                insert.setString(5, this.sessionID.getSessionQualifier());
                insert.setString(6, value);
                insert.execute();
                JdbcUtil.close(this.sessionID, insert);
            }
            catch (SQLException e) {
                LogUtil.logThrowable(this.sessionID, e.getMessage(), (Throwable)e);
                break block5;
            }
            finally {
                JdbcUtil.close(this.sessionID, insert);
                JdbcUtil.close(this.sessionID, connection);
            }
            JdbcUtil.close(this.sessionID, connection);
        }
    }

    public void clear() {
        this.clearTable(EVENT_LOG_TABLE);
        this.clearTable(MESSAGES_LOG_TABLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTable(String tableName) {
        block5: {
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.dataSource.getConnection();
                statement = connection.prepareStatement("DELETE FROM " + tableName + " WHERE beginString=? AND senderCompID=? " + "AND targetCompID=? AND session_qualifier=?");
                statement.setString(1, this.sessionID.getBeginString());
                statement.setString(2, this.sessionID.getSenderCompID());
                statement.setString(3, this.sessionID.getTargetCompID());
                statement.setString(4, this.sessionID.getSessionQualifier());
                statement.execute();
                JdbcUtil.close(this.sessionID, statement);
            }
            catch (SQLException e) {
                LogUtil.logThrowable(this.sessionID, e.getMessage(), (Throwable)e);
                break block5;
            }
            finally {
                JdbcUtil.close(this.sessionID, statement);
                JdbcUtil.close(this.sessionID, connection);
            }
            JdbcUtil.close(this.sessionID, connection);
        }
    }
}

