/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import quickfix.FileUtil;
import quickfix.MemoryStore;
import quickfix.RefreshableMessageStore;
import quickfix.SessionID;
import quickfix.SystemTime;
import quickfix.field.converter.UtcTimestampConverter;

public class FileStore
implements RefreshableMessageStore {
    private static final String READ_OPTION = "r";
    private static final String WRITE_OPTION = "w";
    private static final String SYNC_OPTION = "d";
    private static final String NOSYNC_OPTION = "";
    private MemoryStore cache = new MemoryStore();
    private final String msgFileName;
    private final String headerFileName;
    private final String seqNumFileName;
    private final String sessionFileName;
    private RandomAccessFile messageFile;
    private DataOutputStream headerDataOutputStream;
    private RandomAccessFile sequenceNumberFile;
    private final boolean syncWrites;
    private HashMap messageIndex = new HashMap();
    private FileOutputStream headerFileOutputStream;

    FileStore(String path, SessionID sessionID, boolean syncWrites) throws IOException {
        this.syncWrites = syncWrites;
        if (path == null) {
            path = ".";
        }
        path = new File(path).getAbsolutePath();
        String sessionId = sessionID.getBeginString() + "-" + sessionID.getSenderCompID() + "-" + sessionID.getTargetCompID();
        if (sessionID.getSessionQualifier() != null && !sessionID.getSessionQualifier().equals(NOSYNC_OPTION)) {
            sessionId = sessionId + "-" + sessionID.getSessionQualifier();
        }
        String prefix = FileUtil.fileAppendPath(path, sessionId + ".");
        this.msgFileName = prefix + "body";
        this.headerFileName = prefix + "header";
        this.seqNumFileName = prefix + "seqnums";
        this.sessionFileName = prefix + "session";
        File directory = new File(this.msgFileName).getParentFile();
        if (!directory.exists()) {
            directory.mkdirs();
        }
        this.initialize(false);
    }

    void initialize(boolean deleteFiles) throws IOException {
        this.closeFiles();
        if (deleteFiles) {
            this.deleteFiles();
        }
        this.messageFile = new RandomAccessFile(this.msgFileName, this.getRandomAccessFileOptions());
        this.sequenceNumberFile = new RandomAccessFile(this.seqNumFileName, this.getRandomAccessFileOptions());
        this.initializeCache();
    }

    private void initializeCache() throws IOException {
        this.cache.reset();
        this.initializeMessageIndex();
        this.initializeSequenceNumbers();
        this.initializeSessionCreateTime();
        this.messageFile.seek(this.messageFile.length());
    }

    private void initializeSessionCreateTime() throws IOException {
        File sessionTimeFile = new File(this.sessionFileName);
        if (sessionTimeFile.exists()) {
            DataInputStream sessionTimeInput = new DataInputStream(new BufferedInputStream(new FileInputStream(sessionTimeFile)));
            try {
                Calendar c = SystemTime.getUtcCalendar(UtcTimestampConverter.convert(sessionTimeInput.readUTF()));
                this.cache.setCreationTime(c);
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
            finally {
                sessionTimeInput.close();
            }
        } else {
            this.storeSessionTimeStamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeSessionTimeStamp() throws IOException {
        DataOutputStream sessionTimeOutput = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.sessionFileName, false)));
        try {
            Date date = SystemTime.getDate();
            this.cache.setCreationTime(SystemTime.getUtcCalendar(date));
            sessionTimeOutput.writeUTF(UtcTimestampConverter.convert(date, true));
        }
        finally {
            sessionTimeOutput.close();
        }
    }

    public Date getCreationTime() throws IOException {
        return this.cache.getCreationTime();
    }

    private void initializeSequenceNumbers() throws IOException {
        this.sequenceNumberFile.seek(0L);
        if (this.sequenceNumberFile.length() > 0L) {
            String s = this.sequenceNumberFile.readUTF();
            int offset = s.indexOf(58);
            this.cache.setNextSenderMsgSeqNum(Integer.parseInt(s.substring(0, offset)));
            this.cache.setNextTargetMsgSeqNum(Integer.parseInt(s.substring(offset + 1)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeMessageIndex() throws IOException {
        File headerFile = new File(this.headerFileName);
        if (headerFile.exists()) {
            DataInputStream headerDataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(headerFile)));
            try {
                while (headerDataInputStream.available() > 0) {
                    int sequenceNumber = headerDataInputStream.readInt();
                    long offset = headerDataInputStream.readLong();
                    int size = headerDataInputStream.readInt();
                    this.messageIndex.put(new Long(sequenceNumber), new long[]{offset, size});
                }
            }
            finally {
                headerDataInputStream.close();
            }
        }
        this.headerFileOutputStream = new FileOutputStream(this.headerFileName, true);
        this.headerDataOutputStream = new DataOutputStream(new BufferedOutputStream(this.headerFileOutputStream));
    }

    private String getRandomAccessFileOptions() {
        return "rw" + (this.syncWrites ? SYNC_OPTION : NOSYNC_OPTION);
    }

    public void closeFiles() throws IOException {
        this.closeOutputStream(this.headerDataOutputStream);
        this.closeFile(this.messageFile);
        this.closeFile(this.sequenceNumberFile);
    }

    private void closeFile(RandomAccessFile file) throws IOException {
        if (file != null) {
            file.close();
        }
    }

    private void closeOutputStream(OutputStream stream) throws IOException {
        if (stream != null) {
            stream.close();
        }
    }

    public void deleteFiles() throws IOException {
        this.closeFiles();
        this.deleteFile(this.headerFileName);
        this.deleteFile(this.msgFileName);
        this.deleteFile(this.seqNumFileName);
        this.deleteFile(this.sessionFileName);
    }

    private void deleteFile(String fileName) throws IOException {
        File file = new File(fileName);
        if (file.exists() && !file.delete()) {
            System.err.println("File delete failed: " + fileName);
        }
    }

    public int getNextSenderMsgSeqNum() throws IOException {
        return this.cache.getNextSenderMsgSeqNum();
    }

    public int getNextTargetMsgSeqNum() throws IOException {
        return this.cache.getNextTargetMsgSeqNum();
    }

    public void setNextSenderMsgSeqNum(int next) throws IOException {
        this.cache.setNextSenderMsgSeqNum(next);
        this.storeSequenceNumbers();
    }

    public void setNextTargetMsgSeqNum(int next) throws IOException {
        this.cache.setNextTargetMsgSeqNum(next);
        this.storeSequenceNumbers();
    }

    public void incrNextSenderMsgSeqNum() throws IOException {
        this.cache.incrNextSenderMsgSeqNum();
        this.storeSequenceNumbers();
    }

    public void incrNextTargetMsgSeqNum() throws IOException {
        this.cache.incrNextTargetMsgSeqNum();
        this.storeSequenceNumbers();
    }

    public void get(int startSequence, int endSequence, Collection messages) throws IOException {
        for (int i = startSequence; i <= endSequence; ++i) {
            String message = this.getMessage(i);
            if (message == null) continue;
            messages.add(message);
        }
    }

    public boolean get(int sequence, String message) throws IOException {
        throw new UnsupportedOperationException("not supported");
    }

    private String getMessage(int i) throws IOException {
        long[] offsetAndSize = (long[])this.messageIndex.get(new Long(i));
        String message = null;
        if (offsetAndSize != null) {
            this.messageFile.seek(offsetAndSize[0]);
            byte[] data = new byte[(int)offsetAndSize[1]];
            this.messageFile.read(data);
            message = new String(data);
            this.messageFile.seek(this.messageFile.length());
        }
        return message;
    }

    public boolean set(int sequence, String message) throws IOException {
        long offset = this.messageFile.getFilePointer();
        int size = message.length();
        this.messageIndex.put(new Long(sequence), new long[]{offset, size});
        this.headerDataOutputStream.writeInt(sequence);
        this.headerDataOutputStream.writeLong(offset);
        this.headerDataOutputStream.writeInt(size);
        this.headerDataOutputStream.flush();
        if (this.syncWrites) {
            this.headerFileOutputStream.getFD().sync();
        }
        this.messageFile.write(message.getBytes());
        return true;
    }

    private void storeSequenceNumbers() throws IOException {
        this.sequenceNumberFile.seek(0L);
        this.sequenceNumberFile.writeUTF(NOSYNC_OPTION + this.cache.getNextSenderMsgSeqNum() + ':' + this.cache.getNextTargetMsgSeqNum());
    }

    String getHeaderFileName() {
        return this.headerFileName;
    }

    String getMsgFileName() {
        return this.msgFileName;
    }

    String getSeqNumFileName() {
        return this.seqNumFileName;
    }

    public void refresh() throws IOException {
        this.initialize(false);
    }

    public void reset() throws IOException {
        this.initialize(true);
    }
}

